/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.BootstrappableEstimator;
import ffx.numerics.estimator.EstimateBootstrapper;
import ffx.numerics.estimator.SequentialEstimator;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.FastMath;

public class Zwanzig
extends SequentialEstimator
implements BootstrappableEstimator {
    private static final Logger logger = Logger.getLogger(Zwanzig.class.getName());
    public final Directionality directionality;
    private final boolean forwards;
    private final int nWindows;
    private final double[] freeEnergyDifferences;
    private final double[] enthalpyDifferences;
    private final double[] freeEnergyDifferenceUncertainties;
    private final Random random;
    private double totalFreeEnergyDifference;
    private double totalFreeEnergyDifferenceUncertainty;
    private double totalEnthalpyDifference;

    public Zwanzig(double[] lambdaValues, double[][] eLambdaMinusdL, double[][] eLambda, double[][] eLambdaPlusdL, double[] temperature, Directionality directionality) {
        super(lambdaValues, eLambdaMinusdL, eLambda, eLambdaPlusdL, temperature);
        this.directionality = directionality;
        this.nWindows = this.nStates - 1;
        this.freeEnergyDifferences = new double[this.nWindows];
        this.freeEnergyDifferenceUncertainties = new double[this.nWindows];
        this.enthalpyDifferences = new double[this.nWindows];
        this.forwards = directionality.equals((Object)Directionality.FORWARDS);
        this.random = new Random();
        this.estimateDG();
    }

    @Override
    public Zwanzig copyEstimator() {
        return new Zwanzig(this.lamValues, this.eLambdaMinusdL, this.eLambda, this.eLambdaPlusdL, this.temperatures, this.directionality);
    }

    @Override
    public final void estimateDG(boolean randomSamples) {
        double cumDG = 0.0;
        Level warningLevel = randomSamples ? Level.FINE : Level.WARNING;
        for (int i = 0; i < this.nWindows; ++i) {
            int windowIndex = i + (this.forwards ? 0 : 1);
            double[] referenceEnergy = this.eLambda[windowIndex];
            double[] perturbedEnergy = this.forwards ? this.eLambdaPlusdL[windowIndex] : this.eLambdaMinusdL[windowIndex];
            double sign = this.forwards ? 1.0 : -1.0;
            double kT = this.temperatures[windowIndex] * 0.0019872042586408316;
            double beta = 1.0 / kT;
            int numSamples = referenceEnergy.length;
            if (numSamples == 0) {
                logger.log(warningLevel, " Skipping frame " + i + " due to lack of snapshots!");
                continue;
            }
            int[] sampleIndices = randomSamples ? EstimateBootstrapper.getBootstrapIndices(numSamples, this.random) : IntStream.range(0, numSamples).toArray();
            double boltzmannFactorSum = 0.0;
            double weightedMeanEnergy = 0.0;
            double meanEnergy = 0.0;
            for (int j = 0; j < numSamples; ++j) {
                int index = sampleIndices[j];
                double dE = perturbedEnergy[index] - referenceEnergy[index];
                double weight = FastMath.exp((double)(-beta * dE));
                boltzmannFactorSum += weight;
                if (this.forwards) {
                    meanEnergy += referenceEnergy[index];
                    weightedMeanEnergy += perturbedEnergy[index] * weight;
                    continue;
                }
                meanEnergy += perturbedEnergy[index];
                weightedMeanEnergy += referenceEnergy[index] * weight;
            }
            meanEnergy /= (double)numSamples;
            double dG = -sign * kT * FastMath.log((double)(boltzmannFactorSum / (double)numSamples));
            if (Double.isNaN(dG) || Double.isInfinite(dG)) {
                logger.severe(String.format(" Change in free energy (%9.4f) for window (%2d of %2d) failed. Sign: %9.4f, Beta: %9.4f, Temp: %9.4f, Sum: %9.4f, Len: %3d, Log: %9.4f", dG, i, this.nWindows, sign, kT, this.temperatures[windowIndex], boltzmannFactorSum, numSamples, FastMath.log((double)(boltzmannFactorSum / (double)numSamples))));
            }
            this.freeEnergyDifferences[i] = dG;
            this.enthalpyDifferences[i] = sign * (weightedMeanEnergy / boltzmannFactorSum - meanEnergy);
            this.freeEnergyDifferenceUncertainties[i] = 0.0;
            this.totalEnthalpyDifference += this.enthalpyDifferences[i];
            cumDG += dG;
        }
        this.totalFreeEnergyDifference = cumDG;
        this.totalFreeEnergyDifferenceUncertainty = 0.0;
    }

    @Override
    public final void estimateDG() {
        this.estimateDG(false);
    }

    @Override
    public double getTotalFreeEnergyDifference() {
        return this.totalFreeEnergyDifference;
    }

    @Override
    public double[] getFreeEnergyDifferences() {
        return Arrays.copyOf(this.freeEnergyDifferences, this.nWindows);
    }

    @Override
    public double getTotalFEDifferenceUncertainty() {
        return this.totalFreeEnergyDifferenceUncertainty;
    }

    @Override
    public double[] getFEDifferenceUncertainties() {
        return Arrays.copyOf(this.freeEnergyDifferenceUncertainties, this.nWindows);
    }

    @Override
    public int getNumberOfBins() {
        return this.nWindows;
    }

    @Override
    public double getTotalEnthalpyDifference() {
        return this.totalEnthalpyDifference;
    }

    @Override
    public double[] getEnthalpyDifferences() {
        return Arrays.copyOf(this.enthalpyDifferences, this.nWindows);
    }

    public static enum Directionality {
        FORWARDS,
        BACKWARDS;

    }
}

