/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.BennettAcceptanceRatio;
import ffx.numerics.estimator.EstimateBootstrapper;
import ffx.numerics.math.BootStrapStatistics;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class FreeEnergyDifferenceReporter {
    private static final Logger logger = Logger.getLogger(FreeEnergyDifferenceReporter.class.getName());
    private final int nStates;
    private final double[][] energiesLow;
    private final double[][] energiesAt;
    private final double[][] energiesHigh;
    private final double[][] volume;
    private final double[] lambdaValues;
    private final double[] temperature;
    private final double eps;
    private final int nIterations;
    final long MIN_BOOTSTRAP_TRIALS = 1000L;
    private double forwardTotalFEDifference;
    private double forwardTotalEnthalpyChange;
    private double forwardTotalEntropyChange;
    private double backwardTotalFEDifference;
    private double backwardTotalEnthalpyChange;
    private double backwardTotalEntropyChange;
    private double barIterTotalFEDiff;
    private double barBSTotalFEDiff;
    private double barBSTotalEnthalpyChange;
    private double barBSTotalEntropyChange;

    public FreeEnergyDifferenceReporter(int nStates, double[] lambdaValues, double[] temperature, double eps, int nIterations, double[][] energiesLow, double[][] energiesAt, double[][] energiesHigh, double[][] volume) {
        this.nStates = nStates;
        this.energiesLow = energiesLow;
        this.energiesAt = energiesAt;
        this.energiesHigh = energiesHigh;
        this.volume = volume;
        this.lambdaValues = lambdaValues;
        this.temperature = temperature;
        this.eps = eps;
        this.nIterations = nIterations;
    }

    public void report() {
        int n;
        double[] energyMean = new double[this.nStates];
        double[] energySD = new double[this.nStates];
        double[] energyVar = new double[this.nStates];
        for (int state = 0; state < this.nStates; ++state) {
            BootStrapStatistics energyStats = new BootStrapStatistics(this.energiesAt[state]);
            energyMean[state] = energyStats.mean;
            energySD[state] = energyStats.sd;
            energyVar[state] = energyStats.var;
        }
        BennettAcceptanceRatio bar = new BennettAcceptanceRatio(this.lambdaValues, this.energiesLow, this.energiesAt, this.energiesHigh, this.temperature, this.eps, this.nIterations);
        this.barIterTotalFEDiff = bar.getTotalFreeEnergyDifference();
        double barIterFEDiffTotalUncertainty = bar.getTotalFEDifferenceUncertainty();
        double[] barIterFEDifferences = bar.getFreeEnergyDifferences();
        double[] barIterFEDiffUncertainties = bar.getFEDifferenceUncertainties();
        EstimateBootstrapper barBS = new EstimateBootstrapper(bar);
        EstimateBootstrapper forwardBS = new EstimateBootstrapper(bar.getInitialForwardsGuess());
        EstimateBootstrapper backwardBS = new EstimateBootstrapper(bar.getInitialBackwardsGuess());
        int numSnapshots = this.energiesAt[0].length;
        int trials = (int)(1.0E8 / (double)numSnapshots);
        long bootstrap = FastMath.min((long)1000L, (long)trials);
        logger.info(String.format(" Number of bootstrap trials: %d", bootstrap));
        long time = -System.nanoTime();
        forwardBS.bootstrap(bootstrap);
        logger.fine(String.format(" Forward FEP Bootstrap Complete:      %7.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
        this.forwardTotalFEDifference = forwardBS.getTotalFreeEnergyDifference();
        double forwardTotalFEDiffUncertainty = forwardBS.getTotalFEDifferenceUncertainty();
        this.forwardTotalEnthalpyChange = forwardBS.getTotalEnthalpyChange();
        double forwardTotalEnthalpyUncertainty = forwardBS.getTotalEnthalpyUncertainty();
        time = -System.nanoTime();
        backwardBS.bootstrap(bootstrap);
        logger.fine(String.format(" Backward FEP Bootstrap Complete:     %7.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
        this.backwardTotalFEDifference = backwardBS.getTotalFreeEnergyDifference();
        double backwardTotalFEDiffUncertainty = backwardBS.getTotalFEDifferenceUncertainty();
        this.backwardTotalEnthalpyChange = backwardBS.getTotalEnthalpyChange();
        double backwardTotalEnthalpyUncertainty = backwardBS.getTotalEnthalpyUncertainty();
        time = -System.nanoTime();
        barBS.bootstrap(bootstrap);
        logger.fine(String.format(" BAR Bootstrap Complete:              %7.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
        this.barBSTotalFEDiff = barBS.getTotalFreeEnergyDifference();
        double barBSTotalFEDiffUncertainty = barBS.getTotalFEDifferenceUncertainty();
        this.barBSTotalEnthalpyChange = barBS.getTotalEnthalpyChange();
        double barBSTotalEnthalpyUncertainty = barBS.getTotalEnthalpyUncertainty();
        if (this.nStates > 2) {
            logger.info("\n Window Free Energy Differences (kcal/mol)");
            logger.info("        Forward FEP           Backward FEP          BAR Iteration         BAR Bootstrap");
            double[] forwardFEDifferences = forwardBS.getFreeEnergyDifferences();
            double[] forwardFEDUncertainty = forwardBS.getFEDifferenceStdDevs();
            double[] backwardFEDifferences = backwardBS.getFreeEnergyDifferences();
            double[] backwardFEDUncertainty = backwardBS.getFEDifferenceStdDevs();
            double[] barBSFE = barBS.getFreeEnergyDifferences();
            double[] barBSUncertaintyFE = barBS.getFEDifferenceStdDevs();
            for (int n2 = 0; n2 < this.nStates - 1; ++n2) {
                logger.info(String.format(" %2d %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", n2, forwardFEDifferences[n2], forwardFEDUncertainty[n2], backwardFEDifferences[n2], backwardFEDUncertainty[n2], barIterFEDifferences[n2], barIterFEDiffUncertainties[n2], barBSFE[n2], barBSUncertaintyFE[n2]));
            }
        }
        logger.info("\n Total Free Energy Difference (kcal/mol)");
        logger.info("        Forward FEP           Backward FEP          BAR Iteration         BAR Bootstrap");
        logger.info(String.format("    %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", this.forwardTotalFEDifference, forwardTotalFEDiffUncertainty, this.backwardTotalFEDifference, backwardTotalFEDiffUncertainty, this.barIterTotalFEDiff, barIterFEDiffTotalUncertainty, this.barBSTotalFEDiff, barBSTotalFEDiffUncertainty));
        logger.info("\n Enthalpy from Potential Energy Averages (kcal/mol)\n");
        for (int n3 = 0; n3 < this.nStates; ++n3) {
            logger.info(String.format(" State %2d:     %12.4f +/- %6.4f", n3, energyMean[n3], energySD[n3]));
        }
        double enthalpyDiff = energyMean[this.nStates - 1] - energyMean[0];
        double enthalpyDiffSD = Math.sqrt(energyVar[this.nStates - 1] + energyVar[0]);
        logger.info(String.format(" Enthalpy via Direct Estimate:   %12.4f +/- %6.4f", enthalpyDiff, enthalpyDiffSD));
        if (this.nStates > 2) {
            logger.info("\n Window Enthalpy Differences (kcal/mol)");
            logger.info("        Forward FEP           Backward FEP          BAR Bootstrap");
            double[] forwardEnthalpyDifferences = forwardBS.getEnthalpyChanges();
            double[] forwardEnthalpyUncertainty = forwardBS.getEnthalpyStdDevs();
            double[] backwardEnthalpyDifferences = backwardBS.getEnthalpyChanges();
            double[] backwardEnthalpyUncertainty = backwardBS.getEnthalpyStdDevs();
            double[] barBSenthalpy = barBS.getEnthalpyChanges();
            double[] barBSenthalpyUncertainty = barBS.getEnthalpyStdDevs();
            for (n = 0; n < this.nStates - 1; ++n) {
                logger.info(String.format(" %2d %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", n, forwardEnthalpyDifferences[n], forwardEnthalpyUncertainty[n], backwardEnthalpyDifferences[n], backwardEnthalpyUncertainty[n], barBSenthalpy[n], barBSenthalpyUncertainty[n]));
            }
        }
        logger.info("\n Total Enthalpy Difference (kcal/mol)");
        logger.info("        Forward FEP           Backward FEP          BAR Bootstrap");
        logger.info(String.format("    %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", this.forwardTotalEnthalpyChange, forwardTotalEnthalpyUncertainty, this.backwardTotalEnthalpyChange, backwardTotalEnthalpyUncertainty, this.barBSTotalEnthalpyChange, barBSTotalEnthalpyUncertainty));
        if (this.nStates > 2) {
            logger.info("\n Window Entropy Differences -T*dS (kcal/mol)");
            logger.info("        Forward FEP           Backward FEP          BAR Bootstrap");
            double[] forwardEntropyDifferences = forwardBS.getEntropyChanges();
            double[] forwardEntropyUncertainty = forwardBS.getEntropyStdDevs();
            double[] backwardEntropyDifferences = backwardBS.getEntropyChanges();
            double[] backwardEntropyUncertainty = backwardBS.getEntropyStdDevs();
            double[] barBSEntropy = barBS.getEntropyChanges();
            double[] barBSEntropyUncertainty = barBS.getEntropyStdDevs();
            for (n = 0; n < this.nStates - 1; ++n) {
                logger.info(String.format(" %2d %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", n, forwardEntropyDifferences[n], forwardEntropyUncertainty[n], backwardEntropyDifferences[n], backwardEntropyUncertainty[n], barBSEntropy[n], barBSEntropyUncertainty[n]));
            }
        }
        this.forwardTotalEntropyChange = forwardBS.getTotalEntropyChange();
        double forwardTotalEntropyUncertainty = forwardBS.getTotalEntropyUncertainty();
        this.backwardTotalEntropyChange = backwardBS.getTotalEntropyChange();
        double backwardTotalEntropyUncertainty = backwardBS.getTotalEntropyUncertainty();
        this.barBSTotalEntropyChange = barBS.getTotalEntropyChange();
        double barBSTotalEntropyUncertainty = barBS.getTotalEntropyUncertainty();
        logger.info("\n Total Entropy Difference -T*dS (kcal/mol)");
        logger.info("        Forward FEP           Backward FEP          BAR Bootstrap");
        logger.info(String.format("    %10.4f +/- %6.4f %10.4f +/- %6.4f %10.4f +/- %6.4f", this.forwardTotalEntropyChange, forwardTotalEntropyUncertainty, this.backwardTotalEntropyChange, backwardTotalEntropyUncertainty, this.barBSTotalEntropyChange, barBSTotalEntropyUncertainty));
    }

    public double getForwardTotalFEDifference() {
        return this.forwardTotalFEDifference;
    }

    public double getForwardTotalEnthalpyChange() {
        return this.forwardTotalEnthalpyChange;
    }

    public double getForwardTotalEntropyChange() {
        return this.forwardTotalEntropyChange;
    }

    public double getBackwardTotalFEDifference() {
        return this.backwardTotalFEDifference;
    }

    public double getBackwardTotalEnthalpyChange() {
        return this.backwardTotalEnthalpyChange;
    }

    public double getBackwardTotalEntropyChange() {
        return this.backwardTotalEntropyChange;
    }

    public double getBarIterTotalFEDiff() {
        return this.barIterTotalFEDiff;
    }

    public double getBarBSTotalFEDiff() {
        return this.barBSTotalFEDiff;
    }

    public double getBarBSTotalEnthalpyChange() {
        return this.barBSTotalEnthalpyChange;
    }

    public double getBarBSTotalEntropyChange() {
        return this.barBSTotalEntropyChange;
    }
}

