/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering.visualization;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.visualization.Paintable;
import ffx.numerics.clustering.visualization.VCoord;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ClusterComponent
implements Paintable {
    private Cluster cluster;
    private VCoord linkPoint;
    private VCoord initPoint;
    private boolean printName;
    private int dotRadius = 2;
    private int namePadding = 6;
    private List<ClusterComponent> children;

    public List<ClusterComponent> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ClusterComponent>();
        }
        return this.children;
    }

    public int getNamePadding() {
        return this.namePadding;
    }

    public void setNamePadding(int namePadding) {
        this.namePadding = namePadding;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    public void setChildren(List<ClusterComponent> children) {
        this.children = children;
    }

    public VCoord getLinkPoint() {
        return this.linkPoint;
    }

    public void setLinkPoint(VCoord linkPoint) {
        this.linkPoint = linkPoint;
    }

    public VCoord getInitPoint() {
        return this.initPoint;
    }

    public void setInitPoint(VCoord initPoint) {
        this.initPoint = initPoint;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public boolean isPrintName() {
        return this.printName;
    }

    public void setPrintName(boolean printName) {
        this.printName = printName;
    }

    public ClusterComponent(Cluster cluster, boolean printName, VCoord initPoint) {
        this.printName = printName;
        this.cluster = cluster;
        this.initPoint = initPoint;
        this.linkPoint = initPoint;
    }

    @Override
    public void paint(Graphics2D g, int xDisplayOffset, int yDisplayOffset, double xDisplayFactor, double yDisplayFactor, boolean decorated) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int x1 = (int)(this.initPoint.x() * xDisplayFactor + (double)xDisplayOffset);
        int y1 = (int)(this.initPoint.y() * yDisplayFactor + (double)yDisplayOffset);
        int x2 = (int)(this.linkPoint.x() * xDisplayFactor + (double)xDisplayOffset);
        int y2 = y1;
        g.fillOval(x1 - this.dotRadius, y1 - this.dotRadius, this.dotRadius * 2, this.dotRadius * 2);
        g.drawLine(x1, y1, x2, y2);
        if (this.cluster.isLeaf()) {
            g.drawString(this.cluster.getName(), x1 + this.namePadding, y1 + fontMetrics.getHeight() / 2 - 2);
        }
        if (decorated && this.cluster.getDistance() != null && !this.cluster.getDistance().isNaN() && this.cluster.getDistance().getDistance() > 0.0) {
            String s = String.format("%.2f", this.cluster.getDistance().getDistance());
            Rectangle2D rect = fontMetrics.getStringBounds(s, g);
            g.drawString(s, x1 - (int)rect.getWidth(), y1 - 2);
        }
        x1 = x2;
        y1 = y2;
        y2 = (int)(this.linkPoint.y() * yDisplayFactor + (double)yDisplayOffset);
        g.drawLine(x1, y1, x2, y2);
        for (ClusterComponent child : this.children) {
            child.paint(g, xDisplayOffset, yDisplayOffset, xDisplayFactor, yDisplayFactor, decorated);
        }
    }

    public double getRectMinX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.min(this.initPoint.x(), this.linkPoint.x());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.min(val, child.getRectMinX());
        }
        return val;
    }

    public double getRectMinY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.min(this.initPoint.y(), this.linkPoint.y());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.min(val, child.getRectMinY());
        }
        return val;
    }

    public double getRectMaxX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.max(this.initPoint.x(), this.linkPoint.x());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.max(val, child.getRectMaxX());
        }
        return val;
    }

    public double getRectMaxY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.max(this.initPoint.y(), this.linkPoint.y());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.max(val, child.getRectMaxY());
        }
        return val;
    }

    public int getNameWidth(Graphics2D g, boolean includeNonLeafs) {
        int width = 0;
        if (includeNonLeafs || this.cluster.isLeaf()) {
            Rectangle2D rect = g.getFontMetrics().getStringBounds(this.cluster.getName(), g);
            width = (int)rect.getWidth();
        }
        return width;
    }

    public int getMaxNameWidth(Graphics2D g, boolean includeNonLeafs) {
        int width = this.getNameWidth(g, includeNonLeafs);
        for (ClusterComponent comp : this.getChildren()) {
            int childWidth = comp.getMaxNameWidth(g, includeNonLeafs);
            if (childWidth <= width) continue;
            width = childWidth;
        }
        return width;
    }
}

