/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.ClusterPair;
import ffx.numerics.clustering.ClusteringAlgorithm;
import ffx.numerics.clustering.DistanceMap;
import ffx.numerics.clustering.HierarchyBuilder;
import ffx.numerics.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.List;

public class PDistClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        if (distances == null || distances.length == 0) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (distances[0].length != clusterNames.length * (clusterNames.length - 1) / 2) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        List<Cluster> clusters = this.createClusters(clusterNames);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        while (!builder.isTreeComplete()) {
            builder.agglomerate(linkageStrategy);
        }
        return builder.getRootCluster();
    }

    @Override
    public List<Cluster> performFlatClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy, Double threshold) {
        if (distances == null || distances.length == 0) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (distances[0].length != clusterNames.length * (clusterNames.length - 1) / 2) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        List<Cluster> clusters = this.createClusters(clusterNames);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        return builder.flatAgg(linkageStrategy, threshold);
    }

    @Override
    public Cluster performWeightedClustering(double[][] distances, String[] clusterNames, double[] weights, LinkageStrategy linkageStrategy) {
        return this.performClustering(distances, clusterNames, linkageStrategy);
    }

    private DistanceMap createLinkages(double[][] distances, List<Cluster> clusters) {
        DistanceMap linkages = new DistanceMap();
        for (int col = 0; col < clusters.size(); ++col) {
            Cluster cluster_col = clusters.get(col);
            for (int row = col + 1; row < clusters.size(); ++row) {
                ClusterPair link = new ClusterPair();
                Double d = distances[0][PDistClusteringAlgorithm.accessFunction(row, col, clusters.size())];
                link.setLinkageDistance(d);
                link.setlCluster(cluster_col);
                link.setrCluster(clusters.get(row));
                linkages.add(link);
            }
        }
        return linkages;
    }

    private List<Cluster> createClusters(String[] clusterNames) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (String clusterName : clusterNames) {
            Cluster cluster = new Cluster(clusterName);
            cluster.addLeafName(clusterName);
            clusters.add(cluster);
        }
        return clusters;
    }

    private static int accessFunction(int i, int j, int n) {
        return n * j - j * (j + 1) / 2 + i - 1 - j;
    }
}

