/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.atomic;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiDoubleArray
implements AtomicDoubleArray {
    private static final Logger logger = Logger.getLogger(MultiDoubleArray.class.getName());
    private final int threadCount;
    private final double[][] array;
    private int size;

    public MultiDoubleArray(int threadCount, int arraySize) {
        this.size = arraySize;
        this.array = new double[threadCount][arraySize];
        this.threadCount = threadCount;
    }

    @Override
    public void add(int threadID, int index, double value) {
        double[] dArray = this.array[threadID];
        int n = index;
        dArray[n] = dArray[n] + value;
    }

    @Override
    public void alloc(int arraySize) {
        this.size = arraySize;
        for (int i = 0; i < this.threadCount; ++i) {
            if (this.array[i].length >= arraySize) continue;
            this.array[i] = new double[arraySize];
        }
    }

    @Override
    public double get(int index) {
        return this.array[0][index];
    }

    @Override
    public void reduce(int lb, int ub) {
        double[] mainArray = this.array[0];
        for (int t = 1; t < this.threadCount; ++t) {
            double[] threadArray = this.array[t];
            this.reduceFromThreads(mainArray, threadArray, lb, ub);
        }
    }

    private void reduceFromThreads(double[] mainArray, double[] threadArray, int lb, int ub) {
        for (int i = lb; i <= ub; ++i) {
            int n = i;
            mainArray[n] = mainArray[n] + threadArray[i];
        }
    }

    @Override
    public void reduce(ParallelTeam parallelTeam, final int lb, final int ub) {
        try {
            parallelTeam.execute(new ParallelRegion(this){
                final /* synthetic */ MultiDoubleArray this$0;
                {
                    MultiDoubleArray multiDoubleArray = this$0;
                    Objects.requireNonNull(multiDoubleArray);
                    this.this$0 = multiDoubleArray;
                }

                public void run() throws Exception {
                    this.execute(lb, ub, new IntegerForLoop(this){
                        final /* synthetic */ 1 this$1;
                        {
                            1 v0 = this$1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                        }

                        public void run(int first, int last) {
                            this.this$1.this$0.reduce(first, last);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception reducing a MultiDoubleArray", e);
        }
    }

    @Override
    public void reset(int threadID, int lb, int ub) {
        Arrays.fill(this.array[threadID], 0.0);
    }

    @Override
    public void reset(ParallelTeam parallelTeam, final int lb, final int ub) {
        try {
            parallelTeam.execute(new ParallelRegion(this){
                final /* synthetic */ MultiDoubleArray this$0;
                {
                    MultiDoubleArray multiDoubleArray = this$0;
                    Objects.requireNonNull(multiDoubleArray);
                    this.this$0 = multiDoubleArray;
                }

                public void run() throws Exception {
                    this.execute(0, this.this$0.threadCount - 1, new IntegerForLoop(this){
                        final /* synthetic */ 2 this$1;
                        {
                            2 v0 = this$1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                        }

                        public void run(int first, int last) {
                            for (int i = first; i <= last; ++i) {
                                this.this$1.this$0.reset(i, lb, ub);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception resetting a MultiDoubleArray", e);
        }
    }

    @Override
    public void scale(int threadID, int index, double value) {
        double[] dArray = this.array[threadID];
        int n = index;
        dArray[n] = dArray[n] * value;
    }

    @Override
    public void set(int threadID, int index, double value) {
        this.array[threadID][index] = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sub(int threadID, int index, double value) {
        double[] dArray = this.array[threadID];
        int n = index;
        dArray[n] = dArray[n] - value;
    }
}

