/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.atomic;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AdderDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.MultiDoubleArray;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import java.util.Objects;

public class AtomicDoubleArray3D {
    private final AtomicDoubleArray[] atomicDoubleArray;
    private final AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl;
    private final ParallelRegion3D parallelRegion3D = new ParallelRegion3D(this);

    public AtomicDoubleArray3D(AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl, int size) {
        this(atomicDoubleArrayImpl, size, ParallelTeam.getDefaultThreadCount());
    }

    public AtomicDoubleArray3D(AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl, int size, int nThreads) {
        this.atomicDoubleArray = new AtomicDoubleArray[3];
        this.atomicDoubleArray[0] = atomicDoubleArrayImpl.createInstance(nThreads, size);
        this.atomicDoubleArray[1] = atomicDoubleArrayImpl.createInstance(nThreads, size);
        this.atomicDoubleArray[2] = atomicDoubleArrayImpl.createInstance(nThreads, size);
        this.atomicDoubleArrayImpl = atomicDoubleArrayImpl;
    }

    public AtomicDoubleArray3D(AtomicDoubleArray x, AtomicDoubleArray y, AtomicDoubleArray z) {
        this.atomicDoubleArray = new AtomicDoubleArray[3];
        this.atomicDoubleArray[0] = x;
        this.atomicDoubleArray[1] = y;
        this.atomicDoubleArray[2] = z;
        this.atomicDoubleArrayImpl = x instanceof MultiDoubleArray ? AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI : (x instanceof AdderDoubleArray ? AtomicDoubleArray.AtomicDoubleArrayImpl.ADDER : AtomicDoubleArray.AtomicDoubleArrayImpl.PJ);
    }

    public void add(int threadID, int index, double x, double y, double z) {
        this.atomicDoubleArray[0].add(threadID, index, x);
        this.atomicDoubleArray[1].add(threadID, index, y);
        this.atomicDoubleArray[2].add(threadID, index, z);
    }

    public void add(int threadID, int index, Double3 d3) {
        this.atomicDoubleArray[0].add(threadID, index, d3.x());
        this.atomicDoubleArray[1].add(threadID, index, d3.y());
        this.atomicDoubleArray[2].add(threadID, index, d3.z());
    }

    public void alloc(int size) {
        this.atomicDoubleArray[0].alloc(size);
        this.atomicDoubleArray[1].alloc(size);
        this.atomicDoubleArray[2].alloc(size);
    }

    public double get(int dim, int index) {
        return this.atomicDoubleArray[dim].get(index);
    }

    public Double3 get(int index) {
        return new Double3(this.atomicDoubleArray[0].get(index), this.atomicDoubleArray[1].get(index), this.atomicDoubleArray[2].get(index));
    }

    public double getX(int index) {
        return this.atomicDoubleArray[0].get(index);
    }

    public double getY(int index) {
        return this.atomicDoubleArray[1].get(index);
    }

    public double getZ(int index) {
        return this.atomicDoubleArray[2].get(index);
    }

    public void reduce(int lb, int ub) {
        if (Objects.requireNonNull(this.atomicDoubleArrayImpl) == AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI) {
            this.atomicDoubleArray[0].reduce(lb, ub);
            this.atomicDoubleArray[1].reduce(lb, ub);
            this.atomicDoubleArray[2].reduce(lb, ub);
        }
    }

    public void reduce(ParallelTeam parallelTeam) {
        if (Objects.requireNonNull(this.atomicDoubleArrayImpl) == AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI) {
            this.parallelRegion3D.setOperation(Operation.REDUCE);
            try {
                parallelTeam.execute((ParallelRegion)this.parallelRegion3D);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void reset(int threadID, int lb, int ub) {
        this.atomicDoubleArray[0].reset(threadID, lb, ub);
        this.atomicDoubleArray[1].reset(threadID, lb, ub);
        this.atomicDoubleArray[2].reset(threadID, lb, ub);
    }

    public void reset(ParallelTeam parallelTeam) {
        this.parallelRegion3D.setOperation(Operation.RESET);
        try {
            parallelTeam.execute((ParallelRegion)this.parallelRegion3D);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void scale(int threadID, int index, double scale) {
        this.atomicDoubleArray[0].scale(threadID, index, scale);
        this.atomicDoubleArray[1].scale(threadID, index, scale);
        this.atomicDoubleArray[2].scale(threadID, index, scale);
    }

    public void set(int threadID, int index, double x, double y, double z) {
        this.atomicDoubleArray[0].set(threadID, index, x);
        this.atomicDoubleArray[1].set(threadID, index, y);
        this.atomicDoubleArray[2].set(threadID, index, z);
    }

    public void set(int threadID, int index, Double3 d3) {
        this.atomicDoubleArray[0].set(threadID, index, d3.x());
        this.atomicDoubleArray[1].set(threadID, index, d3.y());
        this.atomicDoubleArray[2].set(threadID, index, d3.z());
    }

    public void sub(int threadID, int index, double x, double y, double z) {
        this.atomicDoubleArray[0].sub(threadID, index, x);
        this.atomicDoubleArray[1].sub(threadID, index, y);
        this.atomicDoubleArray[2].sub(threadID, index, z);
    }

    public void sub(int threadID, int index, Double3 d3) {
        this.atomicDoubleArray[0].sub(threadID, index, d3.x());
        this.atomicDoubleArray[1].sub(threadID, index, d3.y());
        this.atomicDoubleArray[2].sub(threadID, index, d3.z());
    }

    public String toString(int index) {
        String defaultLabel = " " + index + ": ";
        return this.toString(index, defaultLabel);
    }

    public String toString(int index, String label) {
        double[] d = new double[]{this.getX(index), this.getY(index), this.getZ(index)};
        return DoubleMath.toString(d, label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.atomicDoubleArray.length; ++i) {
            sb.append(this.toString(i)).append("\n");
        }
        return sb.toString();
    }

    public String toString(String label) {
        StringBuilder sb = new StringBuilder();
        if (label.contains("%d")) {
            for (int i = 0; i < this.atomicDoubleArray[0].size(); ++i) {
                sb.append(this.toString(i, String.format(label, i))).append("\n");
            }
        } else {
            for (int i = 0; i < this.atomicDoubleArray[0].size(); ++i) {
                sb.append(this.toString(i, label)).append("\n");
            }
        }
        return sb.toString();
    }

    private class ParallelRegion3D
    extends ParallelRegion {
        private Operation operation;
        private IntegerForLoop3D[] integerForLoop3D;
        final /* synthetic */ AtomicDoubleArray3D this$0;

        public ParallelRegion3D(AtomicDoubleArray3D atomicDoubleArray3D) {
            AtomicDoubleArray3D atomicDoubleArray3D2 = atomicDoubleArray3D;
            Objects.requireNonNull(atomicDoubleArray3D2);
            this.this$0 = atomicDoubleArray3D2;
            this.operation = Operation.RESET;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public void start() {
            int nThreads = this.getThreadCount();
            if (this.integerForLoop3D == null) {
                this.integerForLoop3D = new IntegerForLoop3D[nThreads];
            }
        }

        public void run() throws Exception {
            int threadID = this.getThreadIndex();
            if (this.integerForLoop3D[threadID] == null) {
                this.integerForLoop3D[threadID] = new IntegerForLoop3D(this);
            }
            int size = this.this$0.atomicDoubleArray[0].size();
            this.execute(0, size - 1, this.integerForLoop3D[threadID]);
        }

        private class IntegerForLoop3D
        extends IntegerForLoop {
            final /* synthetic */ ParallelRegion3D this$1;

            private IntegerForLoop3D(ParallelRegion3D parallelRegion3D) {
                ParallelRegion3D parallelRegion3D2 = parallelRegion3D;
                Objects.requireNonNull(parallelRegion3D2);
                this.this$1 = parallelRegion3D2;
            }

            public void run(int lb, int ub) {
                int threadID = this.getThreadIndex();
                switch (this.this$1.operation.ordinal()) {
                    case 0: {
                        this.this$1.this$0.reset(threadID, lb, ub);
                        break;
                    }
                    case 1: {
                        this.this$1.this$0.reduce(lb, ub);
                    }
                }
            }
        }
    }

    private static enum Operation {
        RESET,
        REDUCE;

    }
}

