/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.atomic;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray;
import java.util.Objects;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdderDoubleArray
implements AtomicDoubleArray {
    private static final Logger logger = Logger.getLogger(AdderDoubleArray.class.getName());
    private static final double ZERO_VALUE = 0.0;
    private DoubleAdder[] doubleAdders;
    private int arraySize;

    public AdderDoubleArray(int size) {
        this.arraySize = size;
        this.doubleAdders = this.createDoubleAdders(size);
    }

    private DoubleAdder[] createDoubleAdders(int size) {
        DoubleAdder[] adders = new DoubleAdder[size];
        for (int i = 0; i < size; ++i) {
            adders[i] = new DoubleAdder();
        }
        return adders;
    }

    @Override
    public void add(int threadID, int index, double value) {
        this.doubleAdders[index].add(value);
    }

    @Override
    public void alloc(int size) {
        this.arraySize = size;
        if (this.doubleAdders.length < size) {
            this.doubleAdders = this.createDoubleAdders(size);
        }
    }

    @Override
    public double get(int index) {
        return this.doubleAdders[index].sum();
    }

    @Override
    public void reduce(int lb, int ub) {
    }

    @Override
    public void reduce(ParallelTeam parallelTeam, int lb, int ub) {
    }

    @Override
    public void reset(int threadID, int lb, int ub) {
        this.resetRange(lb, ub);
    }

    @Override
    public void reset(ParallelTeam parallelTeam, final int lb, final int ub) {
        try {
            parallelTeam.execute(new ParallelRegion(this){
                final /* synthetic */ AdderDoubleArray this$0;
                {
                    AdderDoubleArray adderDoubleArray = this$0;
                    Objects.requireNonNull(adderDoubleArray);
                    this.this$0 = adderDoubleArray;
                }

                public void run() throws Exception {
                    this.execute(lb, ub, new IntegerForLoop(this){
                        final /* synthetic */ 1 this$1;
                        {
                            1 v0 = this$1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                        }

                        public void run(int first, int last) {
                            this.this$1.this$0.resetRange(first, last);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception resetting an AdderDoubleArray", e);
        }
    }

    private void resetRange(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.resetAdder(this.doubleAdders[i]);
        }
    }

    private void resetAdder(DoubleAdder adder) {
        adder.reset();
        adder.add(0.0);
    }

    @Override
    public void scale(int threadID, int index, double value) {
        double current = this.doubleAdders[index].sumThenReset();
        this.doubleAdders[index].add(current * value);
    }

    @Override
    public void set(int threadID, int index, double value) {
        this.resetAdder(this.doubleAdders[index]);
        this.doubleAdders[index].add(value);
    }

    @Override
    public int size() {
        return this.arraySize;
    }

    @Override
    public void sub(int threadID, int index, double value) {
        this.doubleAdders[index].add(-value);
    }
}

