/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.solvent;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.SpatialDensityLoop;
import ffx.potential.nonbonded.SpatialDensityRegion;
import ffx.xray.solvent.BulkSolventList;
import java.util.Arrays;

public class BulkSolventDensityRegion
extends SpatialDensityRegion {
    private final BulkSolventList bulkSolventList;

    public BulkSolventDensityRegion(int gX, int gY, int gZ, double[] grid, int basisSize, int nSymm, int minWork, int threadCount, Crystal crystal, Atom[] atoms, double[][][] coordinates, double cutoff, ParallelTeam parallelTeam) {
        super(gX, gY, gZ, grid, basisSize, nSymm, minWork, threadCount, crystal, atoms, coordinates);
        Arrays.fill(this.select[0], false);
        this.bulkSolventList = new BulkSolventList(crystal, atoms, cutoff, parallelTeam);
    }

    public void run() {
        int ti = this.getThreadIndex();
        int actualWork1 = this.actualWork - 1;
        SpatialDensityLoop loop = this.spatialDensityLoop[ti];
        try {
            this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(0));
            if (this.nC > 1) {
                this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(1));
                if (this.nB > 1) {
                    this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(2));
                    this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(3));
                    if (this.nA > 1) {
                        this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(4));
                        this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(5));
                        this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(6));
                        this.execute(0, actualWork1, (IntegerForLoop)loop.setOctant(7));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.toString());
        }
    }

    public void selectAtoms() {
        this.bulkSolventList.buildList(this.coordinates, this.select, false);
    }
}

