/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.xray.scatter.XrayParametersCCTBX;
import ffx.xray.scatter.XrayParametersSuCoppens;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;

public record XRayScatteringParameters(String name, int atomicNumber, int charge, int numberOfGaussians, double[][] formFactor) {
    private static final Logger logger;
    private static final HashMap<String, XRayScatteringParameters> formFactorsSuCoppens;
    private static final HashMap<String, XRayScatteringParameters> formFactorsCCTBX;

    @Override
    public String toString() {
        return String.format(" %s %d Charge: %d Gaussian Amplitudes (%d): %s", this.name, this.atomicNumber, this.charge, this.numberOfGaussians, Arrays.toString(this.formFactor[1]));
    }

    public static XRayScatteringParameters getFormFactor(int atomicNumber, int charge, boolean use3G) {
        XRayScatteringParameters parameters = null;
        if (use3G) {
            parameters = XRayScatteringParameters.getFormFactorCCTBX(atomicNumber, charge);
        }
        if (parameters == null) {
            parameters = XRayScatteringParameters.getFormFactorSuCoppens(atomicNumber, charge);
        }
        if (parameters == null) {
            String message = String.format(" Parameters not found for %d with charge %d", atomicNumber, charge);
            logger.severe(message);
        }
        return parameters;
    }

    public static XRayScatteringParameters getFormFactorSuCoppens(int atomicNumber, int charge) {
        String key = Integer.toString(atomicNumber);
        String keyWithCharge = key + "_" + charge;
        if (formFactorsSuCoppens.containsKey(keyWithCharge)) {
            return formFactorsSuCoppens.get(keyWithCharge);
        }
        return formFactorsSuCoppens.getOrDefault(key, null);
    }

    public static XRayScatteringParameters getFormFactorCCTBX(int atomicNumber, int charge) {
        String key = Integer.toString(atomicNumber);
        String keyWithCharge = key + "_" + charge;
        if (formFactorsCCTBX.containsKey(keyWithCharge)) {
            return formFactorsCCTBX.get(keyWithCharge);
        }
        return formFactorsCCTBX.getOrDefault(key, null);
    }

    static {
        XRayScatteringParameters factor;
        int numberOfGaussians;
        int charge;
        int atomicNumber;
        String[] descriptions;
        String environment;
        int i;
        logger = Logger.getLogger(XRayScatteringParameters.class.getName());
        formFactorsSuCoppens = new HashMap();
        formFactorsCCTBX = new HashMap();
        String[] atoms = XrayParametersSuCoppens.atoms;
        String[] atomsi = XrayParametersSuCoppens.atomsi;
        double[][][] ffactors = XrayParametersSuCoppens.ffactors;
        for (i = 0; i < atoms.length; ++i) {
            environment = atomsi[i];
            descriptions = environment.split("_");
            atomicNumber = Integer.parseInt(descriptions[0]);
            charge = 0;
            if (descriptions.length > 1) {
                charge = Integer.parseInt(descriptions[1]);
            }
            numberOfGaussians = ffactors[i][1].length;
            factor = new XRayScatteringParameters(atoms[i], atomicNumber, charge, numberOfGaussians, ffactors[i]);
            formFactorsSuCoppens.put(atomsi[i], factor);
        }
        atoms = XrayParametersCCTBX.atoms;
        atomsi = XrayParametersCCTBX.atomsi;
        ffactors = XrayParametersCCTBX.ffactors;
        for (i = 0; i < atoms.length; ++i) {
            environment = atomsi[i];
            descriptions = environment.split("_");
            atomicNumber = Integer.parseInt(descriptions[0]);
            charge = 0;
            if (descriptions.length > 1) {
                charge = Integer.parseInt(descriptions[1]);
            }
            numberOfGaussians = ffactors[i][1].length;
            factor = new XRayScatteringParameters(atoms[i], atomicNumber, charge, numberOfGaussians, ffactors[i]);
            formFactorsCCTBX.put(atomsi[i], factor);
        }
    }
}

