/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.crystal.HKL;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.ScalarMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;
import ffx.xray.scatter.XRayScatteringParameters;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public final class XRayFormFactor
implements FormFactor {
    private static final Logger logger = Logger.getLogger(XRayFormFactor.class.getName());
    private final Atom atom;
    private final double[] xyz = new double[3];
    private final double[] dxyz = new double[3];
    private final double[] resv = new double[3];
    private final double[] a = new double[6];
    private final double[] b = new double[6];
    private final double[] ainv = new double[6];
    private final double[] binv = new double[6];
    private final double[] gradu = new double[6];
    private final double[][][] u = new double[6][3][3];
    private final double[][][] uInv = new double[6][3][3];
    private final double[][] jmat = new double[3][3];
    private final int nGaussians;
    private boolean hasAnisou;
    private double[] anisou = null;
    private double uAdd;
    private double occupancy;

    public XRayFormFactor(Atom atom, boolean use3G, double badd) {
        this(atom, use3G, badd, atom.getXYZ(null));
    }

    public XRayFormFactor(Atom atom, boolean use3G, double badd, double[] xyz) {
        int i;
        this.atom = atom;
        this.uAdd = ScalarMath.b2u((double)badd);
        int charge = 0;
        if (atom.getMultipoleType() != null) {
            charge = (int)atom.getMultipoleType().getCharge();
        }
        XRayScatteringParameters parameters = XRayScatteringParameters.getFormFactor(atom.getAtomicNumber(), charge, use3G);
        double[][] formFactor = parameters.formFactor();
        for (i = 0; i < formFactor[1].length && !(formFactor[1][i] < 0.01); ++i) {
            this.a[i] = formFactor[1][i];
            this.b[i] = formFactor[2][i];
        }
        this.nGaussians = i;
        assert (this.nGaussians > 0);
        this.occupancy = atom.getOccupancy();
        if (this.occupancy <= 0.0 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " Zero occupancy for atom: {0}", atom.toString());
        }
        this.update(xyz, this.uAdd);
    }

    public double f(HKL hkl) {
        return this.fN(hkl, this.nGaussians);
    }

    public double fN(HKL hkl, int nGaussians) {
        double sum = 0.0;
        for (int i = 0; i < nGaussians; ++i) {
            sum += this.a[i] * FastMath.exp((double)(-19.739208802178716 * hkl.quadForm(this.u[i])));
        }
        return this.occupancy * sum;
    }

    @Override
    public double rho(double f, double lambda, double[] xyz) {
        return this.rhoN(f, lambda, xyz, this.nGaussians);
    }

    @Override
    public void rhoGrad(double[] xyz, double dfc, RefinementMode refinementMode) {
        this.rhoGradN(xyz, this.nGaussians, dfc, refinementMode);
    }

    @Override
    public void update(double[] xyz) {
        this.update(xyz, ScalarMath.u2b((double)this.uAdd));
    }

    @Override
    public void update(double[] xyz, double bAdd) {
        this.xyz[0] = xyz[0];
        this.xyz[1] = xyz[1];
        this.xyz[2] = xyz[2];
        this.uAdd = ScalarMath.b2u((double)bAdd);
        this.occupancy = this.atom.getOccupancy();
        double bIso = this.atom.getTempFactor();
        if (this.occupancy < 0.0) {
            logger.warning(String.format(" %s negative occupancy reset to 0.0.", this.atom));
            this.occupancy = 0.0;
            this.atom.setOccupancy(0.0);
        }
        if (this.atom.getAnisou(null) == null) {
            if (this.anisou == null) {
                this.anisou = new double[6];
            }
            this.hasAnisou = false;
        } else {
            this.hasAnisou = true;
        }
        if (this.hasAnisou) {
            this.anisou = this.atom.getAnisou(null);
            double det = MatrixMath.mat3Determinant((double[])this.anisou);
            if (det <= 1.0E-14) {
                double uIso;
                String message = String.format(" %s non-positive definite ANISOU\n  Reset to isotropic B: %6.2f", this.atom, bIso);
                logger.warning(message);
                this.anisou[0] = uIso = ScalarMath.b2u((double)bIso);
                this.anisou[1] = uIso;
                this.anisou[2] = uIso;
                this.anisou[3] = 0.0;
                this.anisou[4] = 0.0;
                this.anisou[5] = 0.0;
                this.atom.setAnisou(this.anisou);
            }
        } else {
            double uIso;
            if (bIso < 0.0) {
                StringBuilder sb = new StringBuilder();
                sb.append(" Negative B factor for atom: ").append(this.atom);
                sb.append("\n Resetting B to 5.0\n");
                logger.warning(sb.toString());
                bIso = 5.0;
                this.atom.setTempFactor(5.0);
            }
            this.anisou[0] = uIso = ScalarMath.b2u((double)bIso);
            this.anisou[1] = uIso;
            this.anisou[2] = uIso;
            this.anisou[3] = 0.0;
            this.anisou[4] = 0.0;
            this.anisou[5] = 0.0;
        }
        for (int i = 0; i < this.nGaussians; ++i) {
            double uIso = ScalarMath.b2u((double)this.b[i]);
            this.u[i][0][0] = this.anisou[0] + uIso + this.uAdd;
            this.u[i][1][1] = this.anisou[1] + uIso + this.uAdd;
            this.u[i][2][2] = this.anisou[2] + uIso + this.uAdd;
            this.u[i][0][1] = this.anisou[3];
            this.u[i][1][0] = this.anisou[3];
            this.u[i][0][2] = this.anisou[4];
            this.u[i][2][0] = this.anisou[4];
            this.u[i][1][2] = this.anisou[5];
            this.u[i][2][1] = this.anisou[5];
            MatrixMath.mat3Inverse((double[][])this.u[i], (double[][])this.uInv[i]);
            double det = MatrixMath.mat3Determinant((double[][])this.u[i]);
            this.ainv[i] = this.a[i] / FastMath.sqrt((double)det);
            det = MatrixMath.mat3Determinant((double[][])this.uInv[i]);
            this.binv[i] = FastMath.pow((double)det, (double)0.3333333333333333);
        }
    }

    private double rhoN(double f, double lambda, double[] xyz, int nGaussians) {
        assert (nGaussians > 0 && nGaussians <= this.nGaussians);
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])xyz);
        if (DoubleMath.length2((double[])xyz) > this.atom.getFormFactorWidth2()) {
            return f;
        }
        double sum = 0.0;
        for (int i = 0; i < nGaussians; ++i) {
            sum += this.ainv[i] * FastMath.exp((double)(-0.5 * ScalarMath.quadForm((double[])xyz, (double[][])this.uInv[i])));
        }
        return f + lambda * this.occupancy * inverseTwoPI32 * sum;
    }

    private void rhoGradN(double[] xyz, int nGaussians, double dfc, RefinementMode refinementMode) {
        assert (nGaussians > 0 && nGaussians <= this.nGaussians);
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        double r2 = DoubleMath.length2((double[])this.dxyz);
        if (r2 > this.atom.getFormFactorWidth2()) {
            return;
        }
        boolean refineXYZ = refinementMode.includesCoordinates();
        boolean refineBFactor = refinementMode.includesBFactors();
        boolean refineOccupancy = refinementMode.includesOccupancies();
        for (int i = 0; i < nGaussians; ++i) {
            double scale;
            double aex = this.ainv[i] * FastMath.exp((double)(-0.5 * ScalarMath.quadForm((double[])this.dxyz, (double[][])this.uInv[i])));
            if (refineXYZ) {
                MatrixMath.vec3Mat3((double[])this.dxyz, (double[][])this.uInv[i], (double[])this.resv);
                scale = aex * dfc * this.occupancy * inverseTwoPI32;
                double dex = -scale * this.resv[0];
                double dey = -scale * this.resv[1];
                double dez = -scale * this.resv[2];
                this.atom.addToXYZGradient(dex, dey, dez);
            }
            if (refineOccupancy) {
                this.atom.addToOccupancyGradient(dfc * inverseTwoPI32 * aex);
            }
            if (!refineBFactor) continue;
            scale = 0.5 * aex * dfc * this.occupancy * inverseTwoPI32;
            double deb = scale * (r2 * this.binv[i] * this.binv[i] - 3.0 * this.binv[i]);
            this.atom.addToTempFactorGradient(ScalarMath.b2u((double)deb));
            if (!this.hasAnisou) continue;
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU11, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[0] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][0][0]);
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU22, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[1] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][1][1]);
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU33, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[2] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][2][2]);
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU12, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[3] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][0][1] * 2.0);
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU13, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[4] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][0][2] * 2.0);
            MatrixMath.mat3Mat3Multiply((double[][])this.uInv[i], (double[][])dUdU23, (double[][])this.jmat);
            MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv[i], (double[][])this.jmat);
            this.gradu[5] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[i][1][2] * 2.0);
            this.atom.addToAnisouGradient(this.gradu);
        }
    }
}

