/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;

public final class SolventBinaryFormFactor
implements FormFactor {
    private final double[] xyz = new double[3];
    private final double[] dxyz = new double[3];
    private final double probeRad;

    public SolventBinaryFormFactor(Atom atom, double probeRad) {
        this(atom, probeRad, atom.getXYZ(null));
    }

    public SolventBinaryFormFactor(Atom atom, double probeRad, double[] xyz) {
        this.probeRad = probeRad;
        this.update(xyz);
    }

    @Override
    public double rho(double f, double lambda, double[] xyz) {
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        return this.rho(f, lambda, DoubleMath.length((double[])this.dxyz));
    }

    public double rho(double f, double lambda, double ri) {
        if (ri <= this.probeRad) {
            return 0.0;
        }
        return f;
    }

    @Override
    public void rhoGrad(double[] xyz, double dfc, RefinementMode refinementmode) {
    }

    @Override
    public void update(double[] xyz) {
        this.update(xyz, 0.0);
    }

    @Override
    public void update(double[] xyz, double badd) {
        this.xyz[0] = xyz[0];
        this.xyz[1] = xyz[1];
        this.xyz[2] = xyz[2];
    }
}

