/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import java.util.HashMap;
import java.util.logging.Logger;

public record NeutronScatteringParameters(String name, int atomicNumber, double[] formFactor) {
    private static final Logger logger = Logger.getLogger(NeutronScatteringParameters.class.getName());
    private static final HashMap<String, NeutronScatteringParameters> formfactors = new HashMap();
    private static final String[] atomNames = new String[]{"H", "D", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Th", "U"};
    private static final String[] atomicNumbers = new String[]{"1_1", "1_2", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "90", "92"};
    private static final double[][] neutronFormFactors = new double[][]{{-3.739, 0.0}, {6.671, 0.0}, {3.26, 0.0}, {-1.9, 0.0}, {7.79, 0.0}, {5.3, 0.213}, {6.646, 0.0}, {9.36, 0.0}, {5.803, 0.0}, {5.654, 0.0}, {4.566, 0.0}, {3.63, 0.0}, {5.375, 0.0}, {3.449, 0.0}, {4.1491, 0.0}, {5.13, 0.0}, {2.847, 0.0}, {9.577, 0.0}, {1.909, 0.0}, {3.67, 0.0}, {4.7, 0.0}, {12.29, 0.0}, {-3.37, 0.0}, {-0.3824, 0.0}, {3.635, 0.0}, {-3.75, 0.0}, {9.45, 0.0}, {2.49, 0.0}, {10.3, 0.0}, {7.718, 0.0}, {5.6, 0.0}, {7.288, 0.0}, {8.185, 0.0}, {6.58, 0.0}, {7.97, 0.0}, {6.795, 0.0}, {7.81, 0.0}, {7.09, 0.0}, {7.02, 0.0}, {7.75, 0.0}, {7.16, 0.0}, {7.054, 0.0}, {6.715, 0.0}, {6.8, 0.0}, {7.03, 0.0}, {5.88, 0.0}, {5.91, 0.0}, {5.922, 0.0}, {4.87, -0.7}, {4.065, -0.0539}, {6.225, 0.0}, {5.57, 0.0}, {5.8, 0.0}, {5.28, 0.0}, {4.92, 0.0}, {5.42, 0.0}, {5.07, 0.0}, {8.24, 0.0}, {4.84, 0.0}, {4.58, 0.0}, {7.69, 0.0}, {0.8, -1.65}, {7.22, -1.26}, {6.5, -13.82}, {7.38, 0.0}, {16.9, -0.276}, {8.01, 0.0}, {7.79, 0.0}, {7.07, 0.0}, {12.43, 0.0}, {7.21, 0.0}, {7.77, 0.0}, {6.91, 0.0}, {4.86, 0.0}, {9.2, 0.0}, {10.7, 0.0}, {10.6, 0.0}, {9.6, 0.0}, {7.63, 0.0}, {12.692, 0.0}, {8.776, 0.0}, {9.405, 0.0}, {8.532, 0.0}, {10.31, 0.0}, {8.417, 0.0}};

    public static NeutronScatteringParameters getFormFactor(String atom) {
        if (formfactors.containsKey(atom)) {
            return formfactors.get(atom);
        }
        String message = " Form factor for atom: " + atom + " not found!";
        logger.severe(message);
        return null;
    }

    static {
        for (int i = 0; i < atomNames.length; ++i) {
            String number = atomicNumbers[i];
            if (number.contains("_")) {
                number = "1";
            }
            int atomicNumber = Integer.parseInt(number);
            NeutronScatteringParameters parameters = new NeutronScatteringParameters(atomNames[i], atomicNumber, neutronFormFactors[i]);
            formfactors.put(atomicNumbers[i], parameters);
        }
    }
}

