/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.crystal.HKL;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.ScalarMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;
import ffx.xray.scatter.NeutronScatteringParameters;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public final class NeutronFormFactor
implements FormFactor {
    private static final Logger logger = Logger.getLogger(NeutronFormFactor.class.getName());
    private final Atom atom;
    private final double[] xyz = new double[3];
    private final double[] dxyz = new double[3];
    private final double[] a = new double[2];
    private double ainv;
    private final double[][] u = new double[3][3];
    private final double[][] uInv = new double[3][3];
    private double binv;
    private final double[] resv = new double[3];
    private boolean hasAnisou;
    private double[] uaniso = null;
    private final double[] dU = new double[6];
    private final double[][] jmat = new double[3][3];
    private double uadd;
    private double occ;

    public NeutronFormFactor(Atom atom, double badd) {
        this(atom, badd, atom.getXYZ(null));
    }

    public NeutronFormFactor(Atom atom, double badd, double[] xyz) {
        this.atom = atom;
        this.uadd = ScalarMath.b2u((double)badd);
        String key = atom.getAtomicNumber() == 1 ? (atom.isDeuterium() ? atom.getAtomicNumber() + "_2" : atom.getAtomicNumber() + "_1") : "" + atom.getAtomicNumber();
        NeutronScatteringParameters parameters = NeutronScatteringParameters.getFormFactor(key);
        double[] ffactor = parameters.formFactor();
        System.arraycopy(ffactor, 0, this.a, 0, ffactor.length);
        if (this.a[1] != 0.0) {
            logger.severe(" Complex neutron form factor method not supported");
        }
        this.occ = atom.getOccupancy();
        if (this.occ <= 0.0) {
            StringBuilder sb = new StringBuilder();
            sb.append(" Zero occupancy: ").append(atom);
            logger.fine(sb.toString());
        }
        this.update(xyz, this.uadd);
    }

    public String toString() {
        return this.atom.toString() + String.format(" Neutron mag: %9.6f", this.a[0]);
    }

    public double f(HKL hkl) {
        double sum = this.a[0] * FastMath.exp((double)(-19.739208802178716 * hkl.quadForm(this.u)));
        return this.occ * sum;
    }

    @Override
    public double rho(double f, double lambda, double[] xyz) {
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])xyz);
        if (DoubleMath.length2((double[])xyz) > this.atom.getFormFactorWidth2()) {
            return f;
        }
        double sum = this.ainv * FastMath.exp((double)(-0.5 * ScalarMath.quadForm((double[])xyz, (double[][])this.uInv)));
        return f + lambda * this.occ * inverseTwoPI32 * sum;
    }

    @Override
    public void rhoGrad(double[] xyz, double dfc, RefinementMode refinementMode) {
        double scale;
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        double r2 = DoubleMath.length2((double[])this.dxyz);
        if (r2 > this.atom.getFormFactorWidth2()) {
            return;
        }
        double aex = this.ainv * FastMath.exp((double)(-0.5 * ScalarMath.quadForm((double[])this.dxyz, (double[][])this.uInv)));
        if (refinementMode.includesCoordinates()) {
            MatrixMath.vec3Mat3((double[])this.dxyz, (double[][])this.uInv, (double[])this.resv);
            scale = aex * dfc * this.occ * inverseTwoPI32;
            double dex = -scale * this.resv[0];
            double dey = -scale * this.resv[1];
            double dez = -scale * this.resv[2];
            this.atom.addToXYZGradient(dex, dey, dez);
        }
        if (refinementMode.includesOccupancies()) {
            this.atom.addToOccupancyGradient(dfc * inverseTwoPI32 * aex);
        }
        if (refinementMode.includesBFactors()) {
            scale = 0.5 * aex * dfc * this.occ * inverseTwoPI32;
            double deb = scale * (r2 * this.binv * this.binv - 3.0 * this.binv);
            this.atom.addToTempFactorGradient(ScalarMath.b2u((double)deb));
            if (this.hasAnisou) {
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU11, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[0] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[0][0]);
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU22, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[1] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[1][1]);
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU33, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[2] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[2][2]);
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU12, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[3] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[0][1] * 2.0);
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU13, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[4] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[0][2] * 2.0);
                MatrixMath.mat3Mat3Multiply((double[][])this.uInv, (double[][])dUdU23, (double[][])this.jmat);
                MatrixMath.mat3Mat3Multiply((double[][])this.jmat, (double[][])this.uInv, (double[][])this.jmat);
                this.dU[5] = scale * (ScalarMath.quadForm((double[])this.dxyz, (double[][])this.jmat) - this.uInv[1][2] * 2.0);
                this.atom.addToAnisouGradient(this.dU);
            }
        }
    }

    @Override
    public void update(double[] xyz) {
        this.update(xyz, ScalarMath.u2b((double)this.uadd));
    }

    @Override
    public void update(double[] xyz, double badd) {
        StringBuilder sb;
        this.xyz[0] = xyz[0];
        this.xyz[1] = xyz[1];
        this.xyz[2] = xyz[2];
        double biso = this.atom.getTempFactor();
        this.uadd = ScalarMath.b2u((double)badd);
        this.occ = this.atom.getOccupancy();
        if (this.occ < 0.0) {
            sb = new StringBuilder();
            sb.append(" Negative occupancy for atom: ").append(this.atom).append("\n");
            sb.append(" Resetting to 0.0\n");
            logger.warning(sb.toString());
            this.occ = 0.0;
            this.atom.setOccupancy(0.0);
        }
        if (this.atom.getAnisou(null) == null) {
            if (this.uaniso == null) {
                this.uaniso = new double[6];
            }
            this.hasAnisou = false;
        } else {
            this.hasAnisou = true;
        }
        if (this.hasAnisou) {
            this.uaniso = this.atom.getAnisou(null);
            double det = MatrixMath.mat3Determinant((double[])this.uaniso);
            if (det <= 1.0E-14) {
                double val;
                StringBuilder sb2 = new StringBuilder();
                sb2.append(" Non-positive definite ANISOU for atom: ").append(this.atom).append("\n");
                sb2.append(" Resetting ANISOU based on isotropic B: (").append(biso).append(")\n");
                logger.warning(sb2.toString());
                this.uaniso[0] = val = ScalarMath.b2u((double)biso);
                this.uaniso[1] = val;
                this.uaniso[2] = val;
                this.uaniso[3] = 0.0;
                this.uaniso[4] = 0.0;
                this.uaniso[5] = 0.0;
                this.atom.setAnisou(this.uaniso);
            }
        } else {
            if (biso < 0.0) {
                double val;
                sb = new StringBuilder();
                sb.append(" Negative B factor for atom: ").append(this.atom).append("\n");
                sb.append(" Resetting B to 1.0\n");
                logger.warning(sb.toString());
                this.atom.setTempFactor(1.0);
                this.uaniso[0] = val = ScalarMath.b2u((double)1.0);
                this.uaniso[1] = val;
                this.uaniso[2] = val;
            } else {
                double val;
                this.uaniso[0] = val = ScalarMath.b2u((double)biso);
                this.uaniso[1] = val;
                this.uaniso[2] = val;
            }
            this.uaniso[3] = 0.0;
            this.uaniso[4] = 0.0;
            this.uaniso[5] = 0.0;
        }
        this.u[0][0] = this.uaniso[0] + this.uadd;
        this.u[1][1] = this.uaniso[1] + this.uadd;
        this.u[2][2] = this.uaniso[2] + this.uadd;
        this.u[0][1] = this.uaniso[3];
        this.u[1][0] = this.uaniso[3];
        this.u[0][2] = this.uaniso[4];
        this.u[2][0] = this.uaniso[4];
        this.u[1][2] = this.uaniso[5];
        this.u[2][1] = this.uaniso[5];
        MatrixMath.mat3Inverse((double[][])this.u, (double[][])this.uInv);
        double det = MatrixMath.mat3Determinant((double[][])this.u);
        this.ainv = this.a[0] / FastMath.sqrt((double)det);
        det = MatrixMath.mat3Determinant((double[][])this.uInv);
        this.binv = FastMath.pow((double)det, (double)0.3333333333333333);
    }
}

