/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.refine;

import ffx.potential.parameters.ForceField;
import java.util.logging.Logger;

public enum RefinementMode {
    BFACTORS,
    BFACTORS_AND_OCCUPANCIES,
    COORDINATES,
    COORDINATES_AND_BFACTORS,
    COORDINATES_AND_BFACTORS_AND_OCCUPANCIES,
    COORDINATES_AND_OCCUPANCIES,
    OCCUPANCIES;


    public boolean includesCoordinates() {
        return this == COORDINATES || this == COORDINATES_AND_BFACTORS || this == COORDINATES_AND_OCCUPANCIES || this == COORDINATES_AND_BFACTORS_AND_OCCUPANCIES;
    }

    public boolean includesBFactors() {
        return this == BFACTORS || this == BFACTORS_AND_OCCUPANCIES || this == COORDINATES_AND_BFACTORS || this == COORDINATES_AND_BFACTORS_AND_OCCUPANCIES;
    }

    public boolean includesOccupancies() {
        return this == OCCUPANCIES || this == BFACTORS_AND_OCCUPANCIES || this == COORDINATES_AND_OCCUPANCIES || this == COORDINATES_AND_BFACTORS_AND_OCCUPANCIES;
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> " Mode: B-Factors";
            case 1 -> " Mode: B-Factors and Occupancies";
            case 2 -> " Mode: Coordinates";
            case 3 -> " Mode: Coordinates and B-Factors";
            case 4 -> " Mode: Coordinates, B-Factors and Occupancies";
            case 5 -> " Mode: Coordinates and Occupancies";
            case 6 -> " Mode: Occupancies";
        };
    }

    public double getDefaultEps() {
        return this.getDefaultEps(false);
    }

    public double getDefaultEps(boolean hasAnisou) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> {
                if (hasAnisou) {
                    yield 20.0;
                }
                yield 0.01;
            }
            case 2 -> 0.4;
            case 3, 4 -> {
                if (hasAnisou) {
                    yield 20.0;
                }
                yield 0.2;
            }
            case 5 -> 0.2;
            case 6 -> 0.1;
        };
    }

    public static RefinementMode parseMode(String mode) {
        try {
            return RefinementMode.valueOf(ForceField.toEnumForm((String)mode));
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(RefinementMode.class.getName());
            logger.info(String.format(" Could not parse %s as a refinement mode; defaulting to coordinates.", mode));
            return COORDINATES;
        }
    }
}

