/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.refine;

import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinedParameter;
import javax.annotation.Nullable;

public class RefinedCoordinates
extends RefinedParameter {
    private static final double COORDINATE_SCALE = 12.0;

    public RefinedCoordinates(Atom atom) {
        super(atom);
    }

    @Override
    public void addConstrainedAtom(Atom atom) {
        atom.setActive(true);
        atom.setXYZ(this.getCoordinates(null));
        this.constrainedAtoms.add(atom);
    }

    @Override
    public void addConstrainedAtomThatScatters(Atom atom) {
        atom.setActive(true);
        atom.setXYZ(this.getCoordinates(null));
        this.constrainedAtomsThatScatter.add(atom);
    }

    public double[] getCoordinates(@Nullable double[] xyz) {
        return this.atom.getXYZ(xyz);
    }

    public void setCoordinates(double[] xyz) {
        this.atom.setXYZ(xyz);
        for (Atom a : this.constrainedAtoms) {
            a.setXYZ(xyz);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setXYZ(xyz);
        }
    }

    @Override
    public int getNumberOfParameters() {
        return 3;
    }

    @Override
    public void getParameters(double[] parameters) {
        parameters[this.index] = this.atom.getX();
        parameters[this.index + 1] = this.atom.getY();
        parameters[this.index + 2] = this.atom.getZ();
    }

    @Override
    public void setParameters(double[] parameters) {
        double[] xyz = new double[]{parameters[this.index], parameters[this.index + 1], parameters[this.index + 2]};
        this.setCoordinates(xyz);
    }

    @Override
    public void getVelocity(double[] velocity) {
        double[] v = new double[3];
        this.atom.getVelocity(v);
        velocity[this.index] = v[0];
        velocity[this.index + 1] = v[1];
        velocity[this.index + 2] = v[2];
    }

    @Override
    public void setVelocity(double[] velocity) {
        double[] v = new double[]{velocity[this.index], velocity[this.index + 1], velocity[this.index + 2]};
        this.atom.setVelocity(v);
    }

    @Override
    public void getAcceleration(double[] acceleration) {
        double[] a = new double[3];
        this.atom.getAcceleration(a);
        acceleration[this.index] = a[0];
        acceleration[this.index + 1] = a[1];
        acceleration[this.index + 2] = a[2];
    }

    @Override
    public void setAcceleration(double[] acceleration) {
        double[] a = new double[]{acceleration[this.index], acceleration[this.index + 1], acceleration[this.index + 2]};
        this.atom.setAcceleration(a);
    }

    @Override
    public void getPreviousAcceleration(double[] previousAcceleration) {
        double[] a = new double[3];
        this.atom.getPreviousAcceleration(a);
        previousAcceleration[this.index] = a[0];
        previousAcceleration[this.index + 1] = a[1];
        previousAcceleration[this.index + 2] = a[2];
    }

    @Override
    public void setPreviousAcceleration(double[] previousAcceleration) {
        double[] a = new double[]{previousAcceleration[this.index], previousAcceleration[this.index + 1], previousAcceleration[this.index + 2]};
        this.atom.setPreviousAcceleration(a);
    }

    @Override
    public void setOptimizationScaling(double[] optimizationScaling) {
        optimizationScaling[this.index] = 12.0;
        optimizationScaling[this.index + 1] = 12.0;
        optimizationScaling[this.index + 2] = 12.0;
    }

    @Override
    public void zeroGradient() {
        this.atom.setXYZGradient(0.0, 0.0, 0.0);
        this.atom.setLambdaXYZGradient(0.0, 0.0, 0.0);
        for (Atom a : this.constrainedAtoms) {
            a.setXYZGradient(0.0, 0.0, 0.0);
            a.setLambdaXYZGradient(0.0, 0.0, 0.0);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setXYZGradient(0.0, 0.0, 0.0);
            a.setLambdaXYZGradient(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void getGradient(double[] gradient) {
        double[] xyz = new double[3];
        this.atom.getXYZGradient(xyz);
        gradient[this.index] = xyz[0];
        gradient[this.index + 1] = xyz[1];
        gradient[this.index + 2] = xyz[2];
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.getXYZGradient(xyz);
            int n = this.index;
            gradient[n] = gradient[n] + xyz[0];
            int n2 = this.index + 1;
            gradient[n2] = gradient[n2] + xyz[1];
            int n3 = this.index + 2;
            gradient[n3] = gradient[n3] + xyz[2];
        }
    }

    @Override
    public void getMass(double[] mass, double defaultMass) {
        double m;
        mass[this.index] = m = this.atom.getMass();
        mass[this.index + 1] = m;
        mass[this.index + 2] = m;
    }

    public String toString() {
        double[] xyz = new double[3];
        this.atom.getXYZ(xyz);
        StringBuilder sb = new StringBuilder(" Atomic Coordinates: ");
        for (int i = 0; i < 3; ++i) {
            sb.append(String.format("  %10.6f", xyz[i]));
        }
        return sb.toString();
    }
}

