/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.refine;

import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.ScalarMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinedParameter;
import java.util.logging.Logger;

public class RefinedBFactor
extends RefinedParameter {
    private static final Logger logger = Logger.getLogger(RefinedBFactor.class.getName());
    private static final double BFACTOR_SCALE = 12.0;
    private static final double ANISOU_SCALE = 1200.0;
    private final boolean isAnisou;

    public RefinedBFactor(Atom atom) {
        super(atom);
        double[] anisou = this.atom.getAnisou(null);
        this.isAnisou = anisou != null;
    }

    @Override
    public void addConstrainedAtom(Atom atom) {
        atom.setActive(true);
        atom.setTempFactor(this.atom.getTempFactor());
        if (this.isAnisou) {
            atom.setAnisou(this.atom.getAnisou(null));
        }
        this.constrainedAtoms.add(atom);
    }

    @Override
    public void addConstrainedAtomThatScatters(Atom atom) {
        atom.setActive(true);
        atom.setTempFactor(this.atom.getTempFactor());
        if (this.isAnisou) {
            atom.setAnisou(this.atom.getAnisou(null));
        }
        this.constrainedAtomsThatScatter.add(atom);
    }

    @Override
    public int getNumberOfParameters() {
        if (this.isAnisou) {
            return 6;
        }
        return 1;
    }

    public boolean isAnisou() {
        return this.isAnisou;
    }

    public void setBFactor(double bFactor) {
        this.atom.setTempFactor(bFactor);
        double[] anisou = new double[6];
        if (this.isAnisou) {
            double u;
            anisou[0] = u = ScalarMath.b2u((double)bFactor);
            anisou[1] = u;
            anisou[2] = u;
            this.atom.setAnisou(anisou);
        }
        for (Atom a : this.constrainedAtoms) {
            a.setTempFactor(bFactor);
            if (!this.isAnisou || a.isHydrogen()) continue;
            a.setAnisou(anisou);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setTempFactor(bFactor);
            if (!this.isAnisou || a.isHydrogen()) continue;
            a.setAnisou(anisou);
        }
    }

    public void setAnisou(double[] anisou) {
        if (!this.isAnisou) {
            return;
        }
        double det = MatrixMath.mat3Determinant((double[])anisou);
        if (det > 0.0) {
            this.atom.setAnisou(anisou);
            det = Math.pow(det, 0.3333333333333333);
            this.atom.setTempFactor(ScalarMath.u2b((double)det));
        } else {
            double u;
            this.atom.setTempFactor(1.0);
            anisou[0] = u = ScalarMath.b2u((double)1.0);
            anisou[1] = u;
            anisou[2] = u;
            anisou[3] = 0.0;
            anisou[4] = 0.0;
            anisou[5] = 0.0;
            this.atom.setAnisou(anisou);
            logger.info(" Negative ANISOU: " + String.valueOf(this.atom));
        }
        double bfactor = this.atom.getTempFactor();
        for (Atom a : this.constrainedAtoms) {
            a.setTempFactor(bfactor);
            if (a.isHydrogen()) continue;
            a.setAnisou(anisou);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setTempFactor(bfactor);
            if (a.isHydrogen()) continue;
            a.setAnisou(anisou);
        }
    }

    @Override
    public void getParameters(double[] parameters) {
        if (this.isAnisou) {
            double[] anisou = new double[6];
            this.atom.getAnisou(anisou);
            parameters[this.index] = anisou[0];
            parameters[this.index + 1] = anisou[1];
            parameters[this.index + 2] = anisou[2];
            parameters[this.index + 3] = anisou[3];
            parameters[this.index + 4] = anisou[4];
            parameters[this.index + 5] = anisou[5];
        } else {
            parameters[this.index] = this.atom.getTempFactor();
        }
    }

    @Override
    public void setParameters(double[] parameters) {
        if (this.isAnisou) {
            double[] anisou = new double[]{parameters[this.index], parameters[this.index + 1], parameters[this.index + 2], parameters[this.index + 3], parameters[this.index + 4], parameters[this.index + 5]};
            this.setAnisou(anisou);
        } else {
            this.setBFactor(parameters[this.index]);
        }
    }

    @Override
    public void getVelocity(double[] velocity) {
        if (this.isAnisou) {
            double[] anisou = new double[6];
            this.atom.getAnisouVelocity(anisou);
            velocity[this.index] = anisou[0];
            velocity[this.index + 1] = anisou[1];
            velocity[this.index + 2] = anisou[2];
            velocity[this.index + 3] = anisou[3];
            velocity[this.index + 4] = anisou[4];
            velocity[this.index + 5] = anisou[5];
        } else {
            velocity[this.index] = this.atom.getTempFactorVelocity();
        }
    }

    @Override
    public void setVelocity(double[] velocity) {
        if (this.isAnisou) {
            double[] anisou = new double[]{velocity[this.index], velocity[this.index + 1], velocity[this.index + 2], velocity[this.index + 3], velocity[this.index + 4], velocity[this.index + 5]};
            this.atom.setAnisouVelocity(anisou);
        } else {
            this.atom.setTempFactorVelocity(velocity[this.index]);
        }
    }

    @Override
    public void getAcceleration(double[] acceleration) {
        if (this.isAnisou) {
            double[] anisou = new double[6];
            this.atom.getAnisouAcceleration(anisou);
            acceleration[this.index] = anisou[0];
            acceleration[this.index + 1] = anisou[1];
            acceleration[this.index + 2] = anisou[2];
            acceleration[this.index + 3] = anisou[3];
            acceleration[this.index + 4] = anisou[4];
            acceleration[this.index + 5] = anisou[5];
        } else {
            acceleration[this.index] = this.atom.getTempFactorAcceleration();
        }
    }

    @Override
    public void setAcceleration(double[] acceleration) {
        if (this.isAnisou) {
            double[] anisou = new double[]{acceleration[this.index], acceleration[this.index + 1], acceleration[this.index + 2], acceleration[this.index + 3], acceleration[this.index + 4], acceleration[this.index + 5]};
            this.atom.setAnisouAcceleration(anisou);
        } else {
            this.atom.setTempFactorAcceleration(acceleration[this.index]);
        }
    }

    @Override
    public void getPreviousAcceleration(double[] previousAcceleration) {
        if (this.isAnisou) {
            double[] anisou = new double[6];
            this.atom.getAnisouPreviousAcceleration(anisou);
            previousAcceleration[this.index] = anisou[0];
            previousAcceleration[this.index + 1] = anisou[1];
            previousAcceleration[this.index + 2] = anisou[2];
            previousAcceleration[this.index + 3] = anisou[3];
            previousAcceleration[this.index + 4] = anisou[4];
            previousAcceleration[this.index + 5] = anisou[5];
        } else {
            previousAcceleration[this.index] = this.atom.getTempFactorPreviousAcceleration();
        }
    }

    @Override
    public void setPreviousAcceleration(double[] previousAcceleration) {
        if (this.isAnisou) {
            double[] anisou = new double[]{previousAcceleration[this.index], previousAcceleration[this.index + 1], previousAcceleration[this.index + 2], previousAcceleration[this.index + 3], previousAcceleration[this.index + 4], previousAcceleration[this.index + 5]};
            this.atom.setAnisouPreviousAcceleration(anisou);
        } else {
            this.atom.setTempFactorPreviousAcceleration(previousAcceleration[this.index]);
        }
    }

    @Override
    public void setOptimizationScaling(double[] optimizationScaling) {
        if (this.isAnisou) {
            optimizationScaling[this.index] = 1200.0;
            optimizationScaling[this.index + 1] = 1200.0;
            optimizationScaling[this.index + 2] = 1200.0;
            optimizationScaling[this.index + 3] = 1200.0;
            optimizationScaling[this.index + 4] = 1200.0;
            optimizationScaling[this.index + 5] = 1200.0;
        } else {
            optimizationScaling[this.index] = 12.0;
        }
    }

    @Override
    public void zeroGradient() {
        if (!this.isAnisou) {
            this.atom.setTempFactorGradient(0.0);
            for (Atom a : this.constrainedAtoms) {
                a.setTempFactorGradient(0.0);
            }
            for (Atom a : this.constrainedAtomsThatScatter) {
                a.setTempFactorGradient(0.0);
            }
        } else {
            double[] anisouGrad = new double[6];
            this.atom.setTempFactorGradient(0.0);
            this.atom.setAnisouGradient(anisouGrad);
            for (Atom a : this.constrainedAtoms) {
                a.setTempFactorGradient(0.0);
                if (a.isHydrogen()) continue;
                a.setAnisouGradient(anisouGrad);
            }
            for (Atom a : this.constrainedAtomsThatScatter) {
                a.setTempFactorGradient(0.0);
                if (a.isHydrogen()) continue;
                a.setAnisouGradient(anisouGrad);
            }
        }
    }

    @Override
    public void getGradient(double[] gradient) {
        if (!this.isAnisou) {
            double bfactor;
            gradient[this.index] = bfactor = this.atom.getTempFactorGradient();
            for (Atom a : this.constrainedAtomsThatScatter) {
                bfactor = a.getTempFactorGradient();
                int n = this.index;
                gradient[n] = gradient[n] + bfactor;
            }
        } else {
            double[] anisou = new double[6];
            this.atom.getAnisouGradient(anisou);
            gradient[this.index] = anisou[0];
            gradient[this.index + 1] = anisou[1];
            gradient[this.index + 2] = anisou[2];
            gradient[this.index + 3] = anisou[3];
            gradient[this.index + 4] = anisou[4];
            gradient[this.index + 5] = anisou[5];
            for (Atom a : this.constrainedAtomsThatScatter) {
                if (!a.isHydrogen()) {
                    a.getAnisouGradient(anisou);
                    int n = this.index;
                    gradient[n] = gradient[n] + anisou[0];
                    int n2 = this.index + 1;
                    gradient[n2] = gradient[n2] + anisou[1];
                    int n3 = this.index + 2;
                    gradient[n3] = gradient[n3] + anisou[2];
                    int n4 = this.index + 3;
                    gradient[n4] = gradient[n4] + anisou[3];
                    int n5 = this.index + 4;
                    gradient[n5] = gradient[n5] + anisou[4];
                    int n6 = this.index + 5;
                    gradient[n6] = gradient[n6] + anisou[5];
                    continue;
                }
                double bfactor = a.getTempFactorGradient();
                double u = ScalarMath.b2u((double)bfactor);
                int n = this.index;
                gradient[n] = gradient[n] + u;
                int n7 = this.index + 1;
                gradient[n7] = gradient[n7] + u;
                int n8 = this.index + 2;
                gradient[n8] = gradient[n8] + u;
            }
        }
    }

    @Override
    public void getMass(double[] mass, double defaultMass) {
        if (this.isAnisou) {
            mass[this.index] = defaultMass;
            mass[this.index + 1] = defaultMass;
            mass[this.index + 2] = defaultMass;
            mass[this.index + 3] = defaultMass;
            mass[this.index + 4] = defaultMass;
            mass[this.index + 5] = defaultMass;
        } else {
            mass[this.index] = defaultMass;
        }
    }

    public String toString() {
        if (this.isAnisou) {
            double[] anisou = new double[6];
            this.atom.getAnisou(anisou);
            StringBuilder sb = new StringBuilder(" Anisotropic B-factor:");
            for (int i = 0; i < 6; ++i) {
                sb.append(String.format("  %10.6f", anisou[i]));
            }
            return sb.toString();
        }
        return String.format(" B-factor:  %10.6f", this.atom.getTempFactor());
    }
}

