/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.filechooser.FileFilter;

public final class MTZFileFilter
extends FileFilter {
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".mtz");
    }

    public boolean acceptDeep(File file) {
        try {
            if (file == null || file.isDirectory() || !file.canRead()) {
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] bytes = new byte[80];
            int offset = 0;
            dataInputStream.read(bytes, offset, 4);
            String mtzstr = new String(bytes);
            return mtzstr.trim().equals("MTZ");
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public String getDescription() {
        return "CCP4 MTZ Reflection Files: *.mtz";
    }
}

