/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CNSMapWriter {
    private static final Logger logger = Logger.getLogger(CNSMapWriter.class.getName());
    private final String filename;
    private final Crystal crystal;
    private final int nx;
    private final int ny;
    private final int nz;

    public CNSMapWriter(int nx, int ny, int nz, Crystal crystal, String filename) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.crystal = crystal;
        this.filename = filename;
    }

    public void write(double[] data) {
        try {
            int index;
            int i;
            int j;
            int k;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\nwriting CNS map file: \"%s\"\n", this.filename));
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.filename)));
            double mean = 0.0;
            double sd = 0.0;
            out.println();
            out.println("       1");
            out.println("map from ffx");
            out.printf("%8d%8d%8d%8d%8d%8d%8d%8d%8d\n", this.nx, 0, this.nx - 1, this.ny, 0, this.ny - 1, this.nz, 0, this.nz - 1);
            out.printf("%12.5E%12.5E%12.5E%12.5E%12.5E%12.5E\n", this.crystal.a, this.crystal.b, this.crystal.c, this.crystal.alpha, this.crystal.beta, this.crystal.gamma);
            out.println("ZYX");
            int n = 0;
            for (k = 0; k < this.nz; ++k) {
                out.printf("%8d\n", k);
                for (j = 0; j < this.ny; ++j) {
                    for (i = 0; i < this.nx; ++i) {
                        index = 2 * (i + this.nx * (j + this.ny * k));
                        out.printf("%12.5E", data[index]);
                        mean += (data[index] - mean) / (double)(++n);
                        if (n % 6 != 0) continue;
                        out.println();
                    }
                }
            }
            n = 0;
            for (k = 0; k < this.nz; ++k) {
                for (j = 0; j < this.ny; ++j) {
                    for (i = 0; i < this.nx; ++i) {
                        index = 2 * (i + this.nx * (j + this.ny * k));
                        sd += FastMath.pow((double)(data[index] - mean), (double)2.0);
                        ++n;
                    }
                }
            }
            sd = FastMath.sqrt((double)(sd / (double)n));
            out.println("   -9999");
            out.printf("%12.4E%12.4E\n", mean, sd);
            sb.append(String.format("map mean: %g standard dev.: %g", mean, sd));
            out.close();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sb.toString());
            }
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating structure factors.\n";
            logger.log(Level.SEVERE, message, e);
            System.exit(-1);
        }
    }
}

