/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.crystal.SpaceGroupDefinitions;
import ffx.crystal.SpaceGroupInfo;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.parsers.DiffractionFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class CNSFilter
implements DiffractionFileFilter {
    private static final Logger logger = Logger.getLogger(CNSFilter.class.getName());
    private final double[] cell = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private double resHigh = -1.0;
    private String spaceGroupName = null;
    private int spaceGroupNum = -1;

    @Override
    public ReflectionList getReflectionList(File cnsFile) {
        return this.getReflectionList(cnsFile, null);
    }

    @Override
    public ReflectionList getReflectionList(File cnsFile, CompositeConfiguration properties) {
        try (BufferedReader br = new BufferedReader(new FileReader(cnsFile));){
            String string;
            while ((string = br.readLine()) != null) {
                String[] strArray = string.split("\\s+");
                if (strArray[0].equalsIgnoreCase("{")) {
                    if (!strArray[1].toLowerCase().startsWith("sg=")) continue;
                    this.spaceGroupName = strArray[1].substring(3);
                    this.cell[0] = Double.parseDouble(strArray[2].substring(2));
                    this.cell[1] = Double.parseDouble(strArray[3].substring(2));
                    this.cell[2] = Double.parseDouble(strArray[4].substring(2));
                    this.cell[3] = Double.parseDouble(strArray[5].substring(6));
                    this.cell[4] = Double.parseDouble(strArray[6].substring(5));
                    this.cell[5] = Double.parseDouble(strArray[7].substring(6));
                    continue;
                }
                if (strArray[0].equalsIgnoreCase("CRYST1")) {
                    this.cell[0] = Double.parseDouble(strArray[1]);
                    this.cell[1] = Double.parseDouble(strArray[2]);
                    this.cell[2] = Double.parseDouble(strArray[3]);
                    this.cell[3] = Double.parseDouble(strArray[4]);
                    this.cell[4] = Double.parseDouble(strArray[5]);
                    this.cell[5] = Double.parseDouble(strArray[6]);
                    this.spaceGroupName = SpaceGroupInfo.pdb2ShortName((String)string.substring(55, 65));
                    continue;
                }
                if (!strArray[0].toLowerCase().startsWith("inde")) continue;
                break;
            }
        }
        catch (IOException e) {
            String message = " CNS IO Exception.";
            logger.log(Level.WARNING, message, e);
            return null;
        }
        Resolution resolution = null;
        if (properties != null) {
            resolution = Resolution.checkProperties((CompositeConfiguration)properties, (boolean)false, (double)-1.0);
            this.resHigh = resolution.resolution;
        }
        if (this.spaceGroupName != null) {
            this.spaceGroupNum = SpaceGroupDefinitions.spaceGroupNumber((String)this.spaceGroupName);
        }
        if (this.spaceGroupNum < 0 || this.cell[0] < 0.0 || resolution == null) {
            logger.info(" The CNS file contains insufficient information to generate the reflection list.");
            return null;
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\n Opening %s\n", cnsFile.getName()));
            sb.append(" Setting up Reflection List based on CNS:\n");
            sb.append(String.format("  Spacegroup #: %d (name: %s)\n", this.spaceGroupNum, SpaceGroupInfo.spaceGroupNames[this.spaceGroupNum - 1]));
            sb.append(String.format("  Resolution:   %8.3f\n", this.resHigh));
            sb.append(String.format("  Cell:         %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n", this.cell[0], this.cell[1], this.cell[2], this.cell[3], this.cell[4], this.cell[5]));
            logger.info(sb.toString());
        }
        Crystal crystal = new Crystal(this.cell[0], this.cell[1], this.cell[2], this.cell[3], this.cell[4], this.cell[5], SpaceGroupInfo.spaceGroupNames[this.spaceGroupNum - 1]);
        return new ReflectionList(crystal, resolution, properties);
    }

    @Override
    public double getResolution(File cnsFile, Crystal crystal) {
        double res = Double.POSITIVE_INFINITY;
        try (BufferedReader br = new BufferedReader(new FileReader(cnsFile));){
            String string;
            HKL hkl = new HKL();
            while ((string = br.readLine()) != null) {
                String[] strArray = string.split("\\s+");
                for (int i = 0; i < strArray.length; ++i) {
                    if (!strArray[i].toLowerCase().startsWith("inde") || i >= strArray.length - 3) continue;
                    int ih = Integer.parseInt(strArray[i + 1]);
                    int ik = Integer.parseInt(strArray[i + 2]);
                    int il = Integer.parseInt(strArray[i + 3]);
                    hkl.setH(ih);
                    hkl.setK(ik);
                    hkl.setL(il);
                    res = FastMath.min((double)res, (double)crystal.res(hkl));
                }
            }
        }
        catch (IOException e) {
            String message = " CNS IO Exception.";
            logger.log(Level.WARNING, message, e);
            return -1.0;
        }
        return res;
    }

    @Override
    public boolean readFile(File cnsFile, ReflectionList reflectionList, DiffractionRefinementData refinementData, CompositeConfiguration properties) {
        int nRead;
        int nRes;
        int nIgnore;
        int nFriedel;
        int nCut;
        int i;
        double fo;
        double sigFo;
        int ih;
        int ik;
        int il;
        int free;
        boolean transpose = false;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n Opening %s\n", cnsFile.getName()));
        if (refinementData.rFreeFlag < 0) {
            refinementData.setFreeRFlag(1);
            sb.append(String.format(" Setting R free flag to CNS default: %d\n", refinementData.rFreeFlag));
        }
        String foString = null;
        String sigFoString = null;
        String rFreeString = null;
        try (BufferedReader br = new BufferedReader(new FileReader(cnsFile));){
            String string;
            free = -1;
            il = -1;
            ik = -1;
            ih = -1;
            sigFo = -1.0;
            fo = -1.0;
            HKL mate = new HKL();
            int nPosIgnore = 0;
            int nTransIgnore = 0;
            while ((string = br.readLine()) != null) {
                String[] strArray = string.split("\\s+");
                for (i = 0; i < strArray.length; ++i) {
                    if (!strArray[i].toLowerCase().startsWith("inde") || i >= strArray.length - 3) continue;
                    ih = Integer.parseInt(strArray[i + 1]);
                    ik = Integer.parseInt(strArray[i + 2]);
                    il = Integer.parseInt(strArray[i + 3]);
                    reflectionList.findSymHKL(ih, ik, il, mate, false);
                    HKL hklpos = reflectionList.getHKL(mate);
                    if (hklpos == null) {
                        ++nPosIgnore;
                    }
                    reflectionList.findSymHKL(ih, ik, il, mate, true);
                    HKL hkltrans = reflectionList.getHKL(mate);
                    if (hkltrans != null) continue;
                    ++nTransIgnore;
                }
            }
            if (nPosIgnore > nTransIgnore) {
                transpose = true;
            }
            if (properties != null) {
                foString = properties.getString("fostring", null);
                sigFoString = properties.getString("sigfostring", null);
                rFreeString = properties.getString("rfreestring", null);
            }
        }
        catch (IOException e) {
            String message = "CNS IO Exception.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        boolean hasFree = false;
        boolean hasSigFo = false;
        boolean hasFo = false;
        boolean hasHKL = false;
        try (BufferedReader br = new BufferedReader(new FileReader(cnsFile));){
            String string;
            double[][] anofSigF = new double[refinementData.n][4];
            for (i = 0; i < refinementData.n; ++i) {
                anofSigF[i][3] = Double.NaN;
                anofSigF[i][2] = Double.NaN;
                anofSigF[i][1] = Double.NaN;
                anofSigF[i][0] = Double.NaN;
            }
            nCut = 0;
            nFriedel = 0;
            nIgnore = 0;
            nRes = 0;
            nRead = 0;
            HKL mate = new HKL();
            while ((string = br.readLine()) != null) {
                String[] strArray = string.split("\\s+");
                for (int i2 = 0; i2 < strArray.length; ++i2) {
                    if (strArray[i2].toLowerCase().startsWith("inde")) {
                        if (hasHKL && hasFo && hasSigFo && hasFree) {
                            boolean friedel = reflectionList.findSymHKL(ih, ik, il, mate, transpose);
                            HKL hkl = reflectionList.getHKL(mate);
                            if (hkl != null) {
                                if (refinementData.fSigFCutoff > 0.0 && fo / sigFo < refinementData.fSigFCutoff) {
                                    ++nCut;
                                } else if (friedel) {
                                    anofSigF[hkl.getIndex()][2] = fo;
                                    anofSigF[hkl.getIndex()][3] = sigFo;
                                    ++nFriedel;
                                } else {
                                    anofSigF[hkl.getIndex()][0] = fo;
                                    anofSigF[hkl.getIndex()][1] = sigFo;
                                }
                                refinementData.setFreeR(hkl.getIndex(), free);
                                ++nRead;
                            } else {
                                HKL tmp = new HKL(ih, ik, il);
                                if (!reflectionList.resolution.inInverseResSqRange(reflectionList.crystal.invressq(tmp))) {
                                    ++nRes;
                                } else {
                                    ++nIgnore;
                                }
                            }
                        }
                        hasHKL = false;
                        hasFo = false;
                        hasSigFo = false;
                        hasFree = false;
                        if (i2 < strArray.length - 3) {
                            ih = Integer.parseInt(strArray[i2 + 1]);
                            ik = Integer.parseInt(strArray[i2 + 2]);
                            il = Integer.parseInt(strArray[i2 + 3]);
                            hasHKL = true;
                        }
                    }
                    if (strArray[i2].toLowerCase().startsWith("fobs=") || strArray[i2].equalsIgnoreCase(foString + "=")) {
                        fo = Double.parseDouble(strArray[i2 + 1]);
                        hasFo = true;
                    }
                    if (strArray[i2].toLowerCase().startsWith("sigma=") || strArray[i2].equalsIgnoreCase(sigFoString + "=")) {
                        sigFo = Double.parseDouble(strArray[i2 + 1]);
                        hasSigFo = true;
                    }
                    if (!strArray[i2].toLowerCase().startsWith("test=") && !strArray[i2].equalsIgnoreCase(rFreeString + "=")) continue;
                    free = Integer.parseInt(strArray[i2 + 1]);
                    hasFree = true;
                }
            }
            refinementData.generateFsigFfromAnomalousFsigF(anofSigF);
        }
        catch (IOException e) {
            String message = "CNS IO Exception.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        if (logger.isLoggable(Level.INFO)) {
            sb.append(String.format(" HKL read in:                             %d\n", nRead));
            sb.append(String.format(" HKL read as friedel mates:               %d\n", nFriedel));
            sb.append(String.format(" HKL not read in (too high resolution):   %d\n", nRes));
            sb.append(String.format(" HKL not read in (not in internal list?): %d\n", nIgnore));
            sb.append(String.format(" HKL not read in (F/sigF cutoff):         %d\n", nCut));
            sb.append(String.format(" HKL in internal list:                    %d\n", reflectionList.hklList.size()));
            logger.info(sb.toString());
        }
        return true;
    }
}

