/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parallel;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.Arrays;

public class RowSchedule
extends IntegerSchedule {
    private final int[] lowerBounds;
    private final int fftZ;
    private final int fftY;
    private int nThreads;
    private boolean[] threadDone;
    private Range[] ranges;
    private int[] weights;

    public RowSchedule(int nThreads, int fftZ, int fftY) {
        this.nThreads = nThreads;
        this.threadDone = new boolean[nThreads];
        this.ranges = new Range[nThreads];
        this.lowerBounds = new int[nThreads + 1];
        this.fftY = fftY;
        this.fftZ = fftZ;
    }

    public boolean isFixedSchedule() {
        return true;
    }

    public Range next(int threadID) {
        if (!this.threadDone[threadID]) {
            this.threadDone[threadID] = true;
            return this.ranges[threadID];
        }
        return null;
    }

    public void start(int nThreads, Range chunkRange) {
        this.nThreads = nThreads;
        if (nThreads != this.threadDone.length) {
            this.threadDone = new boolean[nThreads];
        }
        Arrays.fill(this.threadDone, false);
        if (nThreads != this.ranges.length) {
            this.ranges = new Range[nThreads];
        }
        Arrays.fill(this.lowerBounds, 0);
        this.defineRanges();
    }

    public void updateWeights(int[] weights) {
        this.weights = weights;
    }

    private int totalWeight() {
        int totalWeight = 0;
        for (int i = 0; i < this.fftZ * this.fftY; ++i) {
            totalWeight += this.weights[i];
        }
        return totalWeight;
    }

    private void defineRanges() {
        int currentThread;
        double totalWeight = this.totalWeight();
        if (totalWeight <= (double)this.nThreads) {
            Range temp = new Range(0, this.fftZ * this.fftY - 1);
            this.ranges = temp.subranges(this.nThreads);
            return;
        }
        if (this.nThreads == 1) {
            this.ranges[0] = new Range(0, this.fftZ * this.fftY - 1);
            return;
        }
        double targetWeight = totalWeight / (double)this.nThreads;
        int lastRow = this.fftZ * this.fftY - 1;
        int currentRow = 0;
        this.lowerBounds[0] = 0;
        for (currentThread = 0; currentThread < this.nThreads; ++currentThread) {
            int threadWeight = 0;
            while ((double)threadWeight < targetWeight && currentRow < lastRow) {
                threadWeight += this.weights[currentRow];
                ++currentRow;
            }
            if (currentRow < lastRow) {
                this.lowerBounds[currentThread] = currentRow;
                continue;
            }
            this.lowerBounds[currentThread] = lastRow;
            break;
        }
        int lastThread = currentThread;
        for (currentThread = 0; currentThread < lastThread - 1; ++currentThread) {
            this.ranges[currentThread] = new Range(this.lowerBounds[currentThread], this.lowerBounds[currentThread + 1] - 1);
        }
        this.ranges[lastThread - 1] = new Range(this.lowerBounds[lastThread - 1], lastRow);
        for (int it = lastThread; it < this.nThreads; ++it) {
            this.ranges[it] = null;
        }
    }

    public int[] getThreadWeights() {
        int[] weightsToReturn = new int[this.nThreads];
        System.arraycopy(this.weights, 0, weightsToReturn, 0, this.nThreads);
        return weightsToReturn;
    }

    public int[] getLowerBounds() {
        int[] boundsToReturn = new int[this.nThreads];
        System.arraycopy(this.lowerBounds, 1, boundsToReturn, 0, this.nThreads);
        return boundsToReturn;
    }
}

