/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parallel;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.Arrays;

public class GradientSchedule
extends IntegerSchedule {
    private final int[] lowerBounds;
    private final int nAtoms;
    private int nThreads;
    private boolean[] threadDone;
    private Range[] ranges;
    private int[] weights;

    public GradientSchedule(int nThreads, int nAtoms) {
        this.nThreads = nThreads;
        this.threadDone = new boolean[nThreads];
        this.ranges = new Range[nThreads];
        this.lowerBounds = new int[nThreads + 1];
        this.nAtoms = nAtoms;
    }

    public int[] getLowerBounds() {
        int[] boundsToReturn = new int[this.nThreads];
        System.arraycopy(this.lowerBounds, 1, boundsToReturn, 0, this.nThreads);
        return boundsToReturn;
    }

    public int[] getThreadWeights() {
        int[] weightsToReturn = new int[this.nThreads];
        System.arraycopy(this.weights, 0, weightsToReturn, 0, this.nThreads);
        return weightsToReturn;
    }

    public boolean isFixedSchedule() {
        return true;
    }

    public Range next(int threadID) {
        if (!this.threadDone[threadID]) {
            this.threadDone[threadID] = true;
            return this.ranges[threadID];
        }
        return null;
    }

    public void start(int nThreads, Range chunkRange) {
        this.nThreads = nThreads;
        if (nThreads != this.threadDone.length) {
            this.threadDone = new boolean[nThreads];
        }
        Arrays.fill(this.threadDone, false);
        if (nThreads != this.ranges.length) {
            this.ranges = new Range[nThreads];
        }
        Arrays.fill(this.lowerBounds, 0);
        this.defineRanges();
    }

    public void updateWeights(int[] weights) {
        this.weights = weights;
    }

    private int totalWeight() {
        int totalWeight = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            totalWeight += this.weights[i];
        }
        return totalWeight;
    }

    private void defineRanges() {
        int currentThread;
        double totalWeight = this.totalWeight();
        if (totalWeight <= (double)this.nThreads) {
            Range temp = new Range(0, this.nAtoms - 1);
            this.ranges = temp.subranges(this.nThreads);
            return;
        }
        if (this.nThreads == 1) {
            this.ranges[0] = new Range(0, this.nAtoms - 1);
            return;
        }
        double targetWeight = totalWeight / (double)this.nThreads;
        int lastAtom = this.nAtoms - 1;
        int currentAtom = 0;
        this.lowerBounds[0] = 0;
        for (currentThread = 0; currentThread < this.nThreads; ++currentThread) {
            int threadWeight = 0;
            while ((double)threadWeight < targetWeight && currentAtom < lastAtom) {
                threadWeight += this.weights[currentAtom];
                ++currentAtom;
            }
            if (currentAtom < lastAtom) {
                this.lowerBounds[currentThread] = currentAtom;
                continue;
            }
            this.lowerBounds[currentThread] = lastAtom;
            break;
        }
        int lastThread = currentThread;
        for (currentThread = 0; currentThread < lastThread - 1; ++currentThread) {
            this.ranges[currentThread] = new Range(this.lowerBounds[currentThread], this.lowerBounds[currentThread + 1] - 1);
        }
        this.ranges[lastThread - 1] = new Range(this.lowerBounds[lastThread - 1], lastAtom);
        for (int it = lastThread; it < this.nThreads; ++it) {
            this.ranges[it] = null;
        }
    }
}

