/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.GradientOptions;
import ffx.utilities.FFXBinding;
import ffx.utilities.StringUtils;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Test Lambda Derivatives on an X-ray target."}, name="xray.test.LambdaGradient")
public class LambdaGradient
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private GradientOptions gradientOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private RefinementEnergy refinementEnergy;

    public LambdaGradient() {
    }

    public LambdaGradient(String[] args) {
        super(args);
    }

    public LambdaGradient(FFXBinding binding) {
        super(binding);
    }

    public LambdaGradient run() {
        List atomsToTest;
        String filename;
        MolecularAssembly[] molecularAssemblies;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        System.setProperty("lambdaterm", "true");
        if (this.filenames != null && !this.filenames.isEmpty()) {
            molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = molecularAssemblies[0];
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            filename = this.activeAssembly.getFile().getAbsolutePath();
            molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        this.alchemicalOptions.setFirstSystemAlchemistry(this.activeAssembly);
        this.alchemicalOptions.setFirstSystemUnchargedAtoms(this.activeAssembly);
        logger.info("\n Testing X-ray lambda derivatives for " + filename);
        CompositeConfiguration properties = molecularAssemblies[0].getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        DiffractionData diffractionData = this.xrayOptions.getDiffractionData(this.filenames, molecularAssemblies, properties);
        RefinementEnergy potential = this.refinementEnergy = this.xrayOptions.toXrayEnergy(diffractionData);
        RefinementEnergy lambdaInterface = this.refinementEnergy;
        double step = this.gradientOptions.getDx();
        RefinementModel refinementModel = diffractionData.getRefinementModel();
        int n = refinementModel.getNumParameters();
        Atom[] atoms = refinementModel.getActiveAtoms();
        int nAtoms = atoms.length;
        double[] x = new double[n];
        double[] gradient = new double[n];
        double width = 2.0 * step;
        double errTol = 0.001;
        double expGrad = 1000.0;
        double[] lambdaGrad = new double[n];
        double[][] lambdaGradFD = new double[2][n];
        double initialLambda = this.alchemicalOptions.getInitialLambda();
        double lambda = 0.0;
        lambdaInterface.setLambda(lambda);
        potential.getCoordinates(x);
        double e0 = potential.energy(x, true);
        lambda = 1.0;
        lambdaInterface.setLambda(lambda);
        double e1 = potential.energy(x, true);
        logger.info(String.format(" E(0):      %20.8f.", e0));
        logger.info(String.format(" E(1):      %20.8f.", e1));
        logger.info(String.format(" E(1)-E(0): %20.8f.\n", e1 - e0));
        for (int j = 0; j < 3; ++j) {
            lambda = initialLambda - 0.01 + 0.01 * (double)j;
            if (lambda - step < 0.0 || lambda + step > 1.0) continue;
            logger.info(String.format(" Current lambda value %6.4f", lambda));
            lambdaInterface.setLambda(lambda);
            double e = potential.energyAndGradient(x, gradient);
            double dEdL = lambdaInterface.getdEdL();
            double d2EdL2 = lambdaInterface.getd2EdL2();
            for (int i = 0; i < n; ++i) {
                lambdaGrad[i] = 0.0;
            }
            lambdaInterface.getdEdXdL(lambdaGrad);
            lambdaInterface.setLambda(lambda + step);
            double lp = potential.energyAndGradient(x, lambdaGradFD[0]);
            double dedlp = lambdaInterface.getdEdL();
            lambdaInterface.setLambda(lambda - step);
            double lm = potential.energyAndGradient(x, lambdaGradFD[1]);
            double dedlm = lambdaInterface.getdEdL();
            double dEdLFD = (lp - lm) / width;
            double d2EdL2FD = (dedlp - dedlm) / width;
            double err = Math.abs(dEdLFD - dEdL);
            if (err < errTol) {
                logger.info(String.format(" dE/dL passed:   %10.6f", err));
            } else {
                logger.info(String.format(" dE/dL failed: %10.6f", err));
            }
            logger.info(String.format(" Numeric:   %15.8f", dEdLFD));
            logger.info(String.format(" Analytic:  %15.8f", dEdL));
            err = Math.abs(d2EdL2FD - d2EdL2);
            if (err < errTol) {
                logger.info(String.format(" d2E/dL2 passed: %10.6f", err));
            } else {
                logger.info(String.format(" d2E/dL2 failed: %10.6f", err));
            }
            logger.info(String.format(" Numeric:   %15.8f", d2EdL2FD));
            logger.info(String.format(" Analytic:  %15.8f", d2EdL2));
            boolean passed = true;
            for (int i = 0; i < nAtoms; ++i) {
                double dZa;
                double dZ;
                double eZ;
                double error;
                int ii = i * 3;
                double dX = (lambdaGradFD[0][ii] - lambdaGradFD[1][ii]) / width;
                double dXa = lambdaGrad[ii];
                double eX = dX - dXa;
                ++ii;
                double dY = (lambdaGradFD[0][ii] - lambdaGradFD[1][ii]) / width;
                double dYa = lambdaGrad[ii];
                double eY = dY - dYa;
                if ((error = Math.sqrt(eX * eX + eY * eY + (eZ = (dZ = (lambdaGradFD[0][++ii] - lambdaGradFD[1][ii]) / width) - (dZa = lambdaGrad[ii])) * eZ)) < errTol) {
                    logger.fine(String.format(" dE/dX/dL for Atom %d passed: %10.6f", i + 1, error));
                    continue;
                }
                logger.info(String.format(" dE/dX/dL for Atom %d failed: %10.6f", i + 1, error));
                logger.info(String.format(" Analytic: (%15.8f, %15.8f, %15.8f)", dXa, dYa, dZa));
                logger.info(String.format(" Numeric:  (%15.8f, %15.8f, %15.8f)", dX, dY, dZ));
                passed = false;
            }
            if (passed) {
                logger.info(String.format(" dE/dX/dL passed for all atoms", new Object[0]));
            }
            logger.info("");
        }
        boolean loopPrint = this.gradientOptions.getVerbose();
        this.refinementEnergy.getCoordinates(x);
        this.refinementEnergy.energyAndGradient(x, gradient, loopPrint);
        double[] numeric = new double[3];
        double avLen = 0.0;
        int nFailures = 0;
        double avGrad = 0.0;
        if (this.gradientOptions.getGradientAtoms().equalsIgnoreCase("NONE")) {
            logger.info(" The gradient of no atoms will be evaluated.");
            return this;
        }
        if (this.gradientOptions.getGradientAtoms().equalsIgnoreCase("ALL")) {
            logger.info(" Checking gradient for all active atoms.\n");
            atomsToTest = new ArrayList();
            IntStream.range(0, nAtoms).forEach(val -> atomsToTest.add(val));
        } else {
            atomsToTest = StringUtils.parseAtomRanges((String)" Gradient atoms", (String)this.gradientOptions.getGradientAtoms(), (int)nAtoms);
            logger.info(" Checking gradient for active atoms in the range: " + this.gradientOptions.getGradientAtoms() + "\n");
        }
        Iterator iterator = atomsToTest.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int i3 = i * 3;
            int i0 = i3 + 0;
            int i1 = i3 + 1;
            int i2 = i3 + 2;
            double orig = x[i0];
            x[i0] = x[i0] + step;
            double e = this.refinementEnergy.energy(x, loopPrint);
            x[i0] = orig - step;
            x[i0] = orig;
            numeric[0] = (e -= this.refinementEnergy.energy(x, loopPrint)) / width;
            orig = x[i1];
            x[i1] = x[i1] + step;
            e = this.refinementEnergy.energy(x, loopPrint);
            x[i1] = orig - step;
            x[i1] = orig;
            numeric[1] = (e -= this.refinementEnergy.energy(x, loopPrint)) / width;
            orig = x[i2];
            x[i2] = x[i2] + step;
            e = this.refinementEnergy.energy(x, loopPrint);
            x[i2] = orig - step;
            x[i2] = orig;
            numeric[2] = (e -= this.refinementEnergy.energy(x, loopPrint)) / width;
            double dx = gradient[i0] - numeric[0];
            double dy = gradient[i1] - numeric[1];
            double dz = gradient[i2] - numeric[2];
            double len = dx * dx + dy * dy + dz * dz;
            avLen += len;
            len = Math.sqrt(len);
            double grad2 = gradient[i0] * gradient[i0] + gradient[i1] * gradient[i1] + gradient[i2] * gradient[i2];
            avGrad += grad2;
            grad2 = Math.sqrt(grad2);
            if (len > errTol) {
                logger.info(String.format(" Atom %d failed: %10.6f.", i + 1, len) + String.format("\n Analytic: (%12.4f, %12.4f, %12.4f)", gradient[i0], gradient[i1], gradient[i2]) + String.format("\n Numeric:  (%12.4f, %12.4f, %12.4f)", numeric[0], numeric[1], numeric[2]));
                ++nFailures;
            } else {
                logger.info(String.format(" Atom %d passed: %10.6f.", i + 1, len) + String.format("\n Analytic: (%12.4f, %12.4f, %12.4f)", gradient[i0], gradient[i1], gradient[i2]) + String.format("\n Numeric:  (%12.4f, %12.4f, %12.4f)", numeric[0], numeric[1], numeric[2]));
            }
            if (grad2 > expGrad) {
                logger.info(String.format(" Atom %d has an unusually large gradient: %10.6f", i + 1, grad2));
            }
            logger.info("\n");
        }
        avLen /= (double)nAtoms;
        if ((avLen = Math.sqrt(avLen)) > errTol) {
            logger.info(String.format(" Test failure: RMSD from analytic solution is %10.6f > %10.6f", avLen, errTol));
        } else {
            logger.info(String.format(" Test success: RMSD from analytic solution is %10.6f < %10.6f", avLen, errTol));
        }
        logger.info(String.format(" Number of atoms failing gradient test: %d", nFailures));
        avGrad /= (double)nAtoms;
        avGrad = Math.sqrt(avGrad);
        if (avGrad > expGrad) {
            logger.info(String.format(" Unusually large RMS gradient: %10.6f > %10.6f", avGrad, expGrad));
        } else {
            logger.info(String.format(" RMS gradient: %10.6f", avGrad));
        }
        diffractionData.getRefinementModel().setRefinementMode(RefinementMode.BFACTORS);
        this.refinementEnergy = new RefinementEnergy(diffractionData);
        n = this.refinementEnergy.getNumberOfVariables();
        gradient = new double[n];
        x = new double[n];
        this.refinementEnergy.getCoordinates(x);
        this.refinementEnergy.energyAndGradient(x, gradient);
        avLen = 0.0;
        nFailures = 0;
        avGrad = 0.0;
        width = 2.0 * step;
        errTol = 0.001;
        expGrad = 1000.0;
        for (int i = 0; i < n; ++i) {
            double orig = x[i];
            x[i] = x[i] + step;
            double e = this.refinementEnergy.energy(x);
            x[i] = orig - step;
            x[i] = orig;
            double fd = (e -= this.refinementEnergy.energy(x)) / width;
            double dB = gradient[i] - fd;
            double len = dB * dB;
            avLen += len;
            len = Math.sqrt(len);
            double grad2 = dB * dB;
            avGrad += grad2;
            grad2 = Math.sqrt(grad2);
            if (len > errTol) {
                logger.info(String.format(" B-Factor %d failed: %10.6f.", i + 1, len) + String.format("\n Analytic: %12.4f", gradient[i]) + String.format("\n Numeric:  %12.4f", fd));
                ++nFailures;
            } else {
                logger.info(String.format(" B-Factor %d passed: %10.6f.", i + 1, len) + String.format("\n Analytic: %12.4f", gradient[i]) + String.format("\n Numeric:  %12.4f", fd));
            }
            if (grad2 > expGrad) {
                logger.info(String.format(" B-Factor %d has an unusually large gradient: %10.6f", i + 1, grad2));
            }
            logger.info("\n");
        }
        avLen /= (double)n;
        if ((avLen = Math.sqrt(avLen)) > errTol) {
            logger.info(String.format(" Test failure: RMSD from analytic solution is %10.6f > %10.6f", avLen, errTol));
        } else {
            logger.info(String.format(" Test success: RMSD from analytic solution is %10.6f < %10.6f", avLen, errTol));
        }
        logger.info(String.format(" Number of B-Factors failing gradient test: %d", nFailures));
        avGrad /= (double)n;
        avGrad = Math.sqrt(avGrad);
        if (avGrad > expGrad) {
            logger.info(String.format(" Unusually large RMS gradient: %10.6f > %10.6f", avGrad, expGrad));
        } else {
            logger.info(String.format(" RMS gradient: %10.6f", avGrad));
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.refinementEnergy == null ? Collections.emptyList() : Collections.singletonList(this.refinementEnergy);
    }
}

