/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.TimerOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Time calculation of the X-ray target."}, name="xray.Timer")
public class Timer
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private TimerOptions timerOptions;
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private DiffractionData diffractionData;
    private MolecularAssembly[] molecularAssemblies;
    private RefinementEnergy refinementEnergy;

    public Timer() {
    }

    public Timer(String[] args) {
        super(args);
    }

    public Timer(FFXBinding binding) {
        super(binding);
    }

    public Timer run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        if (this.timerOptions.getThreads() > 0) {
            System.setProperty("pj.nt", Integer.toString(this.timerOptions.getThreads()));
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = this.molecularAssemblies[0];
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        logger.info("\n Running xray.Timer on " + filename);
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(molecularAssembly);
        }
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.refinementEnergy = this.xrayOptions.toXrayEnergy(this.diffractionData);
        this.algorithmFunctions.energy(this.molecularAssemblies);
        int n = this.refinementEnergy.getNumberOfVariables();
        double[] x = new double[n];
        double[] g = new double[n];
        this.refinementEnergy.getCoordinates(x);
        CrystalPotential energy = this.refinementEnergy.getDataEnergy();
        logger.info("\n Beginning Timings\n");
        int nEvals = this.timerOptions.getIterations();
        boolean gradient = !this.timerOptions.getNoGradient();
        long minTime = Long.MAX_VALUE;
        double sumTime2 = 0.0;
        int halfnEvals = nEvals % 2 == 1 ? nEvals / 2 : nEvals / 2 - 1;
        for (int i = 0; i < nEvals; ++i) {
            long time = -System.nanoTime();
            double e = gradient ? energy.energyAndGradient(x, g) : energy.energy(x);
            time += System.nanoTime();
            if (gradient) {
                logger.info(String.format(" Energy & Gradient: %12.6f in %6.3f (sec)", e, (double)time * 1.0E-9));
            } else {
                logger.info(String.format(" Energy: %12.6f in %6.3f (sec)", e, (double)time * 1.0E-9));
            }
            long l = minTime = time < minTime ? time : minTime;
            if (i < nEvals / 2) continue;
            double time2 = (double)time * 1.0E-9;
            sumTime2 += time2 * time2;
        }
        double rmsTime = Math.sqrt(sumTime2 / (double)(++halfnEvals));
        logger.info(String.format("\n Minimum time:           %6.3f (sec)", (double)minTime * 1.0E-9));
        logger.info(String.format(" RMS time (latter half): %6.3f (sec)", rmsTime));
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

