/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.cli.XrayOptions;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Compare the PDB model to the diffraction data."}, name="xray.ModelvsData")
public class ModelvsData
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Option(names={"-p", "--maps"}, paramLabel="false", description={"Output sigmaA weighted 2Fo-Fc and Fo-Fc maps."})
    private boolean maps = false;
    @CommandLine.Option(names={"-n", "--normalize"}, paramLabel="false", description={"Normalize maps to a standard deviation of 1.0."})
    private boolean normalize = false;
    @CommandLine.Option(names={"-t", "--timings"}, paramLabel="false", description={"Perform FFT timings."})
    private boolean timings = false;
    @CommandLine.Option(names={"-w", "--mtz"}, paramLabel="false", description={"write out MTZ containing structure factor coefficients."})
    private boolean mtz = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private DiffractionData diffractionData;
    private MolecularAssembly[] molecularAssemblies;

    public ModelvsData() {
    }

    public ModelvsData(String[] args) {
        super(args);
    }

    public ModelvsData(FFXBinding binding) {
        super(binding);
    }

    public ModelvsData run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
            filename = this.filenames.getFirst();
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        logger.info(String.format("\n Running xray.ModelvsData on %s", filename));
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(molecularAssembly);
        }
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        boolean useHydrogen = properties.getBoolean("use-hydrogen", true);
        if (!useHydrogen) {
            Atom[] atoms;
            for (Atom atom : atoms = this.activeAssembly.getAtomArray()) {
                if (!atom.isHydrogen()) continue;
                atom.setOccupancy(0.0);
            }
        }
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        this.algorithmFunctions.energy(this.molecularAssemblies);
        if (this.mtz) {
            this.diffractionData.writeData(FilenameUtils.removeExtension((String)filename) + "_ffx.mtz");
        }
        if (this.maps) {
            this.diffractionData.writeMaps(FilenameUtils.removeExtension((String)filename), this.normalize);
        }
        if (this.timings) {
            this.diffractionData.timings();
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

