/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementMinimize;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Refine an X-ray/Neutron target."}, name="xray.Minimize")
public class Minimize
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Option(names={"-t", "--threeStage"}, paramLabel="false", description={"Perform refinement in 3 stages: coordinates, b-factors, and then occupancies (overrides mode setting if true)"})
    private boolean threeStage = false;
    @CommandLine.Option(names={"-E", "--eps3"}, paramLabel="-1.0", arity="3", description={"RMS gradient convergence criteria for three stage refinement (default of -1.0 automatically determines eps for each stage)."})
    private double[] eps3 = new double[]{-1.0, -1.0, -1.0};
    @CommandLine.Option(names={"-c", "--cycles"}, paramLabel="1", defaultValue="1", description={"Number of refinement cycles."})
    private int ncycles = 1;
    @CommandLine.Option(names={"--mtz"}, paramLabel="false", description={"Write out an MTZ containing structure factor coefficients."})
    private boolean mtz = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;

    public Minimize() {
    }

    public Minimize(String[] args) {
        super(args);
    }

    public Minimize(FFXBinding binding) {
        super(binding);
    }

    public Minimize run() {
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(molecularAssembly);
        }
        logger.info("\n Running xray.Minimize on " + filename);
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.algorithmFunctions.energy(this.molecularAssemblies);
        double coordinateEPS = this.eps3[0];
        double bfactorEPS = this.eps3[1];
        double occupancyEPS = this.eps3[2];
        int nBFGS = this.minimizeOptions.getNBFGS();
        int maxIterations = this.minimizeOptions.getIterations();
        for (int cycle = 0; cycle < this.ncycles; ++cycle) {
            if (this.ncycles > 1) {
                logger.info(String.format("\n Refinement Cycle: %d\n", cycle + 1));
            }
            this.diffractionData.scaleBulkFit();
            this.diffractionData.printStats();
            if (this.threeStage) {
                RefinementMinimize refinementMinimize;
                RefinementModel refinementModel = this.diffractionData.getRefinementModel();
                RefinementMode refinementMode = RefinementMode.COORDINATES;
                refinementModel.setRefinementMode(refinementMode);
                if (refinementModel.getNumCoordParameters() > 0) {
                    refinementMinimize = new RefinementMinimize(this.diffractionData);
                    if (coordinateEPS < 0.0) {
                        coordinateEPS = refinementMode.getDefaultEps();
                    }
                    if (maxIterations < Integer.MAX_VALUE) {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f, Maximum iterations %d", coordinateEPS, maxIterations));
                    } else {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f", coordinateEPS));
                    }
                    refinementMinimize.minimize(nBFGS, coordinateEPS, maxIterations);
                    this.algorithmFunctions.energy(this.molecularAssemblies);
                }
                refinementMode = RefinementMode.BFACTORS;
                refinementModel.setRefinementMode(refinementMode);
                if (refinementModel.getNumBFactorParameters() > 0) {
                    refinementMinimize = new RefinementMinimize(this.diffractionData);
                    if (bfactorEPS < 0.0) {
                        boolean hasAnisous = refinementModel.getNumANISOU() > 0;
                        bfactorEPS = refinementMode.getDefaultEps(hasAnisous);
                    }
                    if (maxIterations < Integer.MAX_VALUE) {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f, Maximum iterations %d", bfactorEPS, maxIterations));
                    } else {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f", bfactorEPS));
                    }
                    refinementMinimize.minimize(nBFGS, bfactorEPS, maxIterations);
                }
                refinementMode = RefinementMode.OCCUPANCIES;
                refinementModel.setRefinementMode(refinementMode);
                if (refinementModel.getNumOccupancyParameters() > 0) {
                    refinementMinimize = new RefinementMinimize(this.diffractionData);
                    if (occupancyEPS < 0.0) {
                        occupancyEPS = refinementMode.getDefaultEps();
                    }
                    if (maxIterations < Integer.MAX_VALUE) {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f, Maximum iterations %d", occupancyEPS, maxIterations));
                    } else {
                        logger.info(String.format("\n RMS gradient convergence criteria: %8.5f", occupancyEPS));
                    }
                    refinementMinimize.minimize(occupancyEPS, maxIterations);
                    continue;
                }
                logger.info("Occupancy refinement not necessary, skipping");
                continue;
            }
            RefinementMinimize refinementMinimize = new RefinementMinimize(this.diffractionData);
            RefinementModel refinementModel = this.diffractionData.getRefinementModel();
            RefinementMode refinementMode = refinementModel.getRefinementMode();
            double eps = this.minimizeOptions.getEps();
            if (eps < 0.0) {
                boolean hasAnisous = refinementModel.getNumANISOU() > 0;
                eps = refinementMode.getDefaultEps(hasAnisous);
            }
            if (maxIterations < Integer.MAX_VALUE) {
                logger.info(String.format("\n RMS gradient convergence criteria: %8.5f, Maximum iterations %d", eps, maxIterations));
            } else {
                logger.info(String.format("\n RMS gradient convergence criteria: %8.5f", eps));
            }
            refinementMinimize.minimize(eps, maxIterations);
        }
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        this.algorithmFunctions.energy(this.molecularAssemblies);
        logger.info(" ");
        this.diffractionData.writeModel(FilenameUtils.removeExtension((String)filename) + ".pdb");
        if (this.mtz) {
            this.diffractionData.writeData(FilenameUtils.removeExtension((String)filename) + ".mtz");
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

