/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import java.io.File;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run Dynamics on an X-ray target."}, name="xray.Dynamics")
public class Dynamics
extends AlgorithmsCommand
implements AlgorithmListener {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeoutOptions;
    @CommandLine.Option(names={"--mtz"}, paramLabel="false", description={"Write out an MTZ containing structure factor coefficients."})
    private boolean mtz = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;
    private RefinementEnergy refinementEnergy;

    public Dynamics() {
    }

    public Dynamics(String[] args) {
        super(args);
    }

    public Dynamics(FFXBinding binding) {
        super(binding);
    }

    public Dynamics run() {
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(molecularAssembly);
        }
        logger.info("\n Running xray.Dynamics on " + filename);
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.refinementEnergy = this.xrayOptions.toXrayEnergy(this.diffractionData);
        this.algorithmFunctions.energy(this.molecularAssemblies);
        File dyn = null;
        if (this.xrayOptions.refinementMode == RefinementMode.COORDINATES && !(dyn = new File(FilenameUtils.removeExtension((String)filename) + ".dyn")).exists()) {
            dyn = null;
        }
        MolecularDynamics molecularDynamics = this.dynamicsOptions.getDynamics(this.writeoutOptions, (Potential)this.refinementEnergy, this.activeAssembly, (AlgorithmListener)this);
        this.refinementEnergy.setThermostat(molecularDynamics.getThermostat());
        boolean initVelocities = true;
        molecularDynamics.dynamic(this.dynamicsOptions.getSteps(), this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), initVelocities, dyn);
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        this.algorithmFunctions.energy(this.molecularAssemblies);
        logger.info(" ");
        this.diffractionData.writeModel(FilenameUtils.removeExtension((String)filename) + ".pdb");
        if (this.mtz) {
            this.diffractionData.writeData(FilenameUtils.removeExtension((String)filename) + ".mtz");
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }

    public boolean algorithmUpdate(MolecularAssembly active) {
        logger.info(" R/Rfree " + this.diffractionData.printOptimizationUpdate());
        return true;
    }
}

