/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.crystal.Crystal;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.parsers.CIFFilter;
import ffx.xray.parsers.MTZWriter;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Convert a CIF file to MTZ format."}, name="xray.CIFtoMTZ")
public class CIFtoMTZ
extends AlgorithmsCommand {
    @CommandLine.Parameters(arity="2", paramLabel="file", description={"A PDB file and a CIF diffraction file."})
    private List<String> filenames = null;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionRefinementData refinementData;

    public CIFtoMTZ() {
    }

    public CIFtoMTZ(String[] args) {
        super(args);
    }

    public CIFtoMTZ(FFXBinding binding) {
        super(binding);
    }

    public CIFtoMTZ run() {
        if (!this.init()) {
            return this;
        }
        String pdb = this.filenames.get(0);
        String cif = this.filenames.get(1);
        logger.info("\n Running CIF2MTZ on " + cif);
        this.molecularAssemblies = this.algorithmFunctions.openAll(pdb);
        CIFFilter cifFilter = new CIFFilter();
        ReflectionList reflectionlist = cifFilter.getReflectionList(new File(cif), this.molecularAssemblies[0].getProperties());
        if (reflectionlist == null) {
            logger.info(" Using crystal information from the PDB file to generate MTZ file.");
            Crystal crystal = this.molecularAssemblies[0].getCrystal().getUnitCell();
            double res = cifFilter.getResolution(new File(cif), crystal);
            if (res < 0.0) {
                logger.info(" The resolution could not be determined from the PDB and CIF files.");
                return this;
            }
            Resolution resolution = new Resolution(res);
            reflectionlist = new ReflectionList(crystal, resolution, this.molecularAssemblies[0].getProperties());
        }
        this.refinementData = new DiffractionRefinementData(this.molecularAssemblies[0].getProperties(), reflectionlist);
        cifFilter.readFile(new File(cif), reflectionlist, this.refinementData, this.molecularAssemblies[0].getProperties());
        MTZWriter mtzwriter = new MTZWriter(reflectionlist, this.refinementData, FilenameUtils.removeExtension((String)cif) + ".mtz", 1);
        mtzwriter.write();
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

