/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.AnnealOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.optimize.anneal.SimulatedAnnealing;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import java.io.File;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Simulated annealing on an X-ray target."}, name="xray.Anneal")
public class Anneal
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private AnnealOptions annealOptions;
    @CommandLine.Option(names={"--mtz"}, paramLabel="false", description={"Write out an MTZ containing structure factor coefficients."})
    private boolean mtz = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;
    private SimulatedAnnealing simulatedAnnealing = null;
    private RefinementEnergy refinementEnergy;

    public Anneal() {
    }

    public Anneal(String[] args) {
        super(args);
    }

    public Anneal(FFXBinding binding) {
        super(binding);
    }

    public Anneal run() {
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(molecularAssembly);
        }
        logger.info("\n Running simulated annealing on X-ray target including " + filename + "\n");
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.refinementEnergy = this.xrayOptions.toXrayEnergy(this.diffractionData);
        this.algorithmFunctions.energy(this.molecularAssemblies);
        File dyn = null;
        if (this.xrayOptions.refinementMode == RefinementMode.COORDINATES && !(dyn = new File(FilenameUtils.removeExtension((String)filename) + ".dyn")).exists()) {
            dyn = null;
        }
        this.simulatedAnnealing = this.annealOptions.createAnnealer(this.dynamicsOptions, this.activeAssembly, (Potential)this.refinementEnergy, this.algorithmListener, dyn);
        this.simulatedAnnealing.setPrintInterval(this.dynamicsOptions.getReport());
        this.simulatedAnnealing.setSaveFrequency(this.dynamicsOptions.getWrite());
        this.simulatedAnnealing.setRestartFrequency(this.dynamicsOptions.getCheckpoint());
        this.simulatedAnnealing.setTrajectorySteps(this.dynamicsOptions.getTrajSteps());
        this.simulatedAnnealing.anneal();
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        this.algorithmFunctions.energy(this.molecularAssemblies);
        logger.info(" ");
        this.diffractionData.writeModel(FilenameUtils.removeExtension((String)filename) + ".pdb");
        if (this.mtz) {
            this.diffractionData.writeData(FilenameUtils.removeExtension((String)filename) + ".mtz");
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

