/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.cli;

import ffx.potential.MolecularAssembly;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.DataRefinementOptions;
import ffx.xray.parsers.DiffractionFile;
import ffx.xray.refine.RefinementMode;
import ffx.xray.solvent.SolventModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

public class XrayOptions
extends DataRefinementOptions {
    private static final Logger logger = Logger.getLogger(XrayOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n X-ray Refinement Options%n", validate=false)
    private final XrayOptionGroup group = new XrayOptionGroup();
    @CommandLine.ArgGroup(heading="%n X-ray Reflection Data Options%n", validate=false)
    private final XrayReflectionsGroup reflectionGroup = new XrayReflectionsGroup();
    @CommandLine.ArgGroup(heading="%n X-ray B-Factor Options%n", validate=false)
    private final BFactorGroup bfactorGroup = new BFactorGroup();
    @CommandLine.ArgGroup(heading="%n X-ray Target Options%n", validate=false)
    private final ScatteringGroup targetGroup = new ScatteringGroup();
    @CommandLine.ArgGroup(heading="%n X-ray Bulk Solvent Options%n", validate=false)
    private final BulkSolventGroup solventGroup = new BulkSolventGroup();
    public RefinementMode refinementMode = RefinementMode.COORDINATES;
    public SolventModel solventModel = SolventModel.POLYNOMIAL;

    public void init() {
        this.refinementMode = RefinementMode.parseMode(this.group.modeString);
        this.solventModel = SolventModel.parse(this.solventGroup.solventString);
    }

    public List<DiffractionFile> processData(List<String> filenames, MolecularAssembly[] systems) {
        ArrayList<DiffractionFile> diffractionfiles = new ArrayList<DiffractionFile>();
        logger.info("\n");
        if (filenames.size() > 1) {
            logger.info(String.format(" Diffraction file = %s, weight = %3.1f, neutron = %b", filenames.get(1), this.wA, Boolean.FALSE));
            DiffractionFile diffractionfile = new DiffractionFile(filenames.get(1), this.wA, false);
            diffractionfiles.add(diffractionfile);
        }
        if (this.reflectionGroup.data != null) {
            for (int i = 0; i < this.reflectionGroup.data.length; i += 3) {
                boolean neutron = false;
                double w = this.wA;
                if (this.reflectionGroup.data.length > i + 1) {
                    try {
                        w = Double.parseDouble(this.reflectionGroup.data[i + 1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.reflectionGroup.data.length > i + 2) {
                    try {
                        neutron = Boolean.parseBoolean(this.reflectionGroup.data[i + 2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                logger.info(String.format(" Diffraction file = %s, weight = %3.1f, neutron = %b", this.reflectionGroup.data[i], w, neutron));
                DiffractionFile diffractionfile = new DiffractionFile(this.reflectionGroup.data[i], w, neutron);
                diffractionfiles.add(diffractionfile);
            }
        }
        if (diffractionfiles.isEmpty()) {
            String filename = systems[0].getFile().getAbsolutePath();
            filename = FilenameUtils.removeExtension((String)filename);
            filename = FilenameUtils.getBaseName((String)filename);
            logger.info(String.format(" Diffraction from = %s, weight = %3.1f, neutron = %b", filename, this.wA, false));
            DiffractionFile diffractionfile = new DiffractionFile(systems, 1.0, false);
            diffractionfiles.add(diffractionfile);
        }
        return diffractionfiles;
    }

    public void setProperties(CommandLine.ParseResult parseResult, CompositeConfiguration properties) {
        if (!parseResult.hasMatchedOption("wA")) {
            this.wA = properties.getDouble("data-weight", this.wA);
        }
        properties.setProperty("data-weight", (Object)this.wA);
        if (!parseResult.hasMatchedOption("bSimWeight")) {
            this.bfactorGroup.bSimWeight = properties.getDouble("b-sim-weight", this.bfactorGroup.bSimWeight);
        }
        properties.setProperty("b-sim-weight", (Object)this.bfactorGroup.bSimWeight);
        if (!parseResult.hasMatchedOption("fSigFCutoff")) {
            this.reflectionGroup.fSigFCutoff = properties.getDouble("f-sigf-cutoff", this.reflectionGroup.fSigFCutoff);
        }
        properties.setProperty("f-sigf-cutoff", (Object)this.reflectionGroup.fSigFCutoff);
        if (!parseResult.hasMatchedOption("gridSearch")) {
            this.solventGroup.gridSearch = properties.getBoolean("solvent-grid-search", this.solventGroup.gridSearch);
        }
        properties.setProperty("solvent-grid-search", (Object)this.solventGroup.gridSearch);
        if (!parseResult.hasMatchedOption("nBins")) {
            this.reflectionGroup.nBins = properties.getInt("reflection-bins", this.reflectionGroup.nBins);
        }
        properties.setProperty("reflection-bins", (Object)this.reflectionGroup.nBins);
        if (!parseResult.hasMatchedOption("sampling")) {
            this.targetGroup.sampling = properties.getDouble("sampling", this.targetGroup.sampling);
        }
        properties.setProperty("sampling", (Object)this.targetGroup.sampling);
        if (!parseResult.hasMatchedOption("aRadBuffer")) {
            this.targetGroup.aRadBuffer = properties.getDouble("scattering-buffer", this.targetGroup.aRadBuffer);
        }
        properties.setProperty("scattering-buffer", (Object)this.targetGroup.aRadBuffer);
        if (!parseResult.hasMatchedOption("rFreeFlag")) {
            this.reflectionGroup.rFreeFlag = properties.getInt("rfree-flag", this.reflectionGroup.rFreeFlag);
        }
        properties.setProperty("rfree-flag", (Object)this.reflectionGroup.rFreeFlag);
        if (!parseResult.hasMatchedOption("noSplineFit")) {
            this.targetGroup.noSplineFit = properties.getBoolean("no-spline-fit", this.targetGroup.noSplineFit);
        }
        properties.setProperty("no-spline-fit", (Object)this.targetGroup.noSplineFit);
        if (!parseResult.hasMatchedOption("allGaussians")) {
            this.targetGroup.useAllGaussians = !properties.getBoolean("use-3g", !this.targetGroup.useAllGaussians);
        }
        properties.setProperty("use-3g", (Object)(!this.targetGroup.useAllGaussians ? 1 : 0));
        if (!parseResult.hasMatchedOption("xrayScaleTol")) {
            this.targetGroup.xrayScaleTol = properties.getDouble("xray-scale-tol", this.targetGroup.xrayScaleTol);
        }
        properties.setProperty("xray-scale-tol", (Object)this.targetGroup.xrayScaleTol);
        if (!parseResult.hasMatchedOption("sigmaATol")) {
            this.targetGroup.sigmaATol = properties.getDouble("sigmaa-tol", this.targetGroup.sigmaATol);
        }
        properties.setProperty("sigmaa-tol", (Object)this.targetGroup.sigmaATol);
        if (!parseResult.hasMatchedOption("nResidueBFactor")) {
            this.bfactorGroup.nResidueBFactor = properties.getInt("n-residue-bfactor", this.bfactorGroup.nResidueBFactor);
        }
        properties.setProperty("n-residue-bfactor", (Object)Integer.toString(this.bfactorGroup.nResidueBFactor));
        if (this.bfactorGroup.nResidueBFactor > 0) {
            properties.setProperty("residue-bfactor", (Object)"true");
        }
        if (!parseResult.hasMatchedOption("anisoU")) {
            this.bfactorGroup.anisoU = properties.getBoolean("add-anisou", this.bfactorGroup.anisoU);
        }
        properties.setProperty("add-anisou", (Object)this.bfactorGroup.anisoU);
        if (!parseResult.hasMatchedOption("refineMolOcc")) {
            this.group.refineMolOcc = properties.getBoolean("refine-mol-occ", this.group.refineMolOcc);
        }
        properties.setProperty("refine-mol-occ", (Object)this.group.refineMolOcc);
    }

    public DiffractionData getDiffractionData(List<String> filenames, MolecularAssembly[] assemblies, CompositeConfiguration properties) {
        List<DiffractionFile> diffractionFiles = this.processData(filenames, assemblies);
        DiffractionData diffractionData = new DiffractionData(assemblies, properties, this.solventModel, diffractionFiles.toArray(new DiffractionFile[0]));
        diffractionData.getRefinementModel().setRefinementMode(this.refinementMode);
        return diffractionData;
    }

    public RefinementEnergy toXrayEnergy(DiffractionData diffractionData) {
        diffractionData.scaleBulkFit();
        diffractionData.printStats();
        return new RefinementEnergy(diffractionData);
    }

    private static class XrayOptionGroup {
        @CommandLine.Option(names={"--rmo", "--refineMolOcc"}, paramLabel="false", defaultValue="false", description={"Refine molecular occupancy."})
        @FFXProperty(name="refine-mol-occ", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="false", description="Refine molecular occupancy.")
        boolean refineMolOcc = false;
        @CommandLine.Option(names={"-m", "--mode"}, paramLabel="coordinates", defaultValue="coordinates", description={"Refinement mode: coordinates, bfactors and/or occupancies."})
        String modeString = "coordinates";

        private XrayOptionGroup() {
        }
    }

    private static class XrayReflectionsGroup {
        @CommandLine.Option(names={"--nBins"}, paramLabel="10", defaultValue="10", description={"The number of refection bins."})
        @FFXProperty(name="reflection-bins", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="10", description="The number of refection bins.")
        int nBins = 10;
        @CommandLine.Option(names={"--FSigFCutoff"}, paramLabel="-1.0", defaultValue="-1.0", description={"F / SigF cutoff (-1.0 is no cutoff)."})
        @FFXProperty(name="f-sigf-cutoff", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="-1.0", description="F / SigF cutoff (-1.0 is no cutoff).")
        double fSigFCutoff = -1.0;
        @CommandLine.Option(names={"-R", "--rFreeFlag"}, paramLabel="-1", defaultValue="-1", description={"R-Free Flag value (-1 attempts to auto-determine from the data)."})
        @FFXProperty(name="rfree-flag", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="-1", description="R-Free Flag value (-1 attempts to auto-determine from the data).")
        int rFreeFlag = -1;
        @CommandLine.Option(names={"-X", "--data"}, arity="3", description={"Specify input data filename, its weight (wA) and if its from a neutron experiment (e.g. -X filename 1.0 false)."})
        String[] data = null;

        private XrayReflectionsGroup() {
        }
    }

    private static class BFactorGroup {
        @CommandLine.Option(names={"-B", "--bSimWeight"}, paramLabel="1.0", defaultValue="1.0", description={"B-Factor similarity weight."})
        @FFXProperty(name="b-sim-weight", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="1.0", description="B-factor harmonic restraint weight between bonded atoms.\nThis can be increased for low resolution structures to ~5-10.\n")
        double bSimWeight = 1.0;
        @CommandLine.Option(names={"--nResidueBFactor"}, paramLabel="0", defaultValue="0", description={"Number of residues per B-factor. 0 uses atomic B-factors (default)."})
        @FFXProperty(name="n-residue-bfactor", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="0", description="Number of residues per B-factor. 0 uses atomic B-factors (default).")
        int nResidueBFactor = 0;
        @CommandLine.Option(names={"-U", "--addAnisoU"}, paramLabel="false", defaultValue="false", description={"Add Anisotropic B-Factors to refinement."})
        @FFXProperty(name="add-anisou", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="false", description="Add Anisotropic B-Factors to refinement.")
        boolean anisoU = false;

        private BFactorGroup() {
        }
    }

    private static class ScatteringGroup {
        @CommandLine.Option(names={"--aRadBuffer"}, paramLabel="0.75", defaultValue="0.75", description={"Scattering is evaluated within the atomic radius plus this buffer (\u00c5)."})
        @FFXProperty(name="scattering-buffer", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="0.6", description="Scattering is evaluated within the atomic radius plus this buffer (\u00c5).")
        double aRadBuffer = 0.75;
        @CommandLine.Option(names={"-G", "--sampling"}, paramLabel="0.6", defaultValue="0.6", description={"The number of grid spaces per Angstrom for the scattering FFT grid."})
        @FFXProperty(name="sampling", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="0.6", description="The number of grid spaces per Angstrom for the scattering FFT grid.")
        double sampling = 0.6;
        @CommandLine.Option(names={"--nsf", "--noSplineFit"}, paramLabel="false", defaultValue="false", description={"Use a resolution dependent spline scale factor."})
        @FFXProperty(name="no-spline-fit", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="false", description="Do not use a resolution dependent spline scale factor.")
        boolean noSplineFit = false;
        @CommandLine.Option(names={"-A", "--allGaussians"}, paramLabel="false", defaultValue="false", description={"Use all defined Gaussians for atomic scattering density (the default is to use the top 3)."})
        @FFXProperty(name="use-3g", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="true", description="The three Gaussians with the largest amplitudes define the atomic scattering density.")
        boolean useAllGaussians = false;
        @CommandLine.Option(names={"--xrayScaleTol"}, paramLabel="1.0e-4", defaultValue="1.0e-4", description={"X-ray scale optimization tolerance."})
        @FFXProperty(name="xray-scale-tol", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="1.0e-4", description="X-ray scale optimization tolerance.")
        double xrayScaleTol = 1.0E-4;
        @CommandLine.Option(names={"--sigmaATol"}, paramLabel="0.05", defaultValue="0.05", description={"Sigma A optimization tolerance."})
        @FFXProperty(name="sigmaa-tol", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="0.05", description="Sigma A optimization tolerance.")
        double sigmaATol = 0.05;

        private ScatteringGroup() {
        }
    }

    private static class BulkSolventGroup {
        @CommandLine.Option(names={"-S", "--solventGridSearch"}, paramLabel="false", defaultValue="false", description={"Perform a grid search for optimal bulk solvent parameters."})
        @FFXProperty(name="solvent-grid-search", propertyGroup=PropertyGroup.StructuralRefinement, defaultValue="false", description="Perform a grid search for optimal bulk solvent parameters.")
        boolean gridSearch = false;
        @CommandLine.Option(names={"--sol", "--solvent"}, paramLabel="POLYNOMIAL", defaultValue="POLYNOMIAL", description={"Bulk solvent scattering model [Polynomial/Gaussian/Binary/None]"})
        String solventString = "POLYNOMIAL";

        private BulkSolventGroup() {
        }
    }
}

