/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.algorithms.Terminatable;
import ffx.crystal.ReflectionList;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.SplineEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SplineMinimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(SplineEnergy.class.getName());
    private final SplineEnergy splineEnergy;
    private final SplineEnergy.SplineType splineType;
    private final int n;
    private final double[] x;
    private final double[] grad;
    private final double[] scaling;
    private boolean done = false;
    private boolean terminate = false;
    private long time;
    private double grms;
    private int nSteps;

    public SplineMinimize(ReflectionList reflectionList, DiffractionRefinementData refinementData, double[] x, SplineEnergy.SplineType type) {
        this.x = x;
        this.splineType = type;
        this.n = x.length;
        this.splineEnergy = new SplineEnergy(reflectionList, refinementData, this.n, type);
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            x[i] = type == SplineEnergy.SplineType.FOTOESQ || type == SplineEnergy.SplineType.FCTOESQ ? 0.1 : 1.0;
            this.scaling[i] = 1.0;
        }
    }

    public double[] getCoordinates(@Nullable double[] x) {
        if (x == null) {
            x = new double[this.x.length];
        }
        System.arraycopy(this.x, 0, x, 0, this.x.length);
        return x;
    }

    public int getNumberOfVariables() {
        return this.x.length;
    }

    public SplineEnergy minimize(double eps) {
        return this.minimize(7, eps);
    }

    public SplineEnergy minimize(int m, double eps) {
        this.splineEnergy.setScaling(this.scaling);
        double e = this.splineEnergy.energyAndGradient(this.x, this.grad);
        this.done = false;
        this.time = -System.nanoTime();
        int status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)e, (double[])this.grad, (double)eps, (OptimizationInterface)this.splineEnergy, (OptimizationListener)this);
        this.done = true;
        switch (status) {
            case 0: {
                logger.fine(String.format("\n Optimization achieved convergence criteria: %8.5f\n", this.grms));
                break;
            }
            case 1: {
                logger.fine(String.format("\n Optimization terminated at step %d.\n", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Spline Optimization failed.\n");
            }
        }
        this.splineEnergy.setScaling(null);
        return this.splineEnergy;
    }

    public boolean optimizationUpdate(int iter, int nBFGS, int nfun, double grms, double xrms, double f, double df, double angle, LineSearch.LineSearchResult info) {
        long currentTime = System.nanoTime();
        Double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.grms = grms;
        this.nSteps = iter;
        Level level = Level.FINE;
        if (logger.isLoggable(level)) {
            if (iter == 0) {
                String name = this.splineType.toString();
                if (nBFGS > 0) {
                    logger.log(level, String.format("\n Limited Memory BFGS Quasi-Newton Optimization of %s", name));
                } else {
                    logger.log(level, String.format("\n Steepest Decent Optimization of %s", name));
                }
                logger.log(level, String.format(" Number of Parameters: %d\n", this.n));
                logger.log(level, " Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time");
            }
            if (info == null) {
                logger.log(level, String.format("%6d %12.2e %10.2e", iter, f, grms));
            } else if (info == LineSearch.LineSearchResult.Success) {
                logger.log(level, String.format("%6d %12.2e %10.2e %10.5e %9.5f %8.2f %6d %8.3f", iter, f, grms, df, xrms, angle, nfun, seconds));
            } else {
                logger.log(level, String.format("%6d %12.2e %10.2e %10.5e %9.5f %8.2f %6d %8s", iter, f, grms, df, xrms, angle, nfun, info));
            }
        }
        if (this.terminate) {
            logger.info(" The optimization received a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            SplineMinimize splineMinimize = this;
            synchronized (splineMinimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating minimization.\n", e);
                }
            }
        }
    }

    SplineEnergy getSplineEnergy() {
        return this.splineEnergy;
    }
}

