/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.ParallelTeam;
import ffx.algorithms.Terminatable;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.ReflectionSpline;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.SigmaAEnergy;
import ffx.xray.SplineEnergy;
import ffx.xray.SplineMinimize;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public class SigmaAMinimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(SigmaAMinimize.class.getName());
    private static final double toSeconds = 1.0E-9;
    protected final DiffractionRefinementData refinementData;
    private final ReflectionList reflectionList;
    private final Crystal crystal;
    private final SigmaAEnergy sigmaAEnergy;
    private final int n;
    private final double[] x;
    private final double[] grad;
    private final double[] scaling;
    private boolean done = false;
    private boolean terminate = false;
    private long time;
    private double grms;
    private int nSteps;

    SigmaAMinimize(ReflectionList reflectionList, DiffractionRefinementData refinementData, ParallelTeam parallelTeam) {
        this.reflectionList = reflectionList;
        this.refinementData = refinementData;
        this.crystal = reflectionList.crystal;
        this.n = refinementData.nBins * 2;
        this.sigmaAEnergy = new SigmaAEnergy(reflectionList, refinementData, parallelTeam);
        this.x = new double[this.n];
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        SplineEnergy.SplineType type = SplineEnergy.SplineType.FCTOESQ;
        SplineMinimize splineMinimize = new SplineMinimize(reflectionList, refinementData, refinementData.esqFc, type);
        splineMinimize.minimize(7, 0.1);
        type = SplineEnergy.SplineType.FOTOESQ;
        splineMinimize = new SplineMinimize(reflectionList, refinementData, refinementData.esqFo, type);
        splineMinimize.minimize(7, 0.1);
        int offset = refinementData.nBins;
        for (int i = 0; i < refinementData.nBins; ++i) {
            this.x[i] = 1.0;
            this.scaling[i] = 1.0;
            this.x[i + offset] = 0.05;
            this.scaling[i + offset] = 20.0;
        }
        this.sigmaAEnergy.setScaling(this.scaling);
        this.sigmaAEnergy.scaleCoordinates(this.x);
        logger.fine(" S=1.0, W=0.05");
        logger.fine(String.format(" Likelihood Target:        %16.8f", this.calculateLikelihood()));
        logger.fine(String.format(" Likelihood Target (Free): %16.8f", this.calculateLikelihoodFree()));
    }

    private void logSigmA() {
        int offset = this.refinementData.nBins;
        StringBuilder sigA = new StringBuilder(" Sigma A: ");
        StringBuilder sigAScale = new StringBuilder(" Scale A: ");
        StringBuilder sigW = new StringBuilder(" Sigma W: ");
        StringBuilder sigWScale = new StringBuilder(" Scale W: ");
        for (int i = 0; i < this.refinementData.nBins; ++i) {
            sigA.append(String.format("%5.3f ", this.x[i]));
            sigW.append(String.format("%5.3f ", this.x[i + offset]));
            sigAScale.append(String.format("%5.3f ", this.scaling[i]));
            sigWScale.append(String.format("%5.3f ", this.scaling[i + offset]));
        }
        logger.info(sigA.toString());
        logger.info(sigAScale.toString());
        logger.info(sigW.toString());
        logger.info(sigWScale.toString());
    }

    public double[] getCoordinates(@Nullable double[] x) {
        if (x == null) {
            x = new double[this.x.length];
        }
        System.arraycopy(this.x, 0, x, 0, this.x.length);
        return x;
    }

    public int getNumberOfVariables() {
        return this.x.length;
    }

    public SigmaAEnergy minimize() {
        return this.minimize(0.5);
    }

    public SigmaAEnergy minimize(double eps) {
        return this.minimize(7, eps);
    }

    public SigmaAEnergy minimize(int m, double eps) {
        this.sigmaAEnergy.setScaling(this.scaling);
        double e = this.sigmaAEnergy.energyAndGradient(this.x, this.grad);
        long mTime = -System.nanoTime();
        this.time = -System.nanoTime();
        this.done = false;
        int status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)e, (double[])this.grad, (double)eps, (OptimizationInterface)this.sigmaAEnergy, (OptimizationListener)this);
        this.done = true;
        switch (status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %8.5f\n", this.grms));
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.\n", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.\n");
            }
        }
        this.sigmaAEnergy.unscaleCoordinates(this.x);
        int offset = this.refinementData.nBins;
        for (int i = 0; i < this.refinementData.nBins; ++i) {
            this.refinementData.sigmaA[i] = this.x[i];
            this.refinementData.sigmaW[i] = this.x[i + offset];
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Optimization time: %8.3f (sec)\n", (double)(mTime += System.nanoTime()) * 1.0E-9));
            logger.info(sb.toString());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Final Result: ");
            this.logSigmA();
            this.sigmaAEnergy.setScaling(this.scaling);
            this.sigmaAEnergy.scaleCoordinates(this.x);
            logger.fine(String.format(" Likelihood Target:        %16.8f", this.calculateLikelihood()));
            logger.fine(String.format(" Likelihood Target (Free): %16.8f", this.calculateLikelihoodFree()));
            this.sigmaAEnergy.setScaling(null);
        }
        return this.sigmaAEnergy;
    }

    public boolean optimizationUpdate(int iter, int nBFGS, int nfun, double grms, double xrms, double f, double df, double angle, LineSearch.LineSearchResult info) {
        long currentTime = System.nanoTime();
        Double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.grms = grms;
        this.nSteps = iter;
        if (iter == 0) {
            if (nBFGS > 0) {
                logger.info("\n Limited Memory BFGS Quasi-Newton Optimization of SigmaA Parameters\n");
            } else {
                logger.info("\n Steepest Decent Optimization of SigmaA Parameters\n");
            }
            logger.info(" Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time");
        }
        if (info == null) {
            logger.info(String.format("%6d %12.2f %10.2f", iter, f, grms));
        } else if (info == LineSearch.LineSearchResult.Success) {
            logger.info(String.format("%6d %12.2f %10.2f %10.5f %9.5f %8.2f %6d %8.3f", iter, f, grms, df, xrms, angle, nfun, seconds));
        } else {
            logger.info(String.format("%6d %12.2f %10.2f %10.5f %9.5f %8.2f %6d %8s", iter, f, grms, df, xrms, angle, nfun, info));
        }
        if (this.terminate) {
            logger.info(" The optimization recieved a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            SigmaAMinimize sigmaAMinimize = this;
            synchronized (sigmaAMinimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating minimization.\n", e);
                }
            }
        }
    }

    private void setWEstimate() {
        int i;
        ReflectionSpline spline = new ReflectionSpline(this.reflectionList, this.refinementData.nBins);
        int[] nMean = new int[this.refinementData.nBins];
        for (int i2 = 0; i2 < this.refinementData.nBins; ++i2) {
            nMean[i2] = 0;
        }
        double mean = 0.0;
        double tot = 0.0;
        double[][] fcTot = this.refinementData.fcTot;
        double[][] fSigF = this.refinementData.fSigF;
        for (HKL ih : this.reflectionList.hklList) {
            i = ih.getIndex();
            if (ih.getAllowed() == 0.0 || Double.isNaN(fcTot[i][0]) || Double.isNaN(fSigF[i][0])) continue;
            double s2 = this.crystal.invressq(ih);
            double epsc = ih.epsilonc();
            ComplexNumber fct = new ComplexNumber(fcTot[i][0], fcTot[i][1]);
            double ecscale = spline.f(s2, this.refinementData.esqFc);
            double eoscale = spline.f(s2, this.refinementData.esqFo);
            double ec = fct.times(FastMath.sqrt((double)ecscale)).abs();
            double eo = fSigF[i][0] * FastMath.sqrt((double)eoscale);
            double wi = FastMath.pow((double)(eo - ec), (double)2.0) / epsc;
            int n = spline.i1();
            nMean[n] = nMean[n] + 1;
            int n2 = spline.i1() + this.refinementData.nBins;
            this.x[n2] = this.x[n2] + (wi - this.x[spline.i1() + this.refinementData.nBins]) / (double)nMean[spline.i1()];
            mean += (wi - mean) / (tot += 1.0);
        }
        logger.fine(String.format(" Starting mean w:    %8.3f", mean));
        double initialScale = 0.01;
        if (mean > 0.0) {
            initialScale = 1.0 / mean;
        }
        logger.fine(String.format(" Starting w scaling: %8.3f", initialScale));
        for (i = 0; i < this.refinementData.nBins; ++i) {
            int n = i;
            this.x[n] = this.x[n] - this.x[i + this.refinementData.nBins];
            int n3 = i;
            this.x[n3] = this.x[n3] * this.scaling[i];
            this.scaling[i + this.refinementData.nBins] = initialScale;
            int n4 = i + this.refinementData.nBins;
            this.x[n4] = this.x[n4] * this.scaling[i + this.refinementData.nBins];
        }
    }

    SigmaAEnergy getSigmaAEnergy() {
        return this.sigmaAEnergy;
    }

    double calculateLikelihood() {
        this.sigmaAEnergy.setScaling(this.scaling);
        this.sigmaAEnergy.energyAndGradient(this.x, this.grad);
        this.sigmaAEnergy.setScaling(null);
        return this.refinementData.llkR;
    }

    public double calculateLikelihoodFree() {
        this.sigmaAEnergy.setScaling(this.scaling);
        double energy = this.sigmaAEnergy.energyAndGradient(this.x, this.grad);
        this.sigmaAEnergy.setScaling(null);
        return energy;
    }
}

