/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.pj.reduction.SharedInteger;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.ReflectionSpline;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.special.ModifiedBessel;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.solvent.SolventModel;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SigmaAEnergy
implements OptimizationInterface {
    private static final Logger logger = Logger.getLogger(SigmaAEnergy.class.getName());
    private static final double twoPI2 = 19.739208802178716;
    private final ReflectionList reflectionList;
    private final DiffractionRefinementData refinementData;
    private final ParallelTeam parallelTeam;
    private final Crystal crystal;
    private final double[][] fSigF;
    private final double[][] fcTot;
    private final double[][] fomPhi;
    private final double[][] foFc1;
    private final double[][] foFc2;
    private final double[][] dFc;
    private final double[][] dFs;
    private final int nBins;
    private final double dfScale;
    private final double[][] transposeA;
    private final double[] sa;
    private final double[] wa;
    private final SigmaARegion sigmaARegion;
    private final boolean useCernBessel;
    private double[] optimizationScaling = null;
    private double totalEnergy;
    private static final double sim_a = 1.639294;
    private static final double sim_b = 3.553967;
    private static final double sim_c = 2.228716;
    private static final double sim_d = 3.524142;
    private static final double sim_e = 7.107935;
    private static final double sim_A = -1.28173889903;
    private static final double sim_B = 0.69231689903;
    private static final double sim_g = 2.13643992379;
    private static final double sim_p = 0.04613803811;
    private static final double sim_q = 1.82167089029;
    private static final double sim_r = -0.7481794749;

    SigmaAEnergy(ReflectionList reflectionList, DiffractionRefinementData refinementData, ParallelTeam parallelTeam) {
        this.reflectionList = reflectionList;
        this.refinementData = refinementData;
        this.parallelTeam = parallelTeam;
        this.crystal = reflectionList.crystal;
        this.fSigF = refinementData.fSigF;
        this.fcTot = refinementData.fcTot;
        this.fomPhi = refinementData.fomPhi;
        this.foFc1 = refinementData.foFc1;
        this.foFc2 = refinementData.foFc2;
        this.dFc = refinementData.dFc;
        this.dFs = refinementData.dFs;
        this.nBins = refinementData.nBins;
        assert (refinementData.crystalReciprocalSpaceFc != null);
        double nGrid2 = 2.0 * refinementData.crystalReciprocalSpaceFc.getXDim() * refinementData.crystalReciprocalSpaceFc.getYDim() * refinementData.crystalReciprocalSpaceFc.getZDim();
        this.dfScale = this.crystal.volume * this.crystal.volume / nGrid2;
        this.transposeA = MatrixMath.mat3Transpose((double[][])this.crystal.A);
        this.sa = new double[this.nBins];
        this.wa = new double[this.nBins];
        this.sigmaARegion = new SigmaARegion(this, this.parallelTeam.getThreadCount());
        this.useCernBessel = true;
    }

    public boolean destroy() {
        return true;
    }

    public double energy(double[] x) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, null, false, false);
        this.scaleCoordinates(x);
        return sum;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, g, true, false);
        this.scaleCoordinatesAndGradient(x, g);
        return sum;
    }

    public double[] getCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfVariables() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(double[] scaling) {
        this.optimizationScaling = (double[])(scaling != null && scaling.length == this.nBins * 2 ? scaling : null);
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double target(double[] x, double[] g, boolean gradient, boolean print) {
        double sumR;
        try {
            this.sigmaARegion.init(x, g, gradient);
            this.parallelTeam.execute((ParallelRegion)this.sigmaARegion);
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        double sum = this.sigmaARegion.sum.get();
        this.refinementData.llkR = sumR = this.sigmaARegion.sumR.get();
        this.refinementData.llkF = sum;
        if (print) {
            int nSum = this.sigmaARegion.nSum.get();
            int nSumr = this.sigmaARegion.nSumR.get();
            StringBuilder sb = new StringBuilder("\n");
            sb.append(" Sigma A (s and w) fit using only R free reflections\n");
            sb.append(String.format("      # HKL: %10d (free set) %10d (working set) %10d (total)\n", nSum, nSumr, nSum + nSumr));
            sb.append(String.format("   residual: %10.4f (free set) %10.4f (working set) %10.4f (total)\n", sum, sumR, sum + sumR));
            sb.append("    X: ");
            for (double x1 : x) {
                sb.append(String.format("%8.5f ", x1));
            }
            if (gradient) {
                sb.append("\n    G: ");
                for (double v : g) {
                    sb.append(String.format("%8.5f ", v));
                }
            }
            sb.append("\n");
            logger.info(sb.toString());
        }
        this.totalEnergy = sum;
        return this.totalEnergy;
    }

    private static double i1OverI0_clipper(double x) {
        if (x >= 0.0) {
            return ((x + 1.639294) * x + 3.553967) * x / (((x + 2.228716) * x + 3.524142) * x + 7.107935);
        }
        return -(-(-(-x + 1.639294) * x + 3.553967) * x) / (-(-(-x + 2.228716) * x + 3.524142) * x + 7.107935);
    }

    private static double lnI0_clipper(double x0) {
        double x = FastMath.abs((double)x0);
        double z = (x + 0.04613803811) / 1.82167089029;
        return -1.28173889903 * FastMath.log((double)(x + 2.13643992379)) + 0.346158449515 * FastMath.log((double)(z * z + 1.0)) + -0.7481794749 * FastMath.atan((double)z) + x + 1.0;
    }

    private class SigmaARegion
    extends ParallelRegion {
        private final double[] model_b;
        private final double[][] uStar;
        boolean gradient;
        double modelK;
        double solventK;
        double solventUEq;
        double[] x;
        double[] g;
        SharedInteger nSum;
        SharedInteger nSumR;
        SharedDouble sum;
        SharedDouble sumR;
        SharedDoubleArray grad;
        SigmaALoop[] sigmaALoop;
        final /* synthetic */ SigmaAEnergy this$0;

        SigmaARegion(SigmaAEnergy sigmaAEnergy, int nThreads) {
            SigmaAEnergy sigmaAEnergy2 = sigmaAEnergy;
            Objects.requireNonNull(sigmaAEnergy2);
            this.this$0 = sigmaAEnergy2;
            this.model_b = new double[6];
            this.uStar = new double[3][3];
            this.gradient = true;
            this.sigmaALoop = new SigmaALoop[nThreads];
            this.nSum = new SharedInteger();
            this.nSumR = new SharedInteger();
            this.sum = new SharedDouble();
            this.sumR = new SharedDouble();
        }

        public void finish() {
            if (this.gradient) {
                for (int i = 0; i < this.g.length; ++i) {
                    this.g[i] = this.grad.get(i);
                }
            }
        }

        public void init(double[] x, double[] g, boolean gradient) {
            this.x = x;
            this.g = g;
            this.gradient = gradient;
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.sigmaALoop[ti] == null) {
                this.sigmaALoop[ti] = new SigmaALoop(this);
            }
            try {
                this.execute(0, this.this$0.reflectionList.hklList.size() - 1, this.sigmaALoop[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void start() {
            int i;
            if (this.gradient) {
                if (this.grad == null) {
                    this.grad = new SharedDoubleArray(this.g.length);
                }
                for (i = 0; i < this.g.length; ++i) {
                    this.grad.set(i, 0.0);
                }
            }
            this.sum.set(0.0);
            this.nSum.set(0);
            this.sumR.set(0.0);
            this.nSumR.set(0);
            this.modelK = this.this$0.refinementData.modelScaleK;
            this.solventK = this.this$0.refinementData.bulkSolventK;
            this.solventUEq = this.this$0.refinementData.bulkSolventUeq;
            System.arraycopy(this.this$0.refinementData.modelAnisoB, 0, this.model_b, 0, 6);
            MatrixMath.mat3SymVec6((double[][])this.this$0.crystal.A, (double[])this.model_b, (double[][])this.uStar);
            MatrixMath.mat3Mat3Multiply((double[][])this.uStar, (double[][])this.this$0.transposeA, (double[][])this.uStar);
            for (i = 0; i < this.this$0.nBins; ++i) {
                this.this$0.sa[i] = this.x[i];
                this.this$0.wa[i] = this.x[this.this$0.nBins + i];
            }
            for (i = 0; i < this.this$0.nBins; ++i) {
                if (!(this.this$0.wa[i] <= 0.0)) continue;
                this.this$0.wa[i] = 1.0E-6;
            }
        }

        private class SigmaALoop
        extends IntegerForLoop {
            private final double[] lGrad;
            private final double[] resv;
            private final double[] ihc;
            private final ComplexNumber resc;
            private final ComplexNumber fcc;
            private final ComplexNumber fsc;
            private final ComplexNumber fct;
            private final ComplexNumber kfct;
            private final ComplexNumber ecc;
            private final ComplexNumber esc;
            private final ComplexNumber ect;
            private final ComplexNumber kect;
            private final ComplexNumber mfo;
            private final ComplexNumber mfo2;
            private final ComplexNumber dfcc;
            private final ReflectionSpline spline;
            private double lSum;
            private double lSumR;
            private int lSumN;
            private int lSumRN;
            final /* synthetic */ SigmaARegion this$1;

            SigmaALoop(SigmaARegion sigmaARegion) {
                SigmaARegion sigmaARegion2 = sigmaARegion;
                Objects.requireNonNull(sigmaARegion2);
                this.this$1 = sigmaARegion2;
                this.resv = new double[3];
                this.ihc = new double[3];
                this.resc = new ComplexNumber();
                this.fcc = new ComplexNumber();
                this.fsc = new ComplexNumber();
                this.fct = new ComplexNumber();
                this.kfct = new ComplexNumber();
                this.ecc = new ComplexNumber();
                this.esc = new ComplexNumber();
                this.ect = new ComplexNumber();
                this.kect = new ComplexNumber();
                this.mfo = new ComplexNumber();
                this.mfo2 = new ComplexNumber();
                this.dfcc = new ComplexNumber();
                this.spline = new ReflectionSpline(this.this$1.this$0.reflectionList, this.this$1.this$0.nBins);
                this.lGrad = new double[2 * sigmaARegion.this$0.nBins];
            }

            public void finish() {
                this.this$1.sum.addAndGet(this.lSum);
                this.this$1.sumR.addAndGet(this.lSumR);
                this.this$1.nSum.addAndGet(this.lSumN);
                this.this$1.nSumR.addAndGet(this.lSumRN);
                if (this.this$1.gradient) {
                    for (int i = 0; i < this.lGrad.length; ++i) {
                        this.this$1.grad.getAndAdd(i, this.lGrad[i]);
                    }
                }
            }

            public void run(int lb, int ub) {
                for (int j = lb; j <= ub; ++j) {
                    double cf;
                    double dinot;
                    double inot;
                    HKL ih = (HKL)this.this$1.this$0.reflectionList.hklList.get(j);
                    int i = ih.getIndex();
                    this.ihc[0] = ih.getH();
                    this.ihc[1] = ih.getK();
                    this.ihc[2] = ih.getL();
                    double s = this.this$1.this$0.crystal.invressq(ih);
                    double ebs = FastMath.exp((double)(-19.739208802178716 * this.this$1.solventUEq * s));
                    double ksebs = this.this$1.solventK * ebs;
                    MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.uStar, (double[])this.resv);
                    double u = this.this$1.modelK - DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                    double kmems = FastMath.exp((double)(0.25 * u));
                    double km2 = FastMath.exp((double)(0.5 * u));
                    double epsc = ih.epsilonc();
                    double ecscale = this.spline.f(s, this.this$1.this$0.refinementData.esqFc);
                    double eoscale = this.spline.f(s, this.this$1.this$0.refinementData.esqFo);
                    double sqrtECScale = FastMath.sqrt((double)ecscale);
                    double sqrtEOScale = FastMath.sqrt((double)eoscale);
                    double iSqrtEOScale = 1.0 / sqrtEOScale;
                    double sai = this.spline.f(s, this.this$1.this$0.sa);
                    double wai = this.spline.f(s, this.this$1.this$0.wa);
                    double sa2 = sai * sai;
                    this.this$1.this$0.refinementData.getFcIP(i, this.fcc);
                    this.fct.copy(this.fcc);
                    this.this$1.this$0.refinementData.getFsIP(i, this.fsc);
                    if (this.this$1.this$0.refinementData.crystalReciprocalSpaceFs.getSolventModel() != SolventModel.NONE) {
                        this.resc.copy(this.fsc);
                        this.resc.timesIP(ksebs);
                        this.fct.plusIP(this.resc);
                    }
                    this.kfct.copy(this.fct);
                    this.kfct.timesIP(kmems);
                    this.ecc.copy(this.fcc);
                    this.ecc.timesIP(sqrtECScale);
                    this.esc.copy(this.fsc);
                    this.esc.timesIP(sqrtECScale);
                    this.ect.copy(this.fct);
                    this.ect.timesIP(sqrtECScale);
                    this.kect.copy(this.kfct);
                    this.kect.timesIP(sqrtECScale);
                    double eo = this.this$1.this$0.fSigF[i][0] * sqrtEOScale;
                    double eo2 = eo * eo;
                    double sigeo = this.this$1.this$0.fSigF[i][1] * sqrtEOScale;
                    double akect = this.kect.abs();
                    double kect2 = akect * akect;
                    double d = 2.0 * sigeo * sigeo + epsc * wai;
                    double id = 1.0 / d;
                    double id2 = id * id;
                    double fomx = 2.0 * eo * sai * akect * id;
                    if (ih.centric()) {
                        inot = FastMath.abs((double)fomx) < 10.0 ? FastMath.log((double)FastMath.cosh((double)fomx)) : FastMath.abs((double)fomx) + FastMath.log((double)0.5);
                        dinot = FastMath.tanh((double)fomx);
                        cf = 0.5;
                    } else {
                        if (this.this$1.this$0.useCernBessel) {
                            inot = ModifiedBessel.lnI0((double)fomx);
                            dinot = ModifiedBessel.i1OverI0((double)fomx);
                        } else {
                            inot = SigmaAEnergy.lnI0_clipper(fomx);
                            dinot = SigmaAEnergy.i1OverI0_clipper(fomx);
                        }
                        cf = 1.0;
                    }
                    double llk = cf * FastMath.log((double)d) + (eo2 + sa2 * kect2) * id - inot;
                    double f = dinot * eo;
                    double phi = this.kect.phase();
                    double sinPhi = FastMath.sin((double)phi);
                    double cosPhi = FastMath.cos((double)phi);
                    this.this$1.this$0.fomPhi[i][0] = dinot;
                    this.this$1.this$0.fomPhi[i][1] = phi;
                    this.mfo.re(f * cosPhi);
                    this.mfo.im(f * sinPhi);
                    this.mfo2.re(2.0 * f * cosPhi);
                    this.mfo2.im(2.0 * f * sinPhi);
                    this.dfcc.re(sai * akect * cosPhi);
                    this.dfcc.im(sai * akect * sinPhi);
                    this.this$1.this$0.foFc1[i][0] = 0.0;
                    this.this$1.this$0.foFc1[i][1] = 0.0;
                    this.this$1.this$0.foFc2[i][0] = 0.0;
                    this.this$1.this$0.foFc2[i][1] = 0.0;
                    this.this$1.this$0.dFc[i][0] = 0.0;
                    this.this$1.this$0.dFc[i][1] = 0.0;
                    this.this$1.this$0.dFs[i][0] = 0.0;
                    this.this$1.this$0.dFs[i][1] = 0.0;
                    if (Double.isNaN(this.this$1.this$0.fcTot[i][0])) {
                        if (Double.isNaN(this.this$1.this$0.fSigF[i][0])) continue;
                        this.this$1.this$0.foFc2[i][0] = this.mfo.re() * iSqrtEOScale;
                        this.this$1.this$0.foFc2[i][1] = this.mfo.im() * iSqrtEOScale;
                        continue;
                    }
                    if (Double.isNaN(this.this$1.this$0.fSigF[i][0])) {
                        if (Double.isNaN(this.this$1.this$0.fcTot[i][0])) continue;
                        this.this$1.this$0.foFc2[i][0] = this.dfcc.re() * iSqrtEOScale;
                        this.this$1.this$0.foFc2[i][1] = this.dfcc.im() * iSqrtEOScale;
                        continue;
                    }
                    this.this$1.this$0.fcTot[i][0] = this.kfct.re();
                    this.this$1.this$0.fcTot[i][1] = this.kfct.im();
                    this.resc.copy(this.mfo);
                    this.resc.minusIP(this.dfcc);
                    this.this$1.this$0.foFc1[i][0] = this.resc.re() * iSqrtEOScale;
                    this.this$1.this$0.foFc1[i][1] = this.resc.im() * iSqrtEOScale;
                    this.resc.copy(this.mfo2);
                    this.resc.minusIP(this.dfcc);
                    this.this$1.this$0.foFc2[i][0] = this.resc.re() * iSqrtEOScale;
                    this.this$1.this$0.foFc2[i][1] = this.resc.im() * iSqrtEOScale;
                    double dafct = d * this.fct.abs();
                    double idafct = 1.0 / dafct;
                    double dfp1 = 2.0 * sa2 * km2 * ecscale;
                    double dfp2 = 2.0 * eo * sai * kmems * FastMath.sqrt((double)ecscale);
                    double dfp1id = dfp1 * id;
                    double dfp2id = dfp2 * idafct * dinot;
                    double dfp12 = dfp1id - dfp2id;
                    double dfp21 = ksebs * (dfp2id - dfp1id);
                    double dfcr = this.fct.re() * dfp12;
                    double dfci = this.fct.im() * dfp12;
                    double dfsr = this.fct.re() * dfp21;
                    double dfsi = this.fct.im() * dfp21;
                    double dfsa = 2.0 * (sai * kect2 - eo * akect * dinot) * id;
                    double dfwa = epsc * (cf * id - (eo2 + sa2 * kect2) * id2 + 2.0 * eo * sai * akect * id2 * dinot);
                    this.this$1.this$0.dFc[i][0] = dfcr * this.this$1.this$0.dfScale;
                    this.this$1.this$0.dFc[i][1] = dfci * this.this$1.this$0.dfScale;
                    this.this$1.this$0.dFs[i][0] = dfsr * this.this$1.this$0.dfScale;
                    this.this$1.this$0.dFs[i][1] = dfsi * this.this$1.this$0.dfScale;
                    if (this.this$1.this$0.refinementData.isFreeR(i)) {
                        this.lSum += llk;
                        ++this.lSumN;
                    } else {
                        this.lSumR += llk;
                        ++this.lSumRN;
                        dfsa = 0.0;
                        dfwa = 0.0;
                    }
                    if (!this.this$1.gradient) continue;
                    int i0 = this.spline.i0();
                    int i1 = this.spline.i1();
                    int i2 = this.spline.i2();
                    double g0 = this.spline.dfi0();
                    double g1 = this.spline.dfi1();
                    double g2 = this.spline.dfi2();
                    int n = i0;
                    this.lGrad[n] = this.lGrad[n] + dfsa * g0;
                    int n2 = i1;
                    this.lGrad[n2] = this.lGrad[n2] + dfsa * g1;
                    int n3 = i2;
                    this.lGrad[n3] = this.lGrad[n3] + dfsa * g2;
                    int n4 = this.this$1.this$0.nBins + i0;
                    this.lGrad[n4] = this.lGrad[n4] + dfwa * g0;
                    int n5 = this.this$1.this$0.nBins + i1;
                    this.lGrad[n5] = this.lGrad[n5] + dfwa * g1;
                    int n6 = this.this$1.this$0.nBins + i2;
                    this.lGrad[n6] = this.lGrad[n6] + dfwa * g2;
                }
            }

            public void start() {
                this.lSum = 0.0;
                this.lSumR = 0.0;
                this.lSumN = 0;
                this.lSumRN = 0;
                if (this.this$1.gradient) {
                    Arrays.fill(this.lGrad, 0.0);
                }
            }
        }
    }
}

