/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.realspace.RealSpaceData;
import ffx.realspace.RealSpaceEnergy;
import ffx.xray.DataContainer;
import ffx.xray.DiffractionData;
import ffx.xray.XRayEnergy;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RefinementEnergy
implements LambdaInterface,
CrystalPotential,
AlgorithmListener {
    private static final Logger logger = Logger.getLogger(RefinementEnergy.class.getName());
    private final DataContainer data;
    private final RefinementModel refinementModel;
    private final RefinementMode refinementMode;
    private double totalEnergy;
    private final Atom[] scatteringAtoms;
    private final int nAtoms;
    private final MolecularAssembly[] molecularAssemblies;
    private final double[][] xChemical;
    private final double[][] gChemical;
    private CrystalPotential dataEnergy;
    private double[] gExperiment;
    private double[] optimizationScaling;
    private final int n;
    private final int nXYZ;
    private final int nBFactor;
    private final int nOccupancy;
    private Potential.STATE state = Potential.STATE.BOTH;
    protected Thermostat thermostat;
    private double kTScale;

    public RefinementEnergy(DataContainer dataContainer) {
        this.data = dataContainer;
        this.refinementModel = dataContainer.getRefinementModel();
        this.refinementMode = this.refinementModel.getRefinementMode();
        this.molecularAssemblies = this.refinementModel.getMolecularAssemblies();
        this.scatteringAtoms = this.refinementModel.getScatteringAtoms();
        this.nAtoms = this.scatteringAtoms.length;
        this.thermostat = null;
        this.kTScale = 1.0;
        this.nXYZ = this.refinementModel.getNumCoordParameters();
        this.nBFactor = this.refinementModel.getNumBFactorParameters();
        this.nOccupancy = this.refinementModel.getNumOccupancyParameters();
        this.n = this.nXYZ + this.nBFactor + this.nOccupancy;
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            ForceFieldEnergy forceFieldEnergy = molecularAssembly.getPotentialEnergy();
            if (forceFieldEnergy != null) continue;
            forceFieldEnergy = ForceFieldEnergy.energyFactory((MolecularAssembly)molecularAssembly);
            molecularAssembly.setPotential(forceFieldEnergy);
        }
        if (dataContainer instanceof DiffractionData) {
            DiffractionData diffractionData = (DiffractionData)dataContainer;
            if (!diffractionData.getScaled()[0]) {
                diffractionData.printStats();
            }
            this.dataEnergy = new XRayEnergy(diffractionData);
            this.dataEnergy.setScaling(null);
        } else if (dataContainer instanceof RealSpaceData) {
            RealSpaceData realSpaceData = (RealSpaceData)dataContainer;
            this.dataEnergy = new RealSpaceEnergy(realSpaceData);
            this.dataEnergy.setScaling(null);
        }
        int assemblySize = this.molecularAssemblies.length;
        this.xChemical = new double[assemblySize][];
        this.gChemical = new double[assemblySize][];
        for (int i = 0; i < assemblySize; ++i) {
            int len = this.molecularAssemblies[i].getActiveAtomArray().length * 3;
            this.xChemical[i] = new double[len];
            this.gChemical[i] = new double[len];
        }
        this.gExperiment = new double[this.n];
    }

    public boolean algorithmUpdate(MolecularAssembly active) {
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        logger.info(" kTscale: " + this.kTScale);
        logger.info(this.data.printEnergyUpdate());
        return true;
    }

    public boolean destroy() {
        return this.dataEnergy.destroy();
    }

    public double energy(double[] x) {
        return this.energy(x, false);
    }

    public double energy(double[] x, boolean print) {
        double weight = this.data.getWeight();
        double e = 0.0;
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        RefinementMode refinementMode = this.refinementModel.getRefinementMode();
        int numAssemblies = this.molecularAssemblies.length;
        if (refinementMode.includesCoordinates()) {
            for (int i = 0; i < numAssemblies; ++i) {
                ForceFieldEnergy forceFieldEnergy = this.molecularAssemblies[i].getPotentialEnergy();
                forceFieldEnergy.getCoordinates(this.xChemical[i]);
                double curE = forceFieldEnergy.energy(this.xChemical[i], print);
                e += curE;
            }
            e = e * this.kTScale / (double)numAssemblies;
            e += weight * this.dataEnergy.energy(x, print);
        } else {
            e = this.dataEnergy.energy(x, print);
        }
        this.scaleCoordinates(x);
        this.totalEnergy = e;
        return e;
    }

    public double energyAndGradient(double[] x, double[] g) {
        return this.energyAndGradient(x, g, false);
    }

    public double energyAndGradient(double[] x, double[] g, boolean print) {
        double weight = this.data.getWeight();
        double e = 0.0;
        Arrays.fill(g, 0.0);
        Arrays.fill(this.gExperiment, 0.0);
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        if (this.refinementMode.includesCoordinates()) {
            int i;
            int i2;
            int numAssemblies = this.molecularAssemblies.length;
            for (i2 = 0; i2 < numAssemblies; ++i2) {
                ForceFieldEnergy forceFieldEnergy = this.molecularAssemblies[i2].getPotentialEnergy();
                forceFieldEnergy.getCoordinates(this.xChemical[i2]);
                double curE = forceFieldEnergy.energyAndGradient(this.xChemical[i2], this.gChemical[i2], print);
                e += curE;
                this.refinementModel.addAssemblyGradient(i2, g);
            }
            e = this.kTScale * e / (double)numAssemblies;
            if (numAssemblies > 1) {
                i2 = 0;
                while (i2 < this.nXYZ) {
                    int n = i2++;
                    g[n] = g[n] / (double)numAssemblies;
                }
            }
            i2 = 0;
            while (i2 < this.nXYZ) {
                int n = i2++;
                g[n] = g[n] * this.kTScale;
            }
            double xE = this.dataEnergy.energyAndGradient(x, this.gExperiment);
            e += weight * xE;
            for (i = 0; i < this.nXYZ; ++i) {
                int n = i;
                g[n] = g[n] + weight * this.gExperiment[i];
            }
            if (this.refinementMode.includesBFactors() || this.refinementMode.includesOccupancies()) {
                for (i = this.nXYZ; i < this.n; ++i) {
                    g[i] = weight * this.gExperiment[i];
                }
            }
        } else if (this.refinementMode.includesBFactors() || this.refinementMode.includesOccupancies()) {
            e = this.dataEnergy.energyAndGradient(x, g);
        }
        this.scaleCoordinatesAndGradient(x, g);
        this.totalEnergy = e;
        return e;
    }

    public double[] getAcceleration(double[] acceleration) {
        return this.dataEnergy.getAcceleration(acceleration);
    }

    public double[] getCoordinates(double[] parameters) {
        return this.dataEnergy.getCoordinates(parameters);
    }

    public void setCoordinates(double[] parameters) {
        this.dataEnergy.setCoordinates(parameters);
    }

    public Crystal getCrystal() {
        return this.dataEnergy.getCrystal();
    }

    public void setCrystal(Crystal crystal) {
        logger.severe(" RefinementEnergy does implement setCrystal yet.");
    }

    public CrystalPotential getDataEnergy() {
        return this.dataEnergy;
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            ForceFieldEnergy fe = molecularAssembly.getPotentialEnergy();
            fe.setEnergyTermState(state);
        }
        this.dataEnergy.setEnergyTermState(state);
    }

    public double getLambda() {
        double lambda = 1.0;
        if (this.data instanceof DiffractionData) {
            XRayEnergy xRayEnergy = (XRayEnergy)this.dataEnergy;
            lambda = xRayEnergy.getLambda();
        } else if (this.data instanceof RealSpaceData) {
            RealSpaceEnergy realSpaceEnergy = (RealSpaceEnergy)this.dataEnergy;
            lambda = realSpaceEnergy.getLambda();
        }
        return lambda;
    }

    public void setLambda(double lambda) {
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            ForceFieldEnergy forceFieldEnergy = molecularAssembly.getPotentialEnergy();
            forceFieldEnergy.setLambda(lambda);
        }
        if (this.data instanceof DiffractionData) {
            XRayEnergy xRayEnergy = (XRayEnergy)this.dataEnergy;
            xRayEnergy.setLambda(lambda);
        } else if (this.data instanceof RealSpaceData) {
            RealSpaceEnergy realSpaceEnergy = (RealSpaceEnergy)this.dataEnergy;
            realSpaceEnergy.setLambda(lambda);
        }
    }

    public double[] getMass() {
        return this.dataEnergy.getMass();
    }

    public int getNumberOfVariables() {
        return this.dataEnergy.getNumberOfVariables();
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        return this.dataEnergy.getPreviousAcceleration(previousAcceleration);
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(double[] scaling) {
        this.optimizationScaling = scaling;
    }

    public Thermostat getThermostat() {
        return this.thermostat;
    }

    public void setThermostat(Thermostat thermostat) {
        this.thermostat = thermostat;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public List<Potential> getUnderlyingPotentials() {
        Stream<Potential> directPEs = Arrays.stream(this.molecularAssemblies).map(MolecularAssembly::getPotentialEnergy);
        Stream allPEs = Arrays.stream(this.molecularAssemblies).map(MolecularAssembly::getPotentialEnergy).map(OptimizationInterface::getUnderlyingPotentials).flatMap(Collection::stream);
        return Stream.concat(directPEs, allPEs).collect(Collectors.toList());
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        return this.dataEnergy.getVariableTypes();
    }

    public double[] getVelocity(double[] velocity) {
        return this.dataEnergy.getVelocity(velocity);
    }

    public double getd2EdL2() {
        double d2EdL2 = 0.0;
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        int assemblysize = this.molecularAssemblies.length;
        for (int i = 0; i < assemblysize; ++i) {
            ForceFieldEnergy forceFieldEnergy = this.molecularAssemblies[i].getPotentialEnergy();
            double curE = forceFieldEnergy.getd2EdL2();
            d2EdL2 += (curE - d2EdL2) / (double)(i + 1);
        }
        return d2EdL2 *= this.kTScale;
    }

    public double getdEdL() {
        double dEdL = 0.0;
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        int assemblysize = this.molecularAssemblies.length;
        for (int i = 0; i < assemblysize; ++i) {
            ForceFieldEnergy forceFieldEnergy = this.molecularAssemblies[i].getPotentialEnergy();
            double curdEdL = forceFieldEnergy.getdEdL();
            dEdL += (curdEdL - dEdL) / (double)(i + 1);
        }
        dEdL *= this.kTScale;
        double weight = this.data.getWeight();
        if (this.data instanceof DiffractionData) {
            XRayEnergy xRayEnergy = (XRayEnergy)this.dataEnergy;
            dEdL += weight * xRayEnergy.getdEdL();
        } else if (this.data instanceof RealSpaceData) {
            RealSpaceEnergy realSpaceEnergy = (RealSpaceEnergy)this.dataEnergy;
            dEdL += weight * realSpaceEnergy.getdEdL();
        }
        return dEdL;
    }

    public void getdEdXdL(double[] gradient) {
        int i;
        double weight = this.data.getWeight();
        if (this.thermostat != null) {
            this.kTScale = 418.4 / (this.thermostat.getTargetTemperature() * 0.831446261815324);
        }
        int assemblysize = this.molecularAssemblies.length;
        for (i = 0; i < assemblysize; ++i) {
            ForceFieldEnergy forcefieldEnergy = this.molecularAssemblies[i].getPotentialEnergy();
            Arrays.fill(this.gChemical[i], 0.0);
            forcefieldEnergy.getdEdXdL(this.gChemical[i]);
        }
        for (i = 0; i < assemblysize; ++i) {
            for (int j = 0; j < this.nXYZ; ++j) {
                int n = j;
                gradient[n] = gradient[n] + this.gChemical[i][j];
            }
        }
        if (assemblysize > 1) {
            i = 0;
            while (i < this.nXYZ) {
                int n = i++;
                gradient[n] = gradient[n] / (double)assemblysize;
            }
        }
        i = 0;
        while (i < this.nXYZ) {
            int n = i++;
            gradient[n] = gradient[n] * this.kTScale;
        }
        if (this.gExperiment == null || this.gExperiment.length != this.nXYZ) {
            this.gExperiment = new double[this.nXYZ];
        } else {
            for (int j = 0; j < this.nXYZ; ++j) {
                this.gExperiment[j] = 0.0;
            }
        }
        if (this.data instanceof DiffractionData) {
            XRayEnergy xRayEnergy = (XRayEnergy)this.dataEnergy;
            xRayEnergy.getdEdXdL(this.gExperiment);
        } else if (this.data instanceof RealSpaceData) {
            RealSpaceEnergy realSpaceEnergy = (RealSpaceEnergy)this.dataEnergy;
            realSpaceEnergy.getdEdXdL(this.gExperiment);
        }
        for (i = 0; i < this.nXYZ; ++i) {
            int n = i;
            gradient[n] = gradient[n] + weight * this.gExperiment[i];
        }
    }

    public void setAcceleration(double[] acceleration) {
        this.dataEnergy.setAcceleration(acceleration);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        this.dataEnergy.setPreviousAcceleration(previousAcceleration);
    }

    public void setVelocity(double[] velocity) {
        this.dataEnergy.setVelocity(velocity);
    }
}

