/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.numerics.math.ScalarMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.TinkerUtils;
import ffx.xray.CrystalReciprocalSpace;
import ffx.xray.CrystalStats;
import ffx.xray.DataContainer;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.ScaleBulkMinimize;
import ffx.xray.SigmaAMinimize;
import ffx.xray.SplineEnergy;
import ffx.xray.SplineMinimize;
import ffx.xray.parallel.GridMethod;
import ffx.xray.parsers.CCP4MapWriter;
import ffx.xray.parsers.DiffractionFile;
import ffx.xray.parsers.MTZWriter;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import ffx.xray.scatter.XRayFormFactor;
import ffx.xray.solvent.SolventModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;

public class DiffractionData
implements DataContainer {
    private static final Logger logger = Logger.getLogger(DiffractionData.class.getName());
    private final MolecularAssembly[] assembly;
    private final String modelName;
    private final DiffractionFile[] dataFiles;
    private final int n;
    private final Crystal[] crystal;
    private final Resolution[] resolution;
    private final ReflectionList[] reflectionList;
    private final DiffractionRefinementData[] refinementData;
    private final CrystalReciprocalSpace[] crystalReciprocalSpacesFc;
    private final CrystalReciprocalSpace[] crystalReciprocalSpacesFs;
    private final SolventModel solventModel;
    private final RefinementModel refinementModel;
    private final boolean use_3g;
    private final double aRadBuff;
    private final double xrayScaleTol;
    private final double sigmaATol;
    private final double bSimWeight;
    private final double bNonZeroWeight;
    private final boolean nativeEnvironmentApproximation;
    private final SigmaAMinimize[] sigmaAMinimize;
    private final CrystalStats[] crystalStats;
    private ParallelTeam parallelTeam;
    private final GridMethod gridMethod;
    private final boolean[] scaled;
    private double xWeight;
    private final boolean gridSearch;
    private final boolean splineFit;

    public DiffractionData(MolecularAssembly[] molecularAssemblies, CompositeConfiguration properties, SolventModel solventModel, DiffractionFile ... dataFiles) {
        this.assembly = molecularAssemblies;
        this.solventModel = solventModel;
        this.modelName = molecularAssemblies[0].getName();
        this.dataFiles = dataFiles;
        this.n = dataFiles.length;
        int rflag = properties.getInt("rfree-flag", -1);
        double fsigfCutoff = properties.getDouble("f-sigf-cutoff", -1.0);
        this.gridSearch = properties.getBoolean("solvent-grid-search", false);
        this.splineFit = !properties.getBoolean("no-spline-fit", false);
        this.use_3g = properties.getBoolean("use-3g", true);
        this.aRadBuff = properties.getDouble("scattering-buffer", 0.75);
        double sampling = properties.getDouble("sampling", 0.6);
        this.xrayScaleTol = properties.getDouble("xray-scale-tol", 1.0E-4);
        this.sigmaATol = properties.getDouble("sigmaa-tol", 0.05);
        this.xWeight = properties.getDouble("data-weight", 1.0);
        this.bSimWeight = properties.getDouble("b-sim-weight", 1.0);
        this.bNonZeroWeight = properties.getDouble("b-nonzero-weight", 1.0);
        boolean residueBFactor = properties.getBoolean("residue-bfactor", false);
        int nResidueBFactor = properties.getInt("n-residue-bfactor", 1);
        boolean addAnisou = properties.getBoolean("add-anisou", false);
        boolean refineMolOcc = properties.getBoolean("refine-mol-occ", false);
        ForceField forceField = molecularAssemblies[0].getForceField();
        this.nativeEnvironmentApproximation = forceField.getBoolean("NATIVE_ENVIRONMENT_APPROXIMATION", false);
        this.crystal = new Crystal[this.n];
        this.resolution = new Resolution[this.n];
        this.reflectionList = new ReflectionList[this.n];
        this.refinementData = new DiffractionRefinementData[this.n];
        this.sigmaAMinimize = new SigmaAMinimize[this.n];
        this.crystalStats = new CrystalStats[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.crystal[i] = Crystal.checkProperties((CompositeConfiguration)properties);
            if (this.crystal[i] == null) {
                this.crystal[i] = molecularAssemblies[i].getCrystal().getUnitCell();
            }
            File dataFile = new File(dataFiles[i].getFilename());
            double res = dataFiles[i].getDiffractionfilter().getResolution(dataFile, this.crystal[i]);
            this.resolution[i] = dataFiles[i].isNeutron() ? Resolution.checkProperties((CompositeConfiguration)properties, (boolean)true, (double)res) : Resolution.checkProperties((CompositeConfiguration)properties, (boolean)false, (double)res);
            if (this.resolution[i] == null) {
                logger.severe(" Resolution could not be determined from property or reflection files.");
            }
            this.reflectionList[i] = new ReflectionList(this.crystal[i], this.resolution[i], properties);
            logger.info(this.resolution[i].toString());
            this.refinementData[i] = new DiffractionRefinementData(properties, this.reflectionList[i]);
            dataFiles[i].getDiffractionfilter().readFile(dataFile, this.reflectionList[i], this.refinementData[i], properties);
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n X-ray Refinement Settings\n\n");
            sb.append("  Target Function\n");
            sb.append("   X-ray refinement weight: ").append(this.xWeight).append("\n");
            sb.append("   Use cctbx 3 Gaussians: ").append(this.use_3g).append("\n");
            sb.append("   Atomic form factor radius buffer: ").append(this.aRadBuff).append("\n");
            sb.append("   Reciprocal space sampling rate: ").append(sampling).append("\n");
            sb.append("   Resolution dependent spline scale: ").append(this.splineFit).append("\n");
            sb.append("   Solvent grid search: ").append(this.gridSearch).append("\n");
            sb.append("   X-ray scale fit tolerance: ").append(this.xrayScaleTol).append("\n");
            sb.append("   Sigma A fit tolerance: ").append(this.sigmaATol).append("\n");
            sb.append("   Native environment approximation: ").append(this.nativeEnvironmentApproximation).append("\n");
            sb.append("  Reflections\n");
            sb.append("   F/sigF cutoff: ").append(fsigfCutoff).append("\n");
            sb.append("   R Free flag (-1 auto-determine from the data): ").append(rflag).append("\n");
            sb.append("   Number of bins: ").append(this.reflectionList[0].nBins).append("\n");
            sb.append("  B-Factors\n");
            sb.append("   Similarity weight: ").append(this.bSimWeight).append("\n");
            sb.append("   Refine by residue: ").append(residueBFactor).append("\n");
            if (residueBFactor) {
                sb.append("   Number of residues per B: ").append(nResidueBFactor).append(")\n");
            }
            sb.append("   Add ANISOU for refinement: ").append(addAnisou).append("\n");
            sb.append("  Occupancies\n");
            sb.append("   Refine on molecules: ").append(refineMolOcc).append("\n");
            logger.info(sb.toString());
        }
        this.refinementModel = new RefinementModel(molecularAssemblies);
        for (Atom a : this.refinementModel.getScatteringAtoms()) {
            double arad;
            XRayFormFactor atomff = new XRayFormFactor(a, this.use_3g, 2.0);
            if (a.getOccupancy() == 0.0) {
                a.setFormFactorWidth(1.0);
                continue;
            }
            try {
                arad = a.getVDWType().radius * 0.5;
            }
            catch (NullPointerException ex) {
                logger.warning(String.format(" Failure to get van der Waals type for atom %s; ensure the vdW term is enabled!", a));
                throw ex;
            }
            double[] xyz = new double[]{a.getX() + arad, a.getY(), a.getZ()};
            double rho = atomff.rho(0.0, 1.0, xyz);
            while (rho > 0.001) {
                xyz[0] = a.getX() + (arad += 0.1);
                rho = atomff.rho(0.0, 1.0, xyz);
            }
            a.setFormFactorWidth(arad += this.aRadBuff);
        }
        this.crystalReciprocalSpacesFc = new CrystalReciprocalSpace[this.n];
        this.crystalReciprocalSpacesFs = new CrystalReciprocalSpace[this.n];
        this.parallelTeam = molecularAssemblies[0].getParallelTeam();
        String gridString = properties.getString("grid-method", "SLICE");
        this.gridMethod = GridMethod.parse(gridString);
        this.parallelTeam = new ParallelTeam();
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i] = new CrystalReciprocalSpace(this.reflectionList[i], this.refinementModel.getScatteringAtoms(), this.parallelTeam, this.parallelTeam, false, this.dataFiles[i].isNeutron(), SolventModel.NONE, this.gridMethod);
            this.refinementData[i].setCrystalReciprocalSpaceFc(this.crystalReciprocalSpacesFc[i]);
            this.crystalReciprocalSpacesFc[i].setUse3G(this.use_3g);
            this.crystalReciprocalSpacesFc[i].setWeight(this.dataFiles[i].getWeight());
            this.crystalReciprocalSpacesFc[i].lambdaTerm = false;
            this.crystalReciprocalSpacesFc[i].setNativeEnvironmentApproximation(this.nativeEnvironmentApproximation);
            this.crystalReciprocalSpacesFs[i] = new CrystalReciprocalSpace(this.reflectionList[i], this.refinementModel.getScatteringAtoms(), this.parallelTeam, this.parallelTeam, true, this.dataFiles[i].isNeutron(), solventModel, this.gridMethod);
            this.refinementData[i].setCrystalReciprocalSpaceFs(this.crystalReciprocalSpacesFs[i]);
            this.crystalReciprocalSpacesFs[i].setUse3G(this.use_3g);
            this.crystalReciprocalSpacesFs[i].setWeight(this.dataFiles[i].getWeight());
            this.crystalReciprocalSpacesFs[i].lambdaTerm = false;
            this.crystalReciprocalSpacesFs[i].setNativeEnvironmentApproximation(this.nativeEnvironmentApproximation);
            this.crystalStats[i] = new CrystalStats(this.reflectionList[i], this.refinementData[i]);
        }
        this.scaled = new boolean[this.n];
        Arrays.fill(this.scaled, false);
    }

    public void AverageFc(MolecularAssembly[] assembly, int index) {
        RefinementModel tmprefinementmodel = new RefinementModel(assembly);
        for (Atom a : tmprefinementmodel.getScatteringAtoms()) {
            XRayFormFactor atomff = new XRayFormFactor(a, this.use_3g, 2.0);
            if (a.getOccupancy() == 0.0) {
                a.setFormFactorWidth(1.0);
                continue;
            }
            double arad = a.getVDWType().radius * 0.5;
            double[] xyz = new double[]{a.getX() + arad, a.getY(), a.getZ()};
            double rho = atomff.rho(0.0, 1.0, xyz);
            while (rho > 0.001) {
                xyz[0] = a.getX() + (arad += 0.1);
                rho = atomff.rho(0.0, 1.0, xyz);
            }
            a.setFormFactorWidth(arad += this.aRadBuff);
        }
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i] = new CrystalReciprocalSpace(this.reflectionList[i], tmprefinementmodel.getScatteringAtoms(), this.parallelTeam, this.parallelTeam, false, this.dataFiles[i].isNeutron(), SolventModel.NONE, this.gridMethod);
            this.crystalReciprocalSpacesFc[i].setNativeEnvironmentApproximation(this.nativeEnvironmentApproximation);
            this.refinementData[i].setCrystalReciprocalSpaceFc(this.crystalReciprocalSpacesFc[i]);
            this.crystalReciprocalSpacesFs[i] = new CrystalReciprocalSpace(this.reflectionList[i], tmprefinementmodel.getScatteringAtoms(), this.parallelTeam, this.parallelTeam, true, this.dataFiles[i].isNeutron(), this.solventModel, this.gridMethod);
            this.crystalReciprocalSpacesFs[i].setNativeEnvironmentApproximation(this.nativeEnvironmentApproximation);
            this.refinementData[i].setCrystalReciprocalSpaceFs(this.crystalReciprocalSpacesFs[i]);
        }
        int nhkl = this.refinementData[0].n;
        double[][] fc = new double[nhkl][2];
        double[][] fs = new double[nhkl][2];
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i].computeDensity(fc);
            if (this.solventModel != SolventModel.NONE) {
                this.crystalReciprocalSpacesFs[i].computeDensity(fs);
            }
            for (int j = 0; j < this.refinementData[i].n; ++j) {
                double[] dArray = this.refinementData[i].fc[j];
                dArray[0] = dArray[0] + (fc[j][0] - this.refinementData[i].fc[j][0]) / (double)index;
                double[] dArray2 = this.refinementData[i].fc[j];
                dArray2[1] = dArray2[1] + (fc[j][1] - this.refinementData[i].fc[j][1]) / (double)index;
                double[] dArray3 = this.refinementData[i].fs[j];
                dArray3[0] = dArray3[0] + (fs[j][0] - this.refinementData[i].fs[j][0]) / (double)index;
                double[] dArray4 = this.refinementData[i].fs[j];
                dArray4[1] = dArray4[1] + (fs[j][1] - this.refinementData[i].fs[j][1]) / (double)index;
            }
        }
    }

    public void computeAtomicDensity() {
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i].computeDensity(this.refinementData[i].fc);
            if (this.solventModel == SolventModel.NONE) continue;
            this.crystalReciprocalSpacesFs[i].computeDensity(this.refinementData[i].fs);
        }
    }

    public boolean destroy() {
        try {
            boolean underlyingShutdown = true;
            for (MolecularAssembly assem : this.assembly) {
                boolean thisShutdown = assem.destroy();
                underlyingShutdown = underlyingShutdown && thisShutdown;
            }
            this.parallelTeam.shutdown();
            return underlyingShutdown;
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in shutting down a RealSpaceData: %s", ex));
            logger.info(Utilities.stackTraceToString((Throwable)ex));
            return false;
        }
    }

    public MolecularAssembly[] getAssembly() {
        return this.assembly;
    }

    public Crystal[] getCrystal() {
        return this.crystal;
    }

    public CrystalReciprocalSpace[] getCrystalReciprocalSpacesFc() {
        return this.crystalReciprocalSpacesFc;
    }

    public CrystalReciprocalSpace[] getCrystalReciprocalSpacesFs() {
        return this.crystalReciprocalSpacesFs;
    }

    public int getN() {
        return this.n;
    }

    public ParallelTeam getParallelTeam() {
        return this.parallelTeam;
    }

    public DiffractionRefinementData[] getRefinementData() {
        return this.refinementData;
    }

    @Override
    public RefinementModel getRefinementModel() {
        return this.refinementModel;
    }

    public ReflectionList[] getReflectionList() {
        return this.reflectionList;
    }

    public Resolution[] getResolution() {
        return this.resolution;
    }

    public boolean[] getScaled() {
        return this.scaled;
    }

    @Override
    public double getWeight() {
        return this.xWeight;
    }

    @Override
    public void setWeight(double weight) {
        this.xWeight = weight;
    }

    @Override
    public String printEnergyUpdate() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.n; ++i) {
            sb.append(String.format("     dataset %d (weight: %5.1f): R: %6.2f Rfree: %6.2f chemical energy: %8.2f likelihood: %8.2f free likelihood: %8.2f\n", i + 1, this.dataFiles[i].getWeight(), this.crystalStats[i].getR(), this.crystalStats[i].getRFree(), this.assembly[0].getPotentialEnergy().getTotalEnergy(), this.dataFiles[i].getWeight() * this.sigmaAMinimize[i].calculateLikelihood(), this.dataFiles[i].getWeight() * this.refinementData[i].llkF));
        }
        return sb.toString();
    }

    @Override
    public String printOptimizationHeader() {
        return "R  Rfree";
    }

    @Override
    public String printOptimizationUpdate() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.n; ++i) {
            sb.append(String.format("%6.2f %6.2f ", this.crystalStats[i].getR(), this.crystalStats[i].getRFree()));
        }
        return sb.toString();
    }

    public void printStats() {
        int numberOfScatteringAtoms = 0;
        int nHeavyScatteringAtoms = 0;
        for (Atom a : this.refinementModel.getScatteringAtoms()) {
            if (a.getOccupancy() == 0.0) continue;
            ++numberOfScatteringAtoms;
            if (a.getAtomicNumber() == 1) continue;
            ++nHeavyScatteringAtoms;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.scaled[i]) {
                this.scaleBulkFit(i);
            }
            String sb = String.format(" Statistics for Data Set %d of %d\n\n  Weight:     %6.2f\n  Neutron data: %4s\n  Model:        %s\n  Data file:    %s\n", i + 1, this.n, this.dataFiles[i].getWeight(), this.dataFiles[i].isNeutron(), this.modelName, this.dataFiles[i].getFilename());
            logger.info(sb);
            this.crystalStats[i].printScaleStats();
            this.crystalStats[i].printDPIStats(nHeavyScatteringAtoms, numberOfScatteringAtoms);
            this.crystalStats[i].printHKLStats();
            this.crystalStats[i].printSNStats();
            this.crystalStats[i].printRStats();
        }
    }

    public void scaleBulkFit() {
        for (int i = 0; i < this.n; ++i) {
            this.scaleBulkFit(i);
        }
    }

    public void scaleBulkFit(int i) {
        String sb = String.format(" Scaling Data Set %d of %d\n\n  Weight: %6.2f\n  Neutron data: %s\n  Model: %s\n  Data file: %s", i + 1, this.n, this.dataFiles[i].getWeight(), this.dataFiles[i].isNeutron(), this.modelName, this.dataFiles[i].getFilename());
        logger.info(sb);
        this.refinementData[i].modelScaleK = 0.0;
        Arrays.fill(this.refinementData[i].modelAnisoB, 0.0);
        this.refinementData[i].bulkSolventK = this.dataFiles[i].isNeutron() ? 0.639 : 0.334;
        this.refinementData[i].bulkSolventUeq = ScalarMath.b2u((double)50.0);
        this.refinementData[i].crystalReciprocalSpaceFs.setDefaultSolventAB();
        CompositeConfiguration properties = this.assembly[0].getProperties();
        if (this.dataFiles[i].isNeutron()) {
            if (properties.containsKey("neutron-bulk-solvent")) {
                string = properties.getString("neutron-bulk-solvent", "0.639 50.0");
                split = string.split("\\s+");
                this.refinementData[i].bulkSolventK = Double.parseDouble(split[0]);
                this.refinementData[i].bulkSolventUeq = ScalarMath.b2u((double)Double.parseDouble(split[1]));
                this.refinementData[i].bulkSolventFixed = true;
            } else {
                this.refinementData[i].bulkSolventFixed = false;
            }
        } else if (properties.containsKey("bulk-solvent")) {
            string = properties.getString("bulk-solvent", "0.334 50.0");
            split = string.split("\\s+");
            this.refinementData[i].bulkSolventK = Double.parseDouble(split[0]);
            this.refinementData[i].bulkSolventUeq = ScalarMath.b2u((double)Double.parseDouble(split[1]));
            this.refinementData[i].bulkSolventFixed = true;
        } else {
            this.refinementData[i].bulkSolventFixed = false;
        }
        this.crystalReciprocalSpacesFc[i].computeDensity(this.refinementData[i].fc);
        if (this.solventModel != SolventModel.NONE) {
            this.crystalReciprocalSpacesFs[i].computeDensity(this.refinementData[i].fs);
        }
        if (this.solventModel != SolventModel.NONE) {
            boolean bulkSolventFixed = this.refinementData[i].bulkSolventFixed;
            this.refinementData[i].bulkSolventFixed = true;
            ScaleBulkMinimize scaleBulkMinimize = new ScaleBulkMinimize(this.reflectionList[i], this.refinementData[i], this.crystalReciprocalSpacesFs[i], this.parallelTeam);
            scaleBulkMinimize.minimize(this.xrayScaleTol);
            if (!bulkSolventFixed) {
                this.refinementData[i].bulkSolventFixed = false;
                scaleBulkMinimize = new ScaleBulkMinimize(this.reflectionList[i], this.refinementData[i], this.crystalReciprocalSpacesFs[i], this.parallelTeam);
            }
            if (this.gridSearch) {
                scaleBulkMinimize.gridOptimizeBulkSolventModel();
            }
            if (!bulkSolventFixed) {
                scaleBulkMinimize.gridOptimizeKsBs();
            }
            scaleBulkMinimize.minimize(this.xrayScaleTol);
        } else {
            ScaleBulkMinimize scaleBulkMinimize = new ScaleBulkMinimize(this.reflectionList[i], this.refinementData[i], this.crystalReciprocalSpacesFs[i], this.parallelTeam);
            scaleBulkMinimize.minimize(this.xrayScaleTol);
        }
        this.sigmaAMinimize[i] = new SigmaAMinimize(this.reflectionList[i], this.refinementData[i], this.parallelTeam);
        this.sigmaAMinimize[i].minimize(this.sigmaATol);
        if (this.splineFit) {
            SplineMinimize splineMinimize = new SplineMinimize(this.reflectionList[i], this.refinementData[i], this.refinementData[i].spline, SplineEnergy.SplineType.FOFC);
            splineMinimize.minimize(1.0E-5);
        }
        this.scaled[i] = true;
    }

    public void timings() {
        logger.info(" Performing 10 Fc calculations for timing...");
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.crystalReciprocalSpacesFc[i].computeDensity(this.refinementData[i].fc, true);
                this.crystalReciprocalSpacesFs[i].computeDensity(this.refinementData[i].fs, true);
                this.crystalReciprocalSpacesFc[i].computeAtomicGradients(this.refinementData[i].dFc, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, RefinementMode.COORDINATES, true);
                this.crystalReciprocalSpacesFs[i].computeAtomicGradients(this.refinementData[i].dFs, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, RefinementMode.COORDINATES, true);
            }
        }
    }

    public void writeData(String filename) {
        if (this.n == 1) {
            this.writeData(filename, 0);
        } else {
            for (int i = 0; i < this.n; ++i) {
                this.writeData(FilenameUtils.removeExtension((String)filename) + "_" + i + ".mtz", i);
            }
        }
    }

    public void writeData(String filename, int i) {
        MTZWriter mtzwriter = this.scaled[i] ? new MTZWriter(this.reflectionList[i], this.refinementData[i], filename) : new MTZWriter(this.reflectionList[i], this.refinementData[i], filename, 1);
        mtzwriter.write();
    }

    public void writeMaps(String filename, boolean normalize) {
        if (this.n == 1) {
            this.writeMaps(filename, 0, normalize);
        } else {
            for (int i = 0; i < this.n; ++i) {
                this.writeMaps(FilenameUtils.removeExtension((String)filename) + "_" + i + ".map", i, normalize);
            }
        }
    }

    private void writeMaps(String filename, int i, boolean normalize) {
        if (!this.scaled[i]) {
            this.scaleBulkFit(i);
        }
        this.crystalReciprocalSpacesFc[i].computeAtomicGradients(this.refinementData[i].foFc1, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, RefinementMode.COORDINATES);
        double[] densityGrid = this.crystalReciprocalSpacesFc[i].getDensityGrid();
        int extx = (int)this.crystalReciprocalSpacesFc[i].getXDim();
        int exty = (int)this.crystalReciprocalSpacesFc[i].getYDim();
        int extz = (int)this.crystalReciprocalSpacesFc[i].getZDim();
        CCP4MapWriter mapwriter = new CCP4MapWriter(extx, exty, extz, this.crystal[i], FilenameUtils.removeExtension((String)filename) + "_fofc.map");
        mapwriter.write(densityGrid, normalize);
        this.crystalReciprocalSpacesFc[i].computeAtomicGradients(this.refinementData[i].foFc2, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, RefinementMode.COORDINATES);
        densityGrid = this.crystalReciprocalSpacesFc[i].getDensityGrid();
        extx = (int)this.crystalReciprocalSpacesFc[i].getXDim();
        exty = (int)this.crystalReciprocalSpacesFc[i].getYDim();
        extz = (int)this.crystalReciprocalSpacesFc[i].getZDim();
        mapwriter = new CCP4MapWriter(extx, exty, extz, this.crystal[i], FilenameUtils.removeExtension((String)filename) + "_2fofc.map");
        mapwriter.write(densityGrid, normalize);
    }

    public void writeModel(String filename) {
        int i;
        StringBuilder remark = new StringBuilder();
        File file = TinkerUtils.version((File)new File(filename));
        CompositeConfiguration properties = this.assembly[0].getProperties();
        ForceField forceField = this.assembly[0].getForceField();
        PDBFilter pdbFilter = new PDBFilter(file, Arrays.asList(this.assembly), forceField, properties);
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss ");
        remark.append("REMARK FFX output ISO-8601 date: ").append(sdf.format(now)).append("\n");
        remark.append("REMARK\n");
        remark.append("REMARK   3\n");
        remark.append("REMARK   3 REFINEMENT\n");
        remark.append("REMARK   3   PROGRAM     : FORCE FIELD X\n");
        remark.append("REMARK   3\n");
        for (i = 0; i < this.n; ++i) {
            remark.append("REMARK   3  DATA SET ").append(i + 1).append("\n");
            if (this.dataFiles[i].isNeutron()) {
                remark.append("REMARK   3   DATA SET TYPE   : NEUTRON\n");
            } else {
                remark.append("REMARK   3   DATA SET TYPE   : X-RAY\n");
            }
            remark.append("REMARK   3   DATA SET WEIGHT : ").append(this.dataFiles[i].getWeight()).append("\n");
            remark.append("REMARK   3\n");
            remark.append(this.crystalStats[i].getPDBHeaderString());
        }
        for (i = 0; i < this.assembly.length; ++i) {
            remark.append("REMARK   3  CHEMICAL SYSTEM ").append(i + 1).append("\n");
            remark.append(this.assembly[i].getPotentialEnergy().getPDBHeaderString());
        }
        pdbFilter.writeFileWithHeader(file, remark);
    }

    public void writeModel(String filename, Set<Atom> excludeAtoms, double pH) {
        int i;
        StringBuilder remark = new StringBuilder();
        File file = TinkerUtils.version((File)new File(filename));
        PDBFilter pdbFilter = new PDBFilter(file, Arrays.asList(this.assembly), null, null);
        if (pH > 0.0) {
            pdbFilter.setRotamerTitration(true);
        }
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss ");
        remark.append("REMARK FFX output ISO-8601 date: ").append(sdf.format(now)).append("\n");
        remark.append("REMARK\n");
        remark.append("REMARK   3\n");
        remark.append("REMARK   3 REFINEMENT\n");
        remark.append("REMARK   3   PROGRAM     : FORCE FIELD X\n");
        remark.append("REMARK   3\n");
        for (i = 0; i < this.n; ++i) {
            remark.append("REMARK   3  DATA SET ").append(i + 1).append("\n");
            if (this.dataFiles[i].isNeutron()) {
                remark.append("REMARK   3   DATA SET TYPE   : NEUTRON\n");
            } else {
                remark.append("REMARK   3   DATA SET TYPE   : X-RAY\n");
            }
            remark.append("REMARK   3   DATA SET WEIGHT : ").append(this.dataFiles[i].getWeight()).append("\n");
            remark.append("REMARK   3\n");
            remark.append(this.crystalStats[i].getPDBHeaderString());
        }
        for (i = 0; i < this.assembly.length; ++i) {
            remark.append("REMARK   3  CHEMICAL SYSTEM ").append(i + 1).append("\n");
            remark.append(this.assembly[i].getPotentialEnergy().getPDBHeaderString());
        }
        remark.append("REMARK   3   TITRATION PH   : \n").append(pH).append("\n");
        String[] remarks = remark.toString().split("\n");
        pdbFilter.writeFile(file, false, excludeAtoms, true, true, remarks);
    }

    public void writeSolventMask(String filename) {
        if (this.n == 1) {
            this.writeSolventMask(filename, 0);
        } else {
            for (int i = 0; i < this.n; ++i) {
                this.writeSolventMask(FilenameUtils.removeExtension((String)filename) + "_" + i + ".map", i);
            }
        }
    }

    public void writeSolventMaskCNS(String filename) {
        if (this.n == 1) {
            this.writeSolventMaskCNS(filename, 0);
        } else {
            for (int i = 0; i < this.n; ++i) {
                this.writeSolventMaskCNS(FilenameUtils.removeExtension((String)filename) + "_" + i + ".map", i);
            }
        }
    }

    void updateCoordinates() {
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i].updateCoordinates();
            this.crystalReciprocalSpacesFs[i].updateCoordinates();
        }
    }

    void computeAtomicGradients(RefinementMode refinementMode) {
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i].computeAtomicGradients(this.refinementData[i].dFc, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, refinementMode);
            this.crystalReciprocalSpacesFs[i].computeAtomicGradients(this.refinementData[i].dFs, this.refinementData[i].freeR, this.refinementData[i].rFreeFlag, refinementMode);
        }
    }

    double computeLikelihood() {
        double e = 0.0;
        for (int i = 0; i < this.n; ++i) {
            e += this.dataFiles[i].getWeight() * this.sigmaAMinimize[i].calculateLikelihood();
        }
        return e;
    }

    void setLambdaTerm(boolean lambdaTerm) {
        for (int i = 0; i < this.n; ++i) {
            this.crystalReciprocalSpacesFc[i].setLambdaTerm(lambdaTerm);
            this.crystalReciprocalSpacesFs[i].setLambdaTerm(lambdaTerm);
        }
    }

    private void writeSolventMaskCNS(String filename, int i) {
        if (this.solventModel != SolventModel.NONE) {
            try {
                PrintWriter cnsfile = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
                cnsfile.println(" ANOMalous=FALSE");
                cnsfile.println(" DECLare NAME=FS DOMAin=RECIprocal TYPE=COMP END");
                for (HKL ih : this.reflectionList[i].hklList) {
                    int j = ih.getIndex();
                    cnsfile.printf(" INDE %d %d %d FS= %.4f %.4f\n", ih.getH(), ih.getK(), ih.getL(), this.refinementData[i].fsF(j), Math.toDegrees(this.refinementData[i].fsPhi(j)));
                }
                cnsfile.close();
            }
            catch (Exception e) {
                String message = "Fatal exception evaluating structure factors.\n";
                logger.log(Level.SEVERE, message, e);
                System.exit(-1);
            }
        }
    }

    private void writeSolventMask(String filename, int i) {
        if (this.solventModel != SolventModel.NONE) {
            CCP4MapWriter mapwriter = new CCP4MapWriter((int)this.crystalReciprocalSpacesFs[i].getXDim(), (int)this.crystalReciprocalSpacesFs[i].getYDim(), (int)this.crystalReciprocalSpacesFs[i].getZDim(), this.crystal[i], filename);
            mapwriter.write(this.crystalReciprocalSpacesFs[i].getSolventGrid());
        }
    }

    double getbSimWeight() {
        return this.bSimWeight;
    }

    double getbNonZeroWeight() {
        return this.bNonZeroWeight;
    }
}

