/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedIntegerArray;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.crystal.SymOp;
import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Complex3D;
import ffx.numerics.fft.Complex3DParallel;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.math.ScalarMath;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.RowLoop;
import ffx.potential.nonbonded.RowRegion;
import ffx.potential.nonbonded.SliceLoop;
import ffx.potential.nonbonded.SliceRegion;
import ffx.potential.nonbonded.SpatialDensityLoop;
import ffx.potential.nonbonded.SpatialDensityRegion;
import ffx.xray.parallel.GradientSchedule;
import ffx.xray.parallel.GridMethod;
import ffx.xray.parallel.RowSchedule;
import ffx.xray.parallel.SliceSchedule;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;
import ffx.xray.scatter.NeutronFormFactor;
import ffx.xray.scatter.SolventBinaryFormFactor;
import ffx.xray.scatter.SolventGaussFormFactor;
import ffx.xray.scatter.SolventPolyFormFactor;
import ffx.xray.scatter.XRayFormFactor;
import ffx.xray.solvent.BulkSolventDensityRegion;
import ffx.xray.solvent.BulkSolventRowRegion;
import ffx.xray.solvent.BulkSolventSliceRegion;
import ffx.xray.solvent.SolventModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CrystalReciprocalSpace {
    private static final Logger logger = Logger.getLogger(CrystalReciprocalSpace.class.getName());
    private static final double toSeconds = 1.0E-9;
    private final boolean neutron;
    private final double fftScale;
    private final double[] densityGrid;
    private final double[] solventGrid;
    private final int nSymm;
    private final int bulkNSymm;
    private final int nScatteringAtoms;
    private final int fftX;
    private final int fftY;
    private final int fftZ;
    private final double ifftX;
    private final double ifftY;
    private final double ifftZ;
    private final int halfFFTX;
    private final int complexFFT3DSpace;
    private final int threadCount;
    private final int bufferSize = 3;
    private final SharedIntegerArray optSliceWeightAtomic;
    private final SharedIntegerArray optSliceWeightSolvent;
    private final SharedIntegerArray optSliceWeightBulkSolvent;
    private final int[] previousOptSliceWeightAtomic;
    private final int[] previousOptSliceWeightSolvent;
    private final int[] previousOptSliceWeightBulkSolvent;
    private final SliceSchedule atomicSliceSchedule;
    private final SliceSchedule solventSliceSchedule;
    private final SliceSchedule bulkSolventSliceSchedule;
    private final SharedIntegerArray optRowWeightAtomic;
    private final SharedIntegerArray optRowWeightSolvent;
    private final SharedIntegerArray optRowWeightBulkSolvent;
    private final int[] previousOptRowWeightAtomic;
    private final int[] previousOptRowWeightSolvent;
    private final int[] previousOptRowWeightBulkSolvent;
    private final RowSchedule atomicRowSchedule;
    private final RowSchedule solventRowSchedule;
    private final RowSchedule bulkSolventRowSchedule;
    private final ParallelTeam parallelTeam;
    private final Atom[] scatteringAtoms;
    private final Crystal crystal;
    private final ReflectionList reflectionList;
    private final FormFactor[][] atomFormFactors;
    private final FormFactor[][] solventFormFactors;
    private final GridMethod gridMethod;
    private final SharedIntegerArray optAtomicGradientWeight;
    private final int[] previousOptAtomicGradientWeight;
    private final GradientSchedule atomicGradientSchedule;
    private final SpatialDensityRegion atomicDensityRegion;
    private final SpatialDensityRegion solventDensityRegion;
    private final SliceRegion atomicSliceRegion;
    private final SliceRegion solventSliceRegion;
    private final AtomicSliceLoop[] atomicSliceLoops;
    private final SolventSliceLoop[] solventSliceLoops;
    private final BulkSolventSliceLoop[] bulkSolventSliceLoops;
    private final RowRegion atomicRowRegion;
    private final RowRegion solventRowRegion;
    private final AtomicRowLoop[] atomicRowLoops;
    private final SolventRowLoop[] solventRowLoops;
    private final BulkSolventRowLoop[] bulkSolventRowLoops;
    private final InitRegion initRegion;
    private final ExtractRegion extractRegion;
    private final AtomicScaleRegion atomicScaleRegion;
    private final AtomicGradientRegion atomicGradientRegion;
    private final BabinetRegion babinetRegion;
    private final SolventGridRegion solventGridRegion;
    private final SolventScaleRegion solventScaleRegion;
    private final SolventGradientRegion solventGradientRegion;
    private final Complex3DParallel complexFFT3D;
    private double bAdd;
    boolean lambdaTerm;
    private final SolventModel solventModel;
    private final boolean solvent;
    private double solventA;
    private double solventB;
    private boolean useThreeGaussians;
    private final double[][][] coordinates;
    private double weight;
    private final int aRadGrid;
    private boolean nativeEnvironmentApproximation;

    public CrystalReciprocalSpace(ReflectionList reflectionList, Atom[] scatteringAtoms, ParallelTeam fftTeam, ParallelTeam parallelTeam) {
        this(reflectionList, scatteringAtoms, fftTeam, parallelTeam, false, false, SolventModel.POLYNOMIAL, GridMethod.SLICE);
    }

    public CrystalReciprocalSpace(ReflectionList reflectionList, Atom[] scatteringAtoms, ParallelTeam fftTeam, ParallelTeam parallelTeam, boolean solventMask) {
        this(reflectionList, scatteringAtoms, fftTeam, parallelTeam, solventMask, false, SolventModel.POLYNOMIAL, GridMethod.SLICE);
    }

    public CrystalReciprocalSpace(ReflectionList reflectionlist, Atom[] scatteringAtoms, ParallelTeam fftTeam, ParallelTeam parallelTeam, boolean solventMask, boolean neutron, SolventModel solventModel, GridMethod gridMethod) {
        int nX;
        double gridStep;
        block51: {
            block50: {
                this.bufferSize = 3;
                this.lambdaTerm = false;
                this.useThreeGaussians = true;
                this.weight = 1.0;
                this.nativeEnvironmentApproximation = false;
                this.reflectionList = reflectionlist;
                this.scatteringAtoms = scatteringAtoms;
                this.parallelTeam = parallelTeam;
                this.solvent = solventMask;
                this.neutron = neutron;
                this.solventModel = solventModel;
                this.gridMethod = gridMethod;
                this.nScatteringAtoms = scatteringAtoms.length;
                this.crystal = reflectionlist.crystal;
                this.nSymm = 1;
                this.threadCount = parallelTeam.getThreadCount();
                this.bulkNSymm = this.crystal.spaceGroup.symOps.size();
                Resolution resolution = reflectionlist.resolution;
                double gridFactor = resolution.samplingLimit() / 2.0;
                gridStep = resolution.resolutionLimit() * gridFactor;
                nX = (int)Math.floor(this.crystal.a / gridStep) + 1;
                int nY = (int)Math.floor(this.crystal.b / gridStep) + 1;
                int nZ = (int)Math.floor(this.crystal.c / gridStep) + 1;
                if (nX % 2 != 0) {
                    ++nX;
                }
                while (!Complex.preferredDimension((int)nX)) {
                    nX += 2;
                }
                while (!Complex.preferredDimension((int)nY)) {
                    ++nY;
                }
                while (!Complex.preferredDimension((int)nZ)) {
                    ++nZ;
                }
                this.fftX = nX;
                this.fftY = nY;
                this.fftZ = nZ;
                this.halfFFTX = nX / 2;
                this.ifftX = 1.0 / (double)this.fftX;
                this.ifftY = 1.0 / (double)this.fftY;
                this.ifftZ = 1.0 / (double)this.fftZ;
                this.fftScale = this.crystal.volume;
                this.complexFFT3DSpace = this.fftX * this.fftY * this.fftZ * 2;
                this.densityGrid = new double[this.complexFFT3DSpace];
                this.optSliceWeightAtomic = new SharedIntegerArray(this.fftZ);
                this.optSliceWeightSolvent = new SharedIntegerArray(this.fftZ);
                this.optSliceWeightBulkSolvent = new SharedIntegerArray(this.fftZ);
                this.previousOptSliceWeightAtomic = new int[this.fftZ];
                this.previousOptSliceWeightSolvent = new int[this.fftZ];
                this.previousOptSliceWeightBulkSolvent = new int[this.fftZ];
                this.atomicSliceSchedule = new SliceSchedule(this.threadCount, this.fftZ);
                this.solventSliceSchedule = new SliceSchedule(this.threadCount, this.fftZ);
                this.bulkSolventSliceSchedule = new SliceSchedule(this.threadCount, this.fftZ);
                this.optRowWeightAtomic = new SharedIntegerArray(this.fftZ * this.fftY);
                this.optRowWeightSolvent = new SharedIntegerArray(this.fftZ * this.fftY);
                this.optRowWeightBulkSolvent = new SharedIntegerArray(this.fftZ * this.fftY);
                this.previousOptRowWeightAtomic = new int[this.fftZ * this.fftY];
                this.previousOptRowWeightSolvent = new int[this.fftZ * this.fftY];
                this.previousOptRowWeightBulkSolvent = new int[this.fftZ * this.fftY];
                this.atomicRowSchedule = new RowSchedule(this.threadCount, this.fftZ, this.fftY);
                this.solventRowSchedule = new RowSchedule(this.threadCount, this.fftZ, this.fftY);
                this.bulkSolventRowSchedule = new RowSchedule(this.threadCount, this.fftZ, this.fftY);
                this.optAtomicGradientWeight = new SharedIntegerArray(this.nScatteringAtoms);
                this.previousOptAtomicGradientWeight = new int[this.nScatteringAtoms];
                this.atomicGradientSchedule = new GradientSchedule(this.threadCount, this.nScatteringAtoms);
                if (!this.solvent) break block50;
                this.bAdd = 0.0;
                this.atomFormFactors = null;
                switch (solventModel) {
                    case BINARY: {
                        int i;
                        int iSymm;
                        this.solventA = 1.0;
                        this.solventB = 1.0;
                        this.solventGrid = new double[this.complexFFT3DSpace];
                        this.solventFormFactors = new SolventBinaryFormFactor[this.bulkNSymm][this.nScatteringAtoms];
                        for (iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                            for (i = 0; i < this.nScatteringAtoms; ++i) {
                                double vdwr = scatteringAtoms[i].getVDWType().radius * 0.5;
                                this.solventFormFactors[iSymm][i] = new SolventBinaryFormFactor(scatteringAtoms[i], vdwr + this.solventA);
                            }
                        }
                        break block51;
                    }
                    case GAUSSIAN: {
                        int i;
                        int iSymm;
                        this.solventA = 11.5;
                        this.solventB = 0.55;
                        this.solventGrid = new double[this.complexFFT3DSpace];
                        this.solventFormFactors = new SolventGaussFormFactor[this.bulkNSymm][this.nScatteringAtoms];
                        for (iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                            for (i = 0; i < this.nScatteringAtoms; ++i) {
                                double vdwr = scatteringAtoms[i].getVDWType().radius * 0.5;
                                this.solventFormFactors[iSymm][i] = new SolventGaussFormFactor(scatteringAtoms[i], vdwr * this.solventB);
                            }
                        }
                        break block51;
                    }
                    case POLYNOMIAL: {
                        int i;
                        int iSymm;
                        this.solventA = 0.0;
                        this.solventB = 0.8;
                        this.solventGrid = new double[this.complexFFT3DSpace];
                        this.solventFormFactors = new SolventPolyFormFactor[this.bulkNSymm][this.nScatteringAtoms];
                        for (iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                            for (i = 0; i < this.nScatteringAtoms; ++i) {
                                double vdwr = scatteringAtoms[i].getVDWType().radius * 0.5;
                                this.solventFormFactors[iSymm][i] = new SolventPolyFormFactor(scatteringAtoms[i], vdwr + this.solventA, this.solventB);
                            }
                        }
                        break block51;
                    }
                    default: {
                        this.solventGrid = null;
                        this.solventFormFactors = null;
                        break;
                    }
                }
                break block51;
            }
            this.bAdd = 2.0;
            if (neutron) {
                this.atomFormFactors = new NeutronFormFactor[this.bulkNSymm][this.nScatteringAtoms];
                for (iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                    for (i = 0; i < this.nScatteringAtoms; ++i) {
                        this.atomFormFactors[iSymm][i] = new NeutronFormFactor(scatteringAtoms[i], this.bAdd);
                    }
                }
            } else {
                this.atomFormFactors = new XRayFormFactor[this.bulkNSymm][this.nScatteringAtoms];
                for (iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                    for (i = 0; i < this.nScatteringAtoms; ++i) {
                        this.atomFormFactors[iSymm][i] = new XRayFormFactor(scatteringAtoms[i], this.useThreeGaussians, this.bAdd);
                    }
                }
            }
            this.solventGrid = null;
            this.solventFormFactors = null;
        }
        double aRad = this.getaRad(scatteringAtoms, solventModel);
        this.aRadGrid = (int)Math.floor(aRad * (double)nX / this.crystal.a) + 1;
        this.coordinates = new double[this.bulkNSymm][3][this.nScatteringAtoms];
        List symops = this.crystal.spaceGroup.symOps;
        double[] xyz = new double[3];
        for (int i = 0; i < this.bulkNSymm; ++i) {
            double[] x = this.coordinates[i][0];
            double[] y = this.coordinates[i][1];
            double[] z = this.coordinates[i][2];
            for (int j = 0; j < this.nScatteringAtoms; ++j) {
                Atom aj = scatteringAtoms[j];
                this.crystal.applySymOp(aj.getXYZ(null), xyz, (SymOp)symops.get(i));
                x[j] = xyz[0];
                y[j] = xyz[1];
                z[j] = xyz[2];
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            if (this.solvent) {
                sb.append("  Bulk Solvent Grid\n");
                sb.append(String.format("  Bulk solvent model type:           %8s\n", new Object[]{solventModel}));
            } else {
                sb.append("  Atomic Scattering Grid\n");
            }
            sb.append(String.format("  Form factor grid points:             %8d\n", this.aRadGrid * 2));
            sb.append(String.format("  Form factor grid diameter:           %8.3f\n", aRad * 2.0));
            sb.append(String.format("  Grid density:                        %8.3f\n", 1.0 / gridStep));
            sb.append(String.format("  Grid dimensions:                (%3d,%3d,%3d)\n", this.fftX, this.fftY, this.fftZ));
            sb.append(String.format("  Grid method:                         %8s\n", new Object[]{gridMethod}));
            logger.info(sb.toString());
        }
        if (this.solvent) {
            minWork = this.nSymm;
            if (solventModel != SolventModel.NONE) {
                this.solventGradientRegion = new SolventGradientRegion(this, RefinementMode.COORDINATES_AND_BFACTORS_AND_OCCUPANCIES);
                this.atomicGradientRegion = null;
                this.atomicSliceLoops = null;
                this.atomicRowLoops = null;
                switch (gridMethod) {
                    case SPATIAL: {
                        this.atomicDensityRegion = new SpatialDensityRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, (this.aRadGrid + 2) * 2, this.nSymm, minWork, this.threadCount, this.crystal, scatteringAtoms, this.coordinates);
                        this.solventDensityRegion = new BulkSolventDensityRegion(this.fftX, this.fftY, this.fftZ, this.solventGrid, (this.aRadGrid + 2) * 2, this.bulkNSymm, minWork, this.threadCount, this.crystal, scatteringAtoms, this.coordinates, 4.0, parallelTeam);
                        if (solventModel == SolventModel.GAUSSIAN) {
                            this.atomicDensityRegion.setInitValue(0.0);
                        } else {
                            this.atomicDensityRegion.setInitValue(1.0);
                        }
                        SpatialDensityLoop[] solventDensityLoops = new SolventDensityLoop[this.threadCount];
                        SpatialDensityLoop[] bulkSolventDensityLoops = new SolventDensityLoop[this.threadCount];
                        for (int i = 0; i < this.threadCount; ++i) {
                            solventDensityLoops[i] = new SolventDensityLoop(this, this.atomicDensityRegion);
                            bulkSolventDensityLoops[i] = new SolventDensityLoop(this, this.solventDensityRegion);
                        }
                        this.atomicDensityRegion.setDensityLoop(solventDensityLoops);
                        this.solventDensityRegion.setDensityLoop(bulkSolventDensityLoops);
                        this.atomicSliceRegion = null;
                        this.solventSliceRegion = null;
                        this.bulkSolventSliceLoops = null;
                        this.solventSliceLoops = null;
                        this.atomicRowRegion = null;
                        this.solventRowRegion = null;
                        this.bulkSolventRowLoops = null;
                        this.solventRowLoops = null;
                        break;
                    }
                    case ROW: {
                        this.atomicRowRegion = new RowRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, this.nSymm, this.threadCount, scatteringAtoms, this.coordinates);
                        this.solventRowRegion = new BulkSolventRowRegion(this.fftX, this.fftY, this.fftZ, this.solventGrid, this.bulkNSymm, this.threadCount, this.crystal, scatteringAtoms, this.coordinates, 4.0, parallelTeam);
                        if (solventModel == SolventModel.GAUSSIAN) {
                            this.atomicRowRegion.setInitValue(0.0);
                        } else {
                            this.atomicRowRegion.setInitValue(1.0);
                        }
                        this.solventRowLoops = new SolventRowLoop[this.threadCount];
                        this.bulkSolventRowLoops = new BulkSolventRowLoop[this.threadCount];
                        for (int i = 0; i < this.threadCount; ++i) {
                            this.solventRowLoops[i] = new SolventRowLoop(this, this.atomicRowRegion);
                            this.bulkSolventRowLoops[i] = new BulkSolventRowLoop(this, this.solventRowRegion);
                        }
                        this.atomicRowRegion.setDensityLoop((RowLoop[])this.solventRowLoops);
                        this.solventRowRegion.setDensityLoop((RowLoop[])this.bulkSolventRowLoops);
                        this.atomicDensityRegion = null;
                        this.solventDensityRegion = null;
                        this.atomicSliceRegion = null;
                        this.solventSliceRegion = null;
                        this.bulkSolventSliceLoops = null;
                        this.solventSliceLoops = null;
                        break;
                    }
                    default: {
                        this.atomicSliceRegion = new SliceRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, this.nSymm, this.threadCount, scatteringAtoms, this.coordinates);
                        this.solventSliceRegion = new BulkSolventSliceRegion(this.fftX, this.fftY, this.fftZ, this.solventGrid, this.bulkNSymm, this.threadCount, this.crystal, scatteringAtoms, this.coordinates, 4.0, parallelTeam);
                        if (solventModel == SolventModel.GAUSSIAN) {
                            this.atomicSliceRegion.setInitValue(0.0);
                        } else {
                            this.atomicSliceRegion.setInitValue(1.0);
                        }
                        this.solventSliceLoops = new SolventSliceLoop[this.threadCount];
                        this.bulkSolventSliceLoops = new BulkSolventSliceLoop[this.threadCount];
                        for (int i = 0; i < this.threadCount; ++i) {
                            this.solventSliceLoops[i] = new SolventSliceLoop(this, this.atomicSliceRegion);
                            this.bulkSolventSliceLoops[i] = new BulkSolventSliceLoop(this, this.solventSliceRegion);
                        }
                        this.atomicSliceRegion.setDensityLoop((SliceLoop[])this.solventSliceLoops);
                        this.solventSliceRegion.setDensityLoop((SliceLoop[])this.bulkSolventSliceLoops);
                        this.atomicDensityRegion = null;
                        this.solventDensityRegion = null;
                        this.atomicRowRegion = null;
                        this.solventRowRegion = null;
                        this.bulkSolventRowLoops = null;
                        this.solventRowLoops = null;
                        break;
                    }
                }
            } else {
                this.atomicDensityRegion = null;
                this.solventDensityRegion = null;
                this.atomicGradientRegion = null;
                this.solventGradientRegion = null;
                this.atomicSliceRegion = null;
                this.atomicSliceLoops = null;
                this.solventSliceRegion = null;
                this.bulkSolventSliceLoops = null;
                this.solventSliceLoops = null;
                this.atomicRowRegion = null;
                this.atomicRowLoops = null;
                this.solventRowRegion = null;
                this.bulkSolventRowLoops = null;
                this.solventRowLoops = null;
            }
        } else {
            this.atomicGradientRegion = new AtomicGradientRegion(this, RefinementMode.COORDINATES_AND_BFACTORS_AND_OCCUPANCIES);
            this.solventDensityRegion = null;
            this.solventSliceRegion = null;
            this.solventSliceLoops = null;
            this.bulkSolventSliceLoops = null;
            this.solventRowRegion = null;
            this.solventRowLoops = null;
            this.bulkSolventRowLoops = null;
            this.solventGradientRegion = null;
            switch (gridMethod) {
                case SPATIAL: {
                    minWork = this.nSymm;
                    this.atomicDensityRegion = new SpatialDensityRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, (this.aRadGrid + 2) * 2, this.nSymm, minWork, this.threadCount, this.crystal, scatteringAtoms, this.coordinates);
                    this.atomicDensityRegion.setInitValue(0.0);
                    SpatialDensityLoop[] atomicDensityLoops = new AtomicDensityLoop[this.threadCount];
                    for (int i = 0; i < this.threadCount; ++i) {
                        atomicDensityLoops[i] = new AtomicDensityLoop(this, this.atomicDensityRegion);
                    }
                    this.atomicDensityRegion.setDensityLoop(atomicDensityLoops);
                    this.atomicSliceRegion = null;
                    this.atomicSliceLoops = null;
                    this.atomicRowRegion = null;
                    this.atomicRowLoops = null;
                    break;
                }
                case ROW: {
                    this.atomicRowRegion = new RowRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, this.nSymm, this.threadCount, scatteringAtoms, this.coordinates);
                    this.atomicRowRegion.setInitValue(0.0);
                    this.atomicRowLoops = new AtomicRowLoop[this.threadCount];
                    for (int i = 0; i < this.threadCount; ++i) {
                        this.atomicRowLoops[i] = new AtomicRowLoop(this, this.atomicRowRegion);
                    }
                    this.atomicRowRegion.setDensityLoop((RowLoop[])this.atomicRowLoops);
                    this.atomicDensityRegion = null;
                    this.atomicSliceRegion = null;
                    this.atomicSliceLoops = null;
                    break;
                }
                default: {
                    this.atomicSliceRegion = new SliceRegion(this.fftX, this.fftY, this.fftZ, this.densityGrid, this.nSymm, this.threadCount, scatteringAtoms, this.coordinates);
                    this.atomicSliceRegion.setInitValue(0.0);
                    this.atomicSliceLoops = new AtomicSliceLoop[this.threadCount];
                    for (int i = 0; i < this.threadCount; ++i) {
                        this.atomicSliceLoops[i] = new AtomicSliceLoop(this, this.atomicSliceRegion);
                    }
                    this.atomicSliceRegion.setDensityLoop((SliceLoop[])this.atomicSliceLoops);
                    this.atomicDensityRegion = null;
                    this.atomicRowRegion = null;
                    this.atomicRowLoops = null;
                }
            }
        }
        this.extractRegion = new ExtractRegion(this, this.threadCount);
        this.babinetRegion = new BabinetRegion(this, this.threadCount);
        this.solventGridRegion = new SolventGridRegion(this, this.threadCount);
        this.initRegion = new InitRegion(this, this.threadCount);
        this.solventScaleRegion = new SolventScaleRegion(this, this.threadCount);
        this.atomicScaleRegion = new AtomicScaleRegion(this, this.threadCount);
        this.complexFFT3D = new Complex3DParallel(this.fftX, this.fftY, this.fftZ, fftTeam);
    }

    private double getaRad(Atom[] atoms, SolventModel solventModel) {
        double aRad = -1.0;
        block5: for (Atom a : atoms) {
            double vdwr = a.getVDWType().radius * 0.5;
            if (!this.solvent) {
                aRad = Math.max(aRad, a.getFormFactorWidth());
                continue;
            }
            switch (solventModel) {
                case BINARY: {
                    aRad = Math.max(aRad, vdwr + this.solventA + 0.2);
                    continue block5;
                }
                case GAUSSIAN: {
                    aRad = Math.max(aRad, vdwr * this.solventB + 2.0);
                    continue block5;
                }
                case POLYNOMIAL: {
                    aRad = Math.max(aRad, vdwr + this.solventB + 0.2);
                    continue block5;
                }
                default: {
                    aRad = 0.0;
                }
            }
        }
        return aRad;
    }

    public void computeAtomicGradients(double[][] hklData, int[] freer, int flag, RefinementMode refinementMode) {
        this.computeAtomicGradients(hklData, freer, flag, refinementMode, false);
    }

    public void computeSolventDensity(double[][] hklData) {
        this.computeSolventDensity(hklData, false);
    }

    public void densityNorm(double[] data, double[] meansd, boolean norm) {
        int index;
        int i;
        int j;
        int k;
        double mean = 0.0;
        double sd = 0.0;
        int n = 0;
        for (k = 0; k < this.fftZ; ++k) {
            for (j = 0; j < this.fftY; ++j) {
                for (i = 0; i < this.fftX; ++i) {
                    index = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.fftX, (int)this.fftY);
                    mean += (data[index] - mean) / (double)(++n);
                }
            }
        }
        n = 0;
        for (k = 0; k < this.fftZ; ++k) {
            for (j = 0; j < this.fftY; ++j) {
                for (i = 0; i < this.fftX; ++i) {
                    index = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.fftX, (int)this.fftY);
                    sd += FastMath.pow((double)(data[index] - mean), (int)2);
                    ++n;
                }
            }
        }
        sd = FastMath.sqrt((double)(sd / (double)n));
        if (meansd != null) {
            meansd[0] = mean;
            meansd[1] = sd;
        }
        if (norm) {
            double isd = 1.0 / sd;
            for (int k2 = 0; k2 < this.fftZ; ++k2) {
                for (int j2 = 0; j2 < this.fftY; ++j2) {
                    for (int i2 = 0; i2 < this.fftX; ++i2) {
                        int index2 = Complex3D.interleavedIndex((int)i2, (int)j2, (int)k2, (int)this.fftX, (int)this.fftY);
                        data[index2] = (data[index2] - mean) * isd;
                    }
                }
            }
        }
    }

    public double[] getDensityGrid() {
        return this.densityGrid;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getXDim() {
        return this.fftX;
    }

    public double getYDim() {
        return this.fftY;
    }

    public double getZDim() {
        return this.fftZ;
    }

    public void updateCoordinates() {
        List symops = this.crystal.spaceGroup.symOps;
        double[] xyz = new double[3];
        double[] symXYZ = new double[3];
        for (int i = 0; i < this.nScatteringAtoms; ++i) {
            Atom atom = this.scatteringAtoms[i];
            if (!atom.isActive()) continue;
            atom.getXYZ(xyz);
            for (int j = 0; j < this.nSymm; ++j) {
                this.crystal.applySymOp(xyz, symXYZ, (SymOp)symops.get(j));
                this.coordinates[j][0][i] = symXYZ[0];
                this.coordinates[j][1][i] = symXYZ[1];
                this.coordinates[j][2][i] = symXYZ[2];
            }
        }
    }

    void setNativeEnvironmentApproximation(boolean nativeEnvironmentApproximation) {
        this.nativeEnvironmentApproximation = nativeEnvironmentApproximation;
    }

    double[] getSolventGrid() {
        return this.solventGrid;
    }

    void setLambdaTerm(boolean lambdaTerm) {
        this.lambdaTerm = lambdaTerm;
    }

    SolventModel getSolventModel() {
        return this.solventModel;
    }

    void setDefaultSolventAB() {
        switch (this.solventModel) {
            case BINARY: {
                this.setSolventAB(1.0, 1.0);
                break;
            }
            case GAUSSIAN: {
                this.setSolventAB(11.5, 0.55);
                break;
            }
            case POLYNOMIAL: {
                this.setSolventAB(0.0, 0.8);
                break;
            }
        }
    }

    void setSolventAB(double a, double b) {
        this.solventA = a;
        this.solventB = b;
        if (!this.solvent) {
            return;
        }
        switch (this.solventModel) {
            case BINARY: {
                for (int iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                    for (int i = 0; i < this.nScatteringAtoms; ++i) {
                        double vdwr = this.scatteringAtoms[i].getVDWType().radius * 0.5;
                        this.solventFormFactors[iSymm][i] = new SolventBinaryFormFactor(this.scatteringAtoms[i], vdwr + this.solventA);
                    }
                }
                break;
            }
            case GAUSSIAN: {
                for (int iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                    for (int i = 0; i < this.nScatteringAtoms; ++i) {
                        double vdwr = this.scatteringAtoms[i].getVDWType().radius * 0.5;
                        this.solventFormFactors[iSymm][i] = new SolventGaussFormFactor(this.scatteringAtoms[i], vdwr * this.solventB);
                    }
                }
                break;
            }
            case POLYNOMIAL: {
                for (int iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
                    for (int i = 0; i < this.nScatteringAtoms; ++i) {
                        double vdwr = this.scatteringAtoms[i].getVDWType().radius * 0.5;
                        this.solventFormFactors[iSymm][i] = new SolventPolyFormFactor(this.scatteringAtoms[i], vdwr + this.solventA, this.solventB);
                    }
                }
                break;
            }
        }
    }

    double getSolventA() {
        return this.solventA;
    }

    double getSolventB() {
        return this.solventB;
    }

    void setUse3G(boolean useThreeGaussians) {
        this.useThreeGaussians = useThreeGaussians;
        if (this.solvent || this.neutron) {
            return;
        }
        for (int iSymm = 0; iSymm < this.bulkNSymm; ++iSymm) {
            for (int i = 0; i < this.nScatteringAtoms; ++i) {
                this.atomFormFactors[iSymm][i] = new XRayFormFactor(this.scatteringAtoms[i], useThreeGaussians, this.bAdd);
            }
        }
    }

    void deltaX(int n, double delta) {
        List symops = this.crystal.spaceGroup.symOps;
        double[] xyz = new double[3];
        double[] symxyz = new double[3];
        this.scatteringAtoms[n].getXYZ(xyz);
        xyz[0] = xyz[0] + delta;
        for (int i = 0; i < this.nSymm; ++i) {
            this.crystal.applySymOp(xyz, symxyz, (SymOp)symops.get(i));
            this.coordinates[i][0][n] = symxyz[0];
        }
    }

    void deltaY(int n, double delta) {
        List symops = this.crystal.spaceGroup.symOps;
        double[] xyz = new double[3];
        double[] symxyz = new double[3];
        this.scatteringAtoms[n].getXYZ(xyz);
        xyz[1] = xyz[1] + delta;
        for (int i = 0; i < this.nSymm; ++i) {
            this.crystal.applySymOp(xyz, symxyz, (SymOp)symops.get(i));
            this.coordinates[i][1][n] = symxyz[1];
        }
    }

    void deltaZ(int n, double delta) {
        List symops = this.crystal.spaceGroup.symOps;
        double[] xyz = new double[3];
        double[] symxyz = new double[3];
        this.scatteringAtoms[n].getXYZ(xyz);
        xyz[2] = xyz[2] + delta;
        for (int i = 0; i < this.nSymm; ++i) {
            this.crystal.applySymOp(xyz, symxyz, (SymOp)symops.get(i));
            this.coordinates[i][2][n] = symxyz[2];
        }
    }

    void computeDensity(double[][] hklData) {
        this.computeDensity(hklData, false);
    }

    void computeDensity(double[][] hklData, boolean print) {
        if (this.solvent) {
            if (this.solventModel != SolventModel.NONE) {
                this.computeSolventDensity(hklData, print);
            }
        } else {
            this.computeAtomicDensity(hklData, print);
        }
    }

    void computeAtomicGradients(double[][] hklData, int[] freer, int flag, RefinementMode refinementMode, boolean print) {
        if (this.solvent && this.solventModel == SolventModel.NONE) {
            return;
        }
        for (int i = 0; i < this.complexFFT3DSpace; ++i) {
            this.densityGrid[i] = 0.0;
        }
        int nfree = 0;
        StringBuilder sb = new StringBuilder();
        long symtime = -System.nanoTime();
        int nsym = this.crystal.spaceGroup.symOps.size();
        List symops = this.crystal.spaceGroup.symOps;
        ComplexNumber c = new ComplexNumber();
        ComplexNumber cj = new ComplexNumber();
        HKL ij = new HKL();
        for (HKL ih : this.reflectionList.hklList) {
            double[] fc = hklData[ih.getIndex()];
            if (Double.isNaN(fc[0])) continue;
            if (freer != null && freer[ih.getIndex()] == flag) {
                ++nfree;
                continue;
            }
            c.re(fc[0]);
            c.im(fc[1]);
            c.timesIP(2.0 / this.fftScale);
            for (int j = 0; j < nsym; ++j) {
                int ii;
                cj.copy(c);
                SymOp symOp = (SymOp)symops.get(j);
                SymOp.applyTransSymRot((HKL)ih, (HKL)ij, (SymOp)symOp);
                double shift = symOp.symPhaseShift(ih);
                int h = ScalarMath.mod((int)ij.getH(), (int)this.fftX);
                int k = ScalarMath.mod((int)ij.getK(), (int)this.fftY);
                int l = ScalarMath.mod((int)ij.getL(), (int)this.fftZ);
                if (h < this.halfFFTX + 1) {
                    ii = Complex3D.interleavedIndex((int)h, (int)k, (int)l, (int)this.fftX, (int)this.fftY);
                    cj.phaseShiftIP(shift);
                    int n = ii;
                    this.densityGrid[n] = this.densityGrid[n] + cj.re();
                    int n2 = ii + 1;
                    this.densityGrid[n2] = this.densityGrid[n2] + -cj.im();
                    continue;
                }
                h = (this.fftX - h) % this.fftX;
                k = (this.fftY - k) % this.fftY;
                l = (this.fftZ - l) % this.fftZ;
                ii = Complex3D.interleavedIndex((int)h, (int)k, (int)l, (int)this.fftX, (int)this.fftY);
                cj.phaseShiftIP(shift);
                int n = ii;
                this.densityGrid[n] = this.densityGrid[n] + cj.re();
                int n3 = ii + 1;
                this.densityGrid[n3] = this.densityGrid[n3] + cj.im();
            }
        }
        symtime += System.nanoTime();
        long startTime = System.nanoTime();
        this.complexFFT3D.ifft(this.densityGrid);
        long fftTime = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        long permanentDensityTime = 0L;
        try {
            if (this.solvent) {
                this.solventGradientRegion.setRefinementMode(refinementMode);
                this.parallelTeam.execute((ParallelRegion)this.solventGradientRegion);
            } else {
                int i;
                for (i = 0; i < this.nScatteringAtoms; ++i) {
                    this.optAtomicGradientWeight.set(i, 0);
                }
                this.atomicGradientSchedule.updateWeights(this.previousOptAtomicGradientWeight);
                this.atomicGradientRegion.setRefinementMode(refinementMode);
                this.parallelTeam.execute((ParallelRegion)this.atomicGradientRegion);
                for (i = 0; i < this.nScatteringAtoms; ++i) {
                    this.previousOptAtomicGradientWeight[i] = this.optAtomicGradientWeight.get(i);
                }
            }
            permanentDensityTime = System.nanoTime() - startTime;
        }
        catch (Exception e) {
            String message = "Exception computing atomic gradients.";
            logger.log(Level.SEVERE, message, e);
        }
        if (this.solvent) {
            sb.append(String.format(" Solvent Symmetry:            %8.4f\n", (double)symtime * 1.0E-9));
            sb.append(String.format(" Solvent Inverse FFT:         %8.4f\n", (double)fftTime * 1.0E-9));
            sb.append(String.format(" Solvent Gradient from Grid:  %8.4f", (double)permanentDensityTime * 1.0E-9));
        } else {
            sb.append(String.format(" Atomic Symmetry:             %8.4f\n", (double)symtime * 1.0E-9));
            sb.append(String.format(" Atomic Inverse FFT:          %8.4f\n", (double)fftTime * 1.0E-9));
            sb.append(String.format(" Atomic Gradient from Grid:   %8.4f", (double)permanentDensityTime * 1.0E-9));
        }
        if (logger.isLoggable(Level.INFO) && print) {
            logger.info(sb.toString());
        }
    }

    void computeAtomicDensity(double[][] hklData) {
        this.computeAtomicDensity(hklData, false);
    }

    private void computeAtomicDensity(double[][] hklData, boolean print) {
        long initTime = -System.nanoTime();
        try {
            this.initRegion.setHKL(hklData);
            this.parallelTeam.execute((ParallelRegion)this.initRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception zeroing out reflection data.";
            logger.log(Level.SEVERE, message, e);
        }
        initTime += System.nanoTime();
        long atomicGridTime = -System.nanoTime();
        try {
            switch (this.gridMethod) {
                case SPATIAL: {
                    this.atomicDensityRegion.assignAtomsToCells();
                    this.parallelTeam.execute((ParallelRegion)this.atomicDensityRegion);
                    break;
                }
                case ROW: {
                    int i;
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.optRowWeightAtomic.set(i, 0);
                    }
                    this.atomicRowSchedule.updateWeights(this.previousOptRowWeightAtomic);
                    this.parallelTeam.execute((ParallelRegion)this.atomicRowRegion);
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.previousOptRowWeightAtomic[i] = this.optRowWeightAtomic.get(i);
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < this.fftZ; ++i) {
                        this.optSliceWeightAtomic.set(i, 0);
                    }
                    this.atomicSliceSchedule.updateWeights(this.previousOptSliceWeightAtomic);
                    this.parallelTeam.execute((ParallelRegion)this.atomicSliceRegion);
                    for (i = 0; i < this.fftZ; ++i) {
                        this.previousOptSliceWeightAtomic[i] = this.optSliceWeightAtomic.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating atomic electron density.";
            logger.log(Level.SEVERE, message, e);
        }
        atomicGridTime += System.nanoTime();
        long startTime = System.nanoTime();
        this.complexFFT3D.fft(this.densityGrid);
        long fftTime = System.nanoTime() - startTime;
        long symTime = -System.nanoTime();
        try {
            this.extractRegion.setHKL(hklData);
            this.parallelTeam.execute((ParallelRegion)this.extractRegion);
            double scale = this.fftScale / (double)(this.fftX * this.fftY * this.fftZ);
            this.atomicScaleRegion.setHKL(hklData);
            this.atomicScaleRegion.setScale(scale);
            this.parallelTeam.execute((ParallelRegion)this.atomicScaleRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception extracting structure factors.";
            logger.log(Level.SEVERE, message, e);
        }
        symTime += System.nanoTime();
        if (logger.isLoggable(Level.INFO) && print) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\n Atomic Fc Initialization:    %8.4f\n", (double)initTime * 1.0E-9));
            sb.append(String.format(" Atomic Grid Density:         %8.4f\n", (double)atomicGridTime * 1.0E-9));
            sb.append(String.format(" Atomic FFT:                  %8.4f\n", (double)fftTime * 1.0E-9));
            sb.append(String.format(" Atomic Symmetry & Scaling:   %8.4f", (double)symTime * 1.0E-9));
            logger.info(sb.toString());
            StringBuilder ASB = new StringBuilder();
            switch (this.gridMethod) {
                case ROW: {
                    int i;
                    double atomicRowTotal = 0.0;
                    double atomicRowMin = this.atomicRowLoops[0].getThreadTime();
                    double atomicRowMax = 0.0;
                    double atomicRowWeightTotal = 0.0;
                    for (i = 0; i < this.threadCount; ++i) {
                        atomicRowTotal += this.atomicRowLoops[i].getThreadTime();
                        atomicRowMax = FastMath.max((double)this.atomicRowLoops[i].getThreadTime(), (double)atomicRowMax);
                        atomicRowMin = FastMath.min((double)this.atomicRowLoops[i].getThreadTime(), (double)atomicRowMin);
                        atomicRowWeightTotal += (double)this.atomicRowLoops[i].getThreadWeight();
                    }
                    ASB.append(String.format("\n RowLoop (Atomic): %7.5f (sec)                 | Total Weight: %7.0f\n", (double)atomicGridTime * 1.0E-9, atomicRowWeightTotal));
                    ASB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Rows       Weight    Balance(%)  Normalized\n");
                    if (atomicRowWeightTotal == 0.0) {
                        atomicRowWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        ASB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.atomicRowLoops[i].getThreadTime() * 1.0E-9, this.atomicRowLoops[i].getThreadTime() / atomicRowTotal * 100.0, this.atomicRowLoops[i].getThreadTime() / atomicRowTotal * (100.0 * (double)this.threadCount), this.atomicRowLoops[i].getNumberofSlices(), this.atomicRowLoops[i].getThreadWeight(), 100.0 * ((double)this.atomicRowLoops[i].getThreadWeight() / atomicRowWeightTotal), 100.0 * (double)this.threadCount * ((double)this.atomicRowLoops[i].getThreadWeight() / atomicRowWeightTotal)));
                    }
                    ASB.append(String.format("    Min      %7.5f\n", atomicRowMin * 1.0E-9));
                    ASB.append(String.format("    Max      %7.5f\n", atomicRowMax * 1.0E-9));
                    ASB.append(String.format("    Delta    %7.5f\n", (atomicRowMax - atomicRowMin) * 1.0E-9));
                    logger.info(ASB.toString());
                    break;
                }
                case SPATIAL: {
                    break;
                }
                case SLICE: {
                    int i;
                    double atomicSliceTotal = 0.0;
                    double atomicSliceMin = this.atomicSliceLoops[0].getThreadTime();
                    double atomicSliceMax = 0.0;
                    double atomicSliceWeightTotal = 0.0;
                    for (i = 0; i < this.threadCount; ++i) {
                        atomicSliceTotal += this.atomicSliceLoops[i].getThreadTime();
                        atomicSliceMax = FastMath.max((double)this.atomicSliceLoops[i].getThreadTime(), (double)atomicSliceMax);
                        atomicSliceMin = FastMath.min((double)this.atomicSliceLoops[i].getThreadTime(), (double)atomicSliceMin);
                        atomicSliceWeightTotal += (double)this.atomicSliceLoops[i].getThreadWeight();
                    }
                    ASB.append(String.format("\n SliceLoop (Atomic): %7.5f (sec)               | Total Weight: %7.0f\n", (double)atomicGridTime * 1.0E-9, atomicSliceWeightTotal));
                    ASB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Slices    Weight    Balance(%)  Normalized\n");
                    if (atomicSliceWeightTotal == 0.0) {
                        atomicSliceWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        ASB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.atomicSliceLoops[i].getThreadTime() * 1.0E-9, this.atomicSliceLoops[i].getThreadTime() / atomicSliceTotal * 100.0, this.atomicSliceLoops[i].getThreadTime() / atomicSliceTotal * (100.0 * (double)this.threadCount), this.atomicSliceLoops[i].getNumberofSlices(), this.atomicSliceLoops[i].getThreadWeight(), 100.0 * ((double)this.atomicSliceLoops[i].getThreadWeight() / atomicSliceWeightTotal), 100.0 * (double)this.threadCount * ((double)this.atomicSliceLoops[i].getThreadWeight() / atomicSliceWeightTotal)));
                    }
                    ASB.append(String.format("    Min      %7.5f\n", atomicSliceMin * 1.0E-9));
                    ASB.append(String.format("    Max      %7.5f\n", atomicSliceMax * 1.0E-9));
                    ASB.append(String.format("    Delta    %7.5f\n", (atomicSliceMax - atomicSliceMin) * 1.0E-9));
                    logger.info(ASB.toString());
                    break;
                }
            }
        }
    }

    private void computeSolventDensity(double[][] hklData, boolean print) {
        long initTime = -System.nanoTime();
        try {
            this.initRegion.setHKL(hklData);
            this.parallelTeam.execute((ParallelRegion)this.initRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception initializing structure factors.";
            logger.log(Level.SEVERE, message, e);
        }
        initTime += System.nanoTime();
        long solventGridTime = -System.nanoTime();
        try {
            switch (this.gridMethod) {
                case SPATIAL: {
                    this.atomicDensityRegion.assignAtomsToCells();
                    this.parallelTeam.execute((ParallelRegion)this.atomicDensityRegion);
                    break;
                }
                case ROW: {
                    int i;
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.optRowWeightSolvent.set(i, 0);
                    }
                    this.solventRowSchedule.updateWeights(this.previousOptRowWeightSolvent);
                    this.parallelTeam.execute((ParallelRegion)this.atomicRowRegion);
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.previousOptRowWeightSolvent[i] = this.optRowWeightSolvent.get(i);
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < this.fftZ; ++i) {
                        this.optSliceWeightSolvent.set(i, 0);
                    }
                    this.solventSliceSchedule.updateWeights(this.previousOptSliceWeightSolvent);
                    this.parallelTeam.execute((ParallelRegion)this.atomicSliceRegion);
                    for (i = 0; i < this.fftZ; ++i) {
                        this.previousOptSliceWeightSolvent[i] = this.optSliceWeightSolvent.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating solvent electron density.";
            logger.log(Level.SEVERE, message, e);
        }
        solventGridTime += System.nanoTime();
        long expTime = -System.nanoTime();
        if (this.solventModel == SolventModel.BINARY) {
            int nmap = this.densityGrid.length;
            System.arraycopy(this.densityGrid, 0, this.solventGrid, 0, nmap);
            double[] xyz = new double[]{this.solventB, this.solventB, this.solventB};
            double[] uvw = new double[3];
            this.crystal.toFractionalCoordinates(xyz, uvw);
            double frx = (double)this.fftX * uvw[0];
            int ifrx = (int)frx;
            double fry = (double)this.fftY * uvw[1];
            int ifry = (int)fry;
            double frz = (double)this.fftZ * uvw[2];
            int ifrz = (int)frz;
            for (int k = 0; k < this.fftZ; ++k) {
                for (int j = 0; j < this.fftY; ++j) {
                    block33: for (int i = 0; i < this.fftX; ++i) {
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.fftX, (int)this.fftY);
                        if (this.densityGrid[ii] == 1.0) continue;
                        for (int iz = k - ifrz; iz <= k + ifrz; ++iz) {
                            int giz = ScalarMath.mod((int)iz, (int)this.fftZ);
                            for (int iy = j - ifry; iy <= j + ifry; ++iy) {
                                int giy = ScalarMath.mod((int)iy, (int)this.fftY);
                                for (int ix = i - ifrx; ix <= i + ifrx; ++ix) {
                                    int gix = ScalarMath.mod((int)ix, (int)this.fftX);
                                    int jj = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.fftX, (int)this.fftY);
                                    if (this.densityGrid[jj] != 1.0) continue;
                                    this.solventGrid[ii] = 1.0;
                                    continue block33;
                                }
                            }
                        }
                    }
                }
            }
            System.arraycopy(this.solventGrid, 0, this.densityGrid, 0, nmap);
        }
        ArrayCopyRegion arrayCopyRegion = new ArrayCopyRegion(this);
        try {
            this.parallelTeam.execute((ParallelRegion)arrayCopyRegion);
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        try {
            this.parallelTeam.execute((ParallelRegion)this.babinetRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception Babinet Principle.";
            logger.log(Level.SEVERE, message, e);
        }
        expTime += System.nanoTime();
        long fftTime = -System.nanoTime();
        this.complexFFT3D.fft(this.densityGrid);
        fftTime += System.nanoTime();
        long symTime = -System.nanoTime();
        try {
            this.extractRegion.setHKL(hklData);
            this.parallelTeam.execute((ParallelRegion)this.extractRegion);
            double scale = this.fftScale / (double)(this.fftX * this.fftY * this.fftZ);
            this.solventScaleRegion.setHKL(hklData);
            this.solventScaleRegion.setScale(scale);
            this.parallelTeam.execute((ParallelRegion)this.solventScaleRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception extracting structure factors.";
            logger.log(Level.SEVERE, message, e);
        }
        symTime += System.nanoTime();
        long solventDensityTime = -System.nanoTime();
        try {
            switch (this.gridMethod) {
                case SPATIAL: {
                    this.solventDensityRegion.assignAtomsToCells();
                    this.parallelTeam.execute((ParallelRegion)this.solventDensityRegion);
                    break;
                }
                case ROW: {
                    int i;
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.optRowWeightBulkSolvent.set(i, 0);
                    }
                    this.bulkSolventRowSchedule.updateWeights(this.previousOptRowWeightBulkSolvent);
                    this.parallelTeam.execute((ParallelRegion)this.solventRowRegion);
                    for (i = 0; i < this.fftZ * this.fftY; ++i) {
                        this.previousOptRowWeightBulkSolvent[i] = this.optRowWeightBulkSolvent.get(i);
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < this.fftZ; ++i) {
                        this.optSliceWeightBulkSolvent.set(i, 0);
                    }
                    this.bulkSolventSliceSchedule.updateWeights(this.previousOptSliceWeightBulkSolvent);
                    this.parallelTeam.execute((ParallelRegion)this.solventSliceRegion);
                    for (i = 0; i < this.fftZ; ++i) {
                        this.previousOptSliceWeightBulkSolvent[i] = this.optSliceWeightBulkSolvent.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating solvent electron density.";
            logger.log(Level.SEVERE, message, e);
        }
        solventDensityTime += System.nanoTime();
        long solventExpTime = 0L;
        if (this.solventModel == SolventModel.GAUSSIAN) {
            solventExpTime = -System.nanoTime();
            try {
                this.parallelTeam.execute((ParallelRegion)this.solventGridRegion);
            }
            catch (Exception e) {
                String message = "Fatal exception solvent grid region.";
                logger.log(Level.SEVERE, message, e);
            }
            solventExpTime += System.nanoTime();
        }
        if (logger.isLoggable(Level.INFO) && print) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Solvent Fc Initialization:   %8.4f\n", (double)initTime * 1.0E-9));
            sb.append(String.format(" Solvent Grid Density:        %8.4f\n", (double)solventGridTime * 1.0E-9));
            sb.append(String.format(" Bulk Solvent Exponentiation: %8.4f\n", (double)expTime * 1.0E-9));
            sb.append(String.format(" Solvent FFT:                 %8.4f\n", (double)fftTime * 1.0E-9));
            sb.append(String.format(" Solvent Symmetry & Scaling:  %8.4f\n", (double)symTime * 1.0E-9));
            sb.append(String.format(" Solvent Grid Expansion:      %8.4f", (double)solventDensityTime * 1.0E-9));
            if (this.solventModel == SolventModel.GAUSSIAN) {
                sb.append(String.format("\n Gaussian grid exponentiation:%8.4f", (double)solventExpTime * 1.0E-9));
            }
            logger.info(sb.toString());
            StringBuilder solventSB = new StringBuilder();
            StringBuilder bulkSB = new StringBuilder();
            switch (this.gridMethod) {
                case ROW: {
                    int i;
                    double solventRowTotal = 0.0;
                    double solventRowMin = this.solventRowLoops[0].getThreadTime();
                    double solventRowMax = 0.0;
                    double solventRowWeightTotal = 0.0;
                    double bulkSolventRowTotal = 0.0;
                    double bulkSolventRowMin = this.bulkSolventRowLoops[0].getTimePerThread();
                    double bulkSolventRowMax = 0.0;
                    double bulkSolventRowWeightTotal = 0.0;
                    for (i = 0; i < this.threadCount; ++i) {
                        solventRowTotal += this.solventRowLoops[i].getThreadTime();
                        solventRowMax = FastMath.max((double)this.solventRowLoops[i].getThreadTime(), (double)solventRowMax);
                        solventRowMin = FastMath.min((double)this.solventRowLoops[i].getThreadTime(), (double)solventRowMin);
                        solventRowWeightTotal += (double)this.solventRowLoops[i].getThreadWeight();
                        bulkSolventRowTotal += this.bulkSolventRowLoops[i].getTimePerThread();
                        bulkSolventRowMax = FastMath.max((double)this.bulkSolventRowLoops[i].getTimePerThread(), (double)bulkSolventRowMax);
                        bulkSolventRowMin = FastMath.min((double)this.bulkSolventRowLoops[i].getTimePerThread(), (double)bulkSolventRowMin);
                        bulkSolventRowWeightTotal += (double)this.bulkSolventRowLoops[i].getWeightPerThread()[i];
                    }
                    solventSB.append(String.format("\n RowLoop (Solvent): %7.5f (sec)                | Total Weight: %7.0f\n", (double)solventGridTime * 1.0E-9, solventRowWeightTotal));
                    solventSB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Rows       Weight     Balance(%)  Normalized\n");
                    if (solventRowWeightTotal == 0.0) {
                        solventRowWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        solventSB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.solventRowLoops[i].getThreadTime() * 1.0E-9, this.solventRowLoops[i].getThreadTime() / solventRowTotal * 100.0, this.solventRowLoops[i].getThreadTime() / solventRowTotal * (100.0 * (double)this.threadCount), this.solventRowLoops[i].getNumberofSlices(), this.solventRowLoops[i].getThreadWeight(), 100.0 * ((double)this.solventRowLoops[i].getThreadWeight() / solventRowWeightTotal), 100.0 * (double)this.threadCount * ((double)this.solventRowLoops[i].getThreadWeight() / solventRowWeightTotal)));
                    }
                    solventSB.append(String.format("    Min      %7.5f\n", solventRowMin * 1.0E-9));
                    solventSB.append(String.format("    Max      %7.5f\n", solventRowMax * 1.0E-9));
                    solventSB.append(String.format("    Delta    %7.5f\n", (solventRowMax - solventRowMin) * 1.0E-9));
                    logger.info(solventSB.toString());
                    bulkSB.append(String.format("\n RowLoop (Bulk Solvent): %7.5f (sec)           | Total Weight: %7.0f\n", bulkSolventRowTotal * 1.0E-9, bulkSolventRowWeightTotal));
                    bulkSB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Rows       Weight     Balance(%)  Normalized\n");
                    if (bulkSolventRowWeightTotal == 0.0) {
                        bulkSolventRowWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        bulkSB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.bulkSolventRowLoops[i].getTimePerThread() * 1.0E-9, this.bulkSolventRowLoops[i].getTimePerThread() / bulkSolventRowTotal * 100.0, this.bulkSolventRowLoops[i].getTimePerThread() / bulkSolventRowTotal * (100.0 * (double)this.threadCount), this.bulkSolventRowLoops[i].getBoundsPerThread()[i], this.bulkSolventRowLoops[i].getWeightPerThread()[i], 100.0 * ((double)this.bulkSolventRowLoops[i].getWeightPerThread()[i] / bulkSolventRowWeightTotal), 100.0 * (double)this.threadCount * ((double)this.bulkSolventRowLoops[i].getWeightPerThread()[i] / bulkSolventRowWeightTotal)));
                    }
                    bulkSB.append(String.format("    Min      %7.5f\n", bulkSolventRowMin * 1.0E-9));
                    bulkSB.append(String.format("    Max      %7.5f\n", bulkSolventRowMax * 1.0E-9));
                    bulkSB.append(String.format("    Delta    %7.5f\n", (bulkSolventRowMax - bulkSolventRowMin) * 1.0E-9));
                    logger.info(bulkSB.toString());
                    break;
                }
                case SPATIAL: {
                    break;
                }
                case SLICE: {
                    int i;
                    double solventSliceTotal = 0.0;
                    double solventSliceMin = this.solventSliceLoops[0].getThreadTime();
                    double solventSliceMax = 0.0;
                    double solventSliceWeightTotal = 0.0;
                    double bulkSolventSliceTotal = 0.0;
                    double bulkSolventSliceMin = this.bulkSolventSliceLoops[0].getTimePerThread();
                    double bulkSolventSliceMax = 0.0;
                    double bulkSolventSliceWeightTotal = 0.0;
                    for (i = 0; i < this.threadCount; ++i) {
                        solventSliceTotal += this.solventSliceLoops[i].getThreadTime();
                        solventSliceMax = FastMath.max((double)this.solventSliceLoops[i].getThreadTime(), (double)solventSliceMax);
                        solventSliceMin = FastMath.min((double)this.solventSliceLoops[i].getThreadTime(), (double)solventSliceMin);
                        solventSliceWeightTotal += (double)this.solventSliceLoops[i].getThreadWeight();
                        bulkSolventSliceTotal += this.bulkSolventSliceLoops[i].getTimePerThread();
                        bulkSolventSliceMax = FastMath.max((double)this.bulkSolventSliceLoops[i].getTimePerThread(), (double)bulkSolventSliceMax);
                        bulkSolventSliceMin = FastMath.min((double)this.bulkSolventSliceLoops[i].getTimePerThread(), (double)bulkSolventSliceMin);
                        bulkSolventSliceWeightTotal += (double)this.bulkSolventSliceLoops[i].getWeightPerThread()[i];
                    }
                    solventSB.append(String.format("\n SliceLoop (Solvent): %7.5f (sec)              | Total Weight: %7.0f\n", (double)solventGridTime * 1.0E-9, solventSliceWeightTotal));
                    solventSB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Slices    Weight     Balance(%)  Normalized\n");
                    if (solventSliceWeightTotal == 0.0) {
                        solventSliceWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        solventSB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.solventSliceLoops[i].getThreadTime() * 1.0E-9, this.solventSliceLoops[i].getThreadTime() / solventSliceTotal * 100.0, this.solventSliceLoops[i].getThreadTime() / solventSliceTotal * (100.0 * (double)this.threadCount), this.solventSliceLoops[i].getNumberofSlices(), this.solventSliceLoops[i].getThreadWeight(), 100.0 * ((double)this.solventSliceLoops[i].getThreadWeight() / solventSliceWeightTotal), 100.0 * (double)this.threadCount * ((double)this.solventSliceLoops[i].getThreadWeight() / solventSliceWeightTotal)));
                    }
                    solventSB.append(String.format("    Min      %7.5f\n", solventSliceMin * 1.0E-9));
                    solventSB.append(String.format("    Max      %7.5f\n", solventSliceMax * 1.0E-9));
                    solventSB.append(String.format("    Delta    %7.5f\n", (solventSliceMax - solventSliceMin) * 1.0E-9));
                    logger.info(solventSB.toString());
                    bulkSB.append(String.format(" SliceLoop (Bulk Solvent): %7.5f (sec)         | Total Weight: %7.0f\n", bulkSolventSliceTotal * 1.0E-9, bulkSolventSliceWeightTotal));
                    bulkSB.append(" Thread     LoopTime    Balance(%)  Normalized   |      Slices     Weight     Balance(%)  Normalized\n");
                    if (bulkSolventSliceWeightTotal == 0.0) {
                        bulkSolventSliceWeightTotal = 1.0;
                    }
                    for (i = 0; i < this.threadCount; ++i) {
                        bulkSB.append(String.format("     %3d     %7.5f     %7.1f     %7.1f     |   %7d     %7d     %7.1f     %7.1f\n", i, this.bulkSolventSliceLoops[i].getTimePerThread() * 1.0E-9, this.bulkSolventSliceLoops[i].getTimePerThread() / bulkSolventSliceTotal * 100.0, this.bulkSolventSliceLoops[i].getTimePerThread() / bulkSolventSliceTotal * (100.0 * (double)this.threadCount), this.bulkSolventSliceLoops[i].getBoundsPerThread()[i], this.bulkSolventSliceLoops[i].getWeightPerThread()[i], 100.0 * ((double)this.bulkSolventSliceLoops[i].getWeightPerThread()[i] / bulkSolventSliceWeightTotal), 100.0 * (double)this.threadCount * ((double)this.bulkSolventSliceLoops[i].getWeightPerThread()[i] / bulkSolventSliceWeightTotal)));
                    }
                    bulkSB.append(String.format("    Min      %7.5f\n", bulkSolventSliceMin * 1.0E-9));
                    bulkSB.append(String.format("    Max      %7.5f\n", bulkSolventSliceMax * 1.0E-9));
                    bulkSB.append(String.format("    Delta    %7.5f\n", (bulkSolventSliceMax - bulkSolventSliceMin) * 1.0E-9));
                    logger.info(bulkSB.toString());
                    break;
                }
            }
        }
    }

    private class SolventGradientRegion
    extends ParallelRegion {
        private final SolventGradientLoop[] solventGradientLoop;
        private RefinementMode refinementmode;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public SolventGradientRegion(CrystalReciprocalSpace crystalReciprocalSpace, RefinementMode refinementmode) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.refinementmode = refinementmode;
            this.solventGradientLoop = new SolventGradientLoop[crystalReciprocalSpace.threadCount];
            for (int i = 0; i < crystalReciprocalSpace.threadCount; ++i) {
                this.solventGradientLoop[i] = new SolventGradientLoop(this);
            }
        }

        public RefinementMode getRefinementMode() {
            return this.refinementmode;
        }

        public void setRefinementMode(RefinementMode refinementmode) {
            this.refinementmode = refinementmode;
        }

        public void run() {
            try {
                this.execute(0, this.this$0.nScatteringAtoms - 1, this.solventGradientLoop[this.getThreadIndex()]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        private class SolventGradientLoop
        extends IntegerForLoop {
            double[] xyz;
            double[] uvw;
            double[] xc;
            double[] xf;
            final /* synthetic */ SolventGradientRegion this$1;

            private SolventGradientLoop(SolventGradientRegion solventGradientRegion) {
                SolventGradientRegion solventGradientRegion2 = solventGradientRegion;
                Objects.requireNonNull(solventGradientRegion2);
                this.this$1 = solventGradientRegion2;
                this.xyz = new double[3];
                this.uvw = new double[3];
                this.xc = new double[3];
                this.xf = new double[3];
            }

            public void run(int lb, int ub) {
                for (int n = lb; n <= ub; ++n) {
                    if (!this.this$1.this$0.scatteringAtoms[n].getUse() && !this.this$1.this$0.nativeEnvironmentApproximation || this.this$1.this$0.lambdaTerm && this.this$1.this$0.scatteringAtoms[n].applyLambda()) continue;
                    this.xyz[0] = this.this$1.this$0.coordinates[0][0][n];
                    this.xyz[1] = this.this$1.this$0.coordinates[0][1][n];
                    this.xyz[2] = this.this$1.this$0.coordinates[0][2][n];
                    FormFactor solventff = this.this$1.this$0.solventFormFactors[0][n];
                    solventff.update(this.xyz);
                    this.this$1.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double vdwr = this.this$1.this$0.scatteringAtoms[n].getVDWType().radius * 0.5;
                    double dfcmult = 1.0;
                    int dfrad = this.this$1.this$0.aRadGrid;
                    switch (this.this$1.this$0.solventModel) {
                        case BINARY: {
                            dfrad = Math.min(this.this$1.this$0.aRadGrid, (int)Math.floor((vdwr + this.this$1.this$0.solventA + 0.2) * (double)this.this$1.this$0.fftX / this.this$1.this$0.crystal.a) + 1);
                            break;
                        }
                        case GAUSSIAN: {
                            dfrad = Math.min(this.this$1.this$0.aRadGrid, (int)Math.floor((vdwr * this.this$1.this$0.solventB + 2.0) * (double)this.this$1.this$0.fftX / this.this$1.this$0.crystal.a) + 1);
                            dfcmult = this.this$1.this$0.solventA;
                            break;
                        }
                        case POLYNOMIAL: {
                            dfrad = Math.min(this.this$1.this$0.aRadGrid, (int)Math.floor((vdwr + this.this$1.this$0.solventB + 0.2) * (double)this.this$1.this$0.fftX / this.this$1.this$0.crystal.a) + 1);
                            break;
                        }
                        case NONE: {
                            return;
                        }
                    }
                    double frx = (double)this.this$1.this$0.fftX * this.uvw[0];
                    int ifrx = (int)frx;
                    int ifrxu = ifrx + dfrad;
                    double fry = (double)this.this$1.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    int ifryu = ifry + dfrad;
                    double frz = (double)this.this$1.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    int ifrzu = ifrz + dfrad;
                    for (int ix = ifrx - dfrad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$1.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$1.this$0.ifftX;
                        for (int iy = ifry - dfrad; iy <= ifryu; ++iy) {
                            int giy = ScalarMath.mod((int)iy, (int)this.this$1.this$0.fftY);
                            this.xf[1] = (double)iy * this.this$1.this$0.ifftY;
                            for (int iz = ifrz - dfrad; iz <= ifrzu; ++iz) {
                                int giz = ScalarMath.mod((int)iz, (int)this.this$1.this$0.fftZ);
                                this.xf[2] = (double)iz * this.this$1.this$0.ifftZ;
                                this.this$1.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                                int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                solventff.rhoGrad(this.xc, this.this$1.this$0.weight * this.this$1.this$0.getDensityGrid()[ii] * dfcmult * this.this$1.this$0.getSolventGrid()[ii], this.this$1.refinementmode);
                            }
                        }
                    }
                }
            }
        }
    }

    private class AtomicGradientRegion
    extends ParallelRegion {
        private final AtomicGradientLoop[] atomicGradientLoop;
        private RefinementMode refinementmode;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public AtomicGradientRegion(CrystalReciprocalSpace crystalReciprocalSpace, RefinementMode refinementmode) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.refinementmode = refinementmode;
            this.atomicGradientLoop = new AtomicGradientLoop[crystalReciprocalSpace.threadCount];
            for (int i = 0; i < crystalReciprocalSpace.threadCount; ++i) {
                this.atomicGradientLoop[i] = new AtomicGradientLoop(this);
            }
        }

        public RefinementMode getRefinementMode() {
            return this.refinementmode;
        }

        public void setRefinementMode(RefinementMode refinementmode) {
            this.refinementmode = refinementmode;
        }

        public void run() {
            try {
                this.execute(0, this.this$0.nScatteringAtoms - 1, this.atomicGradientLoop[this.getThreadIndex()]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        private class AtomicGradientLoop
        extends IntegerForLoop {
            final double[] xyz;
            final double[] uvw;
            final double[] xc;
            final double[] xf;
            final int[] optLocal;
            long timer;
            final /* synthetic */ AtomicGradientRegion this$1;

            private AtomicGradientLoop(AtomicGradientRegion atomicGradientRegion) {
                AtomicGradientRegion atomicGradientRegion2 = atomicGradientRegion;
                Objects.requireNonNull(atomicGradientRegion2);
                this.this$1 = atomicGradientRegion2;
                this.xyz = new double[3];
                this.uvw = new double[3];
                this.xc = new double[3];
                this.xf = new double[3];
                this.optLocal = new int[this.this$1.this$0.nScatteringAtoms];
            }

            public void finish() {
                this.timer += System.nanoTime();
                for (int i = 0; i < this.this$1.this$0.nScatteringAtoms; ++i) {
                    this.this$1.this$0.optAtomicGradientWeight.addAndGet(i, this.optLocal[i]);
                }
            }

            public void run(int lb, int ub) {
                for (int n = lb; n <= ub; ++n) {
                    if (!this.this$1.this$0.scatteringAtoms[n].getUse() && !this.this$1.this$0.nativeEnvironmentApproximation || this.this$1.this$0.lambdaTerm && this.this$1.this$0.scatteringAtoms[n].applyLambda()) continue;
                    this.xyz[0] = this.this$1.this$0.coordinates[0][0][n];
                    this.xyz[1] = this.this$1.this$0.coordinates[0][1][n];
                    this.xyz[2] = this.this$1.this$0.coordinates[0][2][n];
                    FormFactor atomff = this.this$1.this$0.atomFormFactors[0][n];
                    atomff.update(this.xyz, 0.0);
                    this.this$1.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    int dfrad = Math.min(this.this$1.this$0.aRadGrid, (int)Math.floor(this.this$1.this$0.scatteringAtoms[n].getFormFactorWidth() * (double)this.this$1.this$0.fftX / this.this$1.this$0.crystal.a) + 1);
                    double frx = (double)this.this$1.this$0.fftX * this.uvw[0];
                    int ifrx = (int)frx;
                    double fry = (double)this.this$1.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    double frz = (double)this.this$1.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    for (int ix = ifrx - dfrad; ix <= ifrx + dfrad; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$1.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$1.this$0.ifftX;
                        for (int iy = ifry - dfrad; iy <= ifry + dfrad; ++iy) {
                            int giy = ScalarMath.mod((int)iy, (int)this.this$1.this$0.fftY);
                            this.xf[1] = (double)iy * this.this$1.this$0.ifftY;
                            for (int iz = ifrz - dfrad; iz <= ifrz + dfrad; ++iz) {
                                int giz = ScalarMath.mod((int)iz, (int)this.this$1.this$0.fftZ);
                                this.xf[2] = (double)iz * this.this$1.this$0.ifftZ;
                                this.this$1.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                                int n2 = n;
                                this.optLocal[n2] = this.optLocal[n2] + 1;
                                int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                atomff.rhoGrad(this.xc, this.this$1.this$0.weight * this.this$1.this$0.getDensityGrid()[ii], this.this$1.refinementmode);
                            }
                        }
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.atomicGradientSchedule;
            }

            public void start() {
                Arrays.fill(this.optLocal, 0);
                this.timer = -System.nanoTime();
            }
        }
    }

    private class AtomicSliceLoop
    extends SliceLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int previousUB;
        int previousLB;
        int actualWeight;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public AtomicSliceLoop(CrystalReciprocalSpace crystalReciprocalSpace, SliceRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ];
        }

        public void buildList(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            int ifrzl = ifrz - frad;
            int buff = 3;
            for (int iz = ifrzl - buff; iz <= ifrzu + buff; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (giz < lb || giz > ub) continue;
                this.buildListA.add(iAtom);
                this.buildListS.add(iSymm);
                break;
            }
        }

        public boolean checkList(int[][] zAtListBuild, int buff) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    if (!this.sliceRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    int previousZ = zAtListBuild[iSymm][iAtom];
                    if (FastMath.abs((int)(ifrz - previousZ)) < buff) continue;
                    return true;
                }
            }
            return false;
        }

        public void finish() {
            for (int i = 0; i < this.this$0.fftZ; ++i) {
                this.this$0.optSliceWeightAtomic.addAndGet(i, this.optLocal[i]);
            }
            this.timer += System.nanoTime();
        }

        public int getNumberofSlices() {
            return this.previousUB - this.previousLB + 1;
        }

        public double getThreadTime() {
            return this.timer;
        }

        public int getThreadWeight() {
            return this.actualWeight;
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor atomff = this.this$0.atomFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lb > giz || giz > ub) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = giz;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        ++this.actualWeight;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = atomff.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public void run(int lb, int ub) throws Exception {
            boolean boundsChange = false;
            if (this.previousLB != lb || this.previousUB != ub) {
                boundsChange = true;
            }
            this.previousLB = lb;
            this.previousUB = ub;
            if (this.rebuildList || boundsChange) {
                this.buildListA = new ArrayList();
                this.buildListS = new ArrayList();
                for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                    for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                        if (!this.sliceRegion.select[iSymm][iAtom]) continue;
                        this.buildList(iSymm, iAtom, lb, ub);
                    }
                }
            }
            for (int i = 0; i < this.buildListA.size(); ++i) {
                if (!this.sliceRegion.select[(Integer)this.buildListS.get(i)][(Integer)this.buildListA.get(i)]) continue;
                this.gridDensity((Integer)this.buildListS.get(i), (Integer)this.buildListA.get(i), lb, ub);
            }
        }

        public void saveZValues(int[][] zAtListBuild) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    int ifrz;
                    zAtListBuild[iSymm][iAtom] = 0;
                    if (!this.sliceRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    zAtListBuild[iSymm][iAtom] = ifrz = (int)frz;
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.atomicSliceSchedule;
        }

        public void start() {
            Arrays.fill(this.optLocal, 0);
            this.actualWeight = 0;
            this.timer = -System.nanoTime();
        }
    }

    private class AtomicRowLoop
    extends RowLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int previousUB;
        int previousLB;
        int actualWeight;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        AtomicRowLoop(CrystalReciprocalSpace crystalReciprocalSpace, RowRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ * crystalReciprocalSpace.fftY];
        }

        public void buildList(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            int ifrzl = ifrz - frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            int ifryl = ifry - frad;
            int buff = 3;
            int lbZ = this.rowRegion.zFromRowIndex(lb);
            int ubZ = this.rowRegion.zFromRowIndex(ub);
            for (int iz = ifrzl - buff; iz <= ifrzu + buff; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lbZ > giz || giz > ubZ) continue;
                int rowLB = this.rowRegion.rowIndexForYZ(ScalarMath.mod((int)(ifryl - buff), (int)this.this$0.fftY), giz);
                int rowUB = this.rowRegion.rowIndexForYZ(ScalarMath.mod((int)(ifryu + buff), (int)this.this$0.fftY), giz);
                if (lb < rowLB && rowUB > ub) continue;
                this.buildListA.add(iAtom);
                this.buildListS.add(iSymm);
                break;
            }
        }

        public boolean checkList(int[][][] zyAtListBuild, int buff) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    if (!this.rowRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    int previousZ = zyAtListBuild[iSymm][iAtom][0];
                    double fry = (double)this.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    int previousY = zyAtListBuild[iSymm][iAtom][1];
                    if (FastMath.abs((int)(ifrz - previousZ)) < buff && FastMath.abs((int)(ifry - previousY)) < buff) continue;
                    return true;
                }
            }
            return false;
        }

        public void finish() {
            for (int i = 0; i < this.this$0.fftZ * this.this$0.fftY; ++i) {
                this.this$0.optRowWeightAtomic.addAndGet(i, this.optLocal[i]);
            }
            this.timer += System.nanoTime();
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            int lbZ = this.rowRegion.zFromRowIndex(lb);
            int ubZ = this.rowRegion.zFromRowIndex(ub);
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor atomff = this.this$0.atomFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lbZ > giz || giz > ubZ) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    int rowIndex = this.rowRegion.rowIndexForYZ(giy, giz);
                    if (lb > rowIndex || rowIndex > ub) continue;
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = rowIndex;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        ++this.actualWeight;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = atomff.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public void run(int lb, int ub) throws Exception {
            boolean boundsChange = false;
            if (this.previousLB != lb || this.previousUB != ub) {
                boundsChange = true;
            }
            this.previousLB = lb;
            this.previousUB = ub;
            if (this.rebuildList || boundsChange) {
                this.buildListA = new ArrayList();
                this.buildListS = new ArrayList();
                for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                    for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                        if (!this.rowRegion.select[iSymm][iAtom]) continue;
                        this.buildList(iSymm, iAtom, lb, ub);
                    }
                }
            }
            for (int i = 0; i < this.buildListA.size(); ++i) {
                if (!this.rowRegion.select[(Integer)this.buildListS.get(i)][(Integer)this.buildListA.get(i)]) continue;
                this.gridDensity((Integer)this.buildListS.get(i), (Integer)this.buildListA.get(i), lb, ub);
            }
        }

        public void saveZYValues(int[][][] zyAtListBuild) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    zyAtListBuild[iSymm][iAtom][0] = 0;
                    zyAtListBuild[iSymm][iAtom][1] = 0;
                    if (!this.rowRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    double fry = (double)this.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    zyAtListBuild[iSymm][iAtom][0] = ifrz;
                    zyAtListBuild[iSymm][iAtom][1] = ifry;
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.atomicRowSchedule;
        }

        public void start() {
            Arrays.fill(this.optLocal, 0);
            this.actualWeight = 0;
            this.timer = -System.nanoTime();
        }

        double getThreadTime() {
            return this.timer;
        }

        int getNumberofSlices() {
            return this.previousUB - this.previousLB + 1;
        }

        int getThreadWeight() {
            return this.actualWeight;
        }
    }

    private class SolventDensityLoop
    extends SpatialDensityLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        SolventDensityLoop(CrystalReciprocalSpace crystalReciprocalSpace, SpatialDensityRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region, region.getNsymm(), region.actualCount);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
        }

        public void gridDensity(int iSymm, int n) {
            if (!this.this$0.scatteringAtoms[n].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[n].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][n];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][n];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][n];
            FormFactor solventff = this.this$0.solventFormFactors[iSymm][n];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            double vdwr = this.this$0.scatteringAtoms[n].getVDWType().radius * 0.5;
            int frad = this.this$0.aRadGrid;
            switch (this.this$0.solventModel) {
                case BINARY: {
                    frad = Math.min(this.this$0.aRadGrid, (int)Math.floor((vdwr + this.this$0.solventA + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a) + 1);
                    break;
                }
                case GAUSSIAN: {
                    frad = Math.min(this.this$0.aRadGrid, (int)Math.floor((vdwr * this.this$0.solventB + 2.0) * (double)this.this$0.fftX / this.this$0.crystal.a) + 1);
                    break;
                }
                case POLYNOMIAL: {
                    frad = Math.min(this.this$0.aRadGrid, (int)Math.floor((vdwr + this.this$0.solventB + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a) + 1);
                    break;
                }
                default: {
                    return;
                }
            }
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = solventff.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }
    }

    private class BulkSolventSliceLoop
    extends SliceLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int[] threadBounds;
        int[] threadWeights;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public BulkSolventSliceLoop(CrystalReciprocalSpace crystalReciprocalSpace, SliceRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ];
        }

        public void finish() {
            int i;
            this.timer += System.nanoTime();
            for (i = 0; i < this.this$0.fftZ; ++i) {
                this.this$0.optSliceWeightBulkSolvent.addAndGet(i, this.optLocal[i]);
            }
            this.threadBounds = (int[])this.this$0.bulkSolventSliceSchedule.getLowerBounds().clone();
            this.threadWeights = (int[])this.this$0.bulkSolventSliceSchedule.getThreadWeights().clone();
            for (i = this.threadBounds.length - 1; i > 0; --i) {
                int n = i;
                this.threadBounds[n] = this.threadBounds[n] - this.threadBounds[i - 1];
            }
        }

        public int[] getBoundsPerThread() {
            return this.threadBounds;
        }

        public double getTimePerThread() {
            return this.timer;
        }

        public int[] getWeightPerThread() {
            return this.threadWeights;
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor formFactor = this.this$0.solventFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            double vdwr = this.this$0.scatteringAtoms[iAtom].getVDWType().radius * 0.5;
            int frad = this.this$0.aRadGrid;
            switch (this.this$0.solventModel) {
                case BINARY: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventA + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case GAUSSIAN: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr * this.this$0.solventB + 2.0) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case POLYNOMIAL: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventB + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                default: {
                    return;
                }
            }
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lb > giz || giz > ub) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = giz;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = formFactor.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.bulkSolventSliceSchedule;
        }

        public void start() {
            Arrays.fill(this.optLocal, 0);
            this.timer = -System.nanoTime();
        }
    }

    private class SolventSliceLoop
    extends SliceLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int previousUB;
        int previousLB;
        int actualWeight;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public SolventSliceLoop(CrystalReciprocalSpace crystalReciprocalSpace, SliceRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ];
        }

        public void buildList(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            int ifrzl = ifrz - frad;
            int buff = 3;
            for (int iz = ifrzl - buff; iz <= ifrzu + buff; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (giz < lb || giz > ub) continue;
                this.buildListA.add(iAtom);
                this.buildListS.add(iSymm);
                break;
            }
        }

        public boolean checkList(int[][] zAtListBuild, int buff) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    if (!this.sliceRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    int previousZ = zAtListBuild[iSymm][iAtom];
                    if (FastMath.abs((int)(ifrz - previousZ)) < buff) continue;
                    return true;
                }
            }
            return false;
        }

        public void finish() {
            this.timer += System.nanoTime();
            for (int i = 0; i < this.this$0.fftZ; ++i) {
                this.this$0.optSliceWeightSolvent.addAndGet(i, this.optLocal[i]);
            }
        }

        public int getNumberofSlices() {
            return this.previousUB - this.previousLB + 1;
        }

        public double getThreadTime() {
            return this.timer;
        }

        public int getThreadWeight() {
            return this.actualWeight;
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor formFactor = this.this$0.solventFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            double vdwr = this.this$0.scatteringAtoms[iAtom].getVDWType().radius * 0.5;
            int frad = this.this$0.aRadGrid;
            switch (this.this$0.solventModel) {
                case BINARY: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventA + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case GAUSSIAN: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr * this.this$0.solventB + 2.0) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case POLYNOMIAL: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventB + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                default: {
                    return;
                }
            }
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lb > giz || giz > ub) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = giz;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        ++this.actualWeight;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = formFactor.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public void run(int lb, int ub) throws Exception {
            boolean boundsChange = false;
            if (this.previousLB != lb || this.previousUB != ub) {
                boundsChange = true;
            }
            this.previousLB = lb;
            this.previousUB = ub;
            if (this.rebuildList || boundsChange) {
                this.buildListA = new ArrayList();
                this.buildListS = new ArrayList();
                for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                    for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                        if (!this.sliceRegion.select[iSymm][iAtom]) continue;
                        this.buildList(iSymm, iAtom, lb, ub);
                    }
                }
            }
            for (int i = 0; i < this.buildListA.size(); ++i) {
                if (!this.sliceRegion.select[(Integer)this.buildListS.get(i)][(Integer)this.buildListA.get(i)]) continue;
                this.gridDensity((Integer)this.buildListS.get(i), (Integer)this.buildListA.get(i), lb, ub);
            }
        }

        public void saveZValues(int[][] zAtListBuild) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    int ifrz;
                    zAtListBuild[iSymm][iAtom] = 0;
                    if (!this.sliceRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    zAtListBuild[iSymm][iAtom] = ifrz = (int)frz;
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.solventSliceSchedule;
        }

        public void start() {
            Arrays.fill(this.optLocal, 0);
            this.actualWeight = 0;
            this.timer = -System.nanoTime();
        }
    }

    private class BulkSolventRowLoop
    extends RowLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int[] threadWeights;
        int[] threadBounds;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public BulkSolventRowLoop(CrystalReciprocalSpace crystalReciprocalSpace, RowRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ * crystalReciprocalSpace.fftY];
        }

        public void finish() {
            int i;
            for (i = 0; i < this.this$0.fftZ * this.this$0.fftY; ++i) {
                this.this$0.optRowWeightBulkSolvent.addAndGet(i, this.optLocal[i]);
            }
            this.timer += System.nanoTime();
            this.threadBounds = (int[])this.this$0.bulkSolventRowSchedule.getLowerBounds().clone();
            this.threadWeights = (int[])this.this$0.bulkSolventRowSchedule.getThreadWeights().clone();
            for (i = this.this$0.threadCount - 1; i > 0; --i) {
                int n = i;
                this.threadWeights[n] = this.threadWeights[n] - this.threadWeights[i - 1];
            }
        }

        public int[] getBoundsPerThread() {
            return this.threadBounds;
        }

        public double getTimePerThread() {
            return this.timer;
        }

        public int[] getWeightPerThread() {
            return this.optLocal;
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor formFactor = this.this$0.solventFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            double vdwr = this.this$0.scatteringAtoms[iAtom].getVDWType().radius * 0.5;
            int frad = this.this$0.aRadGrid;
            switch (this.this$0.solventModel) {
                case BINARY: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventA + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case GAUSSIAN: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr * this.this$0.solventB + 2.0) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case POLYNOMIAL: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventB + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                default: {
                    return;
                }
            }
            int ubZ = this.rowRegion.zFromRowIndex(ub);
            int lbZ = this.rowRegion.zFromRowIndex(lb);
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lbZ > giz || giz > ubZ) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    int rowIndex = this.rowRegion.rowIndexForYZ(giy, giz);
                    if (lb > rowIndex || rowIndex > ub) continue;
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = rowIndex;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = formFactor.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.bulkSolventRowSchedule;
        }

        public void start() {
            this.timer = -System.nanoTime();
            Arrays.fill(this.optLocal, 0);
        }
    }

    private class SolventRowLoop
    extends RowLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final int[] optLocal;
        long timer;
        int previousUB;
        int previousLB;
        int actualWeight;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public SolventRowLoop(CrystalReciprocalSpace crystalReciprocalSpace, RowRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region.getNatoms(), region.getNsymm(), region);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
            this.optLocal = new int[crystalReciprocalSpace.fftZ * crystalReciprocalSpace.fftY];
        }

        public void buildList(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)(this.this$0.scatteringAtoms[iAtom].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            int ifrzl = ifrz - frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            int ifryl = ifry - frad;
            int buff = 3;
            int lbZ = this.rowRegion.zFromRowIndex(lb);
            int ubZ = this.rowRegion.zFromRowIndex(ub);
            for (int iz = ifrzl - buff; iz <= ifrzu + buff; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lbZ > giz || giz > ubZ) continue;
                int rowLB = this.rowRegion.rowIndexForYZ(ScalarMath.mod((int)(ifryl - buff), (int)this.this$0.fftY), giz);
                int rowUB = this.rowRegion.rowIndexForYZ(ScalarMath.mod((int)(ifryu + buff), (int)this.this$0.fftY), giz);
                if (lb < rowLB && rowUB > ub) continue;
                this.buildListA.add(iAtom);
                this.buildListS.add(iSymm);
                break;
            }
        }

        public boolean checkList(int[][][] zyAtListBuild, int buff) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    if (!this.rowRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    int previousZ = zyAtListBuild[iSymm][iAtom][0];
                    double fry = (double)this.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    int previousY = zyAtListBuild[iSymm][iAtom][1];
                    if (FastMath.abs((int)(ifrz - previousZ)) < buff && FastMath.abs((int)(ifry - previousY)) < buff) continue;
                    return true;
                }
            }
            return false;
        }

        public void finish() {
            this.timer += System.nanoTime();
            for (int i = 0; i < this.this$0.fftZ * this.this$0.fftY; ++i) {
                this.this$0.optRowWeightSolvent.addAndGet(i, this.optLocal[i]);
            }
        }

        public int getNumberofSlices() {
            return this.previousUB - this.previousLB + 1;
        }

        public double getThreadTime() {
            return this.timer;
        }

        public int getThreadWeight() {
            return this.actualWeight;
        }

        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (!this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[iAtom].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
            FormFactor formFactor = this.this$0.solventFormFactors[iSymm][iAtom];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            double vdwr = this.this$0.scatteringAtoms[iAtom].getVDWType().radius * 0.5;
            int frad = this.this$0.aRadGrid;
            switch (this.this$0.solventModel) {
                case BINARY: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventA + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case GAUSSIAN: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr * this.this$0.solventB + 2.0) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                case POLYNOMIAL: {
                    frad = FastMath.min((int)this.this$0.aRadGrid, (int)((int)FastMath.floor((double)((vdwr + this.this$0.solventB + 0.2) * (double)this.this$0.fftX / this.this$0.crystal.a)) + 1));
                    break;
                }
                default: {
                    return;
                }
            }
            int ubZ = this.rowRegion.zFromRowIndex(ub);
            int lbZ = this.rowRegion.zFromRowIndex(lb);
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                if (lbZ > giz || giz > ubZ) continue;
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    int rowIndex = this.rowRegion.rowIndexForYZ(giy, giz);
                    if (lb > rowIndex || rowIndex > ub) continue;
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int n = rowIndex;
                        this.optLocal[n] = this.optLocal[n] + 1;
                        ++this.actualWeight;
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = formFactor.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }

        public void run(int lb, int ub) throws Exception {
            boolean boundsChange = false;
            if (this.previousLB != lb || this.previousUB != ub) {
                boundsChange = true;
            }
            this.previousLB = lb;
            this.previousUB = ub;
            if (this.rebuildList || boundsChange) {
                this.buildListA = new ArrayList();
                this.buildListS = new ArrayList();
                for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                    for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                        if (!this.rowRegion.select[iSymm][iAtom]) continue;
                        this.buildList(iSymm, iAtom, lb, ub);
                    }
                }
            }
            for (int i = 0; i < this.buildListA.size(); ++i) {
                if (!this.rowRegion.select[(Integer)this.buildListS.get(i)][(Integer)this.buildListA.get(i)]) continue;
                this.gridDensity((Integer)this.buildListS.get(i), (Integer)this.buildListA.get(i), lb, ub);
            }
        }

        public void saveZYValues(int[][][] zyAtListBuild) {
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int iAtom = 0; iAtom < this.this$0.nScatteringAtoms; ++iAtom) {
                    zyAtListBuild[iSymm][iAtom][0] = 0;
                    zyAtListBuild[iSymm][iAtom][1] = 0;
                    if (!this.rowRegion.select[iSymm][iAtom] || !this.this$0.scatteringAtoms[iAtom].getUse() && !this.this$0.nativeEnvironmentApproximation) continue;
                    this.xyz[0] = this.this$0.coordinates[iSymm][0][iAtom];
                    this.xyz[1] = this.this$0.coordinates[iSymm][1][iAtom];
                    this.xyz[2] = this.this$0.coordinates[iSymm][2][iAtom];
                    this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
                    double frz = (double)this.this$0.fftZ * this.uvw[2];
                    int ifrz = (int)frz;
                    double fry = (double)this.this$0.fftY * this.uvw[1];
                    int ifry = (int)fry;
                    zyAtListBuild[iSymm][iAtom][0] = ifrz;
                    zyAtListBuild[iSymm][iAtom][1] = ifry;
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.solventRowSchedule;
        }

        public void start() {
            Arrays.fill(this.optLocal, 0);
            this.timer = -System.nanoTime();
        }
    }

    private class AtomicDensityLoop
    extends SpatialDensityLoop {
        final double[] xyz;
        final double[] uvw;
        final double[] xc;
        final double[] xf;
        final double[] grid;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        AtomicDensityLoop(CrystalReciprocalSpace crystalReciprocalSpace, SpatialDensityRegion region) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            super(region, region.getNsymm(), region.actualCount);
            this.xyz = new double[3];
            this.uvw = new double[3];
            this.xc = new double[3];
            this.xf = new double[3];
            this.grid = region.getGrid();
        }

        public void gridDensity(int iSymm, int n) {
            if (!this.this$0.scatteringAtoms[n].getUse() && !this.this$0.nativeEnvironmentApproximation) {
                return;
            }
            if (this.this$0.lambdaTerm && this.this$0.scatteringAtoms[n].applyLambda()) {
                return;
            }
            this.xyz[0] = this.this$0.coordinates[iSymm][0][n];
            this.xyz[1] = this.this$0.coordinates[iSymm][1][n];
            this.xyz[2] = this.this$0.coordinates[iSymm][2][n];
            FormFactor atomff = this.this$0.atomFormFactors[iSymm][n];
            this.this$0.crystal.toFractionalCoordinates(this.xyz, this.uvw);
            int frad = Math.min(this.this$0.aRadGrid, (int)Math.floor(this.this$0.scatteringAtoms[n].getFormFactorWidth() * (double)this.this$0.fftX / this.this$0.crystal.a) + 1);
            double frx = (double)this.this$0.fftX * this.uvw[0];
            int ifrx = (int)frx;
            int ifrxu = ifrx + frad;
            double fry = (double)this.this$0.fftY * this.uvw[1];
            int ifry = (int)fry;
            int ifryu = ifry + frad;
            double frz = (double)this.this$0.fftZ * this.uvw[2];
            int ifrz = (int)frz;
            int ifrzu = ifrz + frad;
            for (int iz = ifrz - frad; iz <= ifrzu; ++iz) {
                int giz = ScalarMath.mod((int)iz, (int)this.this$0.fftZ);
                this.xf[2] = (double)iz * this.this$0.ifftZ;
                for (int iy = ifry - frad; iy <= ifryu; ++iy) {
                    int giy = ScalarMath.mod((int)iy, (int)this.this$0.fftY);
                    this.xf[1] = (double)iy * this.this$0.ifftY;
                    for (int ix = ifrx - frad; ix <= ifrxu; ++ix) {
                        int gix = ScalarMath.mod((int)ix, (int)this.this$0.fftX);
                        this.xf[0] = (double)ix * this.this$0.ifftX;
                        this.this$0.crystal.toCartesianCoordinates(this.xf, this.xc);
                        int ii = Complex3D.interleavedIndex((int)gix, (int)giy, (int)giz, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        this.grid[ii] = atomff.rho(this.grid[ii], 1.0, this.xc);
                    }
                }
            }
        }
    }

    private class ExtractRegion
    extends ParallelRegion {
        ExtractLoop[] extractLoops;
        int nHKL;
        double[][] hkldata;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public ExtractRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.nHKL = this.this$0.reflectionList.hklList.size();
            this.hkldata = null;
            this.extractLoops = new ExtractLoop[nThreads];
        }

        public void run() throws Exception {
            int ti = this.getThreadIndex();
            if (this.extractLoops[ti] == null) {
                this.extractLoops[ti] = new ExtractLoop(this);
            }
            try {
                this.execute(0, this.nHKL - 1, this.extractLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void setHKL(double[][] hkldata) {
            this.hkldata = hkldata;
        }

        private class ExtractLoop
        extends IntegerForLoop {
            ComplexNumber c;
            int nsym;
            List<SymOp> symops;
            HKL ij;
            final /* synthetic */ ExtractRegion this$1;

            public ExtractLoop(ExtractRegion extractRegion) {
                ExtractRegion extractRegion2 = extractRegion;
                Objects.requireNonNull(extractRegion2);
                this.this$1 = extractRegion2;
                this.c = new ComplexNumber();
                this.nsym = extractRegion.this$0.crystal.spaceGroup.symOps.size();
                this.symops = extractRegion.this$0.crystal.spaceGroup.symOps;
                this.ij = new HKL();
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    HKL ih = (HKL)this.this$1.this$0.reflectionList.hklList.get(i);
                    double[] fc = this.this$1.hkldata[ih.getIndex()];
                    for (int j = 0; j < this.nsym; ++j) {
                        SymOp symOp = this.symops.get(j);
                        SymOp.applyTransSymRot((HKL)ih, (HKL)this.ij, (SymOp)symOp);
                        double shift = symOp.symPhaseShift(ih);
                        int h = ScalarMath.mod((int)this.ij.getH(), (int)this.this$1.this$0.fftX);
                        int k = ScalarMath.mod((int)this.ij.getK(), (int)this.this$1.this$0.fftY);
                        int l = ScalarMath.mod((int)this.ij.getL(), (int)this.this$1.this$0.fftZ);
                        if (h < this.this$1.this$0.halfFFTX + 1) {
                            ii = Complex3D.interleavedIndex((int)h, (int)k, (int)l, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                            this.c.re(this.this$1.this$0.getDensityGrid()[ii]);
                            this.c.im(this.this$1.this$0.getDensityGrid()[ii + 1]);
                        } else {
                            h = (this.this$1.this$0.fftX - h) % this.this$1.this$0.fftX;
                            k = (this.this$1.this$0.fftY - k) % this.this$1.this$0.fftY;
                            l = (this.this$1.this$0.fftZ - l) % this.this$1.this$0.fftZ;
                            ii = Complex3D.interleavedIndex((int)h, (int)k, (int)l, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                            this.c.re(this.this$1.this$0.getDensityGrid()[ii]);
                            this.c.im(-this.this$1.this$0.getDensityGrid()[ii + 1]);
                        }
                        this.c.phaseShiftIP(shift);
                        fc[0] = fc[0] + this.c.re();
                        fc[1] = fc[1] + this.c.im();
                    }
                }
            }
        }
    }

    private class BabinetRegion
    extends ParallelRegion {
        BabinetLoop[] babinetLoops;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public BabinetRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.babinetLoops = new BabinetLoop[nThreads];
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.babinetLoops[ti] == null) {
                this.babinetLoops[ti] = new BabinetLoop(this);
            }
            try {
                this.execute(0, this.this$0.fftZ - 1, this.babinetLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        private class BabinetLoop
        extends IntegerForLoop {
            final /* synthetic */ BabinetRegion this$1;

            private BabinetLoop(BabinetRegion babinetRegion) {
                BabinetRegion babinetRegion2 = babinetRegion;
                Objects.requireNonNull(babinetRegion2);
                this.this$1 = babinetRegion2;
            }

            public void run(int lb, int ub) {
                switch (this.this$1.this$0.solventModel) {
                    case BINARY: 
                    case POLYNOMIAL: {
                        for (int k = lb; k <= ub; ++k) {
                            for (int j = 0; j < this.this$1.this$0.fftY; ++j) {
                                for (int i = 0; i < this.this$1.this$0.fftX; ++i) {
                                    int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                    this.this$1.this$0.densityGrid[ii] = 1.0 - this.this$1.this$0.getDensityGrid()[ii];
                                }
                            }
                        }
                        break;
                    }
                    case GAUSSIAN: {
                        for (int k = lb; k <= ub; ++k) {
                            for (int j = 0; j < this.this$1.this$0.fftY; ++j) {
                                for (int i = 0; i < this.this$1.this$0.fftX; ++i) {
                                    int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                    this.this$1.this$0.densityGrid[ii] = 1.0 - FastMath.exp((double)(-this.this$1.this$0.solventA * this.this$1.this$0.getDensityGrid()[ii]));
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private class SolventGridRegion
    extends ParallelRegion {
        SolventGridLoop[] solventGridLoops;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public SolventGridRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.solventGridLoops = new SolventGridLoop[nThreads];
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.solventGridLoops[ti] == null) {
                this.solventGridLoops[ti] = new SolventGridLoop(this);
            }
            try {
                this.execute(0, this.this$0.fftZ - 1, this.solventGridLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        private class SolventGridLoop
        extends IntegerForLoop {
            final /* synthetic */ SolventGridRegion this$1;

            private SolventGridLoop(SolventGridRegion solventGridRegion) {
                SolventGridRegion solventGridRegion2 = solventGridRegion;
                Objects.requireNonNull(solventGridRegion2);
                this.this$1 = solventGridRegion2;
            }

            public void run(int lb, int ub) {
                for (int k = lb; k <= ub; ++k) {
                    for (int j = 0; j < this.this$1.this$0.fftY; ++j) {
                        for (int i = 0; i < this.this$1.this$0.fftX; ++i) {
                            int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                            this.this$1.this$0.solventGrid[ii] = FastMath.exp((double)(-this.this$1.this$0.solventA * this.this$1.this$0.getSolventGrid()[ii]));
                        }
                    }
                }
            }
        }
    }

    private class InitRegion
    extends ParallelRegion {
        InitLoop[] initLoops;
        FormFactorUpdateLoop[] formFactorUpdateLoops;
        int nHKL;
        double[][] hkldata;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public InitRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.nHKL = this.this$0.reflectionList.hklList.size();
            this.hkldata = null;
            this.initLoops = new InitLoop[nThreads];
            this.formFactorUpdateLoops = new FormFactorUpdateLoop[nThreads];
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.initLoops[ti] == null) {
                this.initLoops[ti] = new InitLoop(this);
                this.formFactorUpdateLoops[ti] = new FormFactorUpdateLoop(this);
            }
            try {
                this.execute(0, this.nHKL - 1, this.initLoops[ti]);
                this.execute(0, this.this$0.nScatteringAtoms - 1, this.formFactorUpdateLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void setHKL(double[][] hkldata) {
            this.hkldata = hkldata;
        }

        private class InitLoop
        extends IntegerForLoop {
            final /* synthetic */ InitRegion this$1;

            private InitLoop(InitRegion initRegion) {
                InitRegion initRegion2 = initRegion;
                Objects.requireNonNull(initRegion2);
                this.this$1 = initRegion2;
            }

            public void run(int lb, int ub) {
                for (int i = lb; i <= ub; ++i) {
                    this.this$1.hkldata[i][0] = 0.0;
                    this.this$1.hkldata[i][1] = 0.0;
                }
            }
        }

        private class FormFactorUpdateLoop
        extends IntegerForLoop {
            private final double[] xyz;
            final /* synthetic */ InitRegion this$1;

            private FormFactorUpdateLoop(InitRegion initRegion) {
                InitRegion initRegion2 = initRegion;
                Objects.requireNonNull(initRegion2);
                this.this$1 = initRegion2;
                this.xyz = new double[3];
            }

            public void run(int lb, int ub) {
                for (int iSymm = 0; iSymm < this.this$1.this$0.bulkNSymm; ++iSymm) {
                    for (int i = lb; i <= ub; ++i) {
                        this.xyz[0] = this.this$1.this$0.coordinates[iSymm][0][i];
                        this.xyz[1] = this.this$1.this$0.coordinates[iSymm][1][i];
                        this.xyz[2] = this.this$1.this$0.coordinates[iSymm][2][i];
                        if (this.this$1.this$0.solventFormFactors != null) {
                            this.this$1.this$0.solventFormFactors[iSymm][i].update(this.xyz);
                        }
                        if (this.this$1.this$0.atomFormFactors == null) continue;
                        this.this$1.this$0.atomFormFactors[iSymm][i].update(this.xyz, this.this$1.this$0.bAdd);
                    }
                }
            }
        }
    }

    private class SolventScaleRegion
    extends ParallelRegion {
        SolventScaleLoop[] solventScaleLoops;
        int nHKL;
        double[][] hkldata;
        double scale;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public SolventScaleRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.nHKL = this.this$0.reflectionList.hklList.size();
            this.hkldata = null;
            this.solventScaleLoops = new SolventScaleLoop[nThreads];
        }

        public void run() throws Exception {
            int ti = this.getThreadIndex();
            if (this.solventScaleLoops[ti] == null) {
                this.solventScaleLoops[ti] = new SolventScaleLoop(this);
            }
            try {
                this.execute(0, this.nHKL - 1, this.solventScaleLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void setHKL(double[][] hkldata) {
            this.hkldata = hkldata;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        private class SolventScaleLoop
        extends IntegerForLoop {
            ComplexNumber c;
            final /* synthetic */ SolventScaleRegion this$1;

            public SolventScaleLoop(SolventScaleRegion solventScaleRegion) {
                SolventScaleRegion solventScaleRegion2 = solventScaleRegion;
                Objects.requireNonNull(solventScaleRegion2);
                this.this$1 = solventScaleRegion2;
                this.c = new ComplexNumber();
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    HKL ih = (HKL)this.this$1.this$0.reflectionList.hklList.get(i);
                    double[] fc = this.this$1.hkldata[ih.getIndex()];
                    this.c.re(fc[0]);
                    this.c.im(fc[1]);
                    this.c.timesIP(this.this$1.scale);
                    this.c.conjugateIP();
                    fc[0] = -this.c.re();
                    fc[1] = -this.c.im();
                }
            }
        }
    }

    private class AtomicScaleRegion
    extends ParallelRegion {
        AtomicScaleLoop[] atomicScaleLoops;
        int nHKL;
        double[][] hklData;
        double scale;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public AtomicScaleRegion(CrystalReciprocalSpace crystalReciprocalSpace, int nThreads) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.nHKL = this.this$0.reflectionList.hklList.size();
            this.hklData = null;
            this.atomicScaleLoops = new AtomicScaleLoop[nThreads];
        }

        public void run() throws Exception {
            int ti = this.getThreadIndex();
            if (this.atomicScaleLoops[ti] == null) {
                this.atomicScaleLoops[ti] = new AtomicScaleLoop(this);
            }
            try {
                this.execute(0, this.nHKL - 1, this.atomicScaleLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void setHKL(double[][] hkldata) {
            this.hklData = hkldata;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        private class AtomicScaleLoop
        extends IntegerForLoop {
            ComplexNumber c;
            final /* synthetic */ AtomicScaleRegion this$1;

            public AtomicScaleLoop(AtomicScaleRegion atomicScaleRegion) {
                AtomicScaleRegion atomicScaleRegion2 = atomicScaleRegion;
                Objects.requireNonNull(atomicScaleRegion2);
                this.this$1 = atomicScaleRegion2;
                this.c = new ComplexNumber();
            }

            public void run(int lb, int ub) {
                for (int i = lb; i <= ub; ++i) {
                    HKL ih = (HKL)this.this$1.this$0.reflectionList.hklList.get(i);
                    double[] fc = this.this$1.hklData[ih.getIndex()];
                    this.c.re(fc[0]);
                    this.c.im(fc[1]);
                    double s = this.this$1.this$0.crystal.invressq(ih);
                    this.c.timesIP(this.this$1.scale * FastMath.exp((double)(0.25 * this.this$1.this$0.bAdd * s)));
                    this.c.conjugateIP();
                    fc[0] = this.c.re();
                    fc[1] = this.c.im();
                }
            }
        }
    }

    private class ArrayCopyRegion
    extends ParallelRegion {
        ArrayCopyLoop[] arrayCopyLoops;
        final /* synthetic */ CrystalReciprocalSpace this$0;

        public ArrayCopyRegion(CrystalReciprocalSpace crystalReciprocalSpace) {
            CrystalReciprocalSpace crystalReciprocalSpace2 = crystalReciprocalSpace;
            Objects.requireNonNull(crystalReciprocalSpace2);
            this.this$0 = crystalReciprocalSpace2;
            this.arrayCopyLoops = new ArrayCopyLoop[crystalReciprocalSpace.threadCount];
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.arrayCopyLoops[ti] == null) {
                this.arrayCopyLoops[ti] = new ArrayCopyLoop(this);
            }
            try {
                this.execute(0, this.this$0.complexFFT3DSpace - 1, this.arrayCopyLoops[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        private class ArrayCopyLoop
        extends IntegerForLoop {
            final /* synthetic */ ArrayCopyRegion this$1;

            private ArrayCopyLoop(ArrayCopyRegion arrayCopyRegion) {
                ArrayCopyRegion arrayCopyRegion2 = arrayCopyRegion;
                Objects.requireNonNull(arrayCopyRegion2);
                this.this$1 = arrayCopyRegion2;
            }

            public void run(int lb, int ub) {
                int length = ub - lb + 1;
                System.arraycopy(this.this$1.this$0.getDensityGrid(), lb, this.this$1.this$0.getSolventGrid(), lb, length);
            }
        }
    }
}

