/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.parsers;

import ffx.potential.MolecularAssembly;
import ffx.realspace.parsers.CCP4MapFilter;
import ffx.realspace.parsers.RealSpaceFileFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class RealSpaceFile {
    private static final Logger logger = Logger.getLogger(RealSpaceFile.class.getName());
    private final String filename;
    private final double weight;
    private final RealSpaceFileFilter realSpaceFileFilter;

    public RealSpaceFile(String filename) {
        this(filename, 1.0);
    }

    public RealSpaceFile(String fileName, double weight) {
        File tmp = new File(fileName);
        if (!tmp.exists()) {
            logger.severe(" Data file: " + fileName + " not found!");
        }
        this.realSpaceFileFilter = FilenameUtils.isExtension((String)fileName, (String)"map") ? new CCP4MapFilter() : null;
        this.filename = fileName;
        this.weight = weight;
    }

    public RealSpaceFile(MolecularAssembly[] assembly) {
        this(assembly[0], 1.0);
    }

    public RealSpaceFile(MolecularAssembly assembly) {
        this(assembly, 1.0);
    }

    public RealSpaceFile(MolecularAssembly assembly, double weight) {
        String filenameHolder;
        String name = FilenameUtils.removeExtension((String)assembly.getFile().getPath());
        File tmp = new File(name + ".map");
        if (tmp.exists()) {
            logger.info(" Data file: " + tmp.getName());
            this.realSpaceFileFilter = new CCP4MapFilter();
        } else {
            logger.severe(" No input data was found.");
            this.realSpaceFileFilter = null;
        }
        try {
            Path filePath = Paths.get(tmp.getCanonicalPath(), new String[0]);
            Path pwdPath = Paths.get(new File("").getCanonicalPath(), new String[0]);
            filenameHolder = pwdPath.relativize(filePath).toString();
        }
        catch (IOException e) {
            String message = " Relative path to provided data file could not be resolved: using map file name instead.";
            logger.log(Level.WARNING, message, e);
            filenameHolder = tmp.getName();
        }
        this.filename = filenameHolder;
        this.weight = weight;
    }

    public String getFilename() {
        return this.filename;
    }

    public RealSpaceFileFilter getRealSpaceFileFilter() {
        return this.realSpaceFileFilter;
    }

    public double getWeight() {
        return this.weight;
    }
}

