/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.SpaceGroupInfo;
import ffx.realspace.RealSpaceRefinementData;
import ffx.realspace.parsers.RealSpaceFileFilter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class CCP4MapFilter
implements RealSpaceFileFilter {
    private static final Logger logger = Logger.getLogger(CCP4MapFilter.class.getName());

    @Override
    public Crystal getCrystal(String fileName, CompositeConfiguration properties) {
        String message;
        ByteBuffer byteBuffer;
        byte[] bytes;
        DataInputStream dataInputStream;
        FileInputStream fileInputStream;
        int spaceGroup = -1;
        double cellA = -1.0;
        double cellB = -1.0;
        double cellC = -1.0;
        double cellAlpha = -1.0;
        double cellBeta = -1.0;
        double cellGamma = -1.0;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        try {
            fileInputStream = new FileInputStream(fileName);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(212);
            bytes = new byte[4];
            dataInputStream.read(bytes, 0, 4);
            byteBuffer = ByteBuffer.wrap(bytes);
            int imapData = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
            String stampString = Integer.toHexString(imapData);
            switch (stampString.charAt(0)) {
                case '1': 
                case '3': {
                    if (!byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) break;
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case '4': {
                    if (!byteOrder.equals(ByteOrder.BIG_ENDIAN)) break;
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
            }
            fileInputStream.close();
        }
        catch (Exception e) {
            message = " Fatal exception reading CCP4 map.\n";
            logger.log(Level.SEVERE, message, e);
        }
        try {
            int i;
            fileInputStream = new FileInputStream(fileName);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(40);
            bytes = new byte[80];
            dataInputStream.read(bytes, 0, 80);
            byteBuffer = ByteBuffer.wrap(bytes);
            cellA = byteBuffer.order(byteOrder).getFloat();
            cellB = byteBuffer.order(byteOrder).getFloat();
            cellC = byteBuffer.order(byteOrder).getFloat();
            cellAlpha = byteBuffer.order(byteOrder).getFloat();
            cellBeta = byteBuffer.order(byteOrder).getFloat();
            cellGamma = byteBuffer.order(byteOrder).getFloat();
            for (i = 0; i < 3; ++i) {
                byteBuffer.order(byteOrder).getInt();
            }
            for (i = 0; i < 3; ++i) {
                byteBuffer.order(byteOrder).getFloat();
            }
            spaceGroup = byteBuffer.order(byteOrder).getInt();
            fileInputStream.close();
        }
        catch (Exception e) {
            message = " Fatal exception reading CCP4 map.\n";
            logger.log(Level.SEVERE, message, e);
        }
        return new Crystal(cellA, cellB, cellC, cellAlpha, cellBeta, cellGamma, SpaceGroupInfo.spaceGroupNames[spaceGroup - 1]);
    }

    @Override
    public boolean readFile(String filename, RealSpaceRefinementData refinementdata, CompositeConfiguration properties) {
        String message;
        ByteBuffer byteBuffer;
        byte[] bytes;
        DataInputStream dataInputStream;
        FileInputStream fileInputStream;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double mean = 0.0;
        double sd = 0.0;
        double rmsd = 0.0;
        try {
            fileInputStream = new FileInputStream(filename);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(212);
            bytes = new byte[4];
            dataInputStream.read(bytes, 0, 4);
            byteBuffer = ByteBuffer.wrap(bytes);
            int imapData = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
            String stampString = Integer.toHexString(imapData);
            switch (stampString.charAt(0)) {
                case '1': 
                case '3': {
                    if (!byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) break;
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case '4': {
                    if (!byteOrder.equals(ByteOrder.BIG_ENDIAN)) break;
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(" Opening CCP4 map: %s\n", filename));
                logger.info(sb.toString());
            }
            fileInputStream.close();
        }
        catch (Exception e) {
            message = " Fatal exception reading CCP4 map.\n";
            logger.log(Level.SEVERE, message, e);
        }
        try {
            int i;
            int i2;
            fileInputStream = new FileInputStream(filename);
            dataInputStream = new DataInputStream(fileInputStream);
            bytes = new byte[2048];
            dataInputStream.read(bytes, 0, 1024);
            byteBuffer = ByteBuffer.wrap(bytes);
            int[] ext = new int[]{byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt()};
            int mode = byteBuffer.order(byteOrder).getInt();
            int[] ori = new int[]{byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt()};
            int[] ni = new int[]{byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt(), byteBuffer.order(byteOrder).getInt()};
            double cellA = byteBuffer.order(byteOrder).getFloat();
            double cellB = byteBuffer.order(byteOrder).getFloat();
            double cellC = byteBuffer.order(byteOrder).getFloat();
            double cellAlpha = byteBuffer.order(byteOrder).getFloat();
            double cellBeta = byteBuffer.order(byteOrder).getFloat();
            double cellGamma = byteBuffer.order(byteOrder).getFloat();
            int[] axisi = new int[3];
            block13: for (int i3 = 0; i3 < 3; ++i3) {
                int axis = byteBuffer.order(byteOrder).getInt();
                switch (axis) {
                    case 1: {
                        axisi[0] = i3;
                        continue block13;
                    }
                    case 2: {
                        axisi[1] = i3;
                        continue block13;
                    }
                    case 3: {
                        axisi[2] = i3;
                    }
                }
            }
            min = byteBuffer.order(byteOrder).getFloat();
            max = byteBuffer.order(byteOrder).getFloat();
            mean = byteBuffer.order(byteOrder).getFloat();
            int sg = byteBuffer.order(byteOrder).getInt();
            int nsymb = byteBuffer.order(byteOrder).getInt();
            int skew = byteBuffer.order(byteOrder).getInt();
            for (i2 = 0; i2 < 12; ++i2) {
                byteBuffer.order(byteOrder).getFloat();
            }
            for (i2 = 0; i2 < 15; ++i2) {
                byteBuffer.order(byteOrder).getInt();
            }
            byte[] word = new byte[2048];
            byteBuffer.order(byteOrder).get(word, 0, 4);
            String mapString = new String(word);
            sd = byteBuffer.order(byteOrder).getFloat();
            rmsd = byteBuffer.order(byteOrder).getFloat();
            if (logger.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("  Column origin:  %d\t Extent: %d\n", ori[0], ext[0]));
                sb.append(String.format("  Row origin:     %d\t Extent: %d\n", ori[1], ext[1]));
                sb.append(String.format("  Section origin: %d\t Extent: %d\n", ori[2], ext[2]));
                sb.append(String.format("  Axis order:     %d %d %d\n", axisi[0], axisi[1], axisi[2]));
                sb.append(String.format("  Number of X, Y, Z columns: %d %d %d\n", ni[0], ni[1], ni[2]));
                sb.append(String.format("  Spacegroup:     %d (%s)\n", sg, SpaceGroupInfo.spaceGroupNames[sg - 1]));
                sb.append(String.format("  Cell: %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n", cellA, cellB, cellC, cellAlpha, cellBeta, cellGamma));
                logger.info(sb.toString());
            }
            int nlabel = byteBuffer.order(byteOrder).getInt();
            for (i = 0; i < 10; ++i) {
                byteBuffer.order(byteOrder).get(word, 0, 80);
                mapString = new String(word);
            }
            if (nsymb > 0) {
                byteBuffer.rewind();
                dataInputStream.read(bytes, 0, nsymb);
                for (i = 0; i < nsymb / 80; i += 80) {
                    byteBuffer.order(byteOrder).get(word, 0, 80);
                    mapString = new String(word);
                }
            }
            byteBuffer.rewind();
            dataInputStream.read(bytes, 0, 2048);
            refinementdata.setData(new double[ext[0] * ext[1] * ext[2]]);
            int[] ijk = new int[3];
            refinementdata.setOrigin(ori[axisi[0]], ori[axisi[1]], ori[axisi[2]]);
            int nx = ext[axisi[0]];
            int ny = ext[axisi[1]];
            int nz = ext[axisi[2]];
            refinementdata.setExtent(nx, ny, nz);
            refinementdata.setNI(ni[0], ni[1], ni[2]);
            ijk[2] = 0;
            while (ijk[2] < ext[2]) {
                ijk[1] = 0;
                while (ijk[1] < ext[1]) {
                    ijk[0] = 0;
                    while (ijk[0] < ext[0]) {
                        int x = ijk[axisi[0]];
                        int y = ijk[axisi[1]];
                        int z = ijk[axisi[2]];
                        int index = x + nx * (y + ny * z);
                        refinementdata.getData()[index] = byteBuffer.order(byteOrder).getFloat();
                        if (!byteBuffer.hasRemaining()) {
                            byteBuffer.rewind();
                            dataInputStream.read(bytes, 0, 2048);
                        }
                        ijk[0] = ijk[0] + 1;
                    }
                    ijk[1] = ijk[1] + 1;
                }
                ijk[2] = ijk[2] + 1;
            }
            fileInputStream.close();
        }
        catch (Exception e) {
            message = " Fatal exception reading CCP4 map.\n";
            logger.log(Level.SEVERE, message, e);
        }
        return true;
    }
}

