/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parsers.PDBFilter;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.RefinementEnergy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Discrete optimization using a many-body expansion and elimination expressions."}, name="realspace.ManyBody")
public class ManyBody
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private RealSpaceOptions realSpaceOptions;
    @CommandLine.Mixin
    private ManyBodyOptions manyBodyOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private RefinementEnergy refinementEnergy;
    ForceFieldEnergy potentialEnergy;
    TitrationManyBody titrationManyBody;

    public ManyBody() {
    }

    public ManyBody(String[] args) {
        super(args);
    }

    public ManyBody(FFXBinding binding) {
        super(binding);
    }

    public ManyBody run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        System.setProperty("sor-scf-fallback", "false");
        System.setProperty("direct-scf-fallback", "true");
        double titrationPH = this.manyBodyOptions.getTitrationPH();
        if (titrationPH > 0.0) {
            System.setProperty("manybody-titration", "true");
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.activeAssembly = this.algorithmFunctions.open(this.filenames.get(0));
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        MolecularAssembly[] molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
        this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
        List residues = this.manyBodyOptions.collectResidues(this.activeAssembly);
        if (residues == null || residues.isEmpty()) {
            logger.info(" There are no residues in the active system to optimize.");
            return this;
        }
        if (titrationPH > 0.0) {
            logger.info("\n Adding titration hydrogen to : " + this.filenames.get(0) + "\n");
            ArrayList<Integer> resNumberList = new ArrayList<Integer>();
            for (Residue residue : residues) {
                resNumberList.add(residue.getResidueNumber());
            }
            this.titrationManyBody = new TitrationManyBody(this.filenames.getFirst(), this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
            this.activeAssembly = this.titrationManyBody.getProtonatedAssembly();
            this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
            molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        this.refinementEnergy = this.realSpaceOptions.toRealSpaceEnergy(this.filenames, molecularAssemblies);
        RotamerOptimization rotamerOptimization = new RotamerOptimization(this.activeAssembly, (Potential)this.refinementEnergy, this.algorithmListener);
        this.manyBodyOptions.initRotamerOptimization(rotamerOptimization, this.activeAssembly);
        double[] x = new double[this.refinementEnergy.getNumberOfVariables()];
        x = this.refinementEnergy.getCoordinates(x);
        this.refinementEnergy.energy(x, true);
        List residueList = rotamerOptimization.getResidues();
        RotamerLibrary.measureRotamers((List)residueList, (boolean)false);
        rotamerOptimization.optimize(this.manyBodyOptions.getAlgorithm(residueList.size()));
        boolean isTitrating = false;
        HashSet excludeAtoms = new HashSet();
        int[] optimalRotamers = rotamerOptimization.getOptimumRotamers();
        if (titrationPH > 0.0) {
            isTitrating = this.titrationManyBody.excludeExcessAtoms(excludeAtoms, optimalRotamers, residueList);
        }
        if (Comm.world().rank() == 0) {
            logger.info(" Final Minimum Energy");
            x = this.refinementEnergy.getCoordinates(x);
            double energy = this.refinementEnergy.energy(x, true);
            if (isTitrating) {
                double phBias = rotamerOptimization.getEnergyExpansion().getTotalRotamerPhBias(residueList, optimalRotamers, titrationPH, this.manyBodyOptions.getPHRestraint());
                logger.info(String.format("\n  Rotamer pH Bias    %16.8f", phBias));
                logger.info(String.format("  Potential with Bias%16.8f\n", phBias + energy));
            } else {
                logger.info(String.format("\n  Real Space Target  %16.8f\n", energy));
            }
            String ext = FilenameUtils.getExtension((String)filename);
            filename = FilenameUtils.removeExtension((String)filename);
            if (ext.toUpperCase().contains("XYZ")) {
                this.algorithmFunctions.saveAsXYZ(molecularAssemblies[0], new File(filename + ".xyz"));
            } else {
                properties.setProperty("standardizeAtomNames", (Object)"false");
                File modelFile = this.saveDirFile(this.activeAssembly.getFile());
                PDBFilter pdbFilter = new PDBFilter(modelFile, this.activeAssembly, this.activeAssembly.getForceField(), properties);
                if (titrationPH > 0.0) {
                    String remark = String.format("Titration pH: %6.3f", titrationPH);
                    if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true, new String[]{remark})) {
                        logger.info(String.format(" Save failed for %s", this.activeAssembly));
                    }
                } else if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true)) {
                    logger.info(String.format(" Save failed for %s", this.activeAssembly));
                }
            }
        }
        return this;
    }

    public ManyBodyOptions getManyBodyOptions() {
        return this.manyBodyOptions;
    }

    public List<Potential> getPotentials() {
        return this.refinementEnergy == null ? Collections.emptyList() : Collections.singletonList(this.refinementEnergy);
    }
}

