/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.utilities.FFXBinding;
import ffx.utilities.TinkerUtils;
import ffx.xray.RefinementEnergy;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Molecular dynamics on a Real Space target."}, name="realspace.Dynamics")
public class Dynamics
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private RealSpaceOptions realSpaceOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeoutOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private RefinementEnergy refinementEnergy;

    public Dynamics() {
    }

    public Dynamics(String[] args) {
        super(args);
    }

    public Dynamics(FFXBinding binding) {
        super(binding);
    }

    public Dynamics run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.activeAssembly = this.algorithmFunctions.open(this.filenames.get(0));
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        MolecularAssembly[] molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        logger.info("\n Running Real Space Dynamics on " + filename);
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.refinementEnergy = this.realSpaceOptions.toRealSpaceEnergy(this.filenames, molecularAssemblies);
        this.algorithmFunctions.energy(this.activeAssembly);
        File dyn = new File(FilenameUtils.removeExtension((String)filename) + ".dyn");
        if (!dyn.exists()) {
            dyn = null;
        }
        MolecularDynamics molDyn = this.dynamicsOptions.getDynamics(this.writeoutOptions, (Potential)this.refinementEnergy, this.activeAssembly, this.algorithmListener);
        this.refinementEnergy.setThermostat(molDyn.getThermostat());
        boolean initVelocities = true;
        molDyn.dynamic(this.dynamicsOptions.getSteps(), this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), initVelocities, dyn);
        this.algorithmFunctions.energy(this.activeAssembly);
        File file = TinkerUtils.version((File)new File(FilenameUtils.removeExtension((String)filename) + ".pdb"));
        this.algorithmFunctions.saveAsPDB(molecularAssemblies, file);
        return this;
    }

    public List<Potential> getPotentials() {
        return this.refinementEnergy == null ? Collections.emptyList() : Collections.singletonList(this.refinementEnergy);
    }
}

