/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace;

import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.realspace.RealSpaceData;
import ffx.xray.refine.RefinementModel;
import java.util.logging.Logger;

public class RealSpaceEnergy
implements LambdaInterface,
CrystalPotential {
    private static final Logger logger = Logger.getLogger(RealSpaceEnergy.class.getName());
    private final RealSpaceData realSpaceData;
    private final RefinementModel refinementModel;
    protected double lambda = 1.0;
    private final int nXYZ;
    private double[] optimizationScaling = null;
    private double totalEnergy;
    private Potential.STATE state = Potential.STATE.BOTH;

    public RealSpaceEnergy(RealSpaceData realSpaceData) {
        this.realSpaceData = realSpaceData;
        this.refinementModel = realSpaceData.getRefinementModel();
        this.nXYZ = this.refinementModel.getNumCoordParameters();
    }

    public boolean destroy() {
        return this.realSpaceData.destroy();
    }

    public double energy(double[] x) {
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        double e = this.realSpaceData.computeRealSpaceTarget();
        this.scaleCoordinates(x);
        this.totalEnergy = e;
        return e;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        this.refinementModel.zeroGradient();
        double e = this.realSpaceData.computeRealSpaceTarget();
        this.refinementModel.getGradient(g);
        this.scaleCoordinatesAndGradient(x, g);
        this.totalEnergy = e;
        return e;
    }

    public double[] getAcceleration(double[] acceleration) {
        int n = this.getNumberOfVariables();
        if (acceleration == null || acceleration.length < n) {
            acceleration = new double[n];
        }
        int index = 0;
        double[] acc = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            a.getAcceleration(acc);
            acceleration[index++] = acc[0];
            acceleration[index++] = acc[1];
            acceleration[index++] = acc[2];
        }
        return acceleration;
    }

    public double[] getCoordinates(double[] x) {
        int n = this.getNumberOfVariables();
        if (x == null || x.length < n) {
            x = new double[n];
        }
        int index = 0;
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            x[index++] = a.getX();
            x[index++] = a.getY();
            x[index++] = a.getZ();
        }
        return x;
    }

    public Crystal getCrystal() {
        this.realSpaceData.getCrystal();
        return null;
    }

    public void setCrystal(Crystal crystal) {
        logger.severe(" RealSpaceEnergy does implement setCrystal yet.");
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        if (lambda <= 1.0 && lambda >= 0.0) {
            this.lambda = lambda;
            this.realSpaceData.setLambda(lambda);
        } else {
            String message = String.format(" Lambda value %8.3f is not in the range [0..1].", lambda);
            logger.warning(message);
        }
    }

    public double[] getMass() {
        double[] mass = new double[this.nXYZ];
        this.refinementModel.getMass(mass);
        return mass;
    }

    public int getNumberOfVariables() {
        return this.nXYZ;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        int n = this.getNumberOfVariables();
        if (previousAcceleration == null || previousAcceleration.length < n) {
            previousAcceleration = new double[n];
        }
        int index = 0;
        double[] prev = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            a.getPreviousAcceleration(prev);
            previousAcceleration[index++] = prev[0];
            previousAcceleration[index++] = prev[1];
            previousAcceleration[index++] = prev[2];
        }
        return previousAcceleration;
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(double[] scaling) {
        this.optimizationScaling = scaling;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        int nActive = this.refinementModel.getActiveAtoms().length;
        Potential.VARIABLE_TYPE[] type = new Potential.VARIABLE_TYPE[nActive * 3];
        int index = 0;
        for (int i = 0; i < nActive; ++i) {
            type[index++] = Potential.VARIABLE_TYPE.X;
            type[index++] = Potential.VARIABLE_TYPE.Y;
            type[index++] = Potential.VARIABLE_TYPE.Z;
        }
        return type;
    }

    public double[] getVelocity(double[] velocity) {
        int n = this.getNumberOfVariables();
        if (velocity == null || velocity.length < n) {
            velocity = new double[n];
        }
        int index = 0;
        double[] v = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            a.getVelocity(v);
            velocity[index++] = v[0];
            velocity[index++] = v[1];
            velocity[index++] = v[2];
        }
        return velocity;
    }

    public double getd2EdL2() {
        return 0.0;
    }

    public double getdEdL() {
        return this.realSpaceData.getdEdL();
    }

    public void getdEdXdL(double[] gradient) {
        this.realSpaceData.getdEdXdL(gradient);
    }

    public void setAcceleration(double[] acceleration) {
        if (acceleration == null) {
            return;
        }
        int index = 0;
        double[] accel = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            accel[0] = acceleration[index++];
            accel[1] = acceleration[index++];
            accel[2] = acceleration[index++];
            a.setAcceleration(accel);
        }
    }

    public void setCoordinates(double[] x) {
        if (x == null) {
            return;
        }
        this.refinementModel.setParameters(x);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        if (previousAcceleration == null) {
            return;
        }
        int index = 0;
        double[] prev = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            prev[0] = previousAcceleration[index++];
            prev[1] = previousAcceleration[index++];
            prev[2] = previousAcceleration[index++];
            a.setPreviousAcceleration(prev);
        }
    }

    public void setVelocity(double[] velocity) {
        if (velocity == null) {
            return;
        }
        int index = 0;
        double[] vel = new double[3];
        for (Atom a : this.refinementModel.getActiveAtoms()) {
            vel[0] = velocity[index++];
            vel[1] = velocity[index++];
            vel[2] = velocity[index++];
            a.setVelocity(vel);
        }
    }
}

