/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.ScalarMath;
import ffx.numerics.spline.TriCubicSpline;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.realspace.RealSpaceRefinementData;
import ffx.realspace.parsers.RealSpaceFile;
import ffx.xray.DataContainer;
import ffx.xray.DiffractionData;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class RealSpaceData
implements DataContainer {
    private static final Logger logger = Logger.getLogger(RealSpaceData.class.getName());
    private final ParallelTeam parallelTeam;
    private final RealSpaceRegion realSpaceRegion;
    private final RealSpaceFile[] realSpaceFile;
    private final int nRealSpaceData;
    private final RefinementModel refinementModel;
    private final boolean lambdaTerm;
    private final MolecularAssembly[] molecularAssemblies;
    private Crystal[] crystal;
    private RealSpaceRefinementData[] refinementData;
    private double realSpaceEnergy = 0.0;
    private double realSpacedUdL = 0.0;
    private double[] realSpaceGradient;
    private double[] realSpacedUdXdL;
    private double xweight;
    private double lambda = 1.0;

    public RealSpaceData(MolecularAssembly molecularAssembly, CompositeConfiguration properties, ParallelTeam parallelTeam, DiffractionData diffractionData) {
        this(new MolecularAssembly[]{molecularAssembly}, properties, parallelTeam, diffractionData);
    }

    public RealSpaceData(MolecularAssembly[] molecularAssemblies, CompositeConfiguration properties, ParallelTeam parallelTeam, DiffractionData diffractionData) {
        this.molecularAssemblies = molecularAssemblies;
        this.parallelTeam = parallelTeam;
        this.realSpaceFile = null;
        this.nRealSpaceData = 1;
        this.crystal = new Crystal[this.nRealSpaceData];
        this.crystal[0] = diffractionData.getCrystal()[0];
        this.refinementData = new RealSpaceRefinementData[this.nRealSpaceData];
        this.refinementData[0] = new RealSpaceRefinementData();
        this.refinementData[0].setPeriodic(true);
        this.xweight = properties.getDouble("xweight", 1.0);
        this.lambdaTerm = properties.getBoolean("lambdaterm", false);
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder(" Real Space Refinement Settings\n");
            sb.append(String.format("  Refinement weight (xweight): %5.3f", this.xweight));
            logger.info(sb.toString());
        }
        if (!diffractionData.getScaled()[0]) {
            diffractionData.scaleBulkFit();
            diffractionData.printStats();
        }
        diffractionData.getCrystalReciprocalSpacesFc()[0].computeAtomicGradients(diffractionData.getRefinementData()[0].foFc1, diffractionData.getRefinementData()[0].freeR, diffractionData.getRefinementData()[0].rFreeFlag, RefinementMode.COORDINATES);
        this.refinementData[0].setOrigin(0, 0, 0);
        int extx = (int)diffractionData.getCrystalReciprocalSpacesFc()[0].getXDim();
        int exty = (int)diffractionData.getCrystalReciprocalSpacesFc()[0].getYDim();
        int extz = (int)diffractionData.getCrystalReciprocalSpacesFc()[0].getZDim();
        this.refinementData[0].setExtent(extx, exty, extz);
        this.refinementData[0].setNI(extx, exty, extz);
        this.refinementData[0].setData(new double[extx * exty * extz]);
        for (int k = 0; k < extz; ++k) {
            for (int j = 0; j < exty; ++j) {
                for (int i = 0; i < extx; ++i) {
                    int index1 = i + extx * (j + exty * k);
                    int index2 = 2 * index1;
                    this.refinementData[0].getData()[index1] = diffractionData.getCrystalReciprocalSpacesFc()[0].getDensityGrid()[index2];
                }
            }
        }
        this.refinementModel = new RefinementModel(molecularAssemblies);
        int nAtoms = this.refinementModel.getScatteringAtoms().length;
        this.realSpaceRegion = new RealSpaceRegion(this, parallelTeam.getThreadCount(), nAtoms, this.refinementData.length);
    }

    public RealSpaceData(MolecularAssembly assembly, CompositeConfiguration properties, ParallelTeam parallelTeam) {
        this(new MolecularAssembly[]{assembly}, properties, parallelTeam, new RealSpaceFile(assembly));
    }

    public RealSpaceData(MolecularAssembly assembly, CompositeConfiguration properties, ParallelTeam parallelTeam, RealSpaceFile ... datafile) {
        this(new MolecularAssembly[]{assembly}, properties, parallelTeam, datafile);
    }

    public RealSpaceData(MolecularAssembly[] molecularAssemblies, CompositeConfiguration properties, ParallelTeam parallelTeam, RealSpaceFile ... dataFile) {
        int i;
        this.molecularAssemblies = molecularAssemblies;
        this.parallelTeam = parallelTeam;
        this.realSpaceFile = dataFile;
        this.nRealSpaceData = dataFile.length;
        this.crystal = new Crystal[this.nRealSpaceData];
        this.refinementData = new RealSpaceRefinementData[this.nRealSpaceData];
        this.xweight = properties.getDouble("xweight", 1.0);
        this.lambdaTerm = properties.getBoolean("lambdaterm", false);
        for (i = 0; i < this.nRealSpaceData; ++i) {
            this.crystal[i] = dataFile[i].getRealSpaceFileFilter().getCrystal(dataFile[i].getFilename(), properties);
            if (this.crystal[i] != null) continue;
            logger.severe(" CCP4 map file does not contain full crystal information!");
        }
        for (i = 0; i < this.nRealSpaceData; ++i) {
            this.refinementData[i] = new RealSpaceRefinementData();
            dataFile[i].getRealSpaceFileFilter().readFile(dataFile[i].getFilename(), this.refinementData[i], properties);
            if (this.refinementData[i].getOrigin()[0] != 0 || this.refinementData[i].getOrigin()[1] != 0 || this.refinementData[i].getOrigin()[2] != 0 || this.refinementData[i].getExtent()[0] != this.refinementData[i].getNi()[0] || this.refinementData[i].getExtent()[1] != this.refinementData[i].getNi()[1] || this.refinementData[i].getExtent()[2] != this.refinementData[i].getNi()[2]) continue;
            this.refinementData[i].setPeriodic(true);
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder(" Real Space Refinement Settings\n");
            sb.append(String.format("  Refinement weight (xweight): %5.3f", this.xweight));
            logger.info(sb.toString());
        }
        this.refinementModel = new RefinementModel(RefinementMode.COORDINATES, molecularAssemblies);
        int nAtoms = this.refinementModel.getScatteringAtoms().length;
        this.realSpaceRegion = new RealSpaceRegion(this, parallelTeam.getThreadCount(), nAtoms, this.refinementData.length);
    }

    public boolean destroy() {
        try {
            boolean underlyingShutdown = true;
            for (MolecularAssembly assembly : this.molecularAssemblies) {
                boolean thisShutdown = assembly.destroy();
                underlyingShutdown = underlyingShutdown && thisShutdown;
            }
            this.parallelTeam.shutdown();
            return underlyingShutdown;
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in shutting down a RealSpaceData: %s", ex));
            logger.info(Utilities.stackTraceToString((Throwable)ex));
            return false;
        }
    }

    public Crystal[] getCrystal() {
        return this.crystal;
    }

    public void setCrystal(Crystal[] crystal) {
        this.crystal = crystal;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double[] getRealSpaceGradient(double[] gradient) {
        int i;
        int nAtoms = this.refinementModel.getScatteringAtoms().length;
        int nActiveAtoms = 0;
        for (i = 0; i < nAtoms; ++i) {
            if (!this.refinementModel.getScatteringAtoms()[i].isActive()) continue;
            ++nActiveAtoms;
        }
        if (gradient == null || gradient.length < nActiveAtoms * 3) {
            gradient = new double[nActiveAtoms * 3];
        }
        for (i = 0; i < nActiveAtoms * 3; ++i) {
            int n = i;
            gradient[n] = gradient[n] + this.realSpaceGradient[i];
        }
        return gradient;
    }

    public RealSpaceRefinementData[] getRefinementData() {
        return this.refinementData;
    }

    public void setRefinementData(RealSpaceRefinementData[] refinementData) {
        this.refinementData = refinementData;
    }

    @Override
    public RefinementModel getRefinementModel() {
        return this.refinementModel;
    }

    @Override
    public double getWeight() {
        return this.xweight;
    }

    @Override
    public void setWeight(double weight) {
        this.xweight = weight;
    }

    @Override
    public String printEnergyUpdate() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nRealSpaceData; ++i) {
            sb.append(String.format("     dataset %d (weight: %5.1f): chemical energy: %8.2f density score: %8.2f\n", i + 1, this.realSpaceFile[i].getWeight(), this.molecularAssemblies[0].getPotentialEnergy().getTotalEnergy(), this.realSpaceFile[i].getWeight() * this.refinementData[i].getDensityScore()));
        }
        return sb.toString();
    }

    @Override
    public String printOptimizationHeader() {
        return "Density score";
    }

    @Override
    public String printOptimizationUpdate() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nRealSpaceData; ++i) {
            sb.append(String.format("%6.2f ", this.refinementData[i].getDensityScore()));
        }
        return sb.toString();
    }

    double computeRealSpaceTarget() {
        long time = -System.nanoTime();
        this.realSpaceEnergy = 0.0;
        this.realSpacedUdL = 0.0;
        int nActive = 0;
        int nAtoms = this.refinementModel.getScatteringAtoms().length;
        for (int i = 0; i < nAtoms; ++i) {
            if (!this.refinementModel.getScatteringAtoms()[i].isActive()) continue;
            ++nActive;
        }
        int nGrad = nActive * 3;
        if (this.realSpaceGradient == null || this.realSpaceGradient.length < nGrad) {
            this.realSpaceGradient = new double[nGrad];
        } else {
            Arrays.fill(this.realSpaceGradient, 0.0);
        }
        if (this.realSpacedUdXdL == null || this.realSpacedUdXdL.length < nGrad) {
            this.realSpacedUdXdL = new double[nGrad];
        } else {
            Arrays.fill(this.realSpacedUdXdL, 0.0);
        }
        try {
            this.parallelTeam.execute((ParallelRegion)this.realSpaceRegion);
        }
        catch (Exception e) {
            String message = " Exception computing real space energy";
            logger.log(Level.SEVERE, message, e);
        }
        time += System.nanoTime();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Real space energy time: %16.8f (sec).", (double)time * 1.0E-9));
        }
        return this.realSpaceEnergy;
    }

    double getdEdL() {
        return this.realSpacedUdL;
    }

    double[] getdEdXdL(double[] gradient) {
        int i;
        int nAtoms = this.refinementModel.getScatteringAtoms().length;
        int nActiveAtoms = 0;
        for (i = 0; i < nAtoms; ++i) {
            if (!this.refinementModel.getScatteringAtoms()[i].isActive()) continue;
            ++nActiveAtoms;
        }
        if (gradient == null || gradient.length < nActiveAtoms * 3) {
            gradient = new double[nActiveAtoms * 3];
        }
        for (i = 0; i < nActiveAtoms * 3; ++i) {
            int n = i;
            gradient[n] = gradient[n] + this.realSpacedUdXdL[i];
        }
        return gradient;
    }

    private RealSpaceFile[] getRealSpaceFile() {
        return this.realSpaceFile;
    }

    private int getnRealSpaceData() {
        return this.nRealSpaceData;
    }

    private class RealSpaceRegion
    extends ParallelRegion {
        private final AtomicDoubleArray3D gradient;
        private final AtomicDoubleArray3D lambdaGrad;
        private final InitializationLoop[] initializationLoops;
        private final RealSpaceLoop[] realSpaceLoops;
        private final SharedDouble[] sharedTarget;
        private final SharedDouble shareddUdL;
        private final int nAtoms;
        private final int nData;
        final /* synthetic */ RealSpaceData this$0;

        RealSpaceRegion(RealSpaceData realSpaceData, int nThreads, int nAtoms, int nData) {
            RealSpaceData realSpaceData2 = realSpaceData;
            Objects.requireNonNull(realSpaceData2);
            this.this$0 = realSpaceData2;
            this.nAtoms = nAtoms;
            this.nData = nData;
            this.initializationLoops = new InitializationLoop[nThreads];
            this.realSpaceLoops = new RealSpaceLoop[nThreads];
            this.sharedTarget = new SharedDouble[nData];
            for (int i = 0; i < nData; ++i) {
                this.sharedTarget[i] = new SharedDouble();
            }
            this.shareddUdL = new SharedDouble();
            this.gradient = new AtomicDoubleArray3D(AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI, nThreads, nAtoms);
            this.lambdaGrad = new AtomicDoubleArray3D(AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI, nThreads, nAtoms);
        }

        public void finish() {
            this.this$0.realSpaceEnergy = 0.0;
            for (int i = 0; i < this.nData; ++i) {
                this.this$0.refinementData[i].setDensityScore(this.sharedTarget[i].get());
                this.this$0.realSpaceEnergy += this.this$0.getRefinementData()[i].getDensityScore();
            }
            this.this$0.realSpacedUdL = this.shareddUdL.get();
            int index = 0;
            for (int i = 0; i < this.nAtoms; ++i) {
                Atom atom = this.this$0.refinementModel.getScatteringAtoms()[i];
                if (!atom.isActive()) continue;
                int ii = index * 3;
                double gx = this.gradient.getX(i);
                double gy = this.gradient.getY(i);
                double gz = this.gradient.getZ(i);
                this.this$0.realSpaceGradient[ii] = gx;
                this.this$0.realSpaceGradient[ii + 1] = gy;
                this.this$0.realSpaceGradient[ii + 2] = gz;
                atom.setXYZGradient(gx, gy, gz);
                gx = this.lambdaGrad.getX(i);
                gy = this.lambdaGrad.getY(i);
                gz = this.lambdaGrad.getZ(i);
                this.this$0.realSpacedUdXdL[ii] = gx;
                this.this$0.realSpacedUdXdL[ii + 1] = gy;
                this.this$0.realSpacedUdXdL[ii + 2] = gz;
                atom.setLambdaXYZGradient(gx, gy, gz);
                ++index;
            }
        }

        public void run() throws Exception {
            int threadID = this.getThreadIndex();
            if (this.initializationLoops[threadID] == null) {
                this.initializationLoops[threadID] = new InitializationLoop(this);
            }
            this.execute(0, this.nAtoms - 1, this.initializationLoops[threadID]);
            if (this.realSpaceLoops[threadID] == null) {
                this.realSpaceLoops[threadID] = new RealSpaceLoop(this);
            }
            this.execute(0, this.nAtoms - 1, this.realSpaceLoops[threadID]);
        }

        public void start() {
            for (int i = 0; i < this.nData; ++i) {
                this.sharedTarget[i].set(0.0);
            }
            this.shareddUdL.set(0.0);
            this.gradient.alloc(this.nAtoms);
            this.lambdaGrad.alloc(this.nAtoms);
        }

        private class InitializationLoop
        extends IntegerForLoop {
            final /* synthetic */ RealSpaceRegion this$1;

            private InitializationLoop(RealSpaceRegion realSpaceRegion) {
                RealSpaceRegion realSpaceRegion2 = realSpaceRegion;
                Objects.requireNonNull(realSpaceRegion2);
                this.this$1 = realSpaceRegion2;
            }

            public void run(int lb, int ub) {
                int threadID = this.getThreadIndex();
                this.this$1.gradient.reset(threadID, lb, ub);
                this.this$1.lambdaGrad.reset(threadID, lb, ub);
                for (int i = lb; i <= ub; ++i) {
                    Atom a = this.this$1.this$0.refinementModel.getScatteringAtoms()[i];
                    a.setXYZGradient(0.0, 0.0, 0.0);
                    a.setLambdaXYZGradient(0.0, 0.0, 0.0);
                }
            }
        }

        private class RealSpaceLoop
        extends IntegerForLoop {
            double[] target;
            double localdUdL;
            final /* synthetic */ RealSpaceRegion this$1;

            private RealSpaceLoop(RealSpaceRegion realSpaceRegion) {
                RealSpaceRegion realSpaceRegion2 = realSpaceRegion;
                Objects.requireNonNull(realSpaceRegion2);
                this.this$1 = realSpaceRegion2;
                this.target = new double[this.this$1.nData];
            }

            public void finish() {
                for (int i = 0; i < this.this$1.nData; ++i) {
                    this.this$1.sharedTarget[i].addAndGet(this.target[i]);
                }
                this.this$1.shareddUdL.addAndGet(this.localdUdL);
            }

            public void run(int first, int last) throws Exception {
                int threadID = this.getThreadIndex();
                double[] xyz = new double[3];
                double[] uvw = new double[3];
                double[] grad = new double[3];
                double[][][] scalar = new double[4][4][4];
                TriCubicSpline spline = new TriCubicSpline();
                for (int i = 0; i < this.this$1.this$0.getnRealSpaceData(); ++i) {
                    int extX = this.this$1.this$0.getRefinementData()[i].getExtent()[0];
                    int extY = this.this$1.this$0.getRefinementData()[i].getExtent()[1];
                    int extZ = this.this$1.this$0.getRefinementData()[i].getExtent()[2];
                    int nX = this.this$1.this$0.getRefinementData()[i].getNi()[0];
                    int nY = this.this$1.this$0.getRefinementData()[i].getNi()[1];
                    int nZ = this.this$1.this$0.getRefinementData()[i].getNi()[2];
                    int originX = this.this$1.this$0.getRefinementData()[i].getOrigin()[0];
                    int originY = this.this$1.this$0.getRefinementData()[i].getOrigin()[1];
                    int originZ = this.this$1.this$0.getRefinementData()[i].getOrigin()[2];
                    for (int ia = first; ia <= last; ++ia) {
                        Atom a = this.this$1.this$0.refinementModel.getScatteringAtoms()[ia];
                        if (!a.getUse()) continue;
                        double lambdai = 1.0;
                        double dUdL = 0.0;
                        if (this.this$1.this$0.lambdaTerm && a.applyLambda()) {
                            lambdai = this.this$1.this$0.getLambda();
                            dUdL = 1.0;
                        }
                        a.getXYZ(xyz);
                        this.this$1.this$0.getCrystal()[i].toFractionalCoordinates(xyz, uvw);
                        double frx = (double)nX * uvw[0];
                        int ifrx = (int)FastMath.floor((double)frx) - originX;
                        double dfrx = frx - FastMath.floor((double)frx);
                        double fry = (double)nY * uvw[1];
                        int ifry = (int)FastMath.floor((double)fry) - originY;
                        double dfry = fry - FastMath.floor((double)fry);
                        double frz = (double)nZ * uvw[2];
                        int ifrz = (int)FastMath.floor((double)frz) - originZ;
                        double dfrz = frz - FastMath.floor((double)frz);
                        if (!(this.this$1.this$0.refinementData[i].isPeriodic() || ifrx - 1 >= 0 && ifrx + 2 <= extX && ifry - 1 >= 0 && ifry + 2 <= extY && ifrz - 1 >= 0 && ifrz + 2 <= extZ)) {
                            String message = String.format(" Atom %s is outside the density will be ignored.", a);
                            logger.warning(message);
                            continue;
                        }
                        if (this.this$1.this$0.getRefinementData()[i].isPeriodic()) {
                            for (ui = ifrx - 1; ui < ifrx + 3; ++ui) {
                                uii = ui - (ifrx - 1);
                                int pui = ScalarMath.mod((int)ui, (int)extX);
                                for (int vi = ifry - 1; vi < ifry + 3; ++vi) {
                                    int vii = vi - (ifry - 1);
                                    int pvi = ScalarMath.mod((int)vi, (int)extY);
                                    for (int wi = ifrz - 1; wi < ifrz + 3; ++wi) {
                                        int wii = wi - (ifrz - 1);
                                        int pwi = ScalarMath.mod((int)wi, (int)extZ);
                                        scalar[uii][vii][wii] = this.this$1.this$0.getRefinementData()[i].getDataIndex(pui, pvi, pwi);
                                    }
                                }
                            }
                        } else {
                            for (ui = ifrx - 1; ui < ifrx + 3; ++ui) {
                                uii = ui - (ifrx - 1);
                                for (int vi = ifry - 1; vi < ifry + 3; ++vi) {
                                    int vii = vi - (ifry - 1);
                                    for (int wi = ifrz - 1; wi < ifrz + 3; ++wi) {
                                        int wii = wi - (ifrz - 1);
                                        scalar[uii][vii][wii] = this.this$1.this$0.getRefinementData()[i].getDataIndex(ui, vi, wi);
                                    }
                                }
                            }
                        }
                        double atomicWeight = a.getAtomType().atomicWeight;
                        if (this.this$1.this$0.getRealSpaceFile() != null) {
                            atomicWeight *= this.this$1.this$0.getRealSpaceFile()[i].getWeight();
                        }
                        double scale = -1.0 * lambdai * atomicWeight;
                        double scaledUdL = -1.0 * dUdL * atomicWeight;
                        double val = spline.spline(dfrx, dfry, dfrz, scalar, grad);
                        int n = i;
                        this.target[n] = this.target[n] + scale * val;
                        this.localdUdL += scaledUdL * val;
                        if (!a.isActive()) continue;
                        grad[0] = grad[0] * (double)nX;
                        grad[1] = grad[1] * (double)nY;
                        grad[2] = grad[2] * (double)nZ;
                        xyz[0] = grad[0] * this.this$1.this$0.getCrystal()[i].A00;
                        xyz[1] = grad[0] * this.this$1.this$0.getCrystal()[i].A10 + grad[1] * this.this$1.this$0.getCrystal()[i].A11;
                        xyz[2] = grad[0] * this.this$1.this$0.getCrystal()[i].A20 + grad[1] * this.this$1.this$0.getCrystal()[i].A21 + grad[2] * this.this$1.this$0.getCrystal()[i].A22;
                        this.this$1.gradient.add(threadID, ia, scale * xyz[0], scale * xyz[1], scale * xyz[2]);
                        this.this$1.lambdaGrad.add(threadID, ia, scaledUdL * xyz[0], scaledUdL * xyz[1], scaledUdL * xyz[2]);
                    }
                }
                this.this$1.gradient.reduce(first, last);
                this.this$1.lambdaGrad.reduce(first, last);
            }

            public void start() {
                for (int i = 0; i < this.this$1.nData; ++i) {
                    this.target[i] = 0.0;
                }
                this.localdUdL = 0.0;
            }
        }
    }
}

