/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.solvent;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedBooleanArray;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class BulkSolventList
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(BulkSolventList.class.getName());
    private final Crystal crystal;
    private final int nSymm;
    private final int nAtoms;
    private final SharedBooleanArray[] sharedSelect;
    private final int nEdgeA;
    private final int nEdgeB;
    private final int nEdgeC;
    private final int nAB;
    private final int nCells;
    private final int[][] cellIndex;
    private final int[] cellA;
    private final int[] cellB;
    private final int[] cellC;
    private final int[][] cellList;
    private final int[][] cellOffset;
    private final int[][] cellCount;
    private final int[][] cellStart;
    private final double cutoff;
    private final double cutoff2;
    private final double[][] frac;
    private final ParallelTeam parallelTeam;
    private final SelectionListLoop[] selectionListLoop;
    private final double toSeconds = 1.0E-9;
    private double[][][] coordinates;
    private boolean[][] selected;
    private int nSelected;
    private int nA;
    private int nB;
    private int nC;
    private long time;
    private long cellTime;
    private long selectTime;
    private long totalTime;

    public BulkSolventList(Crystal crystal, Atom[] atoms, double cutoff, ParallelTeam parallelTeam) {
        int i;
        this.crystal = crystal;
        this.cutoff = cutoff;
        this.parallelTeam = new ParallelTeam(parallelTeam.getThreadCount());
        this.nAtoms = atoms.length;
        this.nSymm = crystal.spaceGroup.symOps.size();
        this.cutoff2 = cutoff * cutoff;
        double side = FastMath.min((double)FastMath.min((double)crystal.a, (double)crystal.b), (double)crystal.c);
        assert (side > 2.0 * cutoff);
        this.nEdgeB = this.nEdgeA = 2;
        this.nEdgeC = this.nEdgeA;
        double minLengthA = cutoff / (double)this.nEdgeA;
        double minLengthB = cutoff / (double)this.nEdgeB;
        double minLengthC = cutoff / (double)this.nEdgeC;
        this.nA = (int)FastMath.floor((double)(crystal.a / minLengthA));
        this.nB = (int)FastMath.floor((double)(crystal.b / minLengthB));
        this.nC = (int)FastMath.floor((double)(crystal.c / minLengthC));
        if (this.nA < this.nEdgeA * 2 + 1) {
            this.nA = 1;
        }
        if (this.nB < this.nEdgeB * 2 + 1) {
            this.nB = 1;
        }
        if (this.nC < this.nEdgeC * 2 + 1) {
            this.nC = 1;
        }
        this.nAB = this.nA * this.nB;
        this.nCells = this.nAB * this.nC;
        this.cellList = new int[this.nSymm][this.nAtoms];
        this.cellIndex = new int[this.nSymm][this.nAtoms];
        this.cellOffset = new int[this.nSymm][this.nAtoms];
        this.cellStart = new int[this.nSymm][this.nCells];
        this.cellCount = new int[this.nSymm][this.nCells];
        this.cellA = new int[this.nAtoms];
        this.cellB = new int[this.nAtoms];
        this.cellC = new int[this.nAtoms];
        this.frac = new double[3][this.nAtoms];
        int threadCount = parallelTeam.getThreadCount();
        this.selectionListLoop = new SelectionListLoop[threadCount];
        for (i = 0; i < threadCount; ++i) {
            this.selectionListLoop[i] = new SelectionListLoop(this);
        }
        this.sharedSelect = new SharedBooleanArray[this.nSymm];
        for (i = 0; i < this.nSymm; ++i) {
            this.sharedSelect[i] = new SharedBooleanArray(this.nAtoms);
        }
    }

    public void buildList(double[][][] coordinates, boolean[][] selected, boolean log) {
        this.coordinates = coordinates;
        this.selected = selected;
        this.cellTime = -System.nanoTime();
        this.assignAtomsToCells();
        this.cellTime += System.nanoTime();
        this.selectTime = -System.nanoTime();
        this.selectAtoms();
        this.selectTime += System.nanoTime();
        this.totalTime = this.cellTime + this.selectTime;
        if (log) {
            this.log();
        }
    }

    public void finish() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Parallel Neighbor List: %10.3f seconds", (double)(System.nanoTime() - this.time) * 1.0E-9));
        }
    }

    public void run() {
    }

    public void start() {
        this.time = System.nanoTime();
    }

    private void log() {
        StringBuilder sb = new StringBuilder(String.format(" The cutoff is %5.2f angstroms.\n", this.cutoff));
        sb.append(String.format(" Assignment to cells: %8.3f\n", (double)this.cellTime * 1.0E-9));
        sb.append(String.format(" Selection:           %8.3f\n", (double)this.selectTime * 1.0E-9));
        sb.append(String.format(" Total:               %8.3f (sec)\n", (double)this.totalTime * 1.0E-9));
        if (this.nSymm > 1) {
            double speedup = (double)(this.nAtoms * this.nSymm) / (double)(this.nAtoms + this.nSelected);
            sb.append(String.format(" Atoms in the asymmetric unit: %12d\n", this.nAtoms));
            sb.append(String.format(" Selected symmetry mate atoms: %12d\n", this.nSelected));
            sb.append(String.format(" Babinet speed up factor:      %12.3f\n", speedup));
        }
        sb.append("\n");
        logger.info(sb.toString());
    }

    private void assignAtomsToCells() {
        for (int iSymm = 0; iSymm < this.nSymm; ++iSymm) {
            int i;
            int[] cellIndexs = this.cellIndex[iSymm];
            int[] cellCounts = this.cellCount[iSymm];
            int[] cellStarts = this.cellStart[iSymm];
            int[] cellLists = this.cellList[iSymm];
            int[] cellOffsets = this.cellOffset[iSymm];
            for (int i2 = 0; i2 < this.nCells; ++i2) {
                cellCounts[i2] = 0;
            }
            double[][] xyz = this.coordinates[iSymm];
            this.crystal.toFractionalCoordinates(this.nAtoms, xyz[0], xyz[1], xyz[2], this.frac[0], this.frac[1], this.frac[2]);
            for (i = 0; i < this.nAtoms; ++i) {
                int index;
                double xu;
                double yu = this.frac[1][i];
                double zu = this.frac[2][i];
                for (xu = this.frac[0][i]; xu >= 1.0; xu -= 1.0) {
                }
                while (xu < 0.0) {
                    xu += 1.0;
                }
                while (yu >= 1.0) {
                    yu -= 1.0;
                }
                while (yu < 0.0) {
                    yu += 1.0;
                }
                while (zu >= 1.0) {
                    zu -= 1.0;
                }
                while (zu < 0.0) {
                    zu += 1.0;
                }
                int a = (int)FastMath.floor((double)(xu * (double)this.nA));
                int b = (int)FastMath.floor((double)(yu * (double)this.nB));
                int c = (int)FastMath.floor((double)(zu * (double)this.nC));
                if (iSymm == 0) {
                    this.cellA[i] = a;
                    this.cellB[i] = b;
                    this.cellC[i] = c;
                }
                cellIndexs[i] = index = a + b * this.nA + c * this.nAB;
                int n = index;
                cellCounts[n] = cellCounts[n] + 1;
            }
            cellStarts[0] = 0;
            for (i = 1; i < this.nCells; ++i) {
                int i1 = i - 1;
                cellStarts[i] = cellStarts[i1] + cellCounts[i1];
            }
            i = 0;
            while (i < this.nAtoms) {
                int index;
                int n = index = cellIndexs[i];
                int n2 = cellStarts[n];
                cellStarts[n] = n2 + 1;
                cellLists[n2] = i++;
            }
            cellStarts[0] = 0;
            for (i = 1; i < this.nCells; ++i) {
                int i1 = i - 1;
                cellStarts[i] = cellStarts[i1] + cellCounts[i1];
            }
        }
    }

    private void selectAtoms() {
        for (int iSymm = 0; iSymm < this.nSymm; ++iSymm) {
            if (this.selected[iSymm] == null) {
                this.selected[iSymm] = new boolean[this.nAtoms];
            }
            for (int i = 0; i < this.nAtoms; ++i) {
                this.sharedSelect[iSymm].set(i, false);
            }
        }
        try {
            this.parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = "Fatal exception building neighbor list.\n";
            logger.log(Level.SEVERE, message, e);
        }
        this.nSelected = 0;
        Arrays.fill(this.selected[0], false);
        for (int iSymm = 1; iSymm < this.nSymm; ++iSymm) {
            boolean[] select = this.selected[iSymm];
            SharedBooleanArray shared = this.sharedSelect[iSymm];
            for (int i = 0; i < this.nAtoms; ++i) {
                select[i] = shared.get(i);
                if (!select[i]) continue;
                ++this.nSelected;
            }
        }
    }

    private class SelectionListLoop
    extends IntegerForLoop {
        private final IntegerSchedule schedule;
        private int iSymm;
        private int atomIndex;
        private double[][] xyz;
        private SharedBooleanArray select;
        final /* synthetic */ BulkSolventList this$0;

        public SelectionListLoop(BulkSolventList bulkSolventList) {
            BulkSolventList bulkSolventList2 = bulkSolventList;
            Objects.requireNonNull(bulkSolventList2);
            this.this$0 = bulkSolventList2;
            this.schedule = IntegerSchedule.dynamic((int)10);
        }

        public void run(int lb, int ub) {
            this.iSymm = 1;
            while (this.iSymm < this.this$0.nSymm) {
                this.select = this.this$0.sharedSelect[this.iSymm];
                this.atomIndex = lb;
                while (this.atomIndex <= ub) {
                    int a = this.this$0.cellA[this.atomIndex];
                    int b = this.this$0.cellB[this.atomIndex];
                    int c = this.this$0.cellC[this.atomIndex];
                    int aStart = a - this.this$0.nEdgeA;
                    int aStop = a + this.this$0.nEdgeA;
                    int bStart = b - this.this$0.nEdgeB;
                    int bStop = b + this.this$0.nEdgeB;
                    int cStart = c - this.this$0.nEdgeC;
                    int cStop = c + this.this$0.nEdgeC;
                    if (this.this$0.nA == 1) {
                        aStart = a;
                        aStop = a;
                    }
                    if (this.this$0.nB == 1) {
                        bStart = b;
                        bStop = b;
                    }
                    if (this.this$0.nC == 1) {
                        cStart = c;
                        cStop = c;
                    }
                    for (int ai = aStart; ai <= aStop; ++ai) {
                        for (int bi = bStart; bi <= bStop; ++bi) {
                            for (int ci = cStart; ci <= cStop; ++ci) {
                                this.selectAsymmetricAtoms(this.image(ai, bi, ci));
                            }
                        }
                    }
                    ++this.atomIndex;
                }
                ++this.iSymm;
            }
        }

        public IntegerSchedule schedule() {
            return this.schedule;
        }

        public void start() {
            this.xyz = this.this$0.coordinates[0];
        }

        private int image(int i, int j, int k) {
            if (i >= this.this$0.nA) {
                i -= this.this$0.nA;
            } else if (i < 0) {
                i += this.this$0.nA;
            }
            if (j >= this.this$0.nB) {
                j -= this.this$0.nB;
            } else if (j < 0) {
                j += this.this$0.nB;
            }
            if (k >= this.this$0.nC) {
                k -= this.this$0.nC;
            } else if (k < 0) {
                k += this.this$0.nC;
            }
            return i + j * this.this$0.nA + k * this.this$0.nAB;
        }

        private void selectAsymmetricAtoms(int pairCellIndex) {
            double xi = this.xyz[0][this.atomIndex];
            double yi = this.xyz[1][this.atomIndex];
            double zi = this.xyz[2][this.atomIndex];
            int[] pairList = this.this$0.cellList[this.iSymm];
            int start = this.this$0.cellStart[this.iSymm][pairCellIndex];
            int pairStop = start + this.this$0.cellCount[this.iSymm][pairCellIndex];
            double[][] pair = this.this$0.coordinates[this.iSymm];
            for (int j = start; j < pairStop; ++j) {
                double zj;
                double zr;
                double yj;
                double yr;
                double xj;
                double xr;
                double d2;
                int aj = pairList[j];
                if (this.select.get(aj) || !((d2 = this.this$0.crystal.image(xr = xi - (xj = pair[0][aj]), yr = yi - (yj = pair[1][aj]), zr = zi - (zj = pair[2][aj]))) <= this.this$0.cutoff2)) continue;
                this.select.set(aj, true);
            }
        }
    }
}

