/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;

public final class SolventPolyFormFactor
implements FormFactor {
    private final Atom atom;
    private final double[] xyz = new double[3];
    private final double[] dxyz = new double[3];
    private final double[] g = new double[3];
    private final double iw;
    private final double aradMinusW;
    private final double aradPlusW;
    private final double aradMinusW2;
    private final double aradPlusW2;
    private final double wMinusArad;

    public SolventPolyFormFactor(Atom atom, double arad, double w) {
        this(atom, arad, w, atom.getXYZ(null));
    }

    public SolventPolyFormFactor(Atom atom, double arad, double w, double[] xyz) {
        this.atom = atom;
        this.iw = 1.0 / w;
        this.aradMinusW = arad - w;
        this.aradPlusW = arad + w;
        this.wMinusArad = w - arad;
        this.aradMinusW2 = this.aradMinusW * this.aradMinusW;
        this.aradPlusW2 = this.aradPlusW * this.aradPlusW;
        this.update(xyz);
    }

    @Override
    public double rho(double f, double lambda, double[] xyz) {
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        double ri2 = DoubleMath.length2((double[])this.dxyz);
        if (ri2 <= this.aradMinusW2) {
            return 0.0;
        }
        if (ri2 >= this.aradPlusW2) {
            return f;
        }
        return this.rho(f, lambda, Math.sqrt(ri2));
    }

    public double rho(double f, double lambda, double ri) {
        if (ri <= this.aradMinusW) {
            return 0.0;
        }
        if (ri >= this.aradPlusW) {
            return f;
        }
        double d = ri + this.wMinusArad;
        double dw = d * this.iw;
        double dw2 = dw * dw;
        return f * (0.75 - 0.25 * dw) * dw2;
    }

    @Override
    public void rhoGrad(double[] xyz, double dfc, RefinementMode refinementmode) {
        if (refinementmode == RefinementMode.BFACTORS || refinementmode == RefinementMode.OCCUPANCIES || refinementmode == RefinementMode.BFACTORS_AND_OCCUPANCIES) {
            return;
        }
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        double ri2 = DoubleMath.length2((double[])this.dxyz);
        if (ri2 <= this.aradMinusW2 || ri2 >= this.aradPlusW2) {
            return;
        }
        double ri = Math.sqrt(ri2);
        double d = ri + this.wMinusArad;
        double dw = d * this.iw;
        double dw2 = dw * dw;
        double rho = (0.75 - 0.25 * dw) * dw2;
        double iri = 1.0 / ri;
        double dp = (1.5 * dw - 0.75 * dw2) * iri * this.iw;
        double prefactor = -dp * (dfc / rho);
        this.g[0] = prefactor * this.dxyz[0];
        this.g[1] = prefactor * this.dxyz[1];
        this.g[2] = prefactor * this.dxyz[2];
        this.atom.addToXYZGradient(this.g[0], this.g[1], this.g[2]);
    }

    @Override
    public void update(double[] xyz) {
        this.update(xyz, 0.0);
    }

    @Override
    public void update(double[] xyz, double badd) {
        this.xyz[0] = xyz[0];
        this.xyz[1] = xyz[1];
        this.xyz[2] = xyz[2];
    }
}

