/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.scatter;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinementMode;
import ffx.xray.scatter.FormFactor;
import org.apache.commons.math3.util.FastMath;

public final class SolventGaussFormFactor
implements FormFactor {
    private final Atom atom;
    private final double[] xyz = new double[3];
    private final double[] dxyz = new double[3];
    private final double[] g = new double[3];
    private final double isd2;

    public SolventGaussFormFactor(Atom atom, double sd) {
        this(atom, sd, atom.getXYZ(null));
    }

    public SolventGaussFormFactor(Atom atom, double sd, double[] xyz) {
        this.atom = atom;
        this.isd2 = 1.0 / (sd * sd);
        this.update(xyz);
    }

    @Override
    public double rho(double f, double lambda, double[] xyz) {
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        return this.rho(f, lambda, DoubleMath.length2((double[])this.dxyz));
    }

    public double rho(double f, double lambda, double rsq) {
        return f + FastMath.exp((double)(-rsq * this.isd2));
    }

    @Override
    public void rhoGrad(double[] xyz, double dfc, RefinementMode refinementmode) {
        if (refinementmode == RefinementMode.BFACTORS || refinementmode == RefinementMode.OCCUPANCIES || refinementmode == RefinementMode.BFACTORS_AND_OCCUPANCIES) {
            return;
        }
        DoubleMath.sub((double[])this.xyz, (double[])xyz, (double[])this.dxyz);
        double r2 = DoubleMath.length2((double[])this.dxyz);
        double rho = FastMath.exp((double)(-r2 * this.isd2));
        double prefactor = -dfc * 2.0 * rho * this.isd2;
        this.g[0] = prefactor * this.dxyz[0];
        this.g[1] = prefactor * this.dxyz[1];
        this.g[2] = prefactor * this.dxyz[2];
        this.atom.addToXYZGradient(this.g[0], this.g[1], this.g[2]);
    }

    @Override
    public void update(double[] xyz) {
        this.update(xyz, 0.0);
    }

    @Override
    public void update(double[] xyz, double badd) {
        this.xyz[0] = xyz[0];
        this.xyz[1] = xyz[1];
        this.xyz[2] = xyz[2];
    }
}

