/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.refine;

import ffx.potential.bonded.Atom;
import ffx.xray.refine.RefinedParameter;
import java.util.ArrayList;
import java.util.List;

public class RefinedOccupancy
extends RefinedParameter {
    private static final double OCCUPANCY_SCALE = 120.0;
    protected final List<Atom> complementList = new ArrayList<Atom>();
    protected final List<Atom> complementScatterList = new ArrayList<Atom>();

    public RefinedOccupancy(Atom atom) {
        super(atom);
    }

    @Override
    public void addConstrainedAtom(Atom atom) {
        atom.setActive(true);
        atom.setOccupancy(this.getOccupancy());
        this.constrainedAtoms.add(atom);
    }

    @Override
    public void addConstrainedAtomThatScatters(Atom atom) {
        atom.setActive(true);
        atom.setOccupancy(this.getOccupancy());
        this.constrainedAtomsThatScatter.add(atom);
    }

    public void addConstrainedAtomComplement(Atom atom) {
        atom.setActive(true);
        atom.setOccupancy(1.0 - this.getOccupancy());
        this.complementList.add(atom);
    }

    public void addConstrainedAtomThatScattersComplement(Atom atom) {
        atom.setActive(true);
        atom.setOccupancy(1.0 - this.getOccupancy());
        this.complementScatterList.add(atom);
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    public double getOccupancy() {
        return this.atom.getOccupancy();
    }

    public void setOccupancy(double occupancy) {
        this.atom.setOccupancy(occupancy);
        for (Atom a : this.constrainedAtoms) {
            a.setOccupancy(occupancy);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setOccupancy(occupancy);
        }
        for (Atom a : this.complementList) {
            a.setOccupancy(1.0 - occupancy);
        }
        for (Atom a : this.complementScatterList) {
            a.setOccupancy(1.0 - occupancy);
        }
    }

    @Override
    public void getParameters(double[] parameters) {
        double occupancy = this.atom.getOccupancy();
        parameters[this.index] = Math.asin(Math.sqrt(occupancy));
    }

    @Override
    public void setParameters(double[] parameters) {
        double sinTheta = Math.sin(parameters[this.index]);
        double occupancy = sinTheta * sinTheta;
        this.setOccupancy(occupancy);
    }

    @Override
    public void getVelocity(double[] velocity) {
        double v;
        velocity[this.index] = v = this.atom.getOccupancyVelocity();
    }

    @Override
    public void setVelocity(double[] velocity) {
        this.atom.setOccupancyVelocity(velocity[this.index]);
    }

    @Override
    public void getAcceleration(double[] acceleration) {
        double v;
        acceleration[this.index] = v = this.atom.getOccupancyAcceleration();
    }

    @Override
    public void setAcceleration(double[] acceleration) {
        this.atom.setOccupancyAcceleration(acceleration[this.index]);
    }

    @Override
    public void getPreviousAcceleration(double[] previousAcceleration) {
        double v;
        previousAcceleration[this.index] = v = this.atom.getOccupancyAcceleration();
    }

    @Override
    public void setPreviousAcceleration(double[] previousAcceleration) {
        this.atom.setOccupancyAcceleration(previousAcceleration[this.index]);
    }

    @Override
    public void setOptimizationScaling(double[] optimizationScaling) {
        optimizationScaling[this.index] = 120.0;
    }

    @Override
    public void zeroGradient() {
        this.atom.setOccupancyGradient(0.0);
        for (Atom a : this.constrainedAtoms) {
            a.setOccupancyGradient(0.0);
        }
        for (Atom a : this.constrainedAtomsThatScatter) {
            a.setOccupancyGradient(0.0);
        }
        for (Atom a : this.complementList) {
            a.setOccupancyGradient(0.0);
        }
        for (Atom a : this.complementScatterList) {
            a.setOccupancyGradient(0.0);
        }
    }

    @Override
    public void getGradient(double[] gradient) {
        gradient[this.index] = this.atom.getOccupancyGradient();
        for (Atom a : this.constrainedAtomsThatScatter) {
            int n = this.index;
            gradient[n] = gradient[n] + a.getOccupancyGradient();
        }
        for (Atom a : this.complementScatterList) {
            int n = this.index;
            gradient[n] = gradient[n] - a.getOccupancyGradient();
        }
        double theta = Math.asin(Math.sqrt(this.getOccupancy()));
        double sin2Theta = Math.sin(2.0 * theta);
        int n = this.index;
        gradient[n] = gradient[n] * sin2Theta;
    }

    @Override
    public void getMass(double[] mass, double defaultMass) {
        mass[this.index] = defaultMass;
    }

    public String toString() {
        return String.format(" Occupancy: %10.6f", this.atom.getOccupancy());
    }
}

