/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.ReflectionSpline;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SymOp;
import ffx.utilities.TinkerUtils;
import ffx.xray.DiffractionRefinementData;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class MTZWriter {
    private static final Logger logger = Logger.getLogger(MTZWriter.class.getName());
    private final String fileName;
    private final ReflectionList reflectionList;
    private final DiffractionRefinementData refinementData;
    private final Crystal crystal;
    private final SpaceGroup spaceGroup;
    private final ReflectionSpline spline;
    private final int n;
    private final int nCol;
    private final int mtzType;

    public MTZWriter(ReflectionList reflectionList, DiffractionRefinementData refinementData, String filename) {
        this(reflectionList, refinementData, filename, 3);
    }

    public MTZWriter(ReflectionList reflectionList, DiffractionRefinementData refinementData, String filename, int mtzType) {
        this.reflectionList = reflectionList;
        this.refinementData = refinementData;
        this.crystal = reflectionList.crystal;
        this.spaceGroup = this.crystal.spaceGroup;
        this.spline = new ReflectionSpline(reflectionList, refinementData.spline.length);
        this.fileName = filename;
        this.n = refinementData.n - 1;
        this.mtzType = mtzType;
        switch (mtzType) {
            case 1: {
                this.nCol = 6;
                break;
            }
            case 2: {
                this.nCol = 7;
                break;
            }
            default: {
                this.nCol = 18;
            }
        }
    }

    public void write() {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        File file = TinkerUtils.version((File)new File(this.fileName));
        String name = file.getName();
        try {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(String.format("\n Saving %s", name));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            byte[] bytes = new byte[80];
            int offset = 0;
            int writeLen = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("MTZ ");
            dataOutputStream.writeBytes(sb.toString());
            int headerOffset = this.n * this.nCol + 21;
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(byteOrder).putInt(headerOffset);
            int iMapData = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? 17473 : 4369;
            byteBuffer.order(byteOrder).putInt(iMapData);
            dataOutputStream.write(bytes, offset, 8);
            sb = new StringBuilder();
            sb.append(" ");
            sb.setLength(68);
            dataOutputStream.writeBytes(sb.toString());
            Vector<String> colname = new Vector<String>(this.nCol);
            char[] colType = new char[this.nCol];
            double[] res = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            float[][] colMinMax = new float[this.nCol][2];
            for (int i = 0; i < this.nCol; ++i) {
                colMinMax[i][0] = Float.POSITIVE_INFINITY;
                colMinMax[i][1] = Float.NEGATIVE_INFINITY;
            }
            ReflectionSpline sigmaASpline = new ReflectionSpline(this.reflectionList, this.refinementData.sigmaA.length);
            int col = 0;
            colname.add("H");
            colType[col++] = 72;
            colname.add("K");
            colType[col++] = 72;
            colname.add("L");
            colType[col++] = 72;
            writeLen += 12;
            if (this.mtzType != 2) {
                colname.add("FO");
                colType[col++] = 70;
                colname.add("SIGFO");
                colType[col++] = 81;
                colname.add("FreeR");
                colType[col++] = 73;
                writeLen += 12;
            }
            if (this.mtzType != 1) {
                colname.add("Fs");
                colType[col++] = 70;
                colname.add("PHIFs");
                colType[col++] = 80;
                colname.add("Fc");
                colType[col++] = 70;
                colname.add("PHIFc");
                colType[col++] = 80;
                writeLen += 16;
            }
            if (this.mtzType == 3) {
                colname.add("FOM");
                colType[col++] = 87;
                colname.add("PHIW");
                colType[col++] = 80;
                colname.add("SigmaAs");
                colType[col++] = 70;
                colname.add("SigmaAw");
                colType[col++] = 81;
                colname.add("FWT");
                colType[col++] = 70;
                colname.add("PHWT");
                colType[col++] = 80;
                colname.add("DELFWT");
                colType[col++] = 70;
                colname.add("PHDELWT");
                colType[col] = 80;
                writeLen += 32;
            }
            for (HKL ih : this.reflectionList.hklList) {
                col = 0;
                int i = ih.getIndex();
                if (ih.getH() == 0 && ih.getK() == 0 && ih.getL() == 0) continue;
                double ss = this.crystal.invressq(ih);
                res[0] = FastMath.min((double)ss, (double)res[0]);
                res[1] = FastMath.max((double)ss, (double)res[1]);
                float fMapData = ih.getH();
                colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[0][0]);
                colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[0][1]);
                byteBuffer.rewind();
                byteBuffer.order(byteOrder).putFloat(fMapData);
                fMapData = ih.getK();
                colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[1][0]);
                colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[1][1]);
                byteBuffer.order(byteOrder).putFloat(fMapData);
                fMapData = ih.getL();
                colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[2][0]);
                colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[2][1]);
                byteBuffer.order(byteOrder).putFloat(fMapData);
                ++col;
                if (this.mtzType != 2) {
                    fMapData = (float)this.refinementData.getF(i);
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)this.refinementData.getSigF(i);
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = this.refinementData.getFreeR(i);
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                }
                if (this.mtzType == 2) {
                    fMapData = (float)this.refinementData.fsF(i);
                    colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.fsPhi(i));
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)this.refinementData.fcF(i);
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)Math.toDegrees(this.refinementData.fcPhi(i));
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                }
                if (this.mtzType == 3) {
                    fMapData = (float)this.refinementData.fsF(i);
                    colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.fsPhi(i));
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)this.refinementData.fcTotF(i);
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.fcTotPhi(i));
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = Math.min(fMapData, colMinMax[col][0]);
                        colMinMax[col][1] = Math.max(fMapData, colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)this.refinementData.fomPhi[i][0];
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = Math.min(fMapData, colMinMax[col][0]);
                        colMinMax[col][1] = Math.max(fMapData, colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.fomPhi[i][1]);
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    this.spline.f(ss, this.refinementData.spline);
                    double sa = sigmaASpline.f(ss, this.refinementData.sigmaA);
                    double wa = sigmaASpline.f(ss, this.refinementData.sigmaW);
                    fMapData = (float)sa;
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    ++col;
                    fMapData = (float)wa;
                    if (!Double.isNaN(fMapData)) {
                        colMinMax[col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                        colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    }
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)this.refinementData.FoFc2F(i);
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.FoFc2Phi(i));
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)this.refinementData.foFc1F(i);
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                    fMapData = (float)FastMath.toDegrees((double)this.refinementData.foFc1Phi(i));
                    colMinMax[++col][0] = FastMath.min((float)fMapData, (float)colMinMax[col][0]);
                    colMinMax[col][1] = FastMath.max((float)fMapData, (float)colMinMax[col][1]);
                    byteBuffer.order(byteOrder).putFloat(fMapData);
                }
                dataOutputStream.write(bytes, offset, writeLen);
            }
            sb = new StringBuilder();
            sb.append("VERS MTZ:V1.1 ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            Date now = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss ");
            sb = new StringBuilder();
            sb.append("TITLE FFX output: ").append(sdf.format(now));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append(String.format("NCOL %8d %12d %8d", this.nCol, this.n, 0));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("SORT    0    0    0    0    0 ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            char cdata = this.spaceGroup.shortName.charAt(0);
            if (cdata == 'H') {
                cdata = 'R';
            }
            sb.append(String.format("SYMINF %3d %2d %c %5d %22s %5s", this.spaceGroup.getNumberOfSymOps(), this.spaceGroup.numPrimitiveSymEquiv, Character.valueOf(cdata), this.spaceGroup.number, "'" + this.spaceGroup.shortName + "'", this.spaceGroup.pointGroupName));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            for (int i = 0; i < this.spaceGroup.symOps.size(); ++i) {
                sb = new StringBuilder();
                sb.append("SYMM ");
                SymOp symop = (SymOp)this.spaceGroup.symOps.get(i);
                sb.append(symop.toXYZString());
                while (sb.length() < 80) {
                    sb.append(" ");
                }
                dataOutputStream.writeBytes(sb.toString());
            }
            sb = new StringBuilder();
            sb.append(String.format("RESO %8.6f%13s%8.6f", res[0], " ", res[1]));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("VALM NAN ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("NDIF        1 ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("PROJECT       1 project ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("CRYSTAL       1 crystal ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("DATASET       1 dataset ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            for (int j = 0; j < this.nCol; ++j) {
                sb = new StringBuilder();
                sb.append(String.format("COLUMN %-30s %c %17.4f %17.4f    1", colname.get(j), Character.valueOf(colType[j]), Float.valueOf(colMinMax[j][0]), Float.valueOf(colMinMax[j][1])));
                dataOutputStream.writeBytes(sb.toString());
            }
            sb = new StringBuilder();
            sb.append(String.format("CELL %10.4f %9.4f %9.4f %9.4f %9.4f %9.4f ", this.crystal.a, this.crystal.b, this.crystal.c, this.crystal.alpha, this.crystal.beta, this.crystal.gamma));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append(String.format("DCELL %9d %10.4f %9.4f %9.4f %9.4f %9.4f %9.4f ", 1, this.crystal.a, this.crystal.b, this.crystal.c, this.crystal.alpha, this.crystal.beta, this.crystal.gamma));
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("DWAVEL        1    1.00000 ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("END ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            sb = new StringBuilder();
            sb.append("MTZENDOFHEADERS ");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dataOutputStream.writeBytes(sb.toString());
            dataOutputStream.close();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(String.format(" Wrote MTZ to file %s", file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating structure factors.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public static interface MTZType {
        public static final int DATAONLY = 1;
        public static final int FCONLY = 2;
        public static final int ALL = 3;
    }
}

