/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.crystal.SpaceGroupInfo;
import ffx.numerics.math.ComplexNumber;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.parsers.DiffractionFileFilter;
import ffx.xray.parsers.MTZWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.lang3.Strings;
import org.apache.commons.math3.util.FastMath;

public class MTZFilter
implements DiffractionFileFilter {
    private static final Logger logger = Logger.getLogger(MTZFilter.class.getName());
    private final ArrayList<Column> columns = new ArrayList();
    private final ArrayList<Dataset> dataSets = new ArrayList();
    private boolean headerParsed = false;
    private String title;
    private String foString;
    private String sigFoString;
    private String rFreeString;
    private int h;
    private int k;
    private int l;
    private int fo;
    private int sigFo;
    private int rFree;
    private int fPlus;
    private int sigFPlus;
    private int fMinus;
    private int sigFMinus;
    private int rFreePlus;
    private int rFreeMinus;
    private int fc;
    private int phiC;
    private int fs;
    private int phiS;
    private int dsetOffset = 1;
    private int nColumns;
    private int nReflections;
    private int spaceGroupNum;
    private String spaceGroupName;
    private double resLow;
    private double resHigh;

    public void averageFcs(File mtzFile1, File mtzFile2, ReflectionList reflectionlist, int iter, CompositeConfiguration properties) {
        DiffractionRefinementData fcdata1 = new DiffractionRefinementData(properties, reflectionlist);
        DiffractionRefinementData fcdata2 = new DiffractionRefinementData(properties, reflectionlist);
        this.readFcs(mtzFile1, reflectionlist, fcdata1, properties);
        this.readFcs(mtzFile2, reflectionlist, fcdata2, properties);
        logger.info(String.format(" Iteration for averaging: %d.", iter));
        for (int i = 0; i < reflectionlist.hklList.size(); ++i) {
            double[] dArray = fcdata1.fc[i];
            dArray[0] = dArray[0] + (fcdata2.fc[i][0] - fcdata1.fc[i][0]) / (double)iter;
            double[] dArray2 = fcdata1.fc[i];
            dArray2[1] = dArray2[1] + (fcdata2.fc[i][1] - fcdata1.fc[i][1]) / (double)iter;
            double[] dArray3 = fcdata1.fs[i];
            dArray3[0] = dArray3[0] + (fcdata2.fs[i][0] - fcdata1.fs[i][0]) / (double)iter;
            double[] dArray4 = fcdata1.fs[i];
            dArray4[1] = dArray4[1] + (fcdata2.fs[i][1] - fcdata1.fs[i][1]) / (double)iter;
        }
        MTZWriter mtzOut = new MTZWriter(reflectionlist, fcdata1, mtzFile1.getName(), 2);
        mtzOut.write();
    }

    @Override
    public ReflectionList getReflectionList(File mtzFile, CompositeConfiguration properties) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        try {
            FileInputStream fileInputStream = new FileInputStream(mtzFile);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] headerOffset = new byte[4];
            byte[] bytes = new byte[80];
            int offset = 0;
            dataInputStream.read(bytes, offset, 4);
            dataInputStream.read(headerOffset, offset, 4);
            dataInputStream.read(bytes, offset, 4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int stamp = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
            String stampstr = Integer.toHexString(stamp);
            switch (stampstr.charAt(0)) {
                case '1': 
                case '3': {
                    if (!byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) break;
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case '4': {
                    if (!byteOrder.equals(ByteOrder.BIG_ENDIAN)) break;
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
            }
            byteBuffer = ByteBuffer.wrap(headerOffset);
            int headerOffsetI = byteBuffer.order(byteOrder).getInt();
            dataInputStream.skipBytes((headerOffsetI - 4) * 4);
            Boolean parsing = true;
            while (parsing.booleanValue()) {
                String mtzstr = new String(bytes);
                parsing = this.parseHeader(mtzstr);
                dataInputStream.read(bytes, offset, 80);
            }
        }
        catch (EOFException e) {
            String message = " MTZ end of file reached.";
            logger.log(Level.WARNING, message, e);
            return null;
        }
        catch (IOException e) {
            String message = " MTZ IO exception.";
            logger.log(Level.WARNING, message, e);
            return null;
        }
        this.rFreeString = null;
        this.sigFoString = null;
        this.foString = null;
        if (properties != null) {
            this.foString = properties.getString("fostring", null);
            this.sigFoString = properties.getString("sigfostring", null);
            this.rFreeString = properties.getString("rfreestring", null);
        }
        this.rFree = -1;
        this.sigFo = -1;
        this.fo = -1;
        this.l = -1;
        this.k = -1;
        this.h = -1;
        this.rFreeMinus = -1;
        this.rFreePlus = -1;
        this.sigFMinus = -1;
        this.fMinus = -1;
        this.sigFPlus = -1;
        this.fPlus = -1;
        this.phiC = -1;
        this.fc = -1;
        boolean print = false;
        this.parseColumns(print);
        this.parseFcColumns(print);
        if (this.fo < 0 && this.fPlus < 0 && this.sigFo < 0 && this.sigFPlus < 0 && this.fc < 0 && this.phiC < 0) {
            logger.info(" The MTZ header contains insufficient information to generate the reflection list.");
            logger.info(" For non-default column labels set fostring/sigfostring in the properties file.");
            return null;
        }
        Column column = this.fo > 0 ? this.columns.get(this.fo) : (this.fPlus > 0 ? this.columns.get(this.fPlus) : this.columns.get(this.fc));
        Dataset dataSet = this.dataSets.get(column.id - this.dsetOffset);
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Reading %s\n", mtzFile.getName()));
            sb.append("  Setting up reflection list based on MTZ file.\n");
            sb.append(String.format("  Space group number: %d (name: %s)\n", this.spaceGroupNum, SpaceGroupInfo.spaceGroupNames[this.spaceGroupNum - 1]));
            sb.append(String.format("  Resolution:         %8.3f\n", 0.999999 * this.resHigh));
            sb.append(String.format("  Cell:               %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f", dataSet.cell[0], dataSet.cell[1], dataSet.cell[2], dataSet.cell[3], dataSet.cell[4], dataSet.cell[5]));
            logger.info(sb.toString());
        }
        Crystal crystal = new Crystal(dataSet.cell[0], dataSet.cell[1], dataSet.cell[2], dataSet.cell[3], dataSet.cell[4], dataSet.cell[5], SpaceGroupInfo.spaceGroupNames[this.spaceGroupNum - 1]);
        double sampling = 0.6;
        if (properties != null) {
            sampling = properties.getDouble("sampling", 0.6);
        }
        Resolution resolution = new Resolution(0.999999 * this.resHigh, sampling);
        return new ReflectionList(crystal, resolution, properties);
    }

    @Override
    public ReflectionList getReflectionList(File mtzFile) {
        return this.getReflectionList(mtzFile, null);
    }

    @Override
    public double getResolution(File mtzFile, Crystal crystal) {
        this.getReflectionList(mtzFile, null);
        return this.resHigh;
    }

    public void printHeader() {
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(" MTZ title: ").append(this.title).append("\n");
            sb.append(" MTZ space group: ").append(this.spaceGroupName).append(" space group number: ").append(this.spaceGroupNum).append(" (").append(SpaceGroupInfo.spaceGroupNames[this.spaceGroupNum - 1]).append(")\n");
            sb.append(" MTZ resolution: ").append(this.resLow).append(" - ").append(this.resHigh).append("\n");
            sb.append(" Number of reflections: ").append(this.nReflections).append("\n");
            int ndset = 1;
            for (Dataset d : this.dataSets) {
                sb.append("  dataset ").append(ndset).append(": ").append(d.dataset).append("\n");
                sb.append("  project ").append(ndset).append(": ").append(d.project).append("\n");
                sb.append("  wavelength ").append(ndset).append(": ").append(d.lambda).append("\n");
                sb.append("  cell ").append(ndset).append(": ").append(d.cell[0]).append(" ").append(d.cell[1]).append(" ").append(d.cell[2]).append(" ").append(d.cell[3]).append(" ").append(d.cell[4]).append(" ").append(d.cell[5]).append("\n");
                sb.append("\n");
                ++ndset;
            }
            sb.append(" Number of columns: ").append(this.nColumns).append("\n");
            int nc = 0;
            for (Column c : this.columns) {
                sb.append(String.format("  column %d: dataset id: %d min: %9.2f max: %9.2f label: %s type: %c\n", nc, c.id, c.min, c.max, c.label, Character.valueOf(c.type)));
                ++nc;
            }
            logger.info(sb.toString());
        }
    }

    @Override
    public boolean readFile(File mtzFile, ReflectionList reflectionList, DiffractionRefinementData refinementData, CompositeConfiguration properties) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        boolean transpose = false;
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            FileInputStream fileInputStream = new FileInputStream(mtzFile);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] headerOffset = new byte[4];
            byte[] bytes = new byte[80];
            int offset = 0;
            dataInputStream.read(bytes, offset, 4);
            dataInputStream.read(headerOffset, offset, 4);
            dataInputStream.read(bytes, offset, 4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int stamp = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
            String stampString = Integer.toHexString(stamp);
            switch (stampString.charAt(0)) {
                case '1': 
                case '3': {
                    if (!byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) break;
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case '4': {
                    if (!byteOrder.equals(ByteOrder.BIG_ENDIAN)) break;
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
            }
            byteBuffer = ByteBuffer.wrap(headerOffset);
            int headerOffsetI = byteBuffer.order(byteOrder).getInt();
            dataInputStream.skipBytes((headerOffsetI - 4) * 4);
            Boolean parsing = true;
            while (parsing.booleanValue()) {
                String mtzstr = new String(bytes);
                parsing = this.parseHeader(mtzstr);
                dataInputStream.read(bytes, offset, 80);
            }
            this.rFreeString = null;
            this.sigFoString = null;
            this.foString = null;
            if (properties != null) {
                this.foString = properties.getString("fostring", null);
                this.sigFoString = properties.getString("sigfostring", null);
                this.rFreeString = properties.getString("rfreestring", null);
            }
            this.rFree = -1;
            this.sigFo = -1;
            this.fo = -1;
            this.l = -1;
            this.k = -1;
            this.h = -1;
            this.rFreeMinus = -1;
            this.rFreePlus = -1;
            this.sigFMinus = -1;
            this.fMinus = -1;
            this.sigFPlus = -1;
            this.fPlus = -1;
            boolean print = true;
            this.parseColumns(print);
            if (this.h < 0 || this.k < 0 || this.l < 0) {
                String message = "Fatal error in MTZ file - no H K L indexes?\n";
                logger.log(Level.SEVERE, message);
                return false;
            }
            fileInputStream = new FileInputStream(mtzFile);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(80);
            float[] data = new float[this.nColumns];
            HKL mate = new HKL();
            int nPosIgnore = 0;
            int nTransIgnore = 0;
            int nZero = 0;
            int none = 0;
            for (int i2 = 0; i2 < this.nReflections; ++i2) {
                for (int j = 0; j < this.nColumns; ++j) {
                    dataInputStream.read(bytes, offset, 4);
                    byteBuffer = ByteBuffer.wrap(bytes);
                    data[j] = byteBuffer.order(byteOrder).getFloat();
                }
                int ih = (int)data[this.h];
                int ik = (int)data[this.k];
                int il = (int)data[this.l];
                reflectionList.findSymHKL(ih, ik, il, mate, false);
                HKL hklpos = reflectionList.getHKL(mate);
                if (hklpos == null) {
                    ++nPosIgnore;
                }
                reflectionList.findSymHKL(ih, ik, il, mate, true);
                HKL hkltrans = reflectionList.getHKL(mate);
                if (hkltrans == null) {
                    ++nTransIgnore;
                }
                if (this.rFree > 0) {
                    if ((int)data[this.rFree] == 0) {
                        ++nZero;
                    } else if ((int)data[this.rFree] == 1) {
                        ++none;
                    }
                }
                if (this.rFreePlus > 0) {
                    if ((int)data[this.rFreePlus] == 0) {
                        ++nZero;
                    } else if ((int)data[this.rFreePlus] == 1) {
                        ++none;
                    }
                }
                if (this.rFreeMinus <= 0) continue;
                if ((int)data[this.rFreeMinus] == 0) {
                    ++nZero;
                    continue;
                }
                if ((int)data[this.rFreeMinus] != 1) continue;
                ++none;
            }
            if (nPosIgnore > nTransIgnore) {
                transpose = true;
            }
            if (none > nZero * 2 && refinementData.rFreeFlag < 0) {
                refinementData.setFreeRFlag(0);
                sb.append(String.format(" Setting R free flag to %d based on MTZ file data.\n", refinementData.rFreeFlag));
            } else if (nZero > none * 2 && refinementData.rFreeFlag < 0) {
                refinementData.setFreeRFlag(1);
                sb.append(String.format(" Setting R free flag to %d based on MTZ file data.\n", refinementData.rFreeFlag));
            } else if (refinementData.rFreeFlag < 0) {
                refinementData.setFreeRFlag(0);
                sb.append(String.format(" Setting R free flag to MTZ default: %d\n", refinementData.rFreeFlag));
            }
            fileInputStream = new FileInputStream(mtzFile);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(80);
            double[][] anofSigF = new double[refinementData.n][4];
            for (i = 0; i < refinementData.n; ++i) {
                anofSigF[i][3] = Double.NaN;
                anofSigF[i][2] = Double.NaN;
                anofSigF[i][1] = Double.NaN;
                anofSigF[i][0] = Double.NaN;
            }
            int nCut = 0;
            int nFriedel = 0;
            int nRes = 0;
            int nIgnore = 0;
            int nRead = 0;
            for (i = 0; i < this.nReflections; ++i) {
                for (int j = 0; j < this.nColumns; ++j) {
                    dataInputStream.read(bytes, offset, 4);
                    byteBuffer = ByteBuffer.wrap(bytes);
                    data[j] = byteBuffer.order(byteOrder).getFloat();
                }
                int ih = (int)data[this.h];
                int ik = (int)data[this.k];
                int il = (int)data[this.l];
                boolean friedel = reflectionList.findSymHKL(ih, ik, il, mate, transpose);
                HKL hkl = reflectionList.getHKL(mate);
                if (hkl != null) {
                    if (this.fo > 0 && this.sigFo > 0) {
                        if (refinementData.fSigFCutoff > 0.0 && (double)(data[this.fo] / data[this.sigFo]) < refinementData.fSigFCutoff) {
                            ++nCut;
                            continue;
                        }
                        if (friedel) {
                            anofSigF[hkl.getIndex()][2] = data[this.fo];
                            anofSigF[hkl.getIndex()][3] = data[this.sigFo];
                            ++nFriedel;
                        } else {
                            anofSigF[hkl.getIndex()][0] = data[this.fo];
                            anofSigF[hkl.getIndex()][1] = data[this.sigFo];
                        }
                    } else {
                        if (this.fPlus > 0 && this.sigFPlus > 0) {
                            if (refinementData.fSigFCutoff > 0.0 && (double)(data[this.fPlus] / data[this.sigFPlus]) < refinementData.fSigFCutoff) {
                                ++nCut;
                                continue;
                            }
                            anofSigF[hkl.getIndex()][0] = data[this.fPlus];
                            anofSigF[hkl.getIndex()][1] = data[this.sigFPlus];
                        }
                        if (this.fMinus > 0 && this.sigFMinus > 0) {
                            if (refinementData.fSigFCutoff > 0.0 && (double)(data[this.fMinus] / data[this.sigFMinus]) < refinementData.fSigFCutoff) {
                                ++nCut;
                                continue;
                            }
                            anofSigF[hkl.getIndex()][2] = data[this.fMinus];
                            anofSigF[hkl.getIndex()][3] = data[this.sigFMinus];
                        }
                    }
                    if (this.rFree > 0) {
                        refinementData.setFreeR(hkl.getIndex(), (int)data[this.rFree]);
                    } else if (this.rFreePlus > 0 && this.rFreeMinus > 0) {
                        refinementData.setFreeR(hkl.getIndex(), (int)data[this.rFreePlus]);
                    } else if (this.rFreePlus > 0) {
                        refinementData.setFreeR(hkl.getIndex(), (int)data[this.rFreePlus]);
                    } else if (this.rFreeMinus > 0) {
                        refinementData.setFreeR(hkl.getIndex(), (int)data[this.rFreeMinus]);
                    }
                    ++nRead;
                    continue;
                }
                HKL tmp = new HKL(ih, ik, il);
                if (!reflectionList.resolution.inInverseResSqRange(reflectionList.crystal.invressq(tmp))) {
                    ++nRes;
                    continue;
                }
                ++nIgnore;
            }
            refinementData.generateFsigFfromAnomalousFsigF(anofSigF);
            if (logger.isLoggable(Level.INFO)) {
                sb.append(String.format(" MTZ file type (machine stamp): %s\n", stampString));
                sb.append(String.format(" HKL data is %s\n", transpose ? "transposed" : "not transposed"));
                sb.append(String.format(" HKL read in:                             %d\n", nRead));
                sb.append(String.format(" HKL read as friedel mates:               %d\n", nFriedel));
                sb.append(String.format(" HKL NOT read in (too high resolution):   %d\n", nRes));
                sb.append(String.format(" HKL NOT read in (not in internal list?): %d\n", nIgnore));
                sb.append(String.format(" HKL NOT read in (F/sigF cutoff):         %d\n", nCut));
                sb.append(String.format(" HKL in internal list:                    %d", reflectionList.hklList.size()));
                logger.info(sb.toString());
            }
            if (this.rFree < 0 && this.rFreePlus < 0 && this.rFreeMinus < 0) {
                refinementData.generateRFree();
            }
        }
        catch (EOFException e) {
            String message = " MTZ end of file reached.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        catch (IOException e) {
            String message = " MTZ IO Exception.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        return true;
    }

    private boolean readFcs(File mtzFile, ReflectionList reflectionList, DiffractionRefinementData fcData, CompositeConfiguration properties) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        StringBuilder sb = new StringBuilder();
        try {
            FileInputStream fileInputStream = new FileInputStream(mtzFile);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] headerOffset = new byte[4];
            byte[] bytes = new byte[80];
            int offset = 0;
            dataInputStream.read(bytes, offset, 4);
            dataInputStream.read(headerOffset, offset, 4);
            dataInputStream.read(bytes, offset, 4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int stamp = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt();
            String stampString = Integer.toHexString(stamp);
            switch (stampString.charAt(0)) {
                case '1': 
                case '3': {
                    if (!byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) break;
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case '4': {
                    if (!byteOrder.equals(ByteOrder.BIG_ENDIAN)) break;
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
            }
            byteBuffer = ByteBuffer.wrap(headerOffset);
            int headerOffsetI = byteBuffer.order(byteOrder).getInt();
            dataInputStream.skipBytes((headerOffsetI - 4) * 4);
            Boolean parsing = true;
            while (parsing.booleanValue()) {
                String mtzString = new String(bytes);
                parsing = this.parseHeader(mtzString);
                dataInputStream.read(bytes, offset, 80);
            }
            this.phiS = -1;
            this.fs = -1;
            this.phiC = -1;
            this.fc = -1;
            boolean print = true;
            this.parseFcColumns(print);
            if (this.h < 0 || this.k < 0 || this.l < 0) {
                String message = " Fatal error in MTZ file - no H K L indexes?\n";
                logger.log(Level.SEVERE, message);
                return false;
            }
            fileInputStream = new FileInputStream(mtzFile);
            dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.skipBytes(80);
            float[] data = new float[this.nColumns];
            HKL mate = new HKL();
            ComplexNumber complexNumber = new ComplexNumber();
            int nCut = 0;
            int nFriedel = 0;
            int nRes = 0;
            int nIgnore = 0;
            int nRead = 0;
            for (int i = 0; i < this.nReflections; ++i) {
                for (int j = 0; j < this.nColumns; ++j) {
                    dataInputStream.read(bytes, offset, 4);
                    byteBuffer = ByteBuffer.wrap(bytes);
                    data[j] = byteBuffer.order(byteOrder).getFloat();
                }
                int ih = (int)data[this.h];
                int ik = (int)data[this.k];
                int il = (int)data[this.l];
                reflectionList.findSymHKL(ih, ik, il, mate, false);
                HKL hkl = reflectionList.getHKL(mate);
                if (hkl != null) {
                    if (this.fc > 0 && this.phiC > 0) {
                        complexNumber.re((double)data[this.fc] * FastMath.cos((double)FastMath.toRadians((double)data[this.phiC])));
                        complexNumber.im((double)data[this.fc] * FastMath.sin((double)FastMath.toRadians((double)data[this.phiC])));
                        fcData.setFc(hkl.getIndex(), complexNumber);
                    }
                    if (this.fs > 0 && this.phiS > 0) {
                        complexNumber.re((double)data[this.fs] * FastMath.cos((double)FastMath.toRadians((double)data[this.phiS])));
                        complexNumber.im((double)data[this.fs] * FastMath.sin((double)FastMath.toRadians((double)data[this.phiS])));
                        fcData.setFs(hkl.getIndex(), complexNumber);
                    }
                    ++nRead;
                    continue;
                }
                HKL tmp = new HKL(ih, ik, il);
                if (!reflectionList.resolution.inInverseResSqRange(reflectionList.crystal.invressq(tmp))) {
                    ++nRes;
                    continue;
                }
                ++nIgnore;
            }
            if (logger.isLoggable(Level.INFO)) {
                sb.append(String.format(" MTZ file type (machine stamp): %s\n", stampString));
                sb.append(String.format("  Fc HKL read in:                             %d\n", nRead));
                sb.append(String.format("  Fc HKL read as friedel mates:               %d\n", nFriedel));
                sb.append(String.format("  Fc HKL NOT read in (too high resolution):   %d\n", nRes));
                sb.append(String.format("  Fc HKL NOT read in (not in internal list?): %d\n", nIgnore));
                sb.append(String.format("  Fc HKL NOT read in (F/sigF cutoff):         %d\n", nCut));
                sb.append(String.format("  HKL in internal list:                       %d\n", reflectionList.hklList.size()));
                logger.info(sb.toString());
            }
        }
        catch (EOFException e) {
            String message = " MTZ end of file reached.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        catch (IOException e) {
            String message = " MTZ IO Exception.";
            logger.log(Level.WARNING, message, e);
            return false;
        }
        return true;
    }

    private Boolean parseHeader(String str) {
        boolean parsing = true;
        String[] strArray = str.split("\\s+");
        if (this.headerParsed) {
            return Header.toHeader(strArray[0]) != Header.END;
        }
        switch (Header.toHeader(strArray[0]).ordinal()) {
            case 1: {
                this.title = str.substring(5);
                break;
            }
            case 2: {
                this.nColumns = Integer.parseInt(strArray[1]);
                this.nReflections = Integer.parseInt(strArray[2]);
                int nBatches = Integer.parseInt(strArray[3]);
                break;
            }
            case 4: {
                String[] tmp = str.split("'+");
                this.spaceGroupNum = Integer.parseInt(strArray[4]);
                if (tmp.length <= 1) break;
                this.spaceGroupName = tmp[1];
                break;
            }
            case 6: {
                double r1 = FastMath.sqrt((double)(1.0 / (double)Float.parseFloat(strArray[1])));
                double r2 = FastMath.sqrt((double)(1.0 / (double)Float.parseFloat(strArray[2])));
                this.resLow = FastMath.max((double)r1, (double)r2);
                this.resHigh = FastMath.min((double)r1, (double)r2);
                break;
            }
            case 10: {
                int ndif = Integer.parseInt(strArray[1]);
                break;
            }
            case 8: 
            case 9: {
                int nDataSet = Integer.parseInt(strArray[5]);
                if (nDataSet == 0) {
                    this.dsetOffset = 0;
                }
                Column column = new Column();
                this.columns.add(column);
                column.label = strArray[1];
                column.type = strArray[2].charAt(0);
                column.id = nDataSet;
                column.min = Double.parseDouble(strArray[3]);
                column.max = Double.parseDouble(strArray[4]);
                break;
            }
            case 11: {
                Dataset dataSet;
                int nDataSet = Integer.parseInt(strArray[1]);
                if (nDataSet == 0) {
                    this.dsetOffset = 0;
                }
                try {
                    dataSet = this.dataSets.get(nDataSet - this.dsetOffset);
                }
                catch (IndexOutOfBoundsException e) {
                    dataSet = new Dataset();
                    this.dataSets.add(dataSet);
                }
                dataSet.project = strArray[2];
                break;
            }
            case 13: {
                Dataset dataSet;
                int nDataSet = Integer.parseInt(strArray[1]);
                if (nDataSet == 0) {
                    this.dsetOffset = 0;
                }
                try {
                    dataSet = this.dataSets.get(nDataSet - this.dsetOffset);
                }
                catch (IndexOutOfBoundsException e) {
                    dataSet = new Dataset();
                    this.dataSets.add(dataSet);
                }
                dataSet.dataset = strArray[2];
                break;
            }
            case 14: {
                Dataset dataSet;
                int nDataSet = Integer.parseInt(strArray[1]);
                if (nDataSet == 0) {
                    this.dsetOffset = 0;
                }
                try {
                    dataSet = this.dataSets.get(nDataSet - this.dsetOffset);
                }
                catch (IndexOutOfBoundsException e) {
                    dataSet = new Dataset();
                    this.dataSets.add(dataSet);
                }
                dataSet.cell[0] = Double.parseDouble(strArray[2]);
                dataSet.cell[1] = Double.parseDouble(strArray[3]);
                dataSet.cell[2] = Double.parseDouble(strArray[4]);
                dataSet.cell[3] = Double.parseDouble(strArray[5]);
                dataSet.cell[4] = Double.parseDouble(strArray[6]);
                dataSet.cell[5] = Double.parseDouble(strArray[7]);
                break;
            }
            case 15: {
                Dataset dataSet;
                int nDataSet = Integer.parseInt(strArray[1]);
                if (nDataSet == 0) {
                    this.dsetOffset = 0;
                }
                try {
                    dataSet = this.dataSets.get(nDataSet - this.dsetOffset);
                }
                catch (IndexOutOfBoundsException e) {
                    dataSet = new Dataset();
                    this.dataSets.add(dataSet);
                }
                dataSet.lambda = Double.parseDouble(strArray[2]);
                break;
            }
            case 17: {
                this.headerParsed = true;
                parsing = false;
                break;
            }
        }
        return parsing;
    }

    private void parseColumns(boolean print) {
        int nc = 0;
        StringBuilder sb = new StringBuilder();
        for (Column column : this.columns) {
            String label = column.label.trim();
            if (label.equalsIgnoreCase("H") && column.type == 'H') {
                this.h = nc;
            } else if (label.equalsIgnoreCase("K") && column.type == 'H') {
                this.k = nc;
            } else if (label.equalsIgnoreCase("L") && column.type == 'H') {
                this.l = nc;
            } else if ((label.equalsIgnoreCase("free") || label.equalsIgnoreCase("freer") || label.equalsIgnoreCase("freerflag") || label.equalsIgnoreCase("freer_flag") || label.equalsIgnoreCase("rfree") || label.equalsIgnoreCase("rfreeflag") || label.equalsIgnoreCase("r-free-flags") || label.equalsIgnoreCase("test") || Strings.CI.equals(label, this.rFreeString)) && column.type == 'I') {
                sb.append(String.format(" Reading R Free column: \"%s\"\n", column.label));
                this.rFree = nc;
            } else if ((label.equalsIgnoreCase("free(+)") || label.equalsIgnoreCase("freer(+)") || label.equalsIgnoreCase("freerflag(+)") || label.equalsIgnoreCase("freer_flag(+)") || label.equalsIgnoreCase("rfree(+)") || label.equalsIgnoreCase("rfreeflag(+)") || label.equalsIgnoreCase("r-free-flags(+)") || label.equalsIgnoreCase("test(+)") || Strings.CI.equals(label + "(+)", this.rFreeString)) && column.type == 'I') {
                this.rFreePlus = nc;
            } else if ((label.equalsIgnoreCase("free(-)") || label.equalsIgnoreCase("freer(-)") || label.equalsIgnoreCase("freerflag(-)") || label.equalsIgnoreCase("freer_flag(-)") || label.equalsIgnoreCase("rfree(-)") || label.equalsIgnoreCase("rfreeflag(-)") || label.equalsIgnoreCase("r-free-flags(-)") || label.equalsIgnoreCase("test(-)") || Strings.CI.equals(label + "(-)", this.rFreeString)) && column.type == 'I') {
                this.rFreeMinus = nc;
            } else if ((label.equalsIgnoreCase("f") || label.equalsIgnoreCase("fp") || label.equalsIgnoreCase("fo") || label.equalsIgnoreCase("fobs") || label.equalsIgnoreCase("f-obs") || Strings.CI.equals(label, this.foString)) && column.type == 'F') {
                sb.append(String.format(" Reading Fo column: \"%s\"\n", column.label));
                this.fo = nc;
            } else if ((label.equalsIgnoreCase("f(+)") || label.equalsIgnoreCase("fp(+)") || label.equalsIgnoreCase("fo(+)") || label.equalsIgnoreCase("fobs(+)") || label.equalsIgnoreCase("f-obs(+)") || Strings.CI.equals(label + "(+)", this.foString)) && column.type == 'G') {
                this.fPlus = nc;
            } else if ((label.equalsIgnoreCase("f(-)") || label.equalsIgnoreCase("fp(-)") || label.equalsIgnoreCase("fo(-)") || label.equalsIgnoreCase("fobs(-)") || label.equalsIgnoreCase("f-obs(-)") || Strings.CI.equals(label + "(-)", this.foString)) && column.type == 'G') {
                this.fMinus = nc;
            } else if ((label.equalsIgnoreCase("sigf") || label.equalsIgnoreCase("sigfp") || label.equalsIgnoreCase("sigfo") || label.equalsIgnoreCase("sigfobs") || label.equalsIgnoreCase("sigf-obs") || Strings.CI.equals(label, this.sigFoString)) && column.type == 'Q') {
                sb.append(String.format(" Reading sigFo column: \"%s\"\n", column.label));
                this.sigFo = nc;
            } else if ((label.equalsIgnoreCase("sigf(+)") || label.equalsIgnoreCase("sigfp(+)") || label.equalsIgnoreCase("sigfo(+)") || label.equalsIgnoreCase("sigfobs(+)") || label.equalsIgnoreCase("sigf-obs(+)") || Strings.CI.equals(label + "(+)", this.sigFoString)) && column.type == 'L') {
                this.sigFPlus = nc;
            } else if ((label.equalsIgnoreCase("sigf(-)") || label.equalsIgnoreCase("sigfp(-)") || label.equalsIgnoreCase("sigfo(-)") || label.equalsIgnoreCase("sigfobs(-)") || label.equalsIgnoreCase("sigf-obs(-)") || Strings.CI.equals(label + "(-)", this.sigFoString)) && column.type == 'L') {
                this.sigFMinus = nc;
            }
            ++nc;
        }
        if (this.fo < 0 && this.sigFo < 0 && this.fPlus > 0 && this.sigFPlus > 0 && this.fMinus > 0 && this.sigFMinus > 0) {
            sb.append(" Reading Fplus/Fminus column to fill in Fo\n");
        }
        if (logger.isLoggable(Level.INFO) && print) {
            logger.info(sb.toString());
        }
    }

    private void parseFcColumns(boolean print) {
        int nc = 0;
        StringBuilder sb = new StringBuilder();
        for (Column column : this.columns) {
            String label = column.label.trim();
            if (label.equalsIgnoreCase("H") && column.type == 'H') {
                this.h = nc;
            } else if (label.equalsIgnoreCase("K") && column.type == 'H') {
                this.k = nc;
            } else if (label.equalsIgnoreCase("L") && column.type == 'H') {
                this.l = nc;
            } else if ((label.equalsIgnoreCase("fc") || label.equalsIgnoreCase("fcalc")) && column.type == 'F') {
                sb.append(String.format(" Reading Fc column: \"%s\"\n", column.label));
                this.fc = nc;
            } else if ((label.equalsIgnoreCase("phic") || label.equalsIgnoreCase("phifc") || label.equalsIgnoreCase("phicalc") || label.equalsIgnoreCase("phifcalc")) && column.type == 'P') {
                sb.append(String.format(" Reading phiFc column: \"%s\"\n", column.label));
                this.phiC = nc;
            } else if ((label.equalsIgnoreCase("fs") || label.equalsIgnoreCase("fscalc")) && column.type == 'F') {
                sb.append(String.format(" Reading Fs column: \"%s\"\n", column.label));
                this.fs = nc;
            } else if ((label.equalsIgnoreCase("phis") || label.equalsIgnoreCase("phifs") || label.equalsIgnoreCase("phiscalc") || label.equalsIgnoreCase("phifscalc")) && column.type == 'P') {
                sb.append(String.format(" Reading phiFs column: \"%s\"\n", column.label));
                this.phiS = nc;
            }
            ++nc;
        }
        if (logger.isLoggable(Level.INFO) && print) {
            logger.info(sb.toString());
        }
    }

    int getnColumns() {
        return this.nColumns;
    }

    int getnReflections() {
        return this.nReflections;
    }

    int getSpaceGroupNum() {
        return this.spaceGroupNum;
    }

    private static class Column {
        public String label;
        public char type;
        public int id;
        public double min;
        public double max;

        private Column() {
        }
    }

    private static class Dataset {
        public double lambda;
        public double[] cell = new double[6];
        String project;
        String dataset;

        private Dataset() {
        }
    }

    private static enum Header {
        VERS,
        TITLE,
        NCOL,
        SORT,
        SYMINF,
        SYMM,
        RESO,
        VALM,
        COL,
        COLUMN,
        NDIF,
        PROJECT,
        CRYSTAL,
        DATASET,
        DCELL,
        DWAVEL,
        BATCH,
        END,
        NOVALUE;


        public static Header toHeader(String str) {
            try {
                return Header.valueOf(str);
            }
            catch (Exception ex) {
                return NOVALUE;
            }
        }
    }
}

