/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.potential.MolecularAssembly;
import ffx.xray.parsers.CIFFilter;
import ffx.xray.parsers.CNSFilter;
import ffx.xray.parsers.DiffractionFileFilter;
import ffx.xray.parsers.MTZFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class DiffractionFile {
    private static final Logger logger = Logger.getLogger(DiffractionFile.class.getName());
    private final String fileName;
    private final double weight;
    private final boolean neutron;
    private final DiffractionFileFilter diffractionFilter;

    public DiffractionFile(String filename) {
        this(filename, 1.0, false);
    }

    public DiffractionFile(String filename, double weight) {
        this(filename, weight, false);
    }

    public DiffractionFile(String filename, double weight, boolean neutron) {
        File tmp = new File(filename);
        if (!tmp.exists()) {
            logger.severe(" Data file: " + filename + " not found!");
        }
        this.diffractionFilter = FilenameUtils.isExtension((String)filename, (String)"mtz") ? new MTZFilter() : (FilenameUtils.isExtension((String)filename, (String[])new String[]{"cif", "ent", "sf"}) ? new CIFFilter() : (FilenameUtils.isExtension((String)filename, (String[])new String[]{"cns", "hkl"}) ? new CNSFilter() : null));
        if (this.diffractionFilter == null) {
            logger.severe("input data file format not recognized!\n Please use an appropriate file extension: [MTZ: mtz] [CIF: cif, ent, sf] [CNS: cns, hkl] to identify your data file type!");
        }
        this.fileName = filename;
        this.weight = weight;
        this.neutron = neutron;
    }

    public DiffractionFile(MolecularAssembly[] assembly) {
        this(assembly[0], 1.0, false);
    }

    public DiffractionFile(MolecularAssembly[] assembly, double weight) {
        this(assembly[0], weight, false);
    }

    public DiffractionFile(MolecularAssembly[] assembly, double weight, boolean neutron) {
        this(assembly[0], weight, neutron);
    }

    public DiffractionFile(MolecularAssembly assembly) {
        this(assembly, 1.0, false);
    }

    public DiffractionFile(MolecularAssembly assembly, double weight) {
        this(assembly, weight, false);
    }

    public DiffractionFile(MolecularAssembly assembly, double weight, boolean neutron) {
        String filenameHolder;
        String name = FilenameUtils.removeExtension((String)assembly.getFile().getPath());
        File tmp = new File(name + ".mtz");
        if (tmp.exists()) {
            this.diffractionFilter = new MTZFilter();
        } else {
            tmp = new File(name + ".cif");
            if (tmp.exists()) {
                this.diffractionFilter = new CIFFilter();
            } else {
                tmp = new File(name + ".ent");
                if (tmp.exists()) {
                    this.diffractionFilter = new CIFFilter();
                } else {
                    tmp = new File(name + ".sf");
                    if (tmp.exists()) {
                        this.diffractionFilter = new CIFFilter();
                    } else {
                        tmp = new File(name + ".cns");
                        if (tmp.exists()) {
                            this.diffractionFilter = new CNSFilter();
                        } else {
                            tmp = new File(name + ".hkl");
                            if (tmp.exists()) {
                                this.diffractionFilter = new CNSFilter();
                            } else {
                                logger.severe("no input data found!");
                                this.diffractionFilter = null;
                            }
                        }
                    }
                }
            }
        }
        try {
            Path filepath = Paths.get(tmp.getCanonicalPath(), new String[0]);
            Path pwdPath = Paths.get(new File("").getCanonicalPath(), new String[0]);
            filenameHolder = pwdPath.relativize(filepath).toString();
        }
        catch (IOException ex) {
            logger.warning(" Relative path to provided data file could not be resolved: using data file name instead.");
            filenameHolder = tmp.getName();
        }
        this.fileName = filenameHolder;
        this.weight = weight;
        this.neutron = neutron;
    }

    public DiffractionFileFilter getDiffractionfilter() {
        return this.diffractionFilter;
    }

    public String getFilename() {
        return this.fileName;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isNeutron() {
        return this.neutron;
    }
}

