/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.Resolution;
import ffx.crystal.SpaceGroupDefinitions;
import ffx.crystal.SpaceGroupInfo;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.parsers.DiffractionFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class CIFFilter
implements DiffractionFileFilter {
    private static final Logger logger = Logger.getLogger(CIFFilter.class.getName());
    private final double[] cell = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private double resHigh = -1.0;
    private String spacegroupName = null;
    private int spacegroupNum = -1;
    private int h = -1;
    private int k = -1;
    private int l = -1;
    private int fo = -1;
    private int sigFo = -1;
    private int io = -1;
    private int sigIo = -1;
    private int rFree = -1;
    private int nAll;
    private int nObs;

    @Override
    public ReflectionList getReflectionList(File cifFile) {
        return this.getReflectionList(cifFile, null);
    }

    @Override
    public ReflectionList getReflectionList(File cifFile, CompositeConfiguration properties) {
        try (BufferedReader br = new BufferedReader(new FileReader(cifFile));){
            String string;
            while ((string = br.readLine()) != null) {
                if (string.startsWith("_refln.")) {
                    break;
                }
                String[] strArray = string.split("\\s+");
                if (!strArray[0].startsWith("_reflns") && !strArray[0].startsWith("_cell") && !strArray[0].startsWith("_symmetry")) continue;
                String[] cifArray = strArray[0].split("\\.+");
                switch (CIFHeader.toHeader(cifArray[1]).ordinal()) {
                    case 0: {
                        this.resHigh = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 1: {
                        this.nAll = Integer.parseInt(strArray[1]);
                        break;
                    }
                    case 2: {
                        this.nObs = Integer.parseInt(strArray[1]);
                        break;
                    }
                    case 3: {
                        this.cell[0] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 4: {
                        this.cell[1] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 5: {
                        this.cell[2] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 6: {
                        this.cell[3] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 7: {
                        this.cell[4] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 8: {
                        this.cell[5] = Double.parseDouble(strArray[1]);
                        break;
                    }
                    case 9: {
                        this.spacegroupNum = Integer.parseInt(strArray[1]);
                        break;
                    }
                    case 10: {
                        String[] spacegroupNameArray = string.split("'+");
                        if (spacegroupNameArray.length > 1) {
                            this.spacegroupName = spacegroupNameArray[1];
                            break;
                        }
                        if (strArray.length <= 1) break;
                        this.spacegroupName = strArray[1];
                    }
                }
            }
        }
        catch (IOException e) {
            String message = " CIF IO Exception.";
            logger.log(Level.WARNING, message, e);
            return null;
        }
        if (this.spacegroupNum < 0 && this.spacegroupName != null) {
            this.spacegroupNum = SpaceGroupDefinitions.spaceGroupNumber((String)SpaceGroupInfo.pdb2ShortName((String)this.spacegroupName));
        }
        if (this.spacegroupNum < 0 || this.resHigh < 0.0 || this.cell[0] < 0.0) {
            logger.info(" The CIF header contains insufficient information to generate the reflection list.");
            return null;
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\nOpening %s\n", cifFile.getName()));
            sb.append(" Setting up Reflection List based on CIF:\n");
            sb.append(String.format("  spacegroup #: %d (name: %s)\n", this.spacegroupNum, SpaceGroupInfo.spaceGroupNames[this.spacegroupNum - 1]));
            sb.append(String.format("  Resolution: %8.3f\n", 0.999999 * this.resHigh));
            sb.append(String.format("  Cell: %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n", this.cell[0], this.cell[1], this.cell[2], this.cell[3], this.cell[4], this.cell[5]));
            sb.append(String.format("\n  CIF # HKL (observed): %d\n", this.nObs));
            sb.append(String.format("  CIF # HKL (all):      %d\n", this.nAll));
            logger.info(sb.toString());
        }
        logger.info(String.format(" Space group number %d", this.spacegroupNum));
        Crystal crystal = new Crystal(this.cell[0], this.cell[1], this.cell[2], this.cell[3], this.cell[4], this.cell[5], this.spacegroupNum);
        double sampling = 0.6666666666666666;
        if (properties != null) {
            sampling = properties.getDouble("sampling", 0.6666666666666666);
        }
        Resolution resolution = new Resolution(0.999999 * this.resHigh, sampling);
        return new ReflectionList(crystal, resolution, properties);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public double getResolution(File cifFile, Crystal crystal) {
        resolution = Infinity;
        try {
            block18: {
                br = new BufferedReader(new FileReader(cifFile));
                try {
                    nCol = 0;
                    inHKL = false;
                    while ((string = br.readLine()) != null) {
                        strArray = string.split("\\s+");
                        if (strArray[0].startsWith("_refln.")) {
                            inHKL = true;
                            br.mark(0);
                            cifArray = strArray[0].split("\\.+");
                            switch (CIFHeader.toHeader(cifArray[1]).ordinal()) {
                                case 15: {
                                    this.h = nCol;
                                    break;
                                }
                                case 16: {
                                    this.k = nCol;
                                    break;
                                }
                                case 17: {
                                    this.l = nCol;
                                    break;
                                }
                            }
                            ++nCol;
                            continue;
                        }
                        if (!inHKL) continue;
                        if (this.h < 0 || this.k < 0 || this.l < 0) {
                            message = " Fatal error in CIF file - no H K L indexes?\n";
                            CIFFilter.logger.log(Level.SEVERE, message);
                            var11_13 = -1.0;
                            break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable string) {
                    try {
                        br.close();
                        throw string;
                    }
                    catch (Throwable var7_7) {
                        string.addSuppressed(var7_7);
                    }
                    throw string;
                }
            }
            br.close();
            return var11_13;
        }
        catch (IOException e) {
            message = " CIF IO Exception.";
            CIFFilter.logger.log(Level.WARNING, message, e);
            return -1.0;
        }
lbl-1000:
        // 2 sources

        {
            br.reset();
            hkl = new HKL();
            while ((string = br.readLine()) != null && !string.trim().startsWith("#END") && !string.trim().startsWith("data")) {
                if (string.trim().startsWith("#")) continue;
                strArray = string.trim().split("\\s+");
                while (strArray.length < nCol) {
                    string = (String)string + " " + br.readLine();
                    strArray = string.trim().split("\\s+");
                }
                ih = Integer.parseInt(strArray[this.h]);
                ik = Integer.parseInt(strArray[this.k]);
                il = Integer.parseInt(strArray[this.l]);
                hkl.setH(ih);
                hkl.setK(ik);
                hkl.setL(il);
                resolution = FastMath.min((double)resolution, (double)crystal.res(hkl));
            }
        }
        br.close();
        return resolution;
    }

    @Override
    public boolean readFile(File cifFile, ReflectionList reflectionList, DiffractionRefinementData refinementData, CompositeConfiguration properties) {
        boolean doRFree;
        int nRead;
        int nNAN;
        int nRes;
        int nIgnore;
        int nCIFIgnore;
        int nFriedel;
        int nCut;
        boolean transpose = false;
        boolean intensitiesToAmplitudes = false;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(" Opening %s\n", cifFile.getName()));
        if (refinementData.rFreeFlag < 0) {
            refinementData.setFreeRFlag(1);
            sb.append(String.format(" Setting R free flag to CIF default: %d\n", refinementData.rFreeFlag));
        }
        try {
            String[] strArray;
            Object string;
            BufferedReader br = new BufferedReader(new FileReader(cifFile));
            int nCol = 0;
            boolean inHKL = false;
            while ((string = br.readLine()) != null) {
                String[] stringArray = ((String)string).split("\\s+");
                if (stringArray[0].startsWith("_refln.")) {
                    inHKL = true;
                    br.mark(0);
                    String[] cifArray = stringArray[0].split("\\.+");
                    switch (CIFHeader.toHeader(cifArray[1]).ordinal()) {
                        case 15: {
                            this.h = nCol;
                            break;
                        }
                        case 16: {
                            this.k = nCol;
                            break;
                        }
                        case 17: {
                            this.l = nCol;
                            break;
                        }
                        case 18: 
                        case 19: {
                            this.fo = nCol;
                            break;
                        }
                        case 20: 
                        case 21: {
                            this.sigFo = nCol;
                            break;
                        }
                        case 22: {
                            this.io = nCol;
                            break;
                        }
                        case 23: {
                            this.sigIo = nCol;
                            break;
                        }
                        case 14: {
                            this.rFree = nCol;
                        }
                    }
                    ++nCol;
                    continue;
                }
                if (!inHKL) continue;
                if (this.h >= 0 && this.k >= 0 && this.l >= 0) break;
                String message = " Fatal error in CIF file - no H K L indexes?\n";
                logger.log(Level.SEVERE, message);
                return false;
            }
            if (this.fo < 0 && this.sigFo < 0 && this.io > 0 && this.sigIo > 0) {
                intensitiesToAmplitudes = true;
            }
            if (this.fo < 0 && this.io < 0) {
                logger.severe(" Reflection data (I/F) not found in CIF file!");
            }
            br.reset();
            HKL mate = new HKL();
            int nPosIgnore = 0;
            int nTransIgnore = 0;
            while ((string = br.readLine()) != null && !((String)string).trim().startsWith("#END") && !((String)string).trim().startsWith("data")) {
                if (((String)string).trim().startsWith("#")) continue;
                strArray = ((String)string).trim().split("\\s+");
                while (strArray.length < nCol) {
                    string = (String)string + " " + br.readLine();
                    strArray = ((String)string).trim().split("\\s+");
                }
                if (this.rFree > 0 && (strArray[this.rFree].charAt(0) == 'x' || strArray[this.rFree].charAt(0) == '<' || strArray[this.rFree].charAt(0) == '-' || strArray[this.rFree].charAt(0) == 'h' || strArray[this.rFree].charAt(0) == 'l')) continue;
                int ih = Integer.parseInt(strArray[this.h]);
                int ik = Integer.parseInt(strArray[this.k]);
                int il = Integer.parseInt(strArray[this.l]);
                boolean friedel = reflectionList.findSymHKL(ih, ik, il, mate, false);
                HKL hklPos = reflectionList.getHKL(mate);
                if (hklPos == null) {
                    ++nPosIgnore;
                }
                friedel = reflectionList.findSymHKL(ih, ik, il, mate, true);
                HKL hklTrans = reflectionList.getHKL(mate);
                if (hklTrans != null) continue;
                ++nTransIgnore;
            }
            if (nPosIgnore > nTransIgnore) {
                transpose = true;
            }
            br = new BufferedReader(new FileReader(cifFile));
            inHKL = false;
            while ((string = br.readLine()) != null) {
                strArray = ((String)string).split("\\s+");
                if (strArray[0].startsWith("_refln.")) {
                    br.mark(0);
                    inHKL = true;
                    continue;
                }
                if (!inHKL) continue;
                break;
            }
            br.reset();
            double[][] anofSigF = new double[refinementData.n][4];
            for (int i = 0; i < refinementData.n; ++i) {
                anofSigF[i][3] = Double.NaN;
                anofSigF[i][2] = Double.NaN;
                anofSigF[i][1] = Double.NaN;
                anofSigF[i][0] = Double.NaN;
            }
            nCut = 0;
            nFriedel = 0;
            nCIFIgnore = 0;
            nIgnore = 0;
            nRes = 0;
            nNAN = 0;
            nRead = 0;
            while ((string = br.readLine()) != null && !((String)string).trim().startsWith("#END") && !((String)string).trim().startsWith("data")) {
                if (((String)string).trim().startsWith("#")) continue;
                String[] strArray2 = ((String)string).trim().split("\\s+");
                while (strArray2.length < nCol) {
                    string = (String)string + " " + br.readLine();
                    strArray2 = ((String)string).trim().split("\\s+");
                }
                int ih = Integer.parseInt(strArray2[this.h]);
                int ik = Integer.parseInt(strArray2[this.k]);
                int il = Integer.parseInt(strArray2[this.l]);
                boolean friedel = reflectionList.findSymHKL(ih, ik, il, mate, transpose);
                HKL hkl = reflectionList.getHKL(mate);
                if (hkl != null) {
                    boolean isnull = false;
                    if (this.rFree > 0) {
                        if (strArray2[this.rFree].charAt(0) == 'o') {
                            refinementData.setFreeR(hkl.getIndex(), 0);
                        } else if (strArray2[this.rFree].charAt(0) == 'f') {
                            refinementData.setFreeR(hkl.getIndex(), 1);
                        } else if (strArray2[this.rFree].charAt(0) == 'x') {
                            isnull = true;
                            ++nNAN;
                        } else if (strArray2[this.rFree].charAt(0) == '<' || strArray2[this.rFree].charAt(0) == '-' || strArray2[this.rFree].charAt(0) == 'h' || strArray2[this.rFree].charAt(0) == 'l') {
                            isnull = true;
                            ++nCIFIgnore;
                        } else {
                            refinementData.setFreeR(hkl.getIndex(), Integer.parseInt(strArray2[this.rFree]));
                        }
                    }
                    if (!intensitiesToAmplitudes && !isnull) {
                        double sigf1;
                        double f1;
                        if (strArray2[this.fo].charAt(0) == '?' || strArray2[this.sigFo].charAt(0) == '?') {
                            ++nNAN;
                            continue;
                        }
                        if (refinementData.fSigFCutoff > 0.0 && (f1 = Double.parseDouble(strArray2[this.fo])) / (sigf1 = Double.parseDouble(strArray2[this.sigFo])) < refinementData.fSigFCutoff) {
                            ++nCut;
                            continue;
                        }
                        if (friedel) {
                            anofSigF[hkl.getIndex()][2] = Double.parseDouble(strArray2[this.fo]);
                            anofSigF[hkl.getIndex()][3] = Double.parseDouble(strArray2[this.sigFo]);
                            ++nFriedel;
                        } else {
                            anofSigF[hkl.getIndex()][0] = Double.parseDouble(strArray2[this.fo]);
                            anofSigF[hkl.getIndex()][1] = Double.parseDouble(strArray2[this.sigFo]);
                        }
                    }
                    if (intensitiesToAmplitudes && !isnull) {
                        if (strArray2[this.io].charAt(0) == '?' || strArray2[this.sigIo].charAt(0) == '?') {
                            ++nNAN;
                            continue;
                        }
                        if (friedel) {
                            anofSigF[hkl.getIndex()][2] = Double.parseDouble(strArray2[this.io]);
                            anofSigF[hkl.getIndex()][3] = Double.parseDouble(strArray2[this.sigIo]);
                            ++nFriedel;
                        } else {
                            anofSigF[hkl.getIndex()][0] = Double.parseDouble(strArray2[this.io]);
                            anofSigF[hkl.getIndex()][1] = Double.parseDouble(strArray2[this.sigIo]);
                        }
                    }
                    ++nRead;
                    continue;
                }
                HKL tmp = new HKL(ih, ik, il);
                if (!reflectionList.resolution.inInverseResSqRange(reflectionList.crystal.invressq(tmp))) {
                    ++nRes;
                    continue;
                }
                ++nIgnore;
            }
            br.close();
            refinementData.generateFsigFfromAnomalousFsigF(anofSigF);
            if (intensitiesToAmplitudes) {
                refinementData.intensitiesToAmplitudes();
            }
        }
        catch (IOException ioe) {
            System.out.println(" IO Exception: " + ioe.getMessage());
            return false;
        }
        sb.append(String.format(" HKL data is %s\n", transpose ? "transposed" : "not transposed"));
        sb.append(String.format(" HKL read in:                             %d\n", nRead));
        sb.append(String.format(" HKL read as Friedel mates:               %d\n", nFriedel));
        sb.append(String.format(" HKL with NaN (ignored):                  %d\n", nNAN));
        sb.append(String.format(" HKL NOT read in (status <, -, h or l):   %d\n", nCIFIgnore));
        sb.append(String.format(" HKL NOT read in (too high resolution):   %d\n", nRes));
        sb.append(String.format(" HKL NOT read in (not in internal list?): %d\n", nIgnore));
        sb.append(String.format(" HKL NOT read in (F/sigF cutoff):         %d\n", nCut));
        sb.append(String.format(" HKL in internal list:                    %d\n", reflectionList.hklList.size()));
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sb.toString());
        }
        if (doRFree = properties.getBoolean("generate-rfree", false)) {
            logger.info(" Generating R free flags");
            refinementData.generateRFree();
        }
        return true;
    }

    private static enum CIFHeader {
        d_resolution_high,
        number_all,
        number_obs,
        length_a,
        length_b,
        length_c,
        angle_alpha,
        angle_beta,
        angle_gamma,
        Int_Tables_number,
        space_group_name_H_M,
        crystal_id,
        wavelength_id,
        scale_group_code,
        status,
        index_h,
        index_k,
        index_l,
        F_meas,
        F_meas_au,
        F_meas_sigma,
        F_meas_sigma_au,
        intensity_meas,
        intensity_sigma,
        NOVALUE;


        public static CIFHeader toHeader(String str) {
            try {
                return CIFHeader.valueOf(str.replace('-', '_'));
            }
            catch (Exception ex) {
                return NOVALUE;
            }
        }
    }
}

