/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parsers;

import ffx.crystal.Crystal;
import ffx.utilities.TinkerUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CCP4MapWriter {
    private static final Logger logger = Logger.getLogger(CCP4MapWriter.class.getName());
    private final String filename;
    private final Crystal crystal;
    private final int extx;
    private final int exty;
    private final int extz;
    private final int orix;
    private final int oriy;
    private final int oriz;
    private final int nx;
    private final int ny;
    private final int nz;
    private int stride;

    public CCP4MapWriter(int extx, int exty, int extz, Crystal crystal, String filename) {
        this.orix = 0;
        this.oriy = 0;
        this.oriz = 0;
        this.extx = extx;
        this.exty = exty;
        this.extz = extz;
        this.nx = extx;
        this.ny = exty;
        this.nz = extz;
        this.crystal = crystal;
        this.filename = filename;
        this.stride = 2;
    }

    public CCP4MapWriter(int orix, int oriy, int oriz, int extx, int exty, int extz, int nx, int ny, int nz, Crystal crystal, String filename) {
        this.orix = orix;
        this.oriy = oriy;
        this.oriz = oriz;
        this.extx = extx;
        this.exty = exty;
        this.extz = extz;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.crystal = crystal;
        this.filename = filename;
        this.stride = 2;
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public void write(double[] data) {
        this.write(data, false);
    }

    public void write(double[] data, boolean norm) {
        int index;
        int i;
        int j;
        int k;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double mean = 0.0;
        double sd = 0.0;
        int n = 0;
        for (k = 0; k < this.extz; ++k) {
            for (j = 0; j < this.exty; ++j) {
                for (i = 0; i < this.extx; ++i) {
                    index = this.stride * (i + this.extx * (j + this.exty * k));
                    ++n;
                    if (data[index] < min) {
                        min = data[index];
                    }
                    if (data[index] > max) {
                        max = data[index];
                    }
                    mean += (data[index] - mean) / (double)n;
                }
            }
        }
        n = 0;
        for (k = 0; k < this.extz; ++k) {
            for (j = 0; j < this.exty; ++j) {
                for (i = 0; i < this.extx; ++i) {
                    index = this.stride * (i + this.extx * (j + this.exty * k));
                    sd += FastMath.pow((double)(data[index] - mean), (double)2.0);
                    ++n;
                }
            }
        }
        sd = FastMath.sqrt((double)(sd / (double)n));
        if (norm) {
            if (logger.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n Normalizing CCP4 Map");
                sb.append(String.format("\n  Min:           %8.4f", min));
                sb.append(String.format("\n  Max:           %8.4f", max));
                sb.append(String.format("\n  Mean:          %8.4f", mean));
                sb.append(String.format("\n  Standard Dev.: %8.4f", sd));
                logger.info(sb.toString());
            }
            for (int k2 = 0; k2 < this.extz; ++k2) {
                for (j = 0; j < this.exty; ++j) {
                    for (i = 0; i < this.extx; ++i) {
                        index = this.stride * (i + this.extx * (j + this.exty * k2));
                        data[index] = (data[index] - mean) / sd;
                    }
                }
            }
            this.write(data, false);
            return;
        }
        File file = TinkerUtils.version((File)new File(this.filename));
        String name = file.getName();
        try {
            int i2;
            if (logger.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("\n Writing CCP4 map file: \"%s\"", name));
                sb.append(String.format("\n  Min:           %8.4f", min));
                sb.append(String.format("\n  Max:           %8.4f", max));
                sb.append(String.format("\n  Mean:          %8.4f", mean));
                sb.append(String.format("\n  Standard Dev.: %8.4f", sd));
                logger.info(sb.toString());
            }
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            byte[] bytes = new byte[2048];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(this.extx).putInt(this.exty).putInt(this.extz);
            bb.putInt(2);
            bb.putInt(this.orix).putInt(this.oriy).putInt(this.oriz);
            bb.putInt(this.nx).putInt(this.ny).putInt(this.nz);
            bb.putFloat((float)this.crystal.a);
            bb.putFloat((float)this.crystal.b);
            bb.putFloat((float)this.crystal.c);
            bb.putFloat((float)this.crystal.alpha);
            bb.putFloat((float)this.crystal.beta);
            bb.putFloat((float)this.crystal.gamma);
            bb.putInt(1).putInt(2).putInt(3);
            bb.putFloat((float)min);
            bb.putFloat((float)max);
            bb.putFloat((float)mean);
            bb.putInt(this.crystal.spaceGroup.number);
            bb.putInt(80);
            bb.putInt(0);
            for (i2 = 0; i2 < 12; ++i2) {
                bb.putFloat(0.0f);
            }
            for (i2 = 0; i2 < 15; ++i2) {
                bb.putInt(0);
            }
            int offset = 0;
            dos.write(bytes, offset, 208);
            bb.rewind();
            String mapstr = "MAP ";
            dos.writeBytes(mapstr);
            int imapdata = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? 17473 : 4369;
            bb.putInt(imapdata);
            bb.putFloat((float)sd);
            bb.putInt(1);
            dos.write(bytes, offset, 12);
            StringBuilder sb = new StringBuilder();
            sb.append("map data from ffx");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dos.writeBytes(sb.toString());
            sb = new StringBuilder();
            while (sb.length() < 80) {
                sb.append(" ");
            }
            for (int i3 = 0; i3 < 9; ++i3) {
                dos.writeBytes(sb.toString());
            }
            sb = new StringBuilder();
            sb.append("x,y,z");
            while (sb.length() < 80) {
                sb.append(" ");
            }
            dos.writeBytes(sb.toString());
            bb.rewind();
            for (int k3 = 0; k3 < this.extz; ++k3) {
                for (int j2 = 0; j2 < this.exty; ++j2) {
                    for (int i4 = 0; i4 < this.extx; ++i4) {
                        int index2 = this.stride * (i4 + this.extx * (j2 + this.exty * k3));
                        float fmapdata = (float)data[index2];
                        bb.putFloat(fmapdata);
                        if (bb.hasRemaining()) continue;
                        dos.write(bytes);
                        bb.rewind();
                    }
                }
            }
            if (bb.position() > 0) {
                dos.write(bytes);
                bb.rewind();
            }
            dos.close();
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating structure factors.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }
}

